// -*- c++ -*-

//-------------------------------------------------------------------------
// Author: Daniel Kps, created 2006-01-26.
// This file is public domain.
//-------------------------------------------------------------------------

// no guards:
// #ifndef _INCLUDED_safecast_signedness_h  
// #define _INCLUDED_safecast_signedness_h  

//-------------------------------------------------------------------------
//
// signed/unsigned/default-signed-ness conversions:
// - those are less problematic compared to type-size changes, since,
//   at least, no data is lost by the cast operation
// - however, wrong interpretation may cause incorrect behavior, still
//
// some cast difficulties with regard to signed-ness conversions:
// - some compilers may interpret 'signed type' and '(unspecified 
//   signedness) type' differently with regard to overload resolution
// - the type of '(unspecified signedness) char' may differ from compiler 
//   to compiler and may additionally depend on compiler options
//
//-------------------------------------------------------------------------

// used defines:
//  #define M_Type ... // e.g. char, char *, int etc.
//  #define M_SafecastSignedness_IsAddConstOverloads 0/1
//  #define M_SafecastSignedness_IsUseDefaultSignedness 0/1

//-------------------------------------------------------------------------

// declared functions will be:
//   cast_signed()
//   cast_unsigned()
//   cast_defsigned()
// additionally with const overloads if 
// M_SafecastSignedness_IsAddConstOverloads defined to 1

//=========================================================================
// functions to return M_Type as unsigned type

inline unsigned M_Type cast_unsigned (signed M_Type TypeVar)
{
    return (unsigned M_Type) TypeVar;
}

#if (M_SafecastSignedness_IsUseDefaultSignedness == 1)
inline unsigned M_Type cast_unsigned (M_Type TypeVar)
{
    return (unsigned M_Type) TypeVar;
}
#endif

inline unsigned M_Type cast_unsigned (unsigned M_Type TypeVar)
{
    return TypeVar;
}

//-------------------------------------------------------------------------

#if (M_SafecastSignedness_IsAddConstOverloads == 1)

inline const unsigned M_Type cast_unsigned (const signed M_Type TypeVar)
{
    return (unsigned M_Type) TypeVar;
}

#if (M_SafecastSignedness_IsUseDefaultSignedness == 1)
inline const unsigned M_Type cast_unsigned (const M_Type TypeVar)
{
    return (unsigned M_Type) TypeVar;
}
#endif

inline const unsigned M_Type cast_unsigned (const unsigned M_Type TypeVar)
{
    return TypeVar;
}

#endif

//=========================================================================
// functions to return M_Type as signed type

inline signed M_Type cast_signed (signed M_Type TypeVar)
{
    return TypeVar;
}

#if (M_SafecastSignedness_IsUseDefaultSignedness == 1)
inline signed M_Type cast_signed (M_Type TypeVar)
{
    return (signed M_Type) TypeVar;
}
#endif

inline signed M_Type cast_signed (unsigned M_Type TypeVar)
{
    return (signed M_Type) TypeVar;
}

//-------------------------------------------------------------------------

#if (M_SafecastSignedness_IsAddConstOverloads == 1)

inline const signed M_Type cast_signed (const signed M_Type TypeVar)
{
    return TypeVar;
}

#if (M_SafecastSignedness_IsUseDefaultSignedness == 1)
inline const signed M_Type cast_signed (const M_Type TypeVar)
{
    return (signed M_Type) TypeVar;
}
#endif

inline const signed M_Type cast_signed (const unsigned M_Type TypeVar)
{
    return (signed M_Type) TypeVar;
}

#endif

//=========================================================================
// functions to return M_Type with default-signedness (i.e.
// no signedness declarator ('signed' or 'unsigned') is used)

inline M_Type cast_defsigned (signed M_Type TypeVar)
{
    return (M_Type) TypeVar;
}

#if (M_SafecastSignedness_IsUseDefaultSignedness == 1)
inline M_Type cast_defsigned (M_Type TypeVar)
{
    return TypeVar;
}
#endif

inline M_Type cast_defsigned (unsigned M_Type TypeVar)
{
    return (M_Type) TypeVar;
}

//-------------------------------------------------------------------------

#if (M_SafecastSignedness_IsAddConstOverloads == 1)

inline const M_Type cast_defsigned (const signed M_Type TypeVar)
{
    return (M_Type) TypeVar;
}

#if (M_SafecastSignedness_IsUseDefaultSignedness == 1)
inline const M_Type cast_defsigned (const M_Type TypeVar)
{
    return TypeVar;
}
#endif

inline const M_Type cast_defsigned (const unsigned M_Type TypeVar)
{
    return (M_Type) TypeVar;
}

#endif

//-------------------------------------------------------------------------

// #endif
