// -*- c++ -*-
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2003-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice

-------------------------------------------------------------------------
*/

//-------------------------------------------------------------------------
//
// NOTE
//
// - WxMessageFormat.h,.cpp files are superseeded by StxFormatMessage.h,.cpp.
//   Development and changes shall be made to StxFormatMessage.h,.cpp
//   (not yet published).
//
//
//-------------------------------------------------------------------------
//
// Interoperability with std::string instead of wxString:
// ------------------------------------------------------
//
// if M_MessageFormat_StdString is defined, the wxMessageFormatter/wxFormat/
// wxFormatMessage classes and functions will be made up to be usable with
// std::string instead of wxString. This involves following transparent
// renames (only in this header and in implemenation file):
//   wxMessageFormatter -> stMessageFormatter
//   wxFormat -> stFormat
//   wxFormatMessage -> stFormatMessage
//   wxString -> std::string
//
// Example: wxFormatMessage()/stFormatMessage() the following function call 
// can be used:
// - if M_MessageFormat_StdString was defined:
//       std::string FormattedStdString = stFormatMessage ("file %1 has length of %2 bytes",
//                                                         FilenameStdString, "4096")
// - if M_MessageFormat_StdString was not defined:
//       wxString FormattedWxString = wxFormatMessage ("file %1 has length of %2 bytes",
//                                                      FilenameWxString, "4096")
//
// NOTE to use both variants in a single compilation unit,
// #undef _INCLUDED_WxMessageFormat_h may be required to get the header 
// included a second time (untested)
//
//-------------------------------------------------------------------------

// no guards here, use guards around specific class declarations/implementations
// #ifndef _INCLUDED_WxMessageFormat_h
// #define _INCLUDED_WxMessageFormat_h

//=========================================================================

#ifdef M_MessageFormat_IsUseStxFormatMessage

#   include <StxConfig.h> // for stxInt64
#   include <StxFormatMessage.h>

//=========================================================================

#else

//-------------------------------------------------------------------------

// ?
// #if ((!defined M_MessageFormat_IsReIncludeHeader) && (!defined M_MessageFormat_IsReIncludeSource))
// #   include "WxExtLibConfig.h"
// #endif

//=========================================================================

#if (!defined M_MessageFormat_IsEmitDeclarations)

//-------------------------------------------------------------------------

#if ((!defined M_MessageFormat_WxString) && (!defined M_MessageFormat_StdString))
#   error "please define at least one of M_MessageFormat_StdString, M_MessageFormat_WxString"
#endif

//-------------------------------------------------------------------------

// wxString interface: wxMessageFormatter, wxFormat, etc.
// using wxString

#if (defined M_MessageFormat_WxString)

#ifndef _DECLARED_MessageFormat_WxString
#define _DECLARED_MessageFormat_WxString

    #include <wx/defs.h>

    #ifndef WX_PRECOMP
    #   include <wx/string.h>
    #   include <wx/dynarray.h>
    #endif

    #ifndef WX_DEFINE_ARRAY_PTR
    // under wxWindows 2.5.2, WX_DEFINE_ARRAY_PTR should be used, but it
    // doesn't seem to be available under wxWindows 2.4.1
    #   define WX_DEFINE_ARRAY_PTR WX_DEFINE_ARRAY
    #endif
    
    #define M_MessageFormat_IsEmitDeclarations
    #define M_MessageFormat_IsUseWxString 1
    #define M_MessageFormatter wxMessageFormatter
    #define M_Format wxFormat
    #define M_FormatMessage wxFormatMessage
    #define M_String wxString
    #define M_FormatArray wxFormatArray
    #define M_makeMessageFormatter MessageFormatter
    #include "WxMessageFormat.h" 
    #undef M_MessageFormat_IsEmitDeclarations
    #undef M_MessageFormat_IsUseWxString
    #undef M_MessageFormatter
    #undef M_Format
    #undef M_FormatMessage
    #undef M_String
    #undef M_FormatArray
    #undef M_makeMessageFormatter

#endif

#endif

//-------------------------------------------------------------------------

// std::string interface: stMessageFormatter, stFormat, etc.
// using std::string

#if (defined M_MessageFormat_StdString)

#ifndef _DECLARED_MessageFormat_StdString
#define _DECLARED_MessageFormat_StdString


    #include <string>
    #include <vector>

    #define M_MessageFormat_IsEmitDeclarations
    #define M_MessageFormat_IsUseStdString 1
    #define M_MessageFormatter stMessageFormatter
    #define M_Format stFormat
    #define M_FormatMessage stFormatMessage
    #define M_String std::string
    #define M_FormatArray stFormatArray
    #define M_makeMessageFormatter makeStdStringMessageFormatter
    #include "WxMessageFormat.h" 
    #undef M_MessageFormat_IsEmitDeclarations
    #undef M_MessageFormat_IsUseStdString
    #undef M_MessageFormatter
    #undef M_Format
    #undef M_FormatMessage
    #undef M_String
    #undef M_FormatArray
    #undef M_makeMessageFormatter

#endif

#endif

//-------------------------------------------------------------------------

#endif

//=========================================================================

#if (defined M_MessageFormat_IsEmitDeclarations)

//-------------------------------------------------------------------------

// WARN it is not clear how the multiple variations of this file
// interact with "#pragma interface"
// #if defined(__GNUG__) && (!defined(__APPLE__)) && (!defined(M_NoPragmaInterface))
// #   pragma interface "WxMessageFormat.h"
// #endif

//-------------------------------------------------------------------------

#ifdef M_MessageFormat_IsTraceUsedInterface
#   if (M_MessageFormat_IsUseWxString == 1)
#       pragma message ("-- wxFormatMessage() etc. / wxString interface")
#   endif
#   if (M_MessageFormat_IsUseStdString == 1)
#       pragma message ("-- stFormatMessage() etc. / std::string interface")
#   endif
#endif

//-------------------------------------------------------------------------

// wxMessageFormatter/wxFormat/wxFormatMessage:
// provide type-safe string formatting similar to printf 
// - parameters are added with the "%" operator
// - format string refers to parameters with %N or %{N} (with N 
//   being the N-th parameter added)
// - "%+" may be used to refer to "next" parameter
// Notes:
// - Currently, type-safety may be breached by specifying wrong
//   printf-format strings to wxFormat objects, but this string 
//   is usually changed by the programmer only (not internationalized)
//   (to do: add type-compatibility checks).
// - This approach allows reordering of parameters in the output 
//   which might be useful or even required when translating 
//   messages into other languages.
// - Unlike with the usual with C++-stream operators "<<", 
//   the message string must not be split up into several sub-strings
//   which makes it all possibly better readable.
// - wxFormat may be used to set up output precision as usual, 
//   but for safety reasons currently this cannot be done in the
//   message format string (which might be edited by translators 
//   externally)
// - For the %N syntax, N must be a single digit. This means that
//   %23 prints parameter two, followed by the digit 'three'.
//   (%23 is identical to %{2}3). However, %{23} can be used to
//   refer parameter '23'.
//   It was opted to use this syntax because parameter numbers >= 10
//   are probably rarely used, so normally the %N syntax is sufficient.
// - The idea of using the percent (%) operator has been borrowed
//   from boost::format which also provides printf-like formatting
//   in a type-safe manner, but heavily depends on C++-templates
// - The "%+" syntax can also be used to ease conversion of printf
//   format strings: just replace all occurences of "%d", "%s" etc. 
//   with "%+".
// Possible improvements:
// - avoid allocations of wxStrings by pre-calculating the resulting
//   string size and by using static buffers for intermediate
//   number output buffers
// TODO
// - test with older compilers if overloads work as expected, also test
//   with latest compilers
// TESTED
// - (wxExtLib 0.7.1:) GCC 2.95.2, MSVC 6, DMC 8.40, BCC 5.5.1

// possible (thinkable) shorthands for wxFormat: "wxF", "_F", "F"
// typedef wxFormat wxF;

class M_Format
{
public:
    M_Format (int Integer);
    M_Format (const char * PrintfFormatString, int Integer);
    M_Format (unsigned int UInt);
    M_Format (const char * PrintfFormatString, unsigned int UInt);
    M_Format (long Long);
    M_Format (const char * PrintfFormatString, long Long);
    M_Format (unsigned long ULong);
    M_Format (const char * PrintfFormatString, unsigned long ULong);
    M_Format (const float & Float);
    M_Format (const char * PrintfFormatString, const float & Float);
    M_Format (const double & Double);
    M_Format (const char * PrintfFormatString, const double & Double);
    M_Format (const char * CharPtr);
    M_Format (const char * PrintfFormatString, const char * CharPtr);
    M_Format (const M_String & String);
    M_Format (const char * PrintfFormatString, const M_String & String);
    M_Format (char Char);
    M_Format (const char * PrintfFormatString, char Char);
    M_Format (unsigned char UChar);
    M_Format (const char * PrintfFormatString, unsigned char UChar);
    // TODO: add signed/unsigned overloads char-types,
    // wxDateTime (for current locale)

    virtual ~M_Format ();

    void init (const char * PrintfFormatString, int Integer);
    void init (const char * PrintfFormatString, unsigned int UInt);
    void init (const char * PrintfFormatString, long Long);
    void init (const char * PrintfFormatString, unsigned long ULong);
    void init (const char * PrintfFormatString, const double & Double);
    void init (const char * PrintfFormatString, const char * CharPtr);
    void init (const char * PrintfFormatString, const M_String & String);
    void init (const char * PrintfFormatString, char Char);
    void init (const char * PrintfFormatString, unsigned char UChar);

    // interface draft which might be used for optimization purposes:
    // virtual int getPrintCharCount () const;
    // virtual void printInto (wxString & String, int FirstPos, int Count) const;
    virtual void appendTo (M_String & String) const;
    // virtual M_String print ();

private:
    M_String m_FormattedValueString;
};

class M_MessageFormatter;

//-------------------------------------------------------------------------

// helper functions to ease transition to use wxMessageFormatter
// - Example:
//   use 
//       wxFormatMessage ("TEXT %1 TEXT %2", Int, Double)
//   instead of 
//       wxString::Format ("TEXT %d TEXT %f", Int, Double)
//
M_String M_FormatMessage (const char * FormatString);
M_String M_FormatMessage (const char * FormatString, const M_Format & Param1Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format,
                          const M_Format & Param8Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format,
                          const M_Format & Param8Format,
                          const M_Format & Param9Format);
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format,
                          const M_Format & Param8Format,
                          const M_Format & Param9Format,
                          const M_Format & Param10Format);
// add overloads with more parameters if required... (C++ language
// syntactically doesn't support real variable-number arguments with 
// type-checks)

//-------------------------------------------------------------------------

#if (M_MessageFormat_IsUseWxString == 1)
    WX_DEFINE_ARRAY_PTR(M_Format *, M_FormatArray);
#elif (defined M_MessageFormat_StdString)
    typedef std::vector<M_Format *> M_FormatArray;
#else
    #error "unhandled/missing typedef for M_FormatArray"
#endif

//-------------------------------------------------------------------------

// MessageFormatter will return a wxMessageFormatter object
M_MessageFormatter M_makeMessageFormatter (const char * FormatString);

// helper function
M_String & operator+= (M_String & String, M_MessageFormatter & MessageFormatter);

class M_MessageFormatter
{
public:
    M_MessageFormatter (const char * FormatString);
    ~M_MessageFormatter ();

    // TODO: add signed/unsigned overloads, overload for char-types,
    // wxDateTime
#if 0 
    // TEST these functions should not be required since
    // we have operator%(wxFormat & Format)
    M_MessageFormatter & operator% (int Integer);
    M_MessageFormatter & operator% (long Long);
    M_MessageFormatter & operator% (const double & Double);
    M_MessageFormatter & operator% (const char * CharPtr);
    M_MessageFormatter & operator% (const M_String & String);
#endif
    // NOTE: maybe, the above overloads are not required since
    // wxFormat class constructor has also the required overloads - maybe
    // these functions even cause problems together with the overloads
    // in the wxFormat constructor on some compilers
    M_MessageFormatter & operator% (const M_Format & Format);

    // DEF the operator% and addFormat() taking a pointer to a 
    // wxFormat object assume this object was allocated via 'new'
    // - this is intended to make it possible to use user defined 
    //   formatter classes (NOTE: wxFormatMessage() function
    //   cannot simply use user-defined format objects)
    // - therefore, to output user-defined types, it may be better
    //   to write a function that converts the user-defined-type 
    //   to string and returns an appropriate wxFormat object
    //   (which then can be used as argument to both, wxFormatMessage()
    //   and wxMessageFormatter::operator%())
    M_MessageFormatter & operator% (M_Format * FormatPtr);
    M_MessageFormatter & addFormat (M_Format * FormatPtr);

    // format() does the formatting work
    void format ();

    // format string and return reference to it:
    const M_String & getRef ();
    operator const M_String & ();
    operator const char *();

    // format string and return result or append result to other string
    void appendTo (M_String & String);
    void assignTo (M_String & String);

protected:
    M_String m_FormatString;
    M_FormatArray m_FormatArray;

    M_String m_OutputString;
};

//-------------------------------------------------------------------------

#endif // if(defined M_MessageFormat_IsEmitDeclarations)

//=========================================================================

#endif /* M_MessageFormat_IsUseStxFormatMessage */

//=========================================================================

