
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2003-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice

-------------------------------------------------------------------------
*/

//-------------------------------------------------------------------------
//
// NOTE
//
// - WxMessageFormat.h,.cpp files are superseeded by StxFormatMessage.h,.cpp.
//   Development and changes shall be made to StxFormatMessage.h,.cpp
//   (not yet published).
//
//-------------------------------------------------------------------------

//=========================================================================

#ifdef M_MessageFormat_IsUseStxFormatMessage

#   include <StxFormatMessage.h>
#   include <StxFormatMessage.cpp>

//=========================================================================

#else

#if (!defined M_MessageFormat_IsEmitImplementation)

//-------------------------------------------------------------------------

#if ((!defined M_MessageFormat_WxString) && (!defined M_MessageFormat_StdString))
#   error "please define at least one of M_MessageFormat_StdString, M_MessageFormat_WxString"
#endif

//-------------------------------------------------------------------------

// wxString interface: wxMessageFormatter, wxFormat, etc.
// using wxString

#if (defined M_MessageFormat_WxString)

#ifndef _IMPLEMENTED_MessageFormat_WxString
#define _IMPLEMENTED_MessageFormat_WxString

    #define M_MessageFormat_IsEmitImplementation
    #define M_MessageFormat_IsUseWxString 1
    #define M_MessageFormatter wxMessageFormatter
    #define M_Format wxFormat
    #define M_FormatMessage wxFormatMessage
    #define M_String wxString
    #define M_FormatArray wxFormatArray
    #define M_makeMessageFormatter MessageFormatter
    #include "WxMessageFormat.cpp" 
    #undef M_MessageFormat_IsEmitImplementation
    #undef M_MessageFormat_IsUseWxString
    #undef M_MessageFormatter
    #undef M_Format
    #undef M_FormatMessage
    #undef M_String
    #undef M_FormatArray
    #undef M_makeMessageFormatter

#endif

#endif

//-------------------------------------------------------------------------

// std::string interface: stMessageFormatter, stFormat, etc.
// using std::string

#if (defined M_MessageFormat_StdString)

#ifndef _IMPLEMENTED_MessageFormat_StdString
#define _IMPLEMENTED_MessageFormat_StdString

    #define M_MessageFormat_IsEmitImplementation
    #define M_MessageFormat_IsUseStdString 1
    #define M_MessageFormatter stMessageFormatter
    #define M_Format stFormat
    #define M_FormatMessage stFormatMessage
    #define M_String std::string
    #define M_FormatArray stFormatArray
    #define M_makeMessageFormatter makeStdStringMessageFormatter
    #include "WxMessageFormat.cpp" 
    #undef M_MessageFormat_IsEmitImplementation
    #undef M_MessageFormat_IsUseStdString
    #undef M_MessageFormatter
    #undef M_Format
    #undef M_FormatMessage
    #undef M_String
    #undef M_FormatArray
    #undef M_makeMessageFormatter

#endif

#endif

//-------------------------------------------------------------------------

#endif // (!defined M_MessageFormat_IsEmitImplemenation)

//=========================================================================


#if (defined M_MessageFormat_IsEmitImplementation)

//-------------------------------------------------------------------------

// inclusion of basic headers:

// WARN it is not clear how the multiple variations of this file
// interact with "#pragma interface"
// #if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
//    #pragma implementation "WxMessageFormat.cpp"
// #endif

#if (M_MessageFormat_IsUseWxString == 1)
    #include "WxExtLibConfig.h"

    // For compilers that support precompilation, includes "wx/wx.h".
    #include "wx/wxprec.h"

    #ifdef __BORLANDC__
        #pragma hdrstop
    #endif
#endif

#if (M_MessageFormat_IsUseStdString == 1)
#   include <string>
#endif

//-------------------------------------------------------------------------

// message format declarations:
#include "WxMessageFormat.h"

#include "safecast.h"

#ifdef M_MessageFormat_IsTraceUsedInterface
#   if (M_MessageFormat_IsUseWxString == 1)
#       pragma message ("-- wxFormatMessage() etc. / wxString implementation")
#   endif
#   if (M_MessageFormat_IsUseStdString == 1)
#       pragma message ("-- stFormatMessage() etc. / std::string implementation")
#   endif
#endif

//=========================================================================

M_Format::M_Format (int Integer)
{
    init ("%d", Integer);
}

M_Format::M_Format (const char * PrintfFormatString, int Integer)
{
    init (PrintfFormatString, Integer);
}

M_Format::M_Format (unsigned int UInt)
{
    init ("%u", UInt);
}

M_Format::M_Format (const char * PrintfFormatString, unsigned int UInt)
{
    init (PrintfFormatString, UInt);
}

M_Format::M_Format (long Long)
{
    init ("%ld", Long);
}

M_Format::M_Format (const char * PrintfFormatString, long Long)
{
    init (PrintfFormatString, Long);
}

M_Format::M_Format (unsigned long ULong)
{
    init ("%lu", ULong);
}

M_Format::M_Format (const char * PrintfFormatString, unsigned long ULong)
{
    init (PrintfFormatString, ULong);
}

M_Format::M_Format (const float & Float)
{
    init ("%f", Float);
}

M_Format::M_Format (const char * PrintfFormatString, const float & Float)
{
    double Double = Float;
    init (PrintfFormatString, Double);
}

M_Format::M_Format (const double & Double)
{
    init ("%f", Double);
}

M_Format::M_Format (const char * PrintfFormatString, const double & Double)
{
    init (PrintfFormatString, Double);
}

M_Format::M_Format (const char * CharPtr)
{
    init ("%s", CharPtr);
}

M_Format::M_Format (const char * PrintfFormatString, const char * CharPtr)
{
    init (PrintfFormatString, CharPtr);
}

M_Format::M_Format (const M_String & String)
{
    init ("%s", String);
}

M_Format::M_Format (const char * PrintfFormatString, const M_String & String)
{
    init (PrintfFormatString, String);
}

M_Format::M_Format (char Char)
{
    init ("%c", Char);
}

M_Format::M_Format (const char * PrintfFormatString, char Char)
{
    init (PrintfFormatString, Char);
}

M_Format::M_Format (unsigned char UChar)
{
    init ("%c", UChar);
}

M_Format::M_Format (const char * PrintfFormatString, unsigned char UChar)
{
    init (PrintfFormatString, UChar);
}

//-------------------------------------------------------------------------

M_Format::~M_Format ()
{
}

//-------------------------------------------------------------------------

// temporary macro for calls to printf
#if (M_MessageFormat_IsUseWxString == 1)

    // wxString has a member function Printf() for our needs
    #define M_PrintfHelper(PrintfFormatString, Value, BufferSize) \
        m_FormattedValueString.Printf (PrintfFormatString, Value);

#elif (M_MessageFormat_IsUseStdString == 1)

    #define M_PrintfHelper(PrintfFormatString, Value, BufferSize)  \
        char TempCharArray[BufferSize]; \
        TempCharArray[0] = '\0'; \
        sprintf (TempCharArray, PrintfFormatString, Value); \
        TempCharArray[BufferSize - 1] = '\0'; \
        m_FormattedValueString.append (TempCharArray);

#else
    #error "unhandled/missing implementation of M_PrintfHelper macro"

#endif

//-------------------------------------------------------------------------

void M_Format::init (const char * PrintfFormatString, int Integer)
{
    M_PrintfHelper (PrintfFormatString, Integer, 20);
}

void M_Format::init (const char * PrintfFormatString, unsigned int UInt)
{
    M_PrintfHelper (PrintfFormatString, UInt, 20);
}

void M_Format::init (const char * PrintfFormatString, long Long)
{
    M_PrintfHelper (PrintfFormatString, Long, 32);
}

void M_Format::init (const char * PrintfFormatString, unsigned long ULong)
{
    M_PrintfHelper (PrintfFormatString, ULong, 32);
}

void M_Format::init (const char * PrintfFormatString, const double & Double)
{
    // WARN what is the maximum number of characters printed for
    // double-precision floating point according to output format?
    M_PrintfHelper (PrintfFormatString, Double, 1024);
}

void M_Format::init (const char * PrintfFormatString, const char * CharPtr)
{
#if (M_MessageFormat_IsUseWxString == 1)
    m_FormattedValueString.Printf (PrintfFormatString, CharPtr);
#elif (M_MessageFormat_IsUseStdString == 1)
    // HACK NOTE: PrintfFormatString is ignored for String arguments 
    m_FormattedValueString.append (CharPtr);
#else
    #error "unhandled/missing handling of string formatting"
#endif
}

void M_Format::init (const char * PrintfFormatString, const M_String & String)
{
#if (M_MessageFormat_IsUseWxString == 1)
    m_FormattedValueString.Printf (PrintfFormatString, String.c_str());
#elif (M_MessageFormat_IsUseStdString == 1)
    // HACK NOTE: PrintfFormatString is ignored for String arguments 
    m_FormattedValueString.append (String.c_str());
#else
    #error "unhandled/missing string formatting"
#endif
}

void M_Format::init (const char * PrintfFormatString, char Char)
{
    M_PrintfHelper (PrintfFormatString, Char, 4);
}

void M_Format::init (const char * PrintfFormatString, unsigned char UChar)
{
    M_PrintfHelper (PrintfFormatString, UChar, 4);
}

void M_Format::appendTo (M_String & String) const
{
    String += m_FormattedValueString;
}

#undef M_PrintfHelper

//=========================================================================

M_String M_FormatMessage (const char * FormatString)
{
    M_MessageFormatter MessageFormatter_ (FormatString);

    return MessageFormatter_.getRef();
}

M_String M_FormatMessage (const char * FormatString, const M_Format & Param1Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ % Param1Format;

    return MessageFormatter_.getRef();
}

M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format;

    return MessageFormatter_.getRef();
}

M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format;

    return MessageFormatter_.getRef();
}

M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format
      % Param4Format;

    return MessageFormatter_.getRef();
}

M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format
      % Param4Format
      % Param5Format;

    return MessageFormatter_.getRef();
}

M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format
      % Param4Format
      % Param5Format
      % Param6Format;

    return MessageFormatter_.getRef();
}

M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format
      % Param4Format
      % Param5Format
      % Param6Format
      % Param7Format;

    return MessageFormatter_.getRef();
}
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format,
                          const M_Format & Param8Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format
      % Param4Format
      % Param5Format
      % Param6Format
      % Param7Format
      % Param8Format;

    return MessageFormatter_.getRef();
}
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format,
                          const M_Format & Param8Format,
                          const M_Format & Param9Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format
      % Param4Format
      % Param5Format
      % Param6Format
      % Param7Format
      % Param8Format
      % Param9Format;

    return MessageFormatter_.getRef();
}
M_String M_FormatMessage (const char * FormatString, 
                          const M_Format & Param1Format,
                          const M_Format & Param2Format,
                          const M_Format & Param3Format,
                          const M_Format & Param4Format,
                          const M_Format & Param5Format,
                          const M_Format & Param6Format,
                          const M_Format & Param7Format,
                          const M_Format & Param8Format,
                          const M_Format & Param9Format,
                          const M_Format & Param10Format)
{
    M_MessageFormatter MessageFormatter_ (FormatString);
    MessageFormatter_ 
      % Param1Format
      % Param2Format
      % Param3Format
      % Param4Format
      % Param5Format
      % Param6Format
      % Param7Format
      % Param8Format
      % Param9Format
      % Param10Format;

    return MessageFormatter_.getRef();
}

//=========================================================================

M_MessageFormatter M_makeMessageFormatter (const char * FormatString)
{
    return M_MessageFormatter (FormatString);
}

//-------------------------------------------------------------------------

M_String & operator+= (M_String & String, M_MessageFormatter & MessageFormatter)
{
    MessageFormatter.appendTo (String);
    return String;
}

//-------------------------------------------------------------------------

M_MessageFormatter::M_MessageFormatter (const char * FormatString)
{
    m_FormatString = FormatString;
}

M_MessageFormatter::~M_MessageFormatter ()
{
#if (M_MessageFormat_IsUseWxString == 1)
    int FormatCount = m_FormatArray.GetCount();
#elif (M_MessageFormat_IsUseStdString == 1)
    int FormatCount = m_FormatArray.size();
#else
    #error "missing implementation to obtain array size of M_FormatArray"
#endif

    for (int FormatIndex=0; FormatIndex<FormatCount; ++FormatIndex)
      {
        delete m_FormatArray[FormatIndex];
        m_FormatArray[FormatIndex] = NULL;
      }
}

//-------------------------------------------------------------------------

#if 0 // TEST commented out - see comment in header
M_MessageFormatter & M_MessageFormatter::operator% (int Integer)
{
    addFormat (new M_Format (Integer));
    return *this;
}

M_MessageFormatter & M_MessageFormatter::operator% (long Long)
{
    addFormat (new M_Format (Long));
    return *this;
}

M_MessageFormatter & M_MessageFormatter::operator% (const double & Double)
{
    addFormat (new M_Format (Double));
    return *this;
}

M_MessageFormatter & M_MessageFormatter::operator% (const char * CharPtr)
{
    addFormat (new M_Format (CharPtr));
    return *this;
}

M_MessageFormatter & M_MessageFormatter::operator% (const M_String & String)
{
    addFormat (new M_Format (String));
    return *this;
}
#endif

M_MessageFormatter & M_MessageFormatter::operator% (const M_Format & Format)
{
    addFormat (new M_Format (Format));
    return *this;
}

M_MessageFormatter & M_MessageFormatter::operator% (M_Format * FormatPtr)
{
    addFormat (FormatPtr);
    return *this;
}

//-------------------------------------------------------------------------

M_MessageFormatter & M_MessageFormatter::addFormat (M_Format * FormatPtr)
{
#if (M_MessageFormat_IsUseWxString == 1)
    m_FormatArray.Add (FormatPtr);
#elif (M_MessageFormat_IsUseStdString == 1)
    m_FormatArray.push_back (FormatPtr);
#else
    #error "addFormat(): unhandled/missing array addition"
#endif
    return *this;
}

//-------------------------------------------------------------------------

void M_MessageFormatter::format ()
{
#if (M_MessageFormat_IsUseWxString == 1)
    int FormatStringCharCount = m_FormatString.Length();
#elif (M_MessageFormat_IsUseStdString == 1)
    int FormatStringCharCount = m_FormatString.length();
#else
    #error "missing implementation to obtain string length of M_FormatString"
#endif
    bool IsPreviousCharPercentChar = false;

    int FormatIndex = 0;

    for (int FormatStringCharIndex=0;
         FormatStringCharIndex < FormatStringCharCount;
         ++FormatStringCharIndex)
      {
        const char * FormatStringCharPtr = & (m_FormatString.c_str() [FormatStringCharIndex]);

        if (IsPreviousCharPercentChar)
          {
            if (*FormatStringCharPtr == '%')
              {
                m_OutputString += '%';
              }
            else if (isdigit (*FormatStringCharPtr)
                     || (*FormatStringCharPtr == '+')
                     || (*FormatStringCharPtr == '{'))
              {
                bool IsParsed = false;
                if (*FormatStringCharPtr == '+')
                  {
                    // used syntax is "%+"
                    ++FormatIndex;
                    IsParsed = true;
                  }
                else if (*FormatStringCharPtr == '{')
                  {
                    // used syntax is "%{N}" (e.g. "%{12}", "%{5}"
                    int ParsedCharacterCount = 0;
                    if (sscanf (FormatStringCharPtr + 1, "%d%n", 
                                & FormatIndex,
                                & ParsedCharacterCount) >= 1)
                      {
                        IsParsed = true;

                        FormatStringCharIndex += ParsedCharacterCount;
                        if (FormatStringCharPtr [ParsedCharacterCount + 1] == '}')
                          {
                            ++FormatStringCharIndex;
                          }
                      }
                  }
                else if (isdigit (*FormatStringCharPtr))
                  {
                    // used syntax is "%N" (single digit, e.g. "%2")
                    FormatIndex = ((int) *FormatStringCharPtr) - '0';
                    IsParsed = true;
                  }

                if (IsParsed)
                  {
                    if (FormatIndex > 0
                        && cast_is_equal_smaller (FormatIndex, 
#if (M_MessageFormat_IsUseWxString == 1)
                                                  m_FormatArray.GetCount()))
#elif (M_MessageFormat_IsUseStdString == 1)
                                                  m_FormatArray.size()))
#else
    #error "missing implementation to obtain size of M_FormatArray"
#endif
                      {
                        m_FormatArray[FormatIndex-1] -> appendTo (m_OutputString);
                      }
                    else
                      {
                        m_OutputString += "[??]";
                        // TODO: could add logging if argument is missing
                      }
                  }
              }
            IsPreviousCharPercentChar = false;
          }
        else
          {
            if (*FormatStringCharPtr != '%')
              m_OutputString += *FormatStringCharPtr;

            IsPreviousCharPercentChar = *FormatStringCharPtr == '%';
          }
      }
}

//-------------------------------------------------------------------------

const M_String & M_MessageFormatter::getRef ()
{
    format ();
    return m_OutputString;
}

M_MessageFormatter::operator const M_String & ()
{
    format ();
    return m_OutputString;
}

M_MessageFormatter::operator const char * ()
{
    format ();
    return m_OutputString.c_str();
}

//-------------------------------------------------------------------------

void M_MessageFormatter::appendTo (M_String & String)
{
    String += operator const M_String & ();
}

void M_MessageFormatter::assignTo (M_String & String)
{
    String = operator const M_String & ();
}

//=========================================================================

#endif // (defined M_MessageFormat_IsEmitImplementation)

//=========================================================================

#endif /* M_MessageFormat_IsUseStxFormatMessage */

//=========================================================================
