// -*- c++ -*-
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2006-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxWidgetsExtensions library Copyright notice
*/

//-------------------------------------------------------------------------

#ifndef _INCLUDED_WxExtLibConfig_Version_h
#define _INCLUDED_WxExtLibConfig_Version_h

//-------------------------------------------------------------------------
// WxExtLib Version setup
//-------------------------------------------------------------------------

#include <WxExtLibConfig.h>

//-------------------------------------------------------------------------

// version number setup for this WxExtLib source
// - note: SubMinorVersion sometimes is referred to as "micro-version",
//   "release-number", "patch-level"
// - ranges (relevant for M_WxExtLib_makeVersionLong() and rel. macros):
//   - MajorInt: 0-99, 
//   - MinorInt: 0-99,
//   - SubMinorInt: 0-9999
#define M_WxExtLib_MajorVersionInt 0
#define M_WxExtLib_MinorVersionInt 84
#define M_WxExtLib_SubMinorVersionInt 0018

#define M_WxExtLib_VersionTagString "-"

//-------------------------------------------------------------------------

#define M_WxExtLib_CompilationDateString __DATE__ 
#define M_WxExtLib_CompilationTimeString __TIME__
#define M_WxExtLib_VersionFileTimestampString "?" /* __TIMESTAMP__ */

#define M_WxExtLib_LastRepositoryDate "$Date: 2007/04/12 20:00:14 $"
#define M_WxExtLib_LastRepositoryRevision "$Revision: 1.9 $"

//-------------------------------------------------------------------------

// compose version ident string, for example "0.78.0005":
#define M_WxExtLib_VersionIdentString \
    "" M_PP_stringize(M_WxExtLib_MajorVersionInt) "."  \
    "" M_PP_stringize(M_WxExtLib_MinorVersionInt) "."  \
    "" M_PP_stringize(M_WxExtLib_SubMinorVersionInt)   \

#define M_WxExtLib_DateIdentString "2007-04-12.01"

//-------------------------------------------------------------------------

// version number handling
// - note: next defintions are maybe useful, but for improved flexibility,
//   it would be better to use special version class instead of 
//   packing version into long
#define M_WxExtLib_makeVersionLong(MajorInt,MinorInt,SubMinorInt) \
     (M_WxExtLib_MajorVersionInt * 10000000 \
      + M_WxExtLib_MinorVersionInt * 100000 \
      + M_WxExtLib_SubMinorVersionInt *  10)

#define M_WxExtLib_SourceVersionLong \
      M_WxExtLib_makeVersionLong(M_WxExtLib_MajorVersionInt, \
                                 M_WxExtLib_MinorVersionInt, \
                                 M_WxExtLib_SubMinorVersionInt)
// maybe:
//   #define M_WxExtLib_fillVersionStruct()

// return version information of code in a DLL                                     
// - TagString will point to statically allocated string
M_WxExtLib_ExportDecl void getWxExtLibLinkedLibraryVersion (long & MajorInt, 
                                                            long & MinorInt,
                                                            long & SubMinorInt,
                                                            const char ** TagString);

//-------------------------------------------------------------------------

#endif

//-------------------------------------------------------------------------
