// -*- c++ -*-
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2006-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice
*/

//-------------------------------------------------------------------------

#ifndef _INCLUDED_WxExtLibConfig_Auto_h
#define _INCLUDED_WxExtLibConfig_Auto_h

//=========================================================================
// automatic setting of global defines
//=========================================================================

//-------------------------------------------------------------------------
// class, function, static variable export declarator: default to none
//
// possible alternatives for M_WxExtLib_ExportDecl in Win32/VC++ compilations:
// - __declspec(dllexport)
// - __declspec(dllimport)

// TEST
// putting classes into DLL is untested

#ifndef M_WxExtLib_ExportDecl
#   if (defined M_WxExtLib_IsExtLibDllExport)
#       define M_WxExtLib_ExportDecl __declspec(dllexport)
#   elif (defined M_WxExtLib_IsExtLibDllImport)
#       define M_WxExtLib_ExportDecl __declspec(dllimport)
#   else
#       define M_WxExtLib_ExportDecl /* empty */
#   endif
#else
    // use supplied define
#endif

//-------------------------------------------------------------------------

// MessageFormat wxString interface defining
//     wxMessageFormatter/wxFormat/wxFormatMessage()
// is required for WxExtLib:
#define M_MessageFormat_WxString

//-------------------------------------------------------------------------
// wxMinimalTimeInterval: use ::GetTickCount() instead of
// wxGetLocalTimeMillis() if possible - see declaration of
// class wxMinimalTimeInterval

#if ((defined WIN32) || (defined _WIN32))
#   define M_MinimalTimeInterval_UseGetTickCount
#endif

//-------------------------------------------------------------------------

#endif
