
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2003-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice

-------------------------------------------------------------------------
*/

#ifndef _NO_HEADER_INCLUDE

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
    #pragma implementation "WxExtDialog.h"
#endif

#include "WxExtLibConfig.h"

// For compilers that support precompilation, includes "wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include <wx/statline.h>

#ifdef M_IsHaveGridBagSizer
#   include <wx/gbsizer.h>
#endif

#include <wx/busyinfo.h>
#include <wx/calctrl.h>
// #include <wx/html/htmprint.h>

#include "WxExtDialog.h"
#include "WxMisc.h"

#include "TextCtrlSliderPairValidators.h"

#include <math.h>

#include "safecast.h"

#endif // _NO_HEADER_INCLUDE

#include <wx/arrimpl.cpp>

#if (M_WxExtLib_IsUseStxLogging == 1)
    #include <StxConfig.h>
    #include <StxSimpleLog.h>
    #include <StxException.h>
#endif

//-------------------------------------------------------------------------

#if (M_WxExtLib_IsUseStxLogging == 1)
    #define __try M_StxException_Try
    #define __catch_rethrow M_StxException_Rethrow
    #define __catch_displayMessageBox M_StxException_DisplayException
#endif

//=========================================================================

#ifdef M_WxExtLib_IsMFCCompatibility

wxWindow * MSWCreateChildWindowForMFCFrame (CWnd * ParentWindow)
{
    //-------------------------------------------------------------------------
    // creating a wxFrame has following disadvantages:
    // - non-modal dialogs are hidden if the MFC main frame is activated
    // - wxDialogs will have an own icon in the task-switch window
    // - when activating an other application and switching back to this
    //   application, modal and non-modal dialogs having the wxFrame
    //   as parent are hidden
    //
    //  wxWindow * Window = new wxFrame (NULL, -1, "Dummy Frame", 
    //                                   wxPoint(10, 10), wxSize(300, 300),
    //                                   wxFRAME_NO_TASKBAR); // wxDEFAULT_FRAME_STYLE

    //-------------------------------------------------------------------------
    // create a normal MFC child window for the specified parent:
    CWnd * Wnd = new CWnd();
    RECT Rect = { 0, 0, 100, 100 };
    Wnd -> Create (NULL, "Dummy Frame", 
                   WS_CHILD, 
                   Rect, 
                   ParentWindow,
                   NULL,
                   NULL);

    WXHWND WxHwnd = Wnd != NULL ? (long) Wnd -> m_hWnd : 0;

    // make the MFC window wxWindow class compatible (this seems to work!)
    wxWindow * Window = new wxWindow ();
    if (Window)
    {
        Window -> SetEventHandler (Window);
        Window -> SetHWND (WxHwnd);
        Window -> SetId (-1);
        Window -> SubclassWin (WxHwnd);
        Window -> AdoptAttributesFromHWND ();
        Window -> SetupColours ();
    }

    return Window;
}

#endif

//=========================================================================

enum
{
#if defined(__WXMSW__)
    DefaultDialogFontSize = 8
#elif defined(__WXGTK__)
    DefaultDialogFontSize = 12
#elif defined(__WXX11__)
#   pragma message ("Please adjust DefaultDialogFontSize for your wxWindows port.")
    DefaultDialogFontSize = 12
#elif defined(__WXMOTIF__)
#   pragma message ("Please adjust DefaultDialogFontSize for your wxWindows port.")
    DefaultDialogFontSize = 12
#else
#   pragma message Please adjust DefaultDialogFontSize for your wxWindows port.
    DefaultDialogFontSize = 12
#endif
};

//-------------------------------------------------------------------------

#if 0
    // EVT_QUERY_END_SESSION and EVT_END_SESSION apply only to wxApp
    EVT_QUERY_END_SESSION (ClassName::OnCloseEvent) 
    EVT_END_SESSION (ClassName::OnCloseEvent) 
#endif

#define M_WxExtDlgBase_ImplementWatchedControlChangeEventHandlers(ClassName) \
    EVT_CLOSE (ClassName::OnCloseEvent)  \
 \
    EVT_TEXT  (wxID_ANY, ClassName::OnTextCtrlChanged) \
    EVT_COMMAND_SCROLL_ENDSCROLL (wxID_ANY, ClassName::OnSliderCtrlChanged) \
    EVT_RADIOBUTTON (wxID_ANY, ClassName::OnRadioButtonSelected) \
    EVT_RADIOBOX (wxID_ANY, ClassName::OnRadioBoxSelected) \
    EVT_CHECKBOX (wxID_ANY, ClassName::OnCheckBoxSelected) \
    EVT_COMBOBOX (wxID_ANY, ClassName::OnComboBoxSelected) \
    EVT_LISTBOX (wxID_ANY, ClassName::OnListBoxSelected) \
    EVT_CHOICE (wxID_ANY, ClassName::OnChoiceCtrlSelected) \
    EVT_BUTTON (wxID_ANY, ClassName::OnButtonClicked) \

//=========================================================================

wxExtDlgBase::wxExtDlgBase()
{
    // not here: initCWxDialog();
}

void wxExtDlgBase::initCWxDialog ()
{
    m_ZoomValue = 1.; 
    m_DialogZoomValue = 1.;
    m_DesktopReferenceSize = wxSize (-1, -1);
    m_BorderCompressionValue = 1.;

    m_DialogFontSize = DefaultDialogFontSize;
    m_DialogFontHeight = DefaultDialogFontSize;

    m_IsSetFontIfSameAsDefaultSize = false;

    m_IsWatchedControlChangeNotification = false;
    m_IsDialogInitialized = false;
    m_StatusMessageTarget = NULL;
    // m_ErrorMessageMultiLineText = NULL;
}

wxExtDlgBase::~wxExtDlgBase()
{
    delete m_StatusMessageTarget;
    m_StatusMessageTarget = NULL;
}

//-------------------------------------------------------------------------

void wxExtDlgBase::setDialogInitializedFlag()
{
    m_IsDialogInitialized = true;
}

//=========================================================================

#ifdef M_IsNonWxMainIntegration

wxWindow *wxExtDlgBase::FindSuitableParent() const
{
    wxWindow * ParentWindow = NULL;

#if 0
    // TODO: GetModalDialogList() should be a const function
    // HACK: cast away const from 'this' pointer to be able to use
    // GetModalDialogList()
    // WARN cast
    wxWindowList & ModalDialogList = ((wxDialog *) getDialog()) -> GetModalDialogList ();
    if (ModalDialogList.GetCount() > 0)
      {
        // TEST: if another modal dialog is shown, use this one as parent
        // (otherwise, no input is possible to any modal dialogs anymore
        // if another modal dialog is shown already, and the dialog is created 
        // only once)
        // (has not helped)
        // Finally, the problem was solved by calling new/Create() everytime
        // the dialog is shown modally. This way, the dialog gets the a correct
        // parent window automatically.
        wxWindowList::Node * LastWindowNode = ModalDialogList.GetLast();
        ParentWindow = LastWindowNode->GetData();
      }
    else
#endif
      {
        wxWindow * ParentWindow = wxDialog::FindSuitableParent();

        if (ParentWindow == NULL)
          {
            ParentWindow = wxTheApp->GetTopWindow();
            // we use this window even if it is not shown:
            // it is our special child window that has the MFC frame
            // as parent (wxDialog::FindSuitableParent() above will
            // return NULL because it is not shown)
          }
      }

    return ParentWindow;
}

#endif // M_IsNonWxMainIntegration

//-------------------------------------------------------------------------

#ifdef M_IsNonWxMainIntegration
#if defined(__WXMSW__)

void wxExtDlgBase::MSWEnableOtherWindows (bool IsEnable)
{
    // for MFC main window compatibility:
    AfxGetApp() -> EnableModeless (IsEnable);
    AfxGetMainWnd() -> EnableWindow (IsEnable);
}

#endif // defined(__WXMSW__)
#endif

#if defined(__WXMSW__)
HWND wxExtDlgBase::MSWGetHandle()
{
    return (HWND) (getDialog() -> GetHWND());
}
#endif

//=========================================================================

wxSizer * wxExtDlgBase::addSpace (int Width, int Height, const wxSizerAdderProxy & SizerAdderProxy)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    SizerAdder -> addSpace (Width, Height, 0, 0);

    return SizerAdder -> getSizer();
}

//-------------------------------------------------------------------------

wxWindow * wxExtDlgBase::getAddParentWindow (wxSizerAdder * SizerAdder)
{
    if (SizerAdder -> getParentWindow() != NULL)
      {
        return SizerAdder -> getParentWindow();
      }

    return getDialog();
}

//-------------------------------------------------------------------------

wxButton * wxExtDlgBase::addButton (wxButton ** ButtonPtrPtr,
                                   wxWindowID ButtonId, 
                                   wxCommandEventFunction CommandEventFunction,
                                   const wxString& LabelString, 
                                   const wxSizerAdderProxy & SizerAdderProxy,
                                   const wxPoint& Position,
                                   const wxSize& Size,
                                   long Style, const wxValidator& Validator)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxButton * Button = NULL;

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultButtonSize);

    // to use wxBU_EXACTFIT, wxDefaultSize must be specifed as size
    if (Style & wxBU_EXACTFIT)
      UsedSize = wxDefaultSize;

    Button = new wxButton (getAddParentWindow (SizerAdder), ButtonId, LabelString, Position, UsedSize, 
                           Style, Validator);

    if (CommandEventFunction != (wxCommandEventFunction) NULL)
      {
        getDialog() -> Connect (Button -> GetId(),
                                wxEVT_COMMAND_BUTTON_CLICKED,
                                (wxObjectEventFunction) (wxEventFunction) CommandEventFunction);
      }

    if (SizerAdder != NULL)
      SizerAdder -> addWindow (Button, 0, _B(0));

    if (ButtonPtrPtr != NULL)
      *ButtonPtrPtr = Button;
    return Button;
}

//-------------------------------------------------------------------------

wxSizer * wxExtDlgBase::addCheckBoxWithLabel (wxCheckBox ** CheckBox,
             const wxString & LabelString, const wxValidator & Validator,
             long TextCtrlStyle, const wxSizerAdderProxy & SizerAdderProxy, bool IsLabelOnTheLeft)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);
    wxWindow *PanelWnd = getAddParentWindow (SizerAdder);

    // if (SizerAdder == NULL)
    //  {
    //    Sizer = new wxBoxSizer (wxHORIZONTAL);
    //  }

    bool IsExtraLabelControl = TextCtrlStyle & wxTE_READONLY || IsLabelOnTheLeft;
    int CheckBoxStyle = TextCtrlStyle;
    CheckBoxStyle = CheckBoxStyle & ~wxTE_READONLY;

    *CheckBox = new wxCheckBox (PanelWnd, -1, 
                                wxString (IsExtraLabelControl ? wxString("") : LabelString), 
                                // IsExtraLabelControl ? wxString("") : wxString(LabelString), 
                                wxDefaultPosition, wxDefaultSize, CheckBoxStyle, Validator);
    wxStaticText * StaticText = NULL;

    if (TextCtrlStyle & wxTE_READONLY)
      {
        (*CheckBox) -> Enable (false);
      }

    if (IsExtraLabelControl)
      {
        StaticText = new wxStaticText (PanelWnd, -1, LabelString);
      }

    if (! IsLabelOnTheLeft)
      {
        SizerAdder -> addWindow (*CheckBox, wxEXPAND|wxALIGN_CENTER_VERTICAL, _B(5));
        if (IsExtraLabelControl)
            SizerAdder -> addWindow (StaticText, wxLEFT|wxEXPAND|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, _B(5));
      }
    else
      {
        SizerAdder -> addWindow (StaticText, wxRIGHT|wxEXPAND|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, _B(8));
        SizerAdder -> addWindow (*CheckBox, wxEXPAND|wxALIGN_CENTER_VERTICAL, _B(8));
      }

    return SizerAdder -> getSizer();
}

//-------------------------------------------------------------------------

wxSizer * wxExtDlgBase::addRadioButtonWithLabel (wxRadioButton ** RadioButton,
             const wxString & LabelString, const wxValidator & Validator,
             long RadioCtrlStyle, const wxSizerAdderProxy & SizerAdderProxy)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);
    wxWindow *PanelWnd = getAddParentWindow (SizerAdder);

    // if (SizerAdder == NULL)
    //  {
    //    Sizer = new wxBoxSizer (wxHORIZONTAL);
    //  }

    *RadioButton = new wxRadioButton (PanelWnd, -1, 
                                      LabelString, 
                                      wxDefaultPosition, wxDefaultSize, 
                                      RadioCtrlStyle, Validator);

//  if (TextCtrlStyle & wxTE_READONLY)
//    {
//      (*RadioButton) -> Enable (false);
//    }

    SizerAdder -> addWindow (*RadioButton, wxEXPAND|wxALIGN_CENTER_VERTICAL, _B(5));

    return SizerAdder -> getSizer();
}

//-------------------------------------------------------------------------

wxStaticText * wxExtDlgBase::addLabel (wxStaticText ** StaticTextCtrl,
                                       const wxString & LabelString,
                                       const wxSizerAdderProxy & SizerAdderProxy,
                                       long WindowStyle,
                                       const wxSize & Size,
                                       bool IsTransparent,
                                       long TransparentStaticTextFlags)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxStaticText * TempStaticTextCtrl = NULL;

    if (!IsTransparent)
      {
        TempStaticTextCtrl = new wxStaticText (getAddParentWindow (SizerAdder), -1, LabelString,
                                               wxDefaultPosition, Size,
                                               WindowStyle);
      }
    else
      {
        wxTransparentStaticText::ETransparentStaticTextFlags SpecialFlags
          = (wxTransparentStaticText::ETransparentStaticTextFlags) TransparentStaticTextFlags;
        TempStaticTextCtrl = new wxTransparentStaticText (getAddParentWindow (SizerAdder), -1, LabelString,
                                                          wxDefaultPosition, Size,
                                                          WindowStyle,
                                                          SpecialFlags);
      }
    
    if (StaticTextCtrl != NULL)
      *StaticTextCtrl = TempStaticTextCtrl;
    
    if (SizerAdder != NULL)
      SizerAdder -> addWindow (TempStaticTextCtrl, wxRIGHT|wxALIGN_CENTER_VERTICAL, _B(8));

    return TempStaticTextCtrl;
}

wxWindow * wxExtDlgBase::addMultiLineText (wxMultiLineText * MultiLineText,
                                        long CtrlStyle,
                                        const wxSize & CtrlSize,
                                        int MultiLineTextStyle,
                                        const wxSizerAdderProxy & SizerAdderProxy)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxSize UsedSize = getSizeFromDefaults (CtrlSize, m_DefaultTextCtrlSize);

    MultiLineText -> create (getAddParentWindow (SizerAdder), -1, 
                             CtrlStyle, 
                             UsedSize,
                             MultiLineTextStyle);

    if (MultiLineText -> getHtmlWindow() != NULL)
      {
        setHtmlWindowFonts (MultiLineText -> getHtmlWindow(),
                            m_DialogFontSize,
                            true,
                            false);

        MultiLineText -> getHtmlWindow() -> SetBackgroundColour (getDialog() -> GetBackgroundColour ());
      }

    if (SizerAdder != NULL)
      SizerAdder -> addWindow (MultiLineText -> getWindow(), wxEXPAND, _B(0));

    return MultiLineText -> getWindow ();
}

wxWindow * wxExtDlgBase::addMultiLineText (wxMultiLineText * MultiLineText,
										  long CtrlStyle,
										  const wxSize & CtrlSize,
										  int MultiLineTextStyle,
										  const wxSizerAdderProxy & SizerAdderProxy,
										  const wxString & TextString,
										  int MinLineCount, int MaxLineCount, 
										  int BorderWidth)
{
    wxSizerAdder AlternativeSizerAdder;
    // wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxWindow * Window = addMultiLineText (MultiLineText,
                                          CtrlStyle,
                                          CtrlSize,
                                          MultiLineTextStyle,
                                          SizerAdderProxy);

	if (MultiLineText -> getHtmlWindow() != NULL)
	  {
		MultiLineText -> getHtmlWindow() -> SetBorders (BorderWidth);
	  }

    MultiLineText -> setText (TextString);
    adjustMultiLineTextSize (* MultiLineText, MinLineCount, MaxLineCount);

    return Window;
}

wxTextCtrl * wxExtDlgBase::addTextCtrl
   (
    wxTextCtrl ** TextCtrl, const wxValidator & Validator,
    long TextCtrlStyle,
    const wxSize& Size,
    const wxSizerAdderProxy & SizerAdderProxy
    )
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultTextCtrlSize);

    *TextCtrl = new wxTextCtrl (getAddParentWindow (SizerAdder), -1, _T(""),
                                wxDefaultPosition, UsedSize,
                                TextCtrlStyle, Validator);

    if (TextCtrlStyle & wxTE_READONLY)
      {
        // (*TextCtrl) -> SetBackgroundColour (*wxLIGHT_GREY);
        (*TextCtrl) -> SetBackgroundColour (getDialog() -> GetBackgroundColour ());
      }

    if (SizerAdder != NULL)
      {
        SizerAdder -> addWindow (*TextCtrl, 0, _B(0));
      }

    return *TextCtrl;
}

wxSizer * wxExtDlgBase::addTextCtrlWithLabel (wxTextCtrl ** TextCtrl,
                                           const wxString & LabelString, 
                                           const wxValidator & Validator,
                                           long TextCtrlStyle,
                                           const wxSize & Size,
                                           const wxSizerAdderProxy & SizerAdderProxy)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    // if (Sizer == NULL)
    // {
    //  Sizer = new wxBoxSizer (wxHORIZONTAL);
    //  }
    if (! LabelString.IsEmpty())
      {
        SizerAdder -> addWindow (new wxStaticText (getAddParentWindow (SizerAdder), -1, LabelString),
                                 wxRIGHT|wxALIGN_CENTER_VERTICAL, _B(8));
      }

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultTextCtrlSize);
    SizerAdder -> addWindow (addTextCtrl (TextCtrl,
                                          Validator, TextCtrlStyle, 
                                          UsedSize),
                             wxALIGN_CENTER_VERTICAL, _B(8));
    
    return SizerAdder -> getSizer();
}

wxSizer * wxExtDlgBase::addTextCtrlWithTwoLabels (wxTextCtrl ** TextCtrl,
                                               const wxString & FirstLabelString,
                                               const wxString & SecondLabelString,
                                               const wxValidator & Validator,
                                               long TextCtrlStyle, 
                                               const wxSize & Size,
                                               const wxSizerAdderProxy & SizerAdderProxy)
{
    // NOTE: OtherSizer is possibly the same as Sizer
    wxSizer * OtherSizer = addTextCtrlWithLabel (TextCtrl, FirstLabelString, Validator,
                                                 TextCtrlStyle, Size, SizerAdderProxy);
    // TODO (maybe) use wxSizerAdder, getAddParentWindow (SizerAdder)
    OtherSizer -> Add (new wxStaticText (getDialog(), -1, SecondLabelString),
                       0, wxLEFT|wxALIGN_CENTER_VERTICAL, _B(5));

    return OtherSizer;
}

wxSizer * wxExtDlgBase::addTextCtrlSliderPairWithLabel (wxTextCtrl ** TextCtrl,
                                                     wxSlider ** SliderCtrl,
                                                     const wxString & LabelString,
                                                     long * LongValue, long MinLong, long MaxLong,
                                                     wxStatusMessageTarget * StatusMessageTarget,
                                                     const wxSizerAdderProxy & SizerAdderProxy,
                                                     const wxString & FieldNameString)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    // if (SizerAdder == NULL)
    // {
    //    Sizer = new wxBoxSizer (wxHORIZONTAL);
    //  }

    SizerAdder -> addWindow (new wxStaticText (getAddParentWindow (SizerAdder), -1, LabelString),
                             wxALIGN_CENTER_VERTICAL, _B(5));

    *TextCtrl = new wxTextCtrl (getAddParentWindow (SizerAdder), -1, _T(""),
                                wxDefaultPosition,
                                wxSize(getAdjustedTextCtrlWidth(60), getAdjustedTextCtrlHeight (1, true)),
                                wxTE_LEFT,
                                wxTextCtrlSliderPairTextCtrlValidator (LongValue, MinLong, 
                                                                       MaxLong, StatusMessageTarget,
                                                                       FieldNameString));
    SizerAdder -> addWindow (*TextCtrl, wxLEFT|wxALIGN_CENTER_VERTICAL, _B(5));
    
    // specify 'MinLong' as initial value for the slider just in case it is not yet initialized correctly:
    *SliderCtrl = new wxSlider(getAddParentWindow (SizerAdder), -1, MinLong , MinLong, MaxLong, wxDefaultPosition, 
                               wxSize (getAdjustedSliderWidth(160), getAdjustedSliderHeight(22)), 
                               wxSL_HORIZONTAL,
                               wxTextCtrlSliderPairSliderValidator ());
    SizerAdder -> addWindow (*SliderCtrl, wxLEFT|wxALIGN_CENTER_VERTICAL, _B(5));

//  wxTextCtrlSliderPairSliderValidator * TextCtrlSliderPairSliderValidator =
//    wxDynamicCast ((**SliderCtrl).GetValidator(), wxTextCtrlSliderPairSliderValidator);
//  wxTextCtrlSliderPairTextCtrlValidator * TextCtrlSliderPairTextCtrlValidator =
//    wxDynamicCast ((**TextCtrl).GetValidator(), wxTextCtrlSliderPairTextCtrlValidator);
    wxTextCtrlSliderPairSliderValidator * TextCtrlSliderPairSliderValidator =
      (wxTextCtrlSliderPairSliderValidator *) (**SliderCtrl).GetValidator();
    wxTextCtrlSliderPairTextCtrlValidator * TextCtrlSliderPairTextCtrlValidator =
      (wxTextCtrlSliderPairTextCtrlValidator *) (**TextCtrl).GetValidator();

    if (TextCtrlSliderPairSliderValidator)
      TextCtrlSliderPairSliderValidator -> setAssociatedTextCtrlValidator (TextCtrlSliderPairTextCtrlValidator);

    if (TextCtrlSliderPairTextCtrlValidator)
      TextCtrlSliderPairTextCtrlValidator -> setAssociatedSliderValidator (TextCtrlSliderPairSliderValidator);

    return SizerAdder -> getSizer();
}

//-------------------------------------------------------------------------

wxListBox * wxExtDlgBase::addListBox
   (
    wxListBox ** ListBox, const wxValidator & Validator,
    int ChoiceCount, const wxString ChoiceStringArray [],
    const wxSize& Size,
    const wxSizerAdderProxy & SizerAdderProxy
    )
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultListBoxSize);

    long WindowStyle = 0;
    *ListBox = new wxListBox (getAddParentWindow (SizerAdder), -1,
                              wxDefaultPosition, UsedSize,
                              ChoiceCount, ChoiceStringArray,
                              WindowStyle, Validator);

    return *ListBox;
}

//-------------------------------------------------------------------------

wxChoice * wxExtDlgBase::addChoiceCtrl
   (
    wxChoice ** ChoiceCtrl, const wxValidator & Validator,
    int ChoiceCount, const wxString ChoiceStringArray [],
    const wxSize& Size,
    const wxSizerAdderProxy & SizerAdderProxy
    )
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultChoiceCtrlSize);

    long WindowStyle = 0;
    *ChoiceCtrl = new wxChoice (getAddParentWindow (SizerAdder), -1,
                                wxDefaultPosition, UsedSize,
                                ChoiceCount, ChoiceStringArray,
                                WindowStyle, Validator);

    return *ChoiceCtrl;
}

wxSizer * wxExtDlgBase::addChoiceCtrlWithLabel (wxChoice ** ChoiceCtrl,
                                             const wxString & LabelString, 
                                             const wxValidator & Validator,
                                             int ChoiceCount, const wxString ChoiceStringArray [],
                                             const wxSize & Size,
                                             const wxSizerAdderProxy & SizerAdderProxy)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    // if (Sizer == NULL)
    // {
    //    Sizer = new wxBoxSizer (wxHORIZONTAL);
    //  }
    if (! LabelString.IsEmpty())
      {
        SizerAdder -> addWindow (new wxStaticText (getAddParentWindow (SizerAdder), -1, LabelString),
                                 wxRIGHT|wxALIGN_CENTER_VERTICAL, _B(8));
      }

    SizerAdder -> addWindow (addChoiceCtrl (ChoiceCtrl, Validator,
                                            ChoiceCount, ChoiceStringArray,
                                            Size),
                             wxALIGN_CENTER_VERTICAL, _B(8));
    
    return SizerAdder -> getSizer();
}

//-------------------------------------------------------------------------

wxComboBox * wxExtDlgBase::addComboBox
   (
    wxComboBox ** ComboBox, const wxValidator & Validator,
    int StringCount, const wxString StringArray [],
    const wxSize& Size,
    const wxSizerAdderProxy & SizerAdderProxy
    )
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultComboBoxSize);

    long WindowStyle = 0;
    *ComboBox = new wxComboBox (getAddParentWindow (SizerAdder), -1, "",
                                wxDefaultPosition, UsedSize,
                                StringCount, StringArray,
                                WindowStyle, Validator);

    return *ComboBox;
}

wxSizer * wxExtDlgBase::addComboBoxWithLabel (wxComboBox ** ComboBox,
                                             const wxString & LabelString, 
                                             const wxValidator & Validator,
                                             int StringCount, const wxString StringArray [],
                                             const wxSize & Size,
                                             const wxSizerAdderProxy & SizerAdderProxy)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    // if (Sizer == NULL)
    // {
    // Sizer = new wxBoxSizer (wxHORIZONTAL);
    // }
    if (! LabelString.IsEmpty())
      {
        SizerAdder -> addWindow (new wxStaticText (getAddParentWindow (SizerAdder), -1, LabelString),
                                 wxRIGHT|wxALIGN_CENTER_VERTICAL, _B(8));
      }

    SizerAdder -> addWindow (addComboBox (ComboBox, Validator,
                                          StringCount, StringArray,
                                          Size),
                             wxALIGN_CENTER_VERTICAL, _B(8));
    
    return SizerAdder -> getSizer();
}

//-------------------------------------------------------------------------

// DEF if (ImageDataSize==-1) then ImageData is the name of a
// resource RCDATA (raw data) block
wxSizer * wxExtDlgBase::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtr,
                                        const unsigned char * ImageData,
                                        size_t ImageDataSize,
                                        const wxPoint& Position,
                                        const wxSize& Size,
                                        const wxSizerAdderProxy & SizerAdderProxy,
                                        long WindowStyle)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    for_once
      {
        // if (Sizer == NULL)
        //  {
        //    Sizer = new wxBoxSizer (wxHORIZONTAL);
        //    if (Sizer == NULL)
        //      break;
        //  }

        wxBitmap * Bitmap = NULL;

        if (cast_is_equal (ImageDataSize, -2))
          {
            // transport Bitmap pointer in ImageData const unsigned char pointer
            Bitmap = (wxBitmap *) ImageData;
          }
        else if (cast_is_not_equal (ImageDataSize, -1))
          {
            if (!loadBitmapFromMemory (ImageData, ImageDataSize, & Bitmap))
              break;
          }
        else
          {
#if defined(__WXMSW__)
            if (!loadBitmapFromResource (ImageData, & Bitmap))
              break;
#endif // defined(__WXMSW__)
          }

        if (Bitmap == NULL)
          break;

        wxSize BitmapSize (Bitmap -> GetWidth(), Bitmap -> GetHeight());
        wxSize UsedSize = getSizeFromAspectRatio (Size, BitmapSize);

        wxStaticBitmap * StaticBitmap = new wxStaticBitmap (getAddParentWindow (SizerAdder), -1, *Bitmap, 
                                                            Position, UsedSize, WindowStyle);
        if (StaticBitmap == NULL)
          break;

        SizerAdder -> addWindow (StaticBitmap, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(0));
        
        if (StaticBitmapPtr != NULL)
          *StaticBitmapPtr = StaticBitmap;
      }

    return SizerAdder -> getSizer();
}

wxSizer * wxExtDlgBase::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtr,
                                        const char * ResourceNameString,
                                        const wxPoint& Position,
                                        const wxSize& Size,
                                        const wxSizerAdderProxy & SizerAdderProxy,
                                        long WindowStyle)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    return addStaticBitmap (StaticBitmapPtr, 
                            (const unsigned char *) ResourceNameString, cast_unsigned (-1),
                            Position, Size, SizerAdder, WindowStyle);
}

wxSizer * wxExtDlgBase::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtr,
                                        wxBitmap * Bitmap,
                                        const wxPoint& Position,
                                        const wxSize& Size,
                                        const wxSizerAdderProxy & SizerAdderProxy,
                                        long WindowStyle)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    // transport Bitmap pointer in ImageData const unsigned char pointer
    return addStaticBitmap (StaticBitmapPtr, 
                            (const unsigned char *) Bitmap, cast_unsigned (-2),
                            Position, Size, SizerAdder, WindowStyle);
}

//-------------------------------------------------------------------------

wxMultiLineText * wxExtDlgBase::createErrorMessageCtrl (wxMultiLineText * ErrorMessageMultiLineTextPtr,
                                                       int LineCount)
{
    wxMultiLineText & ErrorMessageMultiLineText = *ErrorMessageMultiLineTextPtr;
    wxSize Size (1 /* width: -1 worked for wxTextCtrl but doesn't for wxHtmlWindow */, 
                 getAdjustedTextCtrlHeight (LineCount, true) /* height */);

    // flags used for wxTextCtrl were: wxTE_READONLY | wxTE_LINEWRAP | wxTE_MULTILINE | wxVSCROLL
    addMultiLineText (& ErrorMessageMultiLineText, 
                      0,
                      Size,
                      0);

    return ErrorMessageMultiLineTextPtr;
    
}

//-------------------------------------------------------------------------

void wxExtDlgBase::addFlexGridSizer (wxFlexGridSizer ** FlexGridSizer,
                                    int Columns, int VGap, int HGap)
{
    *FlexGridSizer = new wxFlexGridSizer (Columns, VGap, HGap);
}

void wxExtDlgBase::addFlexGridSizer (wxFlexGridSizer ** FlexGridSizer,
                                    int Columns, int VGap, int HGap,
                                    wxSizer * OuterSizer, int AddFlags, int AddBorder)
{
    *FlexGridSizer = new wxFlexGridSizer (Columns, VGap, HGap);

    OuterSizer -> Add (*FlexGridSizer, 0, AddFlags, AddBorder);
}

void wxExtDlgBase::addStaticBox (wxFlexGridSizer ** FlexGridSizer,
                                const wxString & LabelString,
                                int Columns, int VGap, int HGap,
                                wxSizer * OuterSizer, int AddFlags, int AddBorder,
                                const wxSizerAdderProxy & SizerAdderProxy)
{
    wxSizerAdder AlternativeSizerAdder;
    wxSizerAdder * SizerAdder = SizerAdderProxy.makeSizerAdder(AlternativeSizerAdder);

    wxStaticBoxSizer *StaticBoxSizer
      = new wxStaticBoxSizer (new wxStaticBox (getAddParentWindow (SizerAdder), -1, LabelString), wxVERTICAL);

    *FlexGridSizer = new wxFlexGridSizer (Columns, VGap, HGap);

    StaticBoxSizer -> Add (*FlexGridSizer, 0, wxALL|wxEXPAND, _B(5));

    OuterSizer -> Add (StaticBoxSizer, 0, AddFlags, AddBorder);
}

//-------------------------------------------------------------------------

wxFont wxExtDlgBase::createDialogFont (int PointSize, int Family, int Style, int Weight,
                                    const bool IsUnderlined, const wxString& FaceName,
                                    wxFontEncoding Encoding, int * RequestedPointSize,
                                    bool IsCreateFont)
{
    const char * UsedFaceNameString = FaceName;

    int MinReadablePointSize = 3; // probably not a sensible value

#if defined(__WXMSW__)

    if (Family == wxDEFAULT && 
        (Weight == wxNORMAL || Weight == wxBOLD))
      {
        // this is the minimal readable font size at least for some wxSWISS
        // font face under Windows 
        // MinReadablePointSize = 7;

        // this is the minimal readable font size at least for 'Small Fonts'
        // under Windows 
        MinReadablePointSize = 6;

        if (PointSize <= 7)
          {
            UsedFaceNameString = "Small Fonts";
            // ?? Family=wxSWISS;
          }
        else if (PointSize == 8 || PointSize == 10 || PointSize == 12)
          {
            UsedFaceNameString = "MS Sans Serif";
            // ?? Family=wxSWISS;
          }
        else
          {
            // because wxDEFAULT will override requested point size and there seems to
            // be only one size available for wxDEFAULT (9), we must specify an other 
            // (similar) font family if we want other font sizes than the only
            // one available for the wxDEFAULT font
            Family=wxSWISS;

            // NOTE the same problem may exist for other parameters (e.g. wxITALIC),
            // may have to apply similar modification of font family (TODO)
          }

        if (FaceName == "Small Fonts")
          {
            // these font sizes look ugly, so use the next smaller size instead:
            excludeRange (PointSize, 8, 127);
          }
        else if (FaceName == "MS Sans Serif")
          {
          }

      }

#elif (defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXX11__))

    if (Family == wxDEFAULT && 
        (Weight == wxNORMAL || Weight == wxBOLD))
      {

        // 8 seems to be the minimal readable font size under X (no font name provided) 
        // (not much testing done to find special fonts which are readable
        // at smaller sizes)
        MinReadablePointSize = 8;

        // these font sizes look ugly, so use the next smaller size instead:
        excludeRange (PointSize, 9);
        excludeRange (PointSize, 15);
        excludeRange (PointSize, 17);
        excludeRange (PointSize, 19, 23);
        excludeRange (PointSize, 25, 29);

        // could try 'xfontsel' to look for a nicely scaling font for big font
        // sizes

//      if (PointSize > 12)
//        {
//          // bigger font sizes don't look well - no scalable fonts seem to
//          // be used - specfiying wxSWISS doesn't help either (scope: GTK 1.2.7)
//          Family = wxSWISS;
//        }
      }

    // UsedFaceNameString = wxEmptyString;
    // TEST:
    // encoding = wxFONTENCODING_DEFAULT;

// #elif defined(__WXX11__)

#else
#   pragma message ("Please adjust function createDialogFont() for your wxWindows port.")
#endif

    if (PointSize < MinReadablePointSize)
      {
        PointSize = MinReadablePointSize;
      }

    if (RequestedPointSize != NULL)
      *RequestedPointSize = PointSize;

    if (IsCreateFont)
      {
        wxFont TempFont (PointSize,
                         Family, Style, Weight,
                         IsUnderlined, UsedFaceNameString,
                         Encoding);
        // wxString NativeFontInfoDescString = TempFont.GetNativeFontInfoDesc ();
        // int ActualPointSize = TempFont.GetPointSize ();

        return TempFont;
      }
    else
      {
        return wxNullFont;
      }
}

//-------------------------------------------------------------------------

void wxExtDlgBase::excludeRange (int & PointSize, int ExcludeRangeMin, int ExcludeRangeMax)
{
    if (ExcludeRangeMax == -1)
      ExcludeRangeMax = ExcludeRangeMin;

    if (PointSize >= ExcludeRangeMin
        && PointSize <= ExcludeRangeMax)
      PointSize = ExcludeRangeMin - 1;
}

//-------------------------------------------------------------------------

void wxExtDlgBase::adjustMultiLineTextSize (wxMultiLineText & MultiLineText,
                                         int MinLineCount, int MaxLineCount)
{
  int Height = getAdjustedTextCtrlHeight (/* LineCount */ 1, true);
  if (MultiLineText.getTextCtrl() != NULL)
    {
      wxTextCtrl * TextCtrl = MultiLineText.getTextCtrl();
      // adjust size of TextCtrl:
      //
      // under WXGTK, the function GetNumberOfLines() will only count the number
      // of newline characters in the text, which is not really useful since with
      // wxTE_LINEWRAP the number of lines after doing the linebreak will usually
      // differ from the number of newline characters in the text
      // int LineCount = 7;
      //
      // under MSW, the number of lines actually used (after the (Rich) text control 
      // does linebreak internally) can be obtained with GetNumberOfLines(). 
      //
      // since now we doTextLineWrap(), the number of newline-characters
      // is the same as the number of lines after wrapping also for GTK,
      // Lesstif/Motif, X11
      int LineCount = TextCtrl -> GetNumberOfLines();

      if (LineCount < MinLineCount)
        LineCount = MinLineCount;

      // limit height of wxTextCtrl:
      if (LineCount > MaxLineCount)
        LineCount = MaxLineCount;

      // NOTE getAdjustedTextCtrlHeight (LineCount, 1)
      // is not fully correct here, because the font height of the
      // wxTextCtrl may be different from the font height specified
      // for the dialog

      Height = getAdjustedTextCtrlHeight (LineCount, true);
    }
  else if (MultiLineText.getHtmlWindow() != NULL)
    {
      wxHtmlWindow * HtmlWindow = MultiLineText.getHtmlWindow();

      int MinHeight = getAdjustedTextCtrlHeight (MinLineCount, true); // WARN
      int MaxHeight = getAdjustedTextCtrlHeight (MaxLineCount, true); // WARN

      // the required height for the HTML text is contained
      // in the outermost HTML cell's height member
      wxHtmlContainerCell * Cell = HtmlWindow -> GetInternalRepresentation();
      int RenderedHeight = Cell -> GetHeight();
      
      if (RenderedHeight < MinHeight)
        Height = MinHeight;
      else if (RenderedHeight > MaxHeight)
        Height = MaxHeight;
      else
        Height = RenderedHeight;

    }

  wxWindow * Window = MultiLineText.getWindow();
  wxSize WindowSize = Window -> GetSize ();
  WindowSize.SetHeight (Height);
  Window -> SetSize (WindowSize);

  // if the window is already assigned to a sizer, the associated
  // sizer's minimum size must be updated as well (it would otherwise
  // override the size specified via wxWindow::SetSize() above)
  wxSizer * ContainingSizer = Window -> GetContainingSizer();
  if (ContainingSizer != NULL)
    {
      ContainingSizer -> SetItemMinSize (Window, WindowSize);
    }
}

//-------------------------------------------------------------------------

int wxExtDlgBase::getAdjustedBorderSize (int BorderSize)
{
    // int AdjustedBorderSize = m_BorderCompressionValue * BorderSize;
    int AdjustedBorderSize;

    if (BorderSize == 0)
      return 0;

    AdjustedBorderSize = (BorderSize * m_DialogFontSize) / DefaultDialogFontSize;

    if (m_BorderCompressionValue < 1 /*&& m_IsBorderHyperZoom*/)
      {
        double AdjustedBorderSizeDouble = AdjustedBorderSize;
        cast_round_assign (AdjustedBorderSize, pow (AdjustedBorderSizeDouble, m_BorderCompressionValue));
      }
    else
      {
        cast_round_assign (AdjustedBorderSize, AdjustedBorderSize * m_BorderCompressionValue);
      }
    // if the border size was greater zero, the adjusted size shall be
    // at least 1 (pixel)
    if (AdjustedBorderSize < 1)
      AdjustedBorderSize = 1;
    return AdjustedBorderSize;
}

int wxExtDlgBase::getAdjustedTextCtrlWidth (int TextCtrlWidth)
{
    return getAdjustedFontLikeWidth (TextCtrlWidth);
}

int wxExtDlgBase::getAdjustedTextCtrlHeight (int TextCtrlHeight, bool IsFromLineCount)
{
    // TODO: calculation should include type of border and font set
    // for the used control
#if defined(__WXMSW__)
    int TotalBorderingHeight = 10;
#elif defined(__WXMOTIF__)
    int TotalBorderingHeight = 18;
#elif defined(__WXGTK__)
    int TotalBorderingHeight = 18;
#else
#   pragma message ("Please adjust function getAdjustedTextCtrlHeight() for your wxWindows port.")
    int TotalBorderingHeight = 10;
#endif

    if (IsFromLineCount)
      {
        int LineCount = TextCtrlHeight;

#if defined(__WXMOTIF__)
        // under Lesstif(Motif?), requests to set a different font for
        // wxTextCtrl are ignored so always some fixed char width font is used
        int FontHeight = 12;
#else
        int FontHeight = getDialogFontHeight();
#endif

#if defined(__WXMSW__)
        int LineSpacing = 2;
#elif defined(__WXMOTIF__)
        int LineSpacing = 1;
#elif defined(__WXGTK__)
        int LineSpacing = 0;
#else
#       pragma message "Please adjust function getAdjustedTextCtrlHeight() for your wxWindows port."
        int LineSpacing = 0;
#endif

        int TotalHeight = TotalBorderingHeight;
//      if (LineCount >= 1)
//        TotalHeight += (FontHeight) * LineCount
//          + LineSpacing * (LineCount - 1);
        if (LineCount >= 1)
          {
            TotalHeight += (FontHeight + LineSpacing) * (LineCount -1)
              + getDialogFontSize();
          }

        return TotalHeight;
      }
    else
      return getAdjustedFontLikeHeight (TextCtrlHeight - TotalBorderingHeight) + TotalBorderingHeight;
}

int wxExtDlgBase::getAdjustedChoiceCtrlWidth (int ChoiceCtrlWidth)
{
    return getAdjustedFontLikeWidth (ChoiceCtrlWidth);
}

int wxExtDlgBase::getAdjustedChoiceCtrlHeight (int ChoiceCtrlHeight, bool IsFromLineCount)
{
    // HACK just use text ctrl height calculation plus fixed offset
    return getAdjustedTextCtrlHeight (ChoiceCtrlHeight, IsFromLineCount) + 2;
}

int wxExtDlgBase::getAdjustedListBoxWidth (int ListBoxWidth)
{
    return getAdjustedFontLikeWidth (ListBoxWidth);
}

int wxExtDlgBase::getAdjustedListBoxHeight (int ListBoxHeight, bool IsFromLineCount)
{
    // HACK just use text ctrl height calculation plus fixed offset
    return getAdjustedTextCtrlHeight (ListBoxHeight, IsFromLineCount) + 2;
}

int wxExtDlgBase::getAdjustedComboBoxWidth (int ComboBoxWidth)
{
    return getAdjustedFontLikeWidth (ComboBoxWidth);
}

int wxExtDlgBase::getAdjustedComboBoxHeight (int ComboBoxHeight, bool IsFromLineCount)
{
    // HACK just use text ctrl height calculation plus fixed offset
    return getAdjustedTextCtrlHeight (ComboBoxHeight, IsFromLineCount) + 2;
}

int wxExtDlgBase::getAdjustedButtonWidth (int ButtonWidth)
{
    return getAdjustedFontLikeWidth (ButtonWidth);
}

int wxExtDlgBase::getAdjustedButtonHeight ()
{
#if defined(__WXMOTIF__)
    // NOTE Lesstif(Motif?) uses a lot of space around the actual
    // button to indicate which is the default button. If a dialog
    // has a default button, the actual (visible) button height
    // is much smaller than the provided height. If there is no
    // default button, the button has a large height. Unfortunately,
    // here we cannot know if the dialog will get any default buttons, 
    // so must assume that there might be any.
    return m_DialogFontSize + 28;
#elif defined(__WXMSW__)
    return m_DialogFontSize + 16;
#elif defined(__WXGTK__)
    return m_DialogFontSize + 20;
#elif defined(__WXX11__)
#   pragma message "Please adjust function getAdjustedButtonHeight() for your wxWindows port."
    return m_DialogFontSize + 12;
#else
#   pragma message "Please adjust function getAdjustedButtonHeight() for your wxWindows port."
    return m_DialogFontSize + 12;
#endif
}

int wxExtDlgBase::getAdjustedSliderWidth (int SliderWidth, bool IsVertical)
{
    int AdjustedSliderWidth;
    if (!IsVertical)
      AdjustedSliderWidth = getAdjustedProportionalWidth (SliderWidth);
    else
      AdjustedSliderWidth = getAdjustedFontLikeHeight (SliderWidth);

    return AdjustedSliderWidth;
}

int wxExtDlgBase::getAdjustedSliderHeight (int SliderHeight, bool IsVertical)
{
    int AdjustedSliderHeight;

    if (!IsVertical)
      AdjustedSliderHeight = getAdjustedFontLikeHeight (SliderHeight);
    else
      AdjustedSliderHeight = getAdjustedProportionalHeight (SliderHeight);
    
    return AdjustedSliderHeight;
}

int wxExtDlgBase::getAdjustedBitmapWidth (int BitmapWidth)
{
    return getAdjustedProportionalWidth (BitmapWidth);
}

int wxExtDlgBase::getAdjustedBitmapHeight (int BitmapHeight)
{
    return getAdjustedProportionalHeight (BitmapHeight);
}

//-------------------------------------------------------------------------

int wxExtDlgBase::getDefaultDialogFontSize ()
{
    return DefaultDialogFontSize;
}

int wxExtDlgBase::getDialogFontSize ()
{
    return m_DialogFontSize;
}

int wxExtDlgBase::getDialogFontHeight ()
{
    return m_DialogFontHeight;
}

void wxExtDlgBase::setIsSetFontIfSameAsDefaultSize (bool IsSetFontIfSameAsDefaultSize)
{
    m_IsSetFontIfSameAsDefaultSize = IsSetFontIfSameAsDefaultSize;
}

//-------------------------------------------------------------------------

int wxExtDlgBase::getAdjustedProportionalWidth(int Width)
{
    int AdjustedWidth;

    cast_round_assign (AdjustedWidth, Width * m_ZoomValue);

    return AdjustedWidth;
}

int wxExtDlgBase::getAdjustedProportionalHeight(int Height)
{
    int AdjustedHeight;

    cast_round_assign (AdjustedHeight, Height * m_ZoomValue);

    return AdjustedHeight;
}

int wxExtDlgBase::getAdjustedFontLikeWidth(int Width)
{
    int AdjustedWidth;

    AdjustedWidth = (Width * m_DialogFontSize) / DefaultDialogFontSize;

    return AdjustedWidth;
}

int wxExtDlgBase::getAdjustedFontLikeHeight(int Height)
{
    int AdjustedHeight;

    AdjustedHeight = (Height * m_DialogFontSize) / DefaultDialogFontSize;

    return AdjustedHeight;
}

//-------------------------------------------------------------------------

void wxExtDlgBase::setDefaultButtonSize (int Width, int Height)
{
    m_DefaultButtonSize = wxSize (Width, Height);
}

//-------------------------------------------------------------------------

void wxExtDlgBase::setHtmlWindowFonts (wxHtmlWindow * HtmlWindow,
                                    int BaseSize,
                                    bool IsUseReadableFontSizes,
                                    bool IsUseScaleableFont)
{

    int FontSizeArray [7];

    cast_round_assign (FontSizeArray [0], BaseSize * 0.7);
    cast_round_assign (FontSizeArray [1], BaseSize * 0.85);
    cast_round_assign (FontSizeArray [2], BaseSize * 1.0);
    cast_round_assign (FontSizeArray [3], BaseSize * 1.2);
    cast_round_assign (FontSizeArray [4], BaseSize * 1.4);
    cast_round_assign (FontSizeArray [5], BaseSize * 2.0);
    cast_round_assign (FontSizeArray [6], BaseSize * 2.5);

    int Family = 0;
    wxString FaceName;
    if (IsUseScaleableFont)
      {
        Family = wxSWISS;
      }
    else
      {
        Family = wxDEFAULT;
        FaceName = getDialog() -> GetFont().GetFaceName();
      }

    if (IsUseReadableFontSizes)
      {
        for (int Index=0; cast_is_smaller (Index, WXSIZEOF(FontSizeArray)); ++Index)
          {
            int RequestedPointSize = 0;
            createDialogFont (FontSizeArray[Index],
                              Family,
                              wxNORMAL /* upright/slant/italic */, 
                              wxNORMAL /* weight */,
                              false /* underlined? */, 
                              FaceName /* face name */,
                              wxFONTENCODING_DEFAULT /* wxFONTENCODING_ISO8859_1 */,
                              & RequestedPointSize,
                              false /* create font? */);
                              
            FontSizeArray[Index] = RequestedPointSize;
          }
      }

    HtmlWindow -> SetFonts (FaceName, "", FontSizeArray);
}

//-------------------------------------------------------------------------

double wxExtDlgBase::getZoom ()
{
    double GlobalZoom = m_GlobalDialogZoom;
    double DialogZoom = m_DialogZoomValue;
    if (m_GlobalDesktopReferenceSize != wxSize (-1, -1)
        || m_DesktopReferenceSize != wxSize (-1, -1))
      {
        int Width = 0;
        int Height = 0;
        wxClientDisplayRect (NULL, NULL, & Width, & Height);

        wxSize DesktopReferenceSize = m_GlobalDesktopReferenceSize;
        if (m_DesktopReferenceSize != wxSize (-1, -1))
          DesktopReferenceSize = m_DesktopReferenceSize;

        double WidthRatio = Width / ((double) DesktopReferenceSize.GetWidth());
        double HeightRatio = Height / ((double) DesktopReferenceSize.GetHeight());

        if (WidthRatio <= HeightRatio)
          GlobalZoom *= WidthRatio;
        else
          GlobalZoom *= HeightRatio;
      }

    return DialogZoom * GlobalZoom;
}

void wxExtDlgBase::setDialogZoom (double DialogZoomValue)
{
    m_DialogZoomValue = DialogZoomValue;
    m_ZoomValue = getZoom ();

    int AdjustedFontSize;
    cast_round_assign (AdjustedFontSize, DefaultDialogFontSize * m_ZoomValue);

    if (m_IsSetFontIfSameAsDefaultSize
        || (AdjustedFontSize != DefaultDialogFontSize)
        || (!(getDialog() -> GetFont().Ok())))
      {
        getDialog() -> SetFont (createDialogFont(AdjustedFontSize,
                                                 wxDEFAULT /* family */, 
                                                 wxNORMAL /* upright/slant/italic */, 
                                                 wxNORMAL /* weight */,
                                                 false /* underlined? */, 
                                                 _T("") /* face name */,
                                                 wxFONTENCODING_DEFAULT /* wxFONTENCODING_ISO8859_1 */ ));
      }

    // determine actually used font size (may differ from requested size)
    m_DialogFontSize = getDialog() -> GetFont().GetPointSize();

    // GetCharHeight() doesn't seem to be sensible for all fonts
    // int CharHeight = GetCharHeight();
    int TextWidth, TextHeight, Descent, ExternalLeading;
    getDialog() -> GetTextExtent ("g-test", & TextWidth, & TextHeight, & Descent, & ExternalLeading);
    m_DialogFontHeight = TextHeight;

    m_DefaultButtonSize = wxSize (getAdjustedButtonWidth (100), 
                                  getAdjustedButtonHeight());

    m_DefaultTextCtrlSize = wxSize (getAdjustedTextCtrlWidth (60),
                                    getAdjustedTextCtrlHeight (1, true));

    m_DefaultListBoxSize = wxSize (getAdjustedTextCtrlWidth (80),
                                   getAdjustedTextCtrlHeight (1, true));

    m_DefaultChoiceCtrlSize = wxSize (getAdjustedTextCtrlWidth (80),
                                      getAdjustedTextCtrlHeight (1, true));

    m_DefaultComboBoxSize = wxSize (getAdjustedTextCtrlWidth (80),
                                    getAdjustedTextCtrlHeight (1, true));

    // setBorderZoom (ZoomValue);
}

double wxExtDlgBase::getDialogZoom ()
{
    return m_DialogZoomValue;
}

double wxExtDlgBase::m_GlobalDialogZoom = 1.;

void wxExtDlgBase::setGlobalDialogZoom (double ZoomValue)
{
    m_GlobalDialogZoom = ZoomValue;
}

double wxExtDlgBase::getGlobalDialogZoom ()
{
    return m_GlobalDialogZoom;
}

void wxExtDlgBase::setDesktopReferenceSize (const wxSize & Size)
{
    m_DesktopReferenceSize = Size;
}

wxSize wxExtDlgBase::m_GlobalDesktopReferenceSize = wxSize (-1, -1);

void wxExtDlgBase::setGlobalDesktopReferenceSize (const wxSize & Size)
{
    m_GlobalDesktopReferenceSize = Size;
}

void wxExtDlgBase::setBorderCompression (double BorderCompressionValue)
{
    m_BorderCompressionValue = BorderCompressionValue;
}

//-------------------------------------------------------------------------

wxSize wxExtDlgBase::getSizeFromDefaults (const wxSize & Size, const wxSize & DefaultSize)
{
    wxSize UsedSize;
    // if (& Size == & wxDefaultSize)
    if (Size == wxDefaultSize)
      UsedSize = DefaultSize;
    else
      UsedSize = Size;

    if (UsedSize.GetWidth () == -1)
      UsedSize.SetWidth (DefaultSize.GetWidth());
    if (UsedSize.GetHeight () == -1)
      UsedSize.SetHeight (DefaultSize.GetHeight());

    return UsedSize;
}

wxSize wxExtDlgBase::getSizeFromAspectRatio (const wxSize & Size, const wxSize & AspectRatioAsSize)
{
    wxSize UsedSize;
    if (& Size == & wxDefaultSize)
      UsedSize = AspectRatioAsSize;
    else
      UsedSize = Size;

    if (UsedSize.GetWidth () == -1)
      UsedSize.SetWidth ((AspectRatioAsSize.GetWidth() * UsedSize.GetHeight()) / AspectRatioAsSize.GetHeight());
    if (UsedSize.GetHeight () == -1)
      UsedSize.SetHeight ((AspectRatioAsSize.GetHeight() * UsedSize.GetWidth()) / AspectRatioAsSize.GetWidth());

    return UsedSize;
}

//-------------------------------------------------------------------------

void wxExtDlgBase::enableWatchedControlChangeNotification (bool IsWatchedControlChangeNotification)
{
    m_IsWatchedControlChangeNotification = IsWatchedControlChangeNotification;
}

void wxExtDlgBase::addWatchedControl(wxWindow * Window)
{
    m_WatchedObjectArray.Add (Window);
}

void wxExtDlgBase::handleControlChange(wxCommandEvent& Event)
{
    if (m_IsDialogInitialized 
        && m_IsWatchedControlChangeNotification 
        && m_WatchedObjectArray.Index (Event.GetEventObject()) != wxNOT_FOUND)
      {
        handleWatchedControlChange (Event);
      }
}

void wxExtDlgBase::handleWatchedControlChange(wxCommandEvent & WXUNUSED(Event))
{
}

//-------------------------------------------------------------------------

void wxExtDlgBase::OnCloseEvent (wxCloseEvent & CloseEvent)
{
    handleCloseEvent (CloseEvent);

    if (CloseEvent.GetVeto())
      return;

    // default handling destroys window then, under the
    // condition that window is modal or in non-modal and
    // contains some button (or control?) with wxID_CANCEL
    // ident (?)
    CloseEvent.Skip();
}

//-------------------------------------------------------------------------

void wxExtDlgBase::OnTextCtrlChanged(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

// void wxExtDlgBase::OnSliderCtrlChanged(wxCommandEvent& Event)
void wxExtDlgBase::OnSliderCtrlChanged(wxScrollEvent & Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDlgBase::OnRadioButtonSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDlgBase::OnRadioBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDlgBase::OnCheckBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDlgBase::OnComboBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDlgBase::OnListBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDlgBase::OnChoiceCtrlSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDlgBase::OnButtonClicked (wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

//-------------------------------------------------------------------------

bool wxExtDlgBase::TransferDataToWindow()
{
    bool PreviousIsWatchedControlChangeNotification = 
      m_IsWatchedControlChangeNotification;
    m_IsWatchedControlChangeNotification = false;
    bool IsOk = getDialog() -> wxWindow::TransferDataToWindow();
    m_IsWatchedControlChangeNotification =
      PreviousIsWatchedControlChangeNotification;
    return IsOk;
}

void wxExtDlgBase::initializeDialog ()
{
#if (defined(__WXMOTIF__) || defined(__WXX11__)) // maybe others required here
    TransferDataToWindow ();
#elif (defined(__WXGTK__) || defined(__WXMSW__))
    // GTK, MSW: TransferDataToWindow() is called by OnInitDialog()
    // OnInitDialog() itself is called automatically after the dialog was 
    // created.
#else
#   pragma message "Please adjust function initializeDialog() for your wxWindows port."
    TransferDataToWindow (); // may not be required here
#endif
}

bool wxExtDlgBase::ValidateWithMessageBox(int ReturnCode)
{
    wxDialog * Dialog = wxDynamicCast (getDialog(), wxDialog);
    wxASSERT (Dialog != NULL);

    return ::ValidateWithMessageBox (Dialog, (this -> m_StatusMessageTarget), 
                                     ReturnCode);
}

//-------------------------------------------------------------------------

bool ValidateWithMessageBox(wxWindow * Window, wxStatusMessageTarget * StatusMessageTarget)
{
    bool IsOk;
    if (StatusMessageTarget != NULL)
      StatusMessageTarget -> enableShowMessageBox (true);
    IsOk = Window -> Validate ();
    if (StatusMessageTarget != NULL)
      StatusMessageTarget -> enableShowMessageBox (false);

    if (IsOk)
      Window -> TransferDataFromWindow();

    return IsOk;
}

bool ValidateWithMessageBox(wxDialog * Dialog, wxStatusMessageTarget * StatusMessageTarget, 
                            int ReturnCode)
{
    bool IsOk = ValidateWithMessageBox (Dialog, StatusMessageTarget);

    if (IsOk && ReturnCode != -1)
      Dialog -> EndModal (ReturnCode);

    return IsOk;
}

//=========================================================================

IMPLEMENT_CLASS(wxExtDlgBaseEvtHandler, wxEvtHandler)

// generic handlers for all controls to allow simplyfied handling
// of all event-types from all controls in a single handler function
BEGIN_EVENT_TABLE (wxExtDlgBaseEvtHandler, wxEvtHandler)
    M_WxExtDlgBase_ImplementWatchedControlChangeEventHandlers(wxExtDlgBaseEvtHandler)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxExtDlgBaseEvtHandler::~wxExtDlgBaseEvtHandler()
{
    m_ExtDlgBase = NULL;
}

//=========================================================================

wxExtDlgHelper::wxExtDlgHelper()
{
    m_Window = NULL;
}

wxExtDlgHelper::~wxExtDlgHelper()
{
    if (m_Window != NULL)
      m_Window -> RemoveEventHandler (& m_ExtDlgBaseEvtHandler);
    m_Window = NULL;
}

void wxExtDlgHelper::setup (wxWindow * Window)
{
    // give EvtHelper pointer to wxExtDlgBase so it can forward events
    m_ExtDlgBaseEvtHandler.setExtDlgBase (this);

    // setup pointer to dialog/window so getDialog() works, and initialize
    setDialog (Window); 
    initCWxDialog(); 

    Window -> PushEventHandler (& m_ExtDlgBaseEvtHandler);
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxExtDialog, wxDialog)

// generic handlers for all controls to allow simplyfied handling
// of all event-types from all controls in a single handler function
BEGIN_EVENT_TABLE (wxExtDialog, wxDialog)
    M_WxExtDlgBase_ImplementWatchedControlChangeEventHandlers(wxExtDialog)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxExtDialog::wxExtDialog()
{
    initCWxDialog();

    setDialogZoom (1.);
}

wxExtDialog::wxExtDialog(wxWindow *parent, wxWindowID id,
                         const wxString& title,
                         const wxPoint& pos,
                         const wxSize& size,
                         long style,
                         const wxString& name)
  : wxDialog (parent, id, title, pos, size, style, name)
{
    initCWxDialog ();

    setDialogZoom (1.);
}

wxWindow * wxExtDialog::getDialog()
{
    return this; 
}

wxExtDialog::~wxExtDialog()
{
}

//-------------------------------------------------------------------------

void wxExtDialog::InitDialog ()
{
    wxDialog::InitDialog ();
    setDialogInitializedFlag ();
}

//-------------------------------------------------------------------------

#if wxCHECK_VERSION (2, 8, 0)
// provide old behavior of wxDialog versions before 2.8
void wxExtDialog::OnOK (wxCommandEvent & WXUNUSED (Event))
{
    if (Validate() && TransferDataFromWindow())
      {
        EndDialog(wxID_OK);
      }
}

void wxExtDialog::OnCancel (wxCommandEvent & WXUNUSED (Event))
{
    EndDialog (wxID_CANCEL);
}
#endif

//-------------------------------------------------------------------------

int wxExtDialog::ShowModal ()
{
    Centre (wxBOTH);
    return wxDialog::ShowModal ();
}

void wxExtDialog::EndDialog(int ReturnCode)
{
    if (IsModal())
      {
        EndModal (ReturnCode);
      }
    else
      {
        // TODO support other alternative to Hide() for non-modal dialogs:
        // call Close() or Destroy()
        
        Hide();
      }
}

//=========================================================================

wxSizerAdder::wxSizerAdder()
{
    init ();
}

wxSizerAdder::wxSizerAdder (wxSizer * Sizer)
{
    init (Sizer);
}

wxSizerAdder::wxSizerAdder (wxSizer * Sizer, int SizerColumnCount, int SizerRowCount)
{
    init (Sizer, SizerColumnCount, SizerRowCount);
}

#ifdef M_IsHaveGridBagSizer
wxSizerAdder (wxGridBagSizer * GridBagSizer, int XPos, int YPos, int XSpan, int YSpan)
{
    init (GridBagSizer, XPos, YPos, XSpan, YSpan);
}
#endif

//-------------------------------------------------------------------------

void wxSizerAdder::init()
{
    m_Sizer = NULL;
#ifdef M_IsHaveGridBagSizer
    m_GridBagSizer = NULL;
#endif

    m_SizerGroupSize = -1;
    m_CurrentCount = 0;

    m_SizerColumnCount = -1;
    m_SizerRowCount = -1;
}

//-------------------------------------------------------------------------

void wxSizerAdder::init (wxSizer * Sizer)
{
    init ();
    m_Sizer = Sizer;
    m_ParentWindow = NULL;
}

void wxSizerAdder::init (wxSizer * Sizer, int SizerColumnCount, int SizerRowCount)
{
    init ();

    m_Sizer = Sizer;
    m_SizerColumnCount = SizerColumnCount;
    m_SizerRowCount = SizerRowCount;

}

#ifdef M_IsHaveGridBagSizer
void wxSizerAdder::init (wxGridBagSizer * GridBagSizer, int XPos, int YPos, int XSpan, int YSpan)
{
    init ();
    m_GridBagSizer = GridBagSizer;

    m_XPos = XPos;
    m_YPos = YPos;
    m_XSpan = XSpan;
    m_YSpan = YSpan;
}
#endif

//-------------------------------------------------------------------------

wxSizer * wxSizerAdder::getSizer()
{
    return getSizerConst();
}

wxSizer * wxSizerAdder::getSizerConst() const
{
    if (m_Sizer != NULL)
      {
        return m_Sizer;
      }
#ifdef M_IsHaveGridBagSizer
    else if (m_GridBagSizer != NULL)
      {
        return m_GridBagSizer;
      }
#endif
    return NULL;
}

void wxSizerAdder::setGroupSize (int SizerGroupSize)
{
    m_SizerGroupSize = SizerGroupSize;
}

void wxSizerAdder::nextGroup()
{
    if (getSizer() != NULL)
      {
        if (m_SizerGroupSize != -1)
          {
            // if m_SizerGroupSize is defined, we add sizers
            // until next row
            while (true)
              {
                if (m_CurrentCount % m_SizerGroupSize != 0)
                  {
                    getSizer() -> Add (0, 0);
                    ++ m_CurrentCount;
                  }
                else
                  break;
              }
          }
      }    
}

//-------------------------------------------------------------------------

void wxSizerAdder::setColumnGrowable (int ColumnIndex, bool IsGrowable)
{
    wxFlexGridSizer * FlexGridSizer = wxDynamicCast (getSizer(), wxFlexGridSizer);
    if (FlexGridSizer != NULL)
      {
        // int ColumnCount = FlexGridSizer -> GetCols();
        if (true) // (ColumnIndex < ColumnCount)
          {
            if (IsGrowable)
              {
                FlexGridSizer -> AddGrowableCol (ColumnIndex); // , 1 /* proportion */);
              }
            else
              {
                FlexGridSizer -> RemoveGrowableCol (ColumnIndex); // , 1 /* proportion */);
              }
          }
      }
}

void wxSizerAdder::setRowGrowable (int RowIndex, bool IsGrowable)
{
    wxFlexGridSizer * FlexGridSizer = wxDynamicCast (getSizer(), wxFlexGridSizer);
    if (FlexGridSizer != NULL)
      {
        // int RowCount = FlexGridSizer -> GetRows();
        if (true) // (RowIndex < RowCount)
          {
            if (IsGrowable)
              {
                FlexGridSizer -> AddGrowableRow (RowIndex); // , 1 /* proportion */);
              }
            else
              {
                FlexGridSizer -> RemoveGrowableRow (RowIndex); // , 1 /* proportion */);
              }
          }
      }
}

void wxSizerAdder::setAllGrowable()
{
    wxFlexGridSizer * FlexGridSizer = wxDynamicCast (getSizer(), wxFlexGridSizer);
    if (FlexGridSizer != NULL)
      {
        int RowCount = FlexGridSizer -> GetRows();
        for (int RowIndex = 0; RowIndex < RowCount; ++RowIndex)
          {
            FlexGridSizer -> AddGrowableRow (RowIndex); // , 1 /* proportion */);
          }
        int ColumnCount = FlexGridSizer -> GetCols();
        for (int ColumnIndex = 0; ColumnIndex < ColumnCount; ++ColumnIndex)
          {
            FlexGridSizer -> AddGrowableCol (ColumnIndex); // , 1 /* proportion */);
          }
      }
}

//-------------------------------------------------------------------------

// ParentWindow is simply a variable that may be read by wxExtDialog
// control adder functions
void wxSizerAdder::setParentWindow (wxWindow * ParentWindow)
{
    m_ParentWindow = ParentWindow;
}

wxWindow * wxSizerAdder::getParentWindow () const
{
    return m_ParentWindow;
}

//-------------------------------------------------------------------------

void wxSizerAdder::addWindow (wxWindow * Window, int Flags, int Border)
{
    if (m_Sizer != NULL)
      {
        m_Sizer -> Add (Window, 0, Flags, Border);
      }
#ifdef M_IsHaveGridBagSizer
    else if (m_GridBagSizer != NULL)
      {
        m_GridBagSizer -> Add (Window, 0, 
                               wxGBPosition (m_XPos, m_YPos),
                               wxGBSpan (m_XSpan, m_YSpan), 
                               Flags, Border);
      }
#endif

    ++m_CurrentCount;
}

void wxSizerAdder::addSizer (wxSizer * Sizer, int Flags, int Border)
{
    if (m_Sizer != NULL)
      {
        m_Sizer -> Add (Sizer, 0, Flags, Border);
      }
#ifdef M_IsHaveGridBagSizer
    else if (m_GridBagSizer != NULL)
      {
        m_GridBagSizer -> Add (Window, 0, 
                               wxGBPosition (m_XPos, m_YPos),
                               wxGBSpan (m_XSpan, m_YSpan), 
                               Flags, Border);
      }
#endif

    ++m_CurrentCount;
}

void wxSizerAdder::addSpace (int Width, int Height, int Flags, int Border)
{
    if (m_Sizer != NULL)
      {
        m_Sizer -> Add (Width, Height, 0, Flags, Border);
      }
#ifdef M_IsHaveGridBagSizer
    else if (m_GridBagSizer != NULL)
      {
        m_GridBagSizer -> Add (Width, Height, 
                               wxGBPosition (m_XPos, m_YPos),
                               wxGBSpan (m_XSpan, m_YSpan), 
                               Flags, Border);
      }
#endif

    ++m_CurrentCount;
}

//=========================================================================

wxSizerAdderProxy::wxSizerAdderProxy ()
{
    m_SizerAdderPtr = NULL;
    m_SizerPtr = NULL;
}

wxSizerAdderProxy::wxSizerAdderProxy (wxSizerAdder * SizerAdder)
{
    m_SizerAdderPtr = SizerAdder;
    m_SizerPtr = NULL;
}

wxSizerAdderProxy::wxSizerAdderProxy (wxSizer * Sizer)
{
    m_SizerAdderPtr = NULL;
    m_SizerPtr = Sizer;
}

wxSizerAdder * wxSizerAdderProxy::makeSizerAdder(wxSizerAdder & AlternativeSizerAdder) const
{
    if (m_SizerAdderPtr != NULL)
      {
        wxASSERT (m_SizerAdderPtr -> getSizerConst() != NULL);
        return m_SizerAdderPtr;
      }

    wxSizer * Sizer = m_SizerPtr;
    if (Sizer == NULL)
      {
        Sizer = new wxBoxSizer (wxHORIZONTAL);
      }
    AlternativeSizerAdder.init (Sizer);
    wxASSERT (AlternativeSizerAdder.getSizerConst() != NULL);
    return & AlternativeSizerAdder;
}

//-------------------------------------------------------------------------

wxSizerAdderProxy s_NullSizerAdderProxy;
wxSizerAdderProxy & wxNullSizerAdderProxy = s_NullSizerAdderProxy;

//=========================================================================

wxWindowAdderDefaultParameterSet::wxWindowAdderDefaultParameterSet()
{
}

wxWindowAdderDefaultParameterSet::~wxWindowAdderDefaultParameterSet()
{
}

void wxWindowAdderDefaultParameterSet::resetToDefaults(wxExtDlgBase * ExtDlgBase)
{
    setIsFixLabelStringOnShortcutClash (true);
    setIsDebugWarningOnShortcutClash (true);

    setSizerSpacing (ExtDlgBase -> _B(5));
    setSizerBorder (ExtDlgBase -> _B(14));

    setWindowFontColourInitializedState (false);
    setWindowBackgroundColourInitializedState (false);

    setLabelFontColourInitializedState (false);
    setLabelBackgroundColourInitializedState (false);
    setPostTextFontColourInitializedState (false);
    setPostTextBackgroundColourInitializedState (false);

    setTransparentStaticTextFlags (wxTransparentStaticText::IsOpaque);
}

void wxWindowAdderDefaultParameterSet::setSizerSpacing (int SizerSpacing)
{
    setSizerHSpacing (SizerSpacing);
    setSizerVSpacing (SizerSpacing);
}

//=========================================================================

wxOverlayAdder::wxOverlayAdder()
{
    init();
}


void wxOverlayAdder::init()
{
    m_OverlayWindow = NULL;

    m_PreviousParentWindow = NULL;
    m_OverlaySizer = NULL;

    m_ModeBits = ZeroModeBits;
}

//=========================================================================

WX_DEFINE_OBJARRAY(wxExtLibSizerAdderArray)

WX_DEFINE_OBJARRAY(wxWindowAdderDefaultParameterSetArray)

WX_DEFINE_OBJARRAY(wxOverlayAdderArray)

//-------------------------------------------------------------------------

wxWindowAdder::wxWindowAdder()
{
    m_Window = NULL;
    m_ExtDlgBase = NULL;

    m_ParentWindow = NULL;

    m_IsLabelCreated = false;

    m_IsDetectShortcutClashs = true;
}

void wxWindowAdder::setExtDlgBase (wxExtDlgBase * ExtDlgBase)
{
    m_ExtDlgBase = ExtDlgBase;
    pushDefaults();
}

void wxWindowAdder::setDialog (wxExtDialog * ExtDialog)
{
    setExtDlgBase (ExtDialog);
}

void wxWindowAdder::setParentWindow (wxWindow * ParentWindow)
{
    m_ParentWindow = ParentWindow;
}

void wxWindowAdder::setSize (const wxSize & Size)
{
    m_Size = Size;
}

void wxWindowAdder::setSize (int Width, int Height)
{
    m_Size = wxSize (Width, Height);
}

void wxWindowAdder::setWindowStyle (long WindowStyle)
{
    m_WindowStyle = WindowStyle;
}

void wxWindowAdder::setLabel (const wxString & LabelString)
{
    next();

    m_LabelString = LabelString;
}

const wxString & wxWindowAdder::getLabel()
{
    return m_LabelString;
}

void wxWindowAdder::setPostText (const wxString & PostTextString)
{
    m_PostTextString = PostTextString;
}

const wxString & wxWindowAdder::getPostString()
{
    return m_PostTextString;
}

void wxWindowAdder::pushGroup (const wxString & GroupNameString)
{
    m_GroupNameStringArray.Add (GroupNameString);
}

void wxWindowAdder::popGroup ()
{
    wxASSERT (m_GroupNameStringArray.GetCount() > 0);
    // remove last element:
    m_GroupNameStringArray.RemoveAt (m_GroupNameStringArray.GetCount() - 1);
}

wxString wxWindowAdder::getFullName ()
{
    // TODO: add group names

    // add all current group names before label string
    wxString FullName;
    for (int Index = 0; cast_is_smaller (Index, m_GroupNameStringArray.GetCount());
         ++Index)
      {
        FullName << m_GroupNameStringArray.Item (Index) << " / ";
      }
    FullName << m_LabelString;

    // simply remove ampersand character used to indicate shortcut
    // to move focus to control
    // TODO handle '&&' sequence
    FullName.Replace ("&", "");

    return FullName;
}

void wxWindowAdder::setValidator (const wxValidator & Validator)
{
    wxASSERT (getWindow() != NULL);
    getWindow() -> SetValidator (Validator);
}

void wxWindowAdder::addSpace (int Width, int Height)
{
    getSizerAdder().addSpace (Width, Height, wxALL|wxEXPAND, m_ExtDlgBase -> _B(0));
}

void wxWindowAdder::addHSpace (int Width)
{
    getSizerAdder().addSpace (Width, 0, wxALL|wxEXPAND, m_ExtDlgBase -> _B(0));
}

void wxWindowAdder::addVSpace (int Height)
{
    getSizerAdder().addSpace (0, Height, wxALL|wxEXPAND, m_ExtDlgBase -> _B(0));
}

void wxWindowAdder::setSizerHSpacing(int Width)
{
    wxGridSizer * GridSizer = wxDynamicCast (getSizer(), wxGridSizer);
    if (GridSizer != NULL)
      {
        GridSizer -> SetHGap (Width);
      }
}

void wxWindowAdder::setSizerVSpacing(int Height)
{
    wxGridSizer * GridSizer = wxDynamicCast (getSizer(), wxGridSizer);
    if (GridSizer != NULL)
      {
        GridSizer -> SetVGap (Height);
      }
}

void wxWindowAdder::skipCell ()
{
    getSizerAdder().addSpace (1, 1, wxALL|wxEXPAND, m_ExtDlgBase -> _B(0));
}

void wxWindowAdder::skipCells (int Count)
{
    for (int Index = 0; Index < Count; ++Index)
      {
        skipCell ();
      }
}

void wxWindowAdder::nextGroup()
{
    getSizerAdder().nextGroup();

    m_IsLabelCreated = false;
    m_LabelString = "";
    m_PostTextString = "";
    m_Window = NULL;
    m_Size = wxSize (-1, -1);
    m_WindowStyle = 0;
}

void wxWindowAdder::next()
{
    nextGroup();
}

wxWindow * wxWindowAdder::getWindow()
{
    wxASSERT (m_Window != NULL);
    return m_Window;
}

wxSizer * wxWindowAdder::getSizer()
{
    wxASSERT (m_SizerAdderArray.GetCount() > 0);
    return m_SizerAdderArray.Item (m_SizerAdderArray.GetCount() - 1).getSizer();
}

wxSizerAdder & wxWindowAdder::getSizerAdder()
{
    wxASSERT (m_SizerAdderArray.GetCount() > 0);
    return m_SizerAdderArray.Item (m_SizerAdderArray.GetCount() - 1);
}

//-------------------------------------------------------------------------

void wxWindowAdder::addSizer (wxSizer * Sizer, int AddFlags, int AddBorder)
{
    // getSizer() -> Add (Sizer, 0, AddFlags, AddBorder);

    getSizerAdder().addSizer (Sizer,
                              AddFlags, 
                              m_ExtDlgBase -> _B(AddBorder));
}

void wxWindowAdder::pushSizer (wxSizer * Sizer)
{
    wxSizerAdder SizerAdder (Sizer);
    SizerAdder.setParentWindow (m_ParentWindow);
    m_SizerAdderArray.Add (SizerAdder);
}

void wxWindowAdder::addAndPushSizer (wxSizer * Sizer, int AddFlags, int AddBorder)
{
    addSizer (Sizer, AddFlags, AddBorder);
    pushSizer (Sizer);
}

void wxWindowAdder::popSizer ()
{
    next();

    wxASSERT (m_SizerAdderArray.GetCount() > 0);

    // TEST:
    // getSizerAdder().setAllGrowable();

    // remove last element:
    m_SizerAdderArray.RemoveAt (m_SizerAdderArray.GetCount() - 1);
}

//-------------------------------------------------------------------------

void wxWindowAdder::addAndPushFlexGridSizer (int ColumnCount, bool IsAddBorder, bool IsAddOnlySizer)
{
    if (!IsAddOnlySizer)
      createAndAddLabel ();

    // TODO use settings from parameter object
    addAndPushSizer (new wxFlexGridSizer (ColumnCount, 
                                          getDefaults().getSizerVSpacing(), 
                                          getDefaults().getSizerHSpacing()),
                     wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, 
                     IsAddBorder ? getDefaults().getSizerBorder() : 0);

    getSizerAdder().setGroupSize (ColumnCount);

    if (!IsAddOnlySizer)
      createAndAddPostText();
}

//-------------------------------------------------------------------------

void wxWindowAdder::addAndPushStaticBoxAndSizer (const wxString & LabelString,
                                                 wxSizer * SubSizer,
                                                 int AddFlags, int AddBorder)
{
    wxStaticBoxSizer *StaticBoxSizer
      = new wxStaticBoxSizer (new wxStaticBox (getAddParentWindow(), -1, LabelString), wxVERTICAL);

    addSizer (StaticBoxSizer, AddFlags, AddBorder);

    StaticBoxSizer -> Add (SubSizer, 0, wxALL|wxEXPAND, m_ExtDlgBase -> _B(5));

    pushSizer (SubSizer);
}

void wxWindowAdder::addAndPushStaticBoxAndFlexGridSizer (const wxString & LabelString, int ColumnCount,
                                                         bool IsAddBorder)
{
    addAndPushStaticBoxAndSizer (LabelString,
                                 new wxFlexGridSizer (ColumnCount, 
                                                      getDefaults().getSizerVSpacing(), 
                                                      getDefaults().getSizerHSpacing()),
                                 wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, 
                                 IsAddBorder ? getDefaults().getSizerBorder() : 0);

    getSizerAdder().setGroupSize (ColumnCount);
}

//-------------------------------------------------------------------------

void wxWindowAdder::pushDefaults()
{
    int Count = m_WindowAdderDefaultParameterSetArray.GetCount();
    if (Count > 0)
      {
        wxWindowAdderDefaultParameterSet * DefaultParameterSet
          = new wxWindowAdderDefaultParameterSet (m_WindowAdderDefaultParameterSetArray [Count - 1]);
        m_WindowAdderDefaultParameterSetArray.Add (DefaultParameterSet);
      }
    else
      {
        wxWindowAdderDefaultParameterSet * DefaultParameterSet
          = new wxWindowAdderDefaultParameterSet;
        DefaultParameterSet -> resetToDefaults (m_ExtDlgBase);
        m_WindowAdderDefaultParameterSetArray.Add (DefaultParameterSet);
      }

    // TEST
    getDefaults();
}

void wxWindowAdder::popDefaults()
{
    // don't remove first(bottom) defaults setting from stack
    wxASSERT (m_WindowAdderDefaultParameterSetArray.GetCount() > 1);

    // TEST
    getDefaults();

    // remove last element:
    m_WindowAdderDefaultParameterSetArray.RemoveAt (m_WindowAdderDefaultParameterSetArray.GetCount() - 1);
}

const wxWindowAdderDefaultParameterSet & wxWindowAdder::getDefaults()
{
    wxASSERT (m_WindowAdderDefaultParameterSetArray.GetCount() > 0);
    wxWindowAdderDefaultParameterSet & WindowAdderDefaultParameterSet 
      = m_WindowAdderDefaultParameterSetArray [m_WindowAdderDefaultParameterSetArray.GetCount() - 1];
    return WindowAdderDefaultParameterSet;
}

wxWindowAdderDefaultParameterSet & wxWindowAdder::accessDefaults()
{
    wxASSERT (m_WindowAdderDefaultParameterSetArray.GetCount() > 0);
    wxWindowAdderDefaultParameterSet & WindowAdderDefaultParameterSet 
      = m_WindowAdderDefaultParameterSetArray [m_WindowAdderDefaultParameterSetArray.GetCount() - 1];
    return WindowAdderDefaultParameterSet;
}

//-------------------------------------------------------------------------

void wxWindowAdder::pushOverlay (wxWindow * OverlayWindow, wxOverlayAdder::EMode ModeBits)
{
    wxOverlayAdder OverlayAdder;
    OverlayAdder.m_OverlayWindow = OverlayWindow;
    OverlayAdder.m_PreviousParentWindow = this -> getAddParentWindow();
    OverlayAdder.m_OverlaySizer = new wxBoxSizer (wxVERTICAL);
    OverlayAdder.m_ModeBits = ModeBits;
    
    this -> setParentWindow (OverlayAdder.m_OverlayWindow);
    this -> pushSizer (OverlayAdder.m_OverlaySizer);

    m_OverlayAdderArray.Add (OverlayAdder);
}

void wxWindowAdder::popOverlay ()
{
    wxASSERT (m_OverlayAdderArray.GetCount() > 0);
    wxOverlayAdder & OverlayAdder = m_OverlayAdderArray [m_OverlayAdderArray.GetCount() - 1];

    this -> popSizer (); // should pop m_OverlaySizer

    // maybe: 
    OverlayAdder.m_OverlayWindow -> Layout();
    OverlayAdder.m_OverlayWindow -> SetSizerAndFit (OverlayAdder.m_OverlaySizer);
    // m_OverlayWindow -> Fit();
    // m_OverlayWindow -> SetSize (m_OverlaySizer -> GetMinSize());

    if (OverlayAdder.m_ModeBits & wxOverlayAdder::IsAddOnPop)
      {
        this -> addWindow (OverlayAdder.m_OverlayWindow);
      }

    this -> setParentWindow (OverlayAdder.m_PreviousParentWindow);

    // remove last element:
    m_OverlayAdderArray.RemoveAt (m_OverlayAdderArray.GetCount() - 1);
}

//-------------------------------------------------------------------------

wxWindow * wxWindowAdder::getAddParentWindow ()
{
    if (getSizerAdder().getParentWindow() != NULL)
      {
        return getSizerAdder().getParentWindow();
      }

    return m_ExtDlgBase -> getDialog();
}

//-------------------------------------------------------------------------

wxWindow * wxWindowAdder::addWindow (wxWindow * Window)
{
    createAndAddLabel();

    getSizerAdder().addWindow (Window,
                               wxALL|wxEXPAND, 
                               m_ExtDlgBase -> _B(0));
    setCurrentWindow (Window);

    return Window;
}

void wxWindowAdder::addButton (const wxString & LabelString,
                               wxButton ** ButtonPtrPtr, wxWindowID CtrlIdent,
                               wxCommandEventFunction CommandEventFunction,
                               long Style)
{
    createAndAddLabel();

    wxButton * Button = NULL;

    wxString FixedLabelString;
    checkAndFixLabelString (LabelString, FixedLabelString);
    m_ExtDlgBase -> addButton (& Button, CtrlIdent, CommandEventFunction,
                              FixedLabelString, & getSizerAdder(),
                              wxDefaultPosition, m_Size, 
                              Style, wxDefaultValidator);

    if (0)
      {
        // test automatic setting of tooltip from provided label:
        wxString AmpersandRemovedLabelString;
        checkAndFixLabelString (LabelString, AmpersandRemovedLabelString, true);
        Button -> SetToolTip (AmpersandRemovedLabelString);
      }

    if (ButtonPtrPtr != NULL)
      *ButtonPtrPtr = Button;
    setCurrentWindow (Button);

    createAndAddPostText();
}

void wxWindowAdder::addButton (const wxString & LabelString,
                               wxCommandEventFunction CommandEventFunction,
                               long Style)
{
    addButton (LabelString, NULL, -1, CommandEventFunction, Style);
}

void wxWindowAdder::addButton (const wxString & LabelString
                               /*long Style */)
{
    long Style = 0;
    addButton (LabelString, NULL, Style);
}

void wxWindowAdder::addButton (const wxString & LabelString, wxWindowID CtrlIdent)
{
    long Style = 0;
    addButton (LabelString, NULL, CtrlIdent, NULL, Style);
}

void wxWindowAdder::setDefaultButton()
{
    wxButton * Button = wxDynamicCast (getWindow(), wxButton);

    wxASSERT (Button != NULL);

    // leave next check in code also in release versions:
    if (Button != NULL)
      {
        Button -> SetDefault();
      }
}

void wxWindowAdder::addCheckBoxWithLabel (wxCheckBox ** CheckBoxPtrPtr,
                                          const wxString & LabelString,
                                          long Flags,  // Flags can be 0 or wxTE_READONLY
                                          bool IsLabelOnTheLeft)
{
    wxCheckBox * CheckBox = NULL;
    wxString FixedLabelString;
    checkAndFixLabelString (LabelString, FixedLabelString);
    m_ExtDlgBase -> addCheckBoxWithLabel (& CheckBox,
                                         FixedLabelString,
                                         wxDefaultValidator,
                                         Flags,  // Flags can be 0 or wxTE_READONLY
                                         & getSizerAdder(),
                                         IsLabelOnTheLeft);
    if (CheckBoxPtrPtr != NULL)
      *CheckBoxPtrPtr = CheckBox;

    setCurrentWindow (CheckBox);
}

void wxWindowAdder::addRadioButtonWithLabel (wxRadioButton ** RadioButtonPtrPtr,
                                             const wxString & LabelString,
                                             long RadioCtrlStyle)
{
    wxRadioButton * RadioButton = NULL;

    wxString FixedLabelString;
    checkAndFixLabelString (LabelString, FixedLabelString);
    m_ExtDlgBase -> addRadioButtonWithLabel (& RadioButton,
                                            FixedLabelString,
                                            wxDefaultValidator,
                                            RadioCtrlStyle, 
                                            & getSizerAdder());
    if (RadioButtonPtrPtr != NULL)
      *RadioButtonPtrPtr = RadioButton;

    setCurrentWindow (RadioButton);
}


void wxWindowAdder::addTextCtrl (wxTextCtrl ** TextCtrlPtrPtr,
                                 long TextCtrlStyle)
{
    createAndAddLabel();

    wxTextCtrl * TextCtrl = NULL;
    m_ExtDlgBase -> addTextCtrl (& TextCtrl,
                                wxDefaultValidator,
                                TextCtrlStyle,
                                m_Size,
                                & getSizerAdder());

    if (TextCtrlPtrPtr != NULL)
      *TextCtrlPtrPtr = TextCtrl;

    setCurrentWindow (TextCtrl);

    createAndAddPostText();
}


void wxWindowAdder::addLabel (wxStaticText ** StaticTextPtrPtr,
                              const wxString & LabelString,
                              long WindowStyle)
{
    wxString FixedLabelString;
    checkAndFixLabelString (LabelString, FixedLabelString);

    wxStaticText * StaticText = NULL;
    // TEST: use transparent labels
    m_ExtDlgBase -> addLabel (& StaticText,
                              FixedLabelString,
                              & getSizerAdder(),
                              WindowStyle,
                              m_Size,
                              true /* IsTransparent */,
                              getDefaults().getTransparentStaticTextFlags());

    if (StaticTextPtrPtr != NULL)
      *StaticTextPtrPtr = StaticText;

    setCurrentWindow (StaticText);
}


void wxWindowAdder::addMultiLineText (wxMultiLineText * MultiLineText,
                                      long CtrlStyle,
                                      int MultiLineTextStyle)
{
    createAndAddLabel();

    m_ExtDlgBase -> addMultiLineText (MultiLineText,
                                     CtrlStyle,
                                     m_Size,
                                     MultiLineTextStyle,
                                     & getSizerAdder());

    setCurrentWindow (MultiLineText -> getWindow());

    createAndAddPostText();
}

void wxWindowAdder::addMultiLineText (wxMultiLineText * MultiLineText,
                                      long CtrlStyle,
                                      int MultiLineTextStyle,
                                      const wxString & TextString,
                                      int MinLineCount, int MaxLineCount,
                                      int BorderWidth)
{
    createAndAddLabel();

    m_ExtDlgBase -> addMultiLineText (MultiLineText,
                                     CtrlStyle,
                                     m_Size,
                                     MultiLineTextStyle,
                                     & getSizerAdder(),
                                     TextString,
                                     MinLineCount, MaxLineCount,
                                     BorderWidth);

    setCurrentWindow (MultiLineText -> getWindow());

    createAndAddPostText();
}



void wxWindowAdder::addListBox (wxListBox ** ListBoxPtrPtr, 
                                int ChoiceCount, const wxString ChoiceStringArray [])
{
    createAndAddLabel();

    wxListBox * ListBox = NULL;
    m_ExtDlgBase -> addListBox (& ListBox, 
                               wxDefaultValidator,
                               ChoiceCount, ChoiceStringArray,
                               m_Size,
                               & getSizerAdder());

    if (ListBoxPtrPtr != NULL)
      *ListBoxPtrPtr = ListBox;
    setCurrentWindow (ListBox);

    getSizerAdder().addWindow (ListBox, wxALIGN_CENTER_VERTICAL, 
                               m_ExtDlgBase -> _B(8));

    createAndAddPostText();
}

void wxWindowAdder::addChoiceCtrl (wxChoice ** ChoiceCtrlPtrPtr, 
                                   int ChoiceCount, const wxString ChoiceStringArray [])
{
    createAndAddLabel();

    wxChoice * ChoiceCtrl = NULL;
    m_ExtDlgBase -> addChoiceCtrl (& ChoiceCtrl, 
                                  wxDefaultValidator,
                                  ChoiceCount, ChoiceStringArray,
                                  m_Size,
                                  & getSizerAdder());
    if (ChoiceCtrlPtrPtr != NULL)
      *ChoiceCtrlPtrPtr = ChoiceCtrl;
    setCurrentWindow (ChoiceCtrl);

    getSizerAdder().addWindow (ChoiceCtrl, wxALIGN_CENTER_VERTICAL, 
                               m_ExtDlgBase -> _B(8));

    createAndAddPostText();
}

void wxWindowAdder::addComboBox (wxComboBox ** ComboBoxPtrPtr, 
                                 int StringCount, const wxString StringArray [])
{
    createAndAddLabel();

    wxComboBox * ComboBox = NULL;
    m_ExtDlgBase -> addComboBox (& ComboBox, 
                                wxDefaultValidator,
                                StringCount, StringArray,
                                m_Size,
                                & getSizerAdder());
    if (ComboBoxPtrPtr != NULL)
      *ComboBoxPtrPtr = ComboBox;
    setCurrentWindow (ComboBox);

    getSizerAdder().addWindow (ComboBox, wxALIGN_CENTER_VERTICAL, 
                               m_ExtDlgBase -> _B(8));

    createAndAddPostText();
}


void wxWindowAdder::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtrPtr,
                                     const unsigned char * ImageData,
                                     size_t ImageDataSize)
{
    createAndAddLabel();

    wxStaticBitmap * StaticBitmap = NULL;
    m_ExtDlgBase -> addStaticBitmap (& StaticBitmap,
                                    ImageData,
                                    ImageDataSize,
                                    wxDefaultPosition,
                                    m_Size,
                                    & getSizerAdder(),
                                    m_WindowStyle);

    if (StaticBitmapPtrPtr != NULL)
      *StaticBitmapPtrPtr = StaticBitmap;

    setCurrentWindow (StaticBitmap);

    createAndAddPostText();
}

void wxWindowAdder::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtrPtr,
                                     const char * ResourceNameString)
{
    createAndAddLabel();

    wxStaticBitmap * StaticBitmap = NULL;
    m_ExtDlgBase -> addStaticBitmap (& StaticBitmap,
                                    ResourceNameString,
                                    wxDefaultPosition,
                                    m_Size,
                                    & getSizerAdder(),
                                    m_WindowStyle);

    if (StaticBitmapPtrPtr != NULL)
      *StaticBitmapPtrPtr = StaticBitmap;

    setCurrentWindow (StaticBitmap);

    createAndAddPostText();
}

void wxWindowAdder::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtrPtr,
                                     wxBitmap * Bitmap)
{
    createAndAddLabel();

    wxStaticBitmap * StaticBitmap = NULL;
    m_ExtDlgBase -> addStaticBitmap (& StaticBitmap,
                                    Bitmap,
                                    wxDefaultPosition,
                                    m_Size,
                                    & getSizerAdder(),
                                    m_WindowStyle);

    if (StaticBitmapPtrPtr != NULL)
      *StaticBitmapPtrPtr = StaticBitmap;

    setCurrentWindow (StaticBitmap);

    createAndAddPostText();
}

//-------------------------------------------------------------------------

void wxWindowAdder::watchControl()
{
    wxASSERT (getWindow() != NULL);
    m_ExtDlgBase -> addWatchedControl (getWindow());
}

//-------------------------------------------------------------------------

void wxWindowAdder::createAndAddLabel ()
{
    if ((!m_IsLabelCreated)
        && (! m_LabelString.IsEmpty()))
      {
        wxString FixedLabelString;
        checkAndFixLabelString (m_LabelString, FixedLabelString);

        // TEST: use wxTransparentStaticText
        wxStaticText * StaticText = new wxTransparentStaticText (getAddParentWindow(), -1, 
                                                                 FixedLabelString,
                                                                 wxDefaultPosition, wxDefaultSize,
                                                                 0,
                                                                 getDefaults().getTransparentStaticTextFlags());

        if (getDefaults().getIsLabelFontColourInitialized())
          {
            StaticText -> SetForegroundColour (getDefaults().getLabelFontColour());
          }
        if (getDefaults().getIsLabelBackgroundColourInitialized())
          {
            StaticText -> SetBackgroundColour (getDefaults().getLabelBackgroundColour());
          }

        getSizerAdder().addWindow (StaticText,
                                   wxRIGHT|wxALIGN_CENTER_VERTICAL, 
                                   m_ExtDlgBase -> _B(8));
        m_IsLabelCreated = true;
      }
}

void wxWindowAdder::setCurrentWindow (wxWindow * Window)
{
    m_Window = Window;

    // TEST use decorateWindow() for all window types
    decorateWindow (m_Window);

    if (getDefaults().getIsWatchControl())
      {
        watchControl();
      }
}

void wxWindowAdder::createAndAddPostText ()
{
    if (! m_PostTextString.IsEmpty())
      {
        wxString FixedPostTextString;
        checkAndFixLabelString (m_PostTextString, FixedPostTextString);

        // TEST: use wxTransparentStaticText
        wxStaticText * StaticText = new wxTransparentStaticText (getAddParentWindow(), -1, 
                                                                 FixedPostTextString,
                                                                 wxDefaultPosition, wxDefaultSize,
                                                                 0,
                                                                 getDefaults().getTransparentStaticTextFlags());


        if (getDefaults().getIsPostTextFontColourInitialized())
          {
            StaticText -> SetForegroundColour (getDefaults().getPostTextFontColour());
          }
        if (getDefaults().getIsPostTextBackgroundColourInitialized())
          {
            StaticText -> SetBackgroundColour (getDefaults().getPostTextBackgroundColour());
          }

        getSizerAdder().addWindow (StaticText,
                                   wxLEFT|wxALIGN_CENTER_VERTICAL, 
                                   m_ExtDlgBase -> _B(5));
      }
}

//-------------------------------------------------------------------------

void wxWindowAdder::decorateWindow (wxWindow * Window)
{
    if (getDefaults().getIsWindowFontColourInitialized())
      {
        Window -> SetForegroundColour (getDefaults().getWindowFontColour());
      }
    if (getDefaults().getIsWindowBackgroundColourInitialized())
      {
        Window -> SetBackgroundColour (getDefaults().getWindowBackgroundColour());
      }
}

//-------------------------------------------------------------------------

void wxWindowAdder::addStaticLine (long Style)
{
    wxStaticLine * StaticLine
      = new wxStaticLine (getAddParentWindow(), -1, wxDefaultPosition, wxDefaultSize,
                          Style);

    getSizerAdder().addWindow (StaticLine,
                               wxALL|wxEXPAND, 
                               m_ExtDlgBase -> _B(0));
}

//-------------------------------------------------------------------------

void wxWindowAdder::addHeadline (const wxString & HeadlineString)
{
    // wxPanel * Panel = new wxPanel (getAddParentWindow(), -1);
    // Panel -> SetBackgroundColour (*wxBLUE);
    wxColour BackgroundColour (48, 48, 164);
    wxColour FontColour (*wxWHITE);
    // wxColour BackgroundColour (192, 192, 255);
    // wxColour FontColour (*wxBLACK);

    wxColourBarWindow * ColourBarWindow = new wxColourBarWindow (getAddParentWindow(), -1,
                                                                 BackgroundColour);

    ColourBarWindow -> setBrush (wxBrush (BackgroundColour, wxSOLID));
    // ColourBarWindow -> setBrush (*wxTRANSPARENT_BRUSH);
    ColourBarWindow -> setRoundedCornerRadius (3.);
    ColourBarWindow -> setPen (wxPen (*wxWHITE, 1, wxSOLID));

    // TEST: use wxTransparentStaticText
    wxStaticText * StaticText = new wxTransparentStaticText (ColourBarWindow, -1, HeadlineString, 
                                                             wxDefaultPosition, wxDefaultSize,
                                                             0,
                                                             getDefaults().getTransparentStaticTextFlags());

    StaticText -> SetForegroundColour (FontColour);
    // wxFont HeadlineFont (10, wxSWISS, wxNORMAL, wxBOLD);
    wxFont HeadlineFont (m_ExtDlgBase -> createDialogFont(m_ExtDlgBase -> getAdjustedFontLikeHeight((m_ExtDlgBase -> getDefaultDialogFontSize() * 14) / 10) /* 10 */,
                                                         wxDEFAULT /* family */, 
                                                         wxNORMAL /* upright/slant/italic */, 
                                                         wxNORMAL /* weight */,
                                                         false /* underlined? */, 
                                                         _T("") /* face name */,
                                                         wxFONTENCODING_DEFAULT /* wxFONTENCODING_ISO8859_1 */ ));
    StaticText -> SetFont (HeadlineFont);

    wxBoxSizer * SubSizer = new wxBoxSizer (wxHORIZONTAL);
    SubSizer -> Add (StaticText,
                     0,
                     wxEXPAND | wxALL | wxADJUST_MINSIZE | wxALIGN_CENTRE,
                     m_ExtDlgBase -> _B(0));

    wxSizer * BoxSizer = new wxBoxSizer (wxHORIZONTAL);
    BoxSizer -> Add (SubSizer,
                     0,
                     wxALL | wxALIGN_CENTRE_HORIZONTAL,
                     m_ExtDlgBase -> _B (3));

    ColourBarWindow -> SetSizer (BoxSizer);
    ColourBarWindow -> Layout();
    ColourBarWindow -> Fit();

    getSizerAdder().addWindow (ColourBarWindow,
                               wxALL | wxEXPAND, 
                               m_ExtDlgBase -> _B(0));

}

//-------------------------------------------------------------------------

void wxWindowAdder::checkAndFixLabelString (const wxString & InputLabelString, 
                                            wxString & FixedLabelString,
                                            bool IsAlwaysRemoveAmpersand)
{
    FixedLabelString = InputLabelString;

    if (!getDefaults().getIsFixLabelStringOnShortcutClash()
        && (!IsAlwaysRemoveAmpersand))
      {
        FixedLabelString = InputLabelString;
        return;
      }

    int CurrentIndex = 0;
    while (true)
      {
        const char * FoundCharPtr = NULL;
        // must obtain start of string again because it may have changed:
        const char * LabelCharPtr = FixedLabelString.c_str();

        // wxString::Find() doesn't support a starting position
        FoundCharPtr = strchr (LabelCharPtr + CurrentIndex, '&');

        int AmpersandIndex = -1;
        if (FoundCharPtr != NULL)
          AmpersandIndex = (FoundCharPtr - LabelCharPtr);
        else
          break;

        CurrentIndex = AmpersandIndex;

        if (AmpersandIndex != -1)
          {
            if (cast_is_smaller (AmpersandIndex + 1, FixedLabelString.Length()))
              {
                char FollowingChar = FixedLabelString.GetChar (AmpersandIndex + 1);
                FollowingChar = wxTolower (FollowingChar);
                if (FollowingChar == '&')
                  {
                    // just an escape for ampersand itself ("&&")
                  }
                else if (IsAlwaysRemoveAmpersand)
                  {
                    FixedLabelString.Remove (AmpersandIndex, 1);
                    // adjust CurrentIndex (it is incremented by two again,
                    // see below)
                    CurrentIndex -= 1;
                  }
                else
                  {
                    int FoundIndex = m_ShortcutCharString.Find (FollowingChar);
                    if (FoundIndex == -1)
                      {
                        m_LabelStringArray.Add (InputLabelString);
                        m_ShortcutCharString.Append (FollowingChar);
                      }
                    else
                      {
                        if (getDefaults().getIsDebugWarningOnShortcutClash())
                          {
                            wxString MessageString;
                            MessageString 
                              << "character '" << FollowingChar << "'\n used as short-cut for label \n"
                              << "\"" << InputLabelString << "\n is already used by label\n"
                              << "\"" << m_LabelStringArray [FoundIndex] << "\".";
                            
                            wxASSERT_MSG (false, MessageString);
                          }

                        // remove ampersand character then, to avoid ambiguity
                        FixedLabelString.Remove (AmpersandIndex, 1);
                        // adjust CurrentIndex (it is incremented by two again,
                        // see below)
                        CurrentIndex -= 1;
                      }
                  }
                // adjust index
                ++CurrentIndex;
              }
            else
              {
                // ignore if ampersand is last character in string
                // TODO should report warning here too
              }
          }
        ++CurrentIndex;
      }
}

//=========================================================================

wxWindowAdderAutoPopSizer::wxWindowAdderAutoPopSizer (wxWindowAdder * WindowAdder)
{
    init();

    m_WindowAdder = WindowAdder;
    push();
}

wxWindowAdderAutoPopSizer::wxWindowAdderAutoPopSizer(wxWindowAdder * WindowAdder, wxWindow * OverlayWindow,
                                                     wxOverlayAdder::EMode ModeBits)
{
    init();
    m_WindowAdder = WindowAdder;
    m_OverlayWindow = OverlayWindow;
    m_OverlayAdderModeBits = ModeBits;
    push();
}

wxWindowAdderAutoPopSizer::~wxWindowAdderAutoPopSizer()
{
    if (m_WindowAdder != NULL)
      {
        pop();
      }
}

void wxWindowAdderAutoPopSizer::init()
{
    reset();
}

void wxWindowAdderAutoPopSizer::reset()
{
    m_WindowAdder = NULL;
    m_OverlayWindow = NULL;
    m_OverlayAdderModeBits = wxOverlayAdder::ZeroModeBits;
}

void wxWindowAdderAutoPopSizer::push()
{
    wxASSERT (m_WindowAdder != NULL);

    if (m_OverlayWindow != NULL)
      {
        m_WindowAdder -> pushOverlay (m_OverlayWindow, m_OverlayAdderModeBits);
      }

    m_WindowAdder -> pushDefaults();
}

void wxWindowAdderAutoPopSizer::pop()
{
    wxASSERT (m_WindowAdder != NULL);

    m_WindowAdder -> popDefaults();
    m_WindowAdder -> popSizer();

    if (m_OverlayWindow != NULL)
      {
        m_WindowAdder -> popOverlay ();
      }

    // note: reset() will also set m_WindowAdder to NULL
    reset();
}

//=========================================================================

wxNonModalDialogInfo::wxNonModalDialogInfo()
{
    m_CommandIdent = 0L;
    m_Window = NULL;
}

//-------------------------------------------------------------------------

WX_DEFINE_OBJARRAY(wxNonModalDialogInfoArray)

//-------------------------------------------------------------------------

wxNonModalDialogManag::wxNonModalDialogManag()
{
}

wxNonModalDialogManag::~wxNonModalDialogManag()
{
}

void wxNonModalDialogManag::handleMenuCommand (long CommandIdent)
{
    int InfoIndex = findInfo (CommandIdent);
    if (InfoIndex == -1)
      {
        InfoIndex = addInfo (CommandIdent);
      }

    wxWindow * Window = getInfoByIndex(InfoIndex).m_Window;
    if (Window == NULL)
      {
        Window = createWindow (CommandIdent);
        getInfoByIndex (InfoIndex).m_Window = Window;
      }

    if (Window != NULL)
      {
        Window -> Show();
        Window -> Raise();
      }
}

// closeAll()
// - TODO: add support for Veto-ing
void wxNonModalDialogManag::closeAll()
{
    int InfoCount = m_NonModalDialogInfoArray.GetCount();
    for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
      {
        wxWindow * Window = getInfoByIndex (InfoIndex).m_Window;
        if (Window != NULL)
          {
            // call Show() before Close()
            // - (scope: WinXP)
            // - need to call Show() before, because otherwise, if dialog
            //   was hidden, the application hangs (for whatever reason)
            //   (this was the case if only Close(), not Destroy() was
            //   called afterwards)
            // - todo: check if Show() is required also if only
            //   Destroy() (or Close() + Destroy()) is called
            // - problem of hanging also exists if task-manager is
            //   used to terminate task(application) (not process, this 
            //   is more forceful) (this happens e.g. under the condition,
            //   that only the main frame and some modal dialog is shown)
            //   (it may be a bug in wxWidgets code)
            Window -> Show();

            // calling Close(false) may cause query if closing dialog is desired
            // setting force==true disables CanVeto-flag
            bool CloseRetVal = Window -> Close (true /* force */);
            // avoid warning about unused variable:
            CloseRetVal = CloseRetVal;

            // NonModalDialog's Destroy() seems not to be called if dialog 
            // close results from application/main dialog close (only 
            // destructor is called, but calling removeListener() there 
            // causes crash)
            // - so try to call Destroy() explicitly for all managed non-modal
            //   windows
            Window -> Destroy();

            // TODO:
            // - should set Window to NULL after calling Destroy() or
            //   remove info from info-array

            // TODO: call Destroy() only if non of the dialogs has issued Veto(),
            // add return value indicating if closing is allowed,
            // - also, need to split up into check-can-close phase plus
            //   actual destroy phase (e.g. for integration with other non-modal
            //   dialog handlers)
          }
      }
}

//-------------------------------------------------------------------------

int wxNonModalDialogManag::findInfo (long CommandIdent)
{
    int InfoCount = m_NonModalDialogInfoArray.GetCount();
    for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
      {
        wxNonModalDialogInfo & NonModalDialogInfo
          = m_NonModalDialogInfoArray [InfoIndex];

        if (NonModalDialogInfo.m_CommandIdent == CommandIdent)
          return InfoIndex;
      }
    return -1;
}

int wxNonModalDialogManag::findInfoFromWindow (wxWindow * Window)
{
    int InfoCount = m_NonModalDialogInfoArray.GetCount();
    for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
      {
        wxNonModalDialogInfo & NonModalDialogInfo
          = m_NonModalDialogInfoArray [InfoIndex];

        if (NonModalDialogInfo.m_Window == Window)
          return InfoIndex;
      }
    return -1;
}

int wxNonModalDialogManag::addInfo (long CommandIdent)
{
    int InfoCount = m_NonModalDialogInfoArray.GetCount();

    // TEST: use new
    wxNonModalDialogInfo * NonModalDialogInfo = new wxNonModalDialogInfo;
    NonModalDialogInfo -> m_CommandIdent = CommandIdent;
    NonModalDialogInfo -> m_Window = NULL;

    // WARN use of reference to Add() call okay?
    m_NonModalDialogInfoArray.Add (NonModalDialogInfo);
    // m_NonModalDialogInfoArray.Add (NonModalDialogInfo);

    // InfoCount should be index of currently added element:
    return InfoCount;
}

wxNonModalDialogInfo & wxNonModalDialogManag::getInfoByIndex (int InfoIndex)
{
    return m_NonModalDialogInfoArray [InfoIndex];
}

//=========================================================================

wxDisablingBusyInfo::wxDisablingBusyInfo (const wxString & MessageString, wxWindow * ParentWindow,
                                          wxWindow * SkipDisableWindow)
  : m_FocusRestorer (),  // call wxFocusRestorer ctor first
    m_WindowDisabler (SkipDisableWindow), // call wxWindowDisabler ctor second
    m_BusyInfo (MessageString, ParentWindow)
{
}

//=========================================================================

wxCalendarDialog::wxCalendarDialog (wxWindow * ParentWindow,
                                    const wxString & DialogTitleString,
                                    wxDateTime * DateTimePtr,
                                    const wxDateTime & MinDateTime, const wxDateTime & MaxDateTime,
                                    long DateTimeValidatorFlags,
                                    const wxString & DateTimeFormatString)
  : wxExtDialog (ParentWindow, 
                 -1, 
                 DialogTitleString,
                 wxDefaultPosition, 
                 wxDefaultSize,
                 wxCAPTION | wxRESIZE_BORDER | wxSYSTEM_MENU /*| wxCLOSE_BOX*/)
{
    init ();
    wxASSERT (DateTimePtr != NULL);

    m_DateTimePtr = DateTimePtr;
    m_MinDateTime = MinDateTime;
    m_MaxDateTime = MaxDateTime;
    m_DateTimeValidatorFlags = DateTimeValidatorFlags;
    m_DateTimeFormatString = DateTimeFormatString;

    m_TextCtrlDateTime = *m_DateTimePtr;
    m_TextCtrlDateTime.ResetTime();

    createControlsMain();
}

void wxCalendarDialog::init()
{
    clearControlPointers();
    m_DateTimePtr = NULL;
}

void wxCalendarDialog::clearControlPointers()
{
    m_DateCalendarCtrl = NULL;
}

void wxCalendarDialog::createControlsMain()
{
    clearControlPointers();

    wxSizer * MainSizer = new wxBoxSizer (wxVERTICAL);

    wxWindowAdder WA;
    WA.setDialog (this);

    this -> SetExtraStyle (this -> GetExtraStyle()
                           | wxWS_EX_VALIDATE_RECURSIVELY);
    
    WA.pushSizer (MainSizer);
    wxWindowAdderAutoPopSizer WindowAdderAutoPopSizer (& WA);
    {
      WA.accessDefaults().setSizerSpacing (_B(4));

      WA.addAndPushFlexGridSizer (1, false /* IsAddBorder */);
      wxWindowAdderAutoPopSizer WindowAdderAutoPopSizer (& WA);
      
      MainSizer = WA.getSizer();
      createControls (WA);
    }

    TransferDataToWindow();
    fillControlsPostCreate();

    if (MainSizer != NULL)
      {
        SetSizerAndFit (MainSizer);
      }

    initializeDialog ();
    enableWatchedControlChangeNotification (true);
}

void wxCalendarDialog::addStatusMessageTarget (wxWindowAdder & WA)
{
    wxMultiLineText * ErrorMessageMultiLineText
      = createErrorMessageCtrl (& m_StatusMessageMultiLineText, 3 /* LineCount */);
    // avoid warning about unused variable:
    ErrorMessageMultiLineText = ErrorMessageMultiLineText;

    m_StatusMessageTarget -> setStatusOutput (& m_StatusMessageMultiLineText);
    m_StatusMessageTarget -> enableShowMessageBox (FALSE);
    wxWindow * Window = m_StatusMessageMultiLineText.getWindow();
    // avoid warning about unused variable:
    Window = Window;

    WA.pushDefaults();
    WA.accessDefaults().setWindowBackgroundColour (*wxWHITE);
    WA.addWindow (m_StatusMessageMultiLineText.getWindow ());
    WA.popDefaults();

    // TEST after addWindow():
    // try to remove border
    long WindowStyle = m_StatusMessageMultiLineText.getWindow() -> GetWindowStyleFlag();
    WindowStyle &= ~wxBORDER_MASK;
    WindowStyle |= wxBORDER_NONE;
    m_StatusMessageMultiLineText.getWindow() -> SetWindowStyleFlag (WindowStyle);
}

void wxCalendarDialog::createControls (wxWindowAdder & WA)
{
    WA.accessDefaults().setSizerBorder (_B(4));
    if (true)
      {
        WA.addAndPushFlexGridSizer (1, false);

        wxWindowAdderAutoPopSizer WindowAdderAutoPopSizer (& WA);
        {
          WA.pushDefaults();
          // WA.accessDefaults().setSizerBorder (_B(20));

          WA.addAndPushFlexGridSizer (3, true);
          wxWindowAdderAutoPopSizer WindowAdderAutoPopSizer (& WA);

          WA.addHSpace (_B(40));

          {
          WA.addAndPushFlexGridSizer (3, false);
          wxWindowAdderAutoPopSizer WindowAdderAutoPopSizer (& WA);

          m_StatusMessageTarget = new wxStatusMessageTarget (NULL, "");
          m_StatusMessageTarget -> enableShowMessageBox (FALSE);

          WA.addVSpace (_B(12));
          WA.next();
          
          WA.setLabel ("");
          m_DateCalendarCtrl = new wxCalendarCtrl;
          m_DateCalendarCtrl -> Create (WA.getAddParentWindow(), 
                                        -1 /* ident == wxID_AUTO */, 
                                        wxDateTime(),
                                        wxDefaultPosition, wxSize(170, 135), 
                                        wxCAL_MONDAY_FIRST | wxCAL_SHOW_SURROUNDING_WEEKS | wxSIMPLE_BORDER);
          m_DateCalendarCtrl -> SetBackgroundColour(wxColour(255, 255, 255));
          WA.addWindow (m_DateCalendarCtrl);
          WA.next();
          
          wxCalendarEventFunction CalendarEventFunction 
            = (wxCalendarEventFunction) (& wxCalendarDialog::OnCalendarDoubleClicked);
          this -> Connect (m_DateCalendarCtrl -> GetId(),
                           wxEVT_CALENDAR_DOUBLECLICKED,
                           (wxObjectEventFunction) (wxEventFunction) CalendarEventFunction);

          CalendarEventFunction = (wxCalendarEventFunction) (& wxCalendarDialog::OnCalendarSelectionChanged);
          this -> Connect (m_DateCalendarCtrl -> GetId(),
                           wxEVT_CALENDAR_SEL_CHANGED,
                           (wxObjectEventFunction) (wxEventFunction) CalendarEventFunction);

          WA.setLabel (_(""));
          WA.setSize (170 /* getAdjustedTextCtrlWidth (170) */,
                      getAdjustedTextCtrlHeight (1, true));
          WA.addTextCtrl (& m_DateTimeTextCtrl, 0 /* TEST may be wxTE_READONLY */);

          WA.setValidator (wxTraitedDateTimeValidator (& m_TextCtrlDateTime, 
                                                       m_MinDateTime, m_MaxDateTime,
                                                       m_StatusMessageTarget, 
                                                       _("date"),
                                                       m_DateTimeValidatorFlags,
                                                       wxInvalidDateTime,
                                                       m_DateTimeFormatString));
          }

          WA.addHSpace (_B(40));

          WA.popDefaults();
        }

        WA.addStaticLine();
        addStatusMessageTarget (WA);

        {        
          WA.addAndPushFlexGridSizer (3, true);
          wxWindowAdderAutoPopSizer WindowAdderAutoPopSizer (& WA);
          
          WA.addSpace (1, 1);
          WA.getSizerAdder().setColumnGrowable (0);
          
          WA.addButton (_("&Cancel"), wxID_CANCEL);
          WA.addButton (_("&OK"), (wxCommandEventFunction) (& wxCalendarDialog::OnOkayButton));
        }
        
      }
}

void wxCalendarDialog::fillControlsPostCreate ()
{
    m_DateCalendarCtrl -> SetDate (m_TextCtrlDateTime);
}

//-------------------------------------------------------------------------

void wxCalendarDialog::OnCalendarSelectionChanged (wxCalendarEvent & Event)
{    
    handleSelectionChange (Event);
}

void wxCalendarDialog::OnCalendarDoubleClicked (wxCalendarEvent & Event)
{
    handleSelectionChange (Event);
    handleAcceptInput();
}

void wxCalendarDialog::handleSelectionChange (wxCalendarEvent & Event)
{
    wxDateTime DateTime = Event.GetDate();
    // formatDateTimeInISOFormat (Basictype, String);
    m_TextCtrlDateTime = DateTime;
    transferDataToControl (m_DateTimeTextCtrl);
    // now validate to check date to get output on StatusMessageTarget:
    validateControl (m_DateTimeTextCtrl);
}

//-------------------------------------------------------------------------

void wxCalendarDialog::OnOkayButton (wxCommandEvent & WXUNUSED(Event))
{
    handleAcceptInput();
}

void wxCalendarDialog::handleAcceptInput()
{
    if (ValidateWithMessageBox (wxID_OK))
      {
        *m_DateTimePtr = m_TextCtrlDateTime;
      }
}

//-------------------------------------------------------------------------

wxTraitedDateTimeValidator & wxCalendarDialog::accessDateTimeValidator()
{
    wxValidator * Validator = m_DateTimeTextCtrl -> GetValidator();
    wxTraitedDateTimeValidator * DateTimeValidator 
      = wxDynamicCast (Validator, wxTraitedDateTimeValidator);

    wxASSERT (DateTimeValidator != NULL);
    return *DateTimeValidator;
}

//=========================================================================

void showCalendarDialog (wxWindow * ParentWindow,
                         const wxString & CalendarDialogCaptionString,
                         const wxDateTime & MinDateTime,
                         const wxDateTime & MaxDateTime,                         
                         long DateTimeValidatorFlags,
                         const wxString & DateTimeFormatString,
                         wxTextCtrl * DateTimeTextCtrl, 
                         bool IsCallResetTime)
{
    wxString TempDateTimeString;
    TempDateTimeString = DateTimeTextCtrl -> GetValue ();

    wxDateTime TempDateTime;
    if (!parseDateTimeWithFormat (TempDateTimeString, TempDateTime,
                                 DateTimeFormatString))
      {
        TempDateTime = wxDateTime::Now();
        // TODO: check flags if Min, Max is not ignored
        if (TempDateTime < MinDateTime)
          TempDateTime = MinDateTime;
        if (TempDateTime > MaxDateTime)
          TempDateTime = MaxDateTime;
      }

    if (IsCallResetTime)
      TempDateTime.ResetTime();

    wxCalendarDialog CalendarDialog (ParentWindow, CalendarDialogCaptionString, 
                                     & TempDateTime,
                                     MinDateTime, 
                                     MaxDateTime,
                                     DateTimeValidatorFlags,
                                     DateTimeFormatString);
    int DialogResultInt = CalendarDialog.ShowModal ();

    // wxTraitedDateTimeValidator::IsIgnoreMinimum
    // | wxTraitedDateTimeValidator::IsIgnoreMaximum 

    if (DialogResultInt == wxID_OK)
      {
        wxString FormattedDateTime;
        formatDateTimeWithFormat (TempDateTime, FormattedDateTime,
                                  DateTimeFormatString);
        DateTimeTextCtrl -> SetValue (FormattedDateTime);
      }
}

//=========================================================================

void modifyTopLevelWindows (wxWindow * ParentWindow, wxWindow * ExcludeWindow, ETopLevelWindowModification Mode,
                            wxNonModalDialogManag * NonModalDialogManag,
                            wxWindow * ExtraWindow)

{
    wxWindowList ModifyWindowList;

    // wxWindowList::compatibility_iterator Node;
    wxWindowListNode * Node = NULL;

    //-- make copy of list of windows which are to be activated/hidden etc.
    for (Node = ParentWindow->GetChildren().GetFirst();
         Node != NULL;
         Node = Node->GetNext())
      {
        wxWindow * Window = Node->GetData();
#if wxCHECK_VERSION (2, 5, 0)
        wxTopLevelWindowNative * TopLevelWindow = wxDynamicCast (Window, wxTopLevelWindowNative);
#else
        // older wxWidgets versions don't seem to have appropriate wxTopLevelWindowNative
        // class info support
        wxWindow * TopLevelWindow = Window;
#endif

        if ((TopLevelWindow != NULL)
            && (TopLevelWindow != ExcludeWindow))
          {
            ModifyWindowList.Append (TopLevelWindow);
          }
      }

    //-- send activation (raise) or hide messages
    for (Node = ModifyWindowList.GetFirst(); Node != NULL; Node = Node -> GetNext())
      {
        wxWindow * Window = Node -> GetData();
#if wxCHECK_VERSION (2, 5, 0)
        wxTopLevelWindowNative * TopLevelWindow = wxDynamicCast (Window, wxTopLevelWindowNative);
#else
        // older wxWidgets versions don't seem to have appropriate wxTopLevelWindowNative
        // class info support
        wxWindow * TopLevelWindow = Window;
#endif

        if (Mode == HideTLWModification)
          {
            // TopLevelWindow -> Reparent (ExcludeWindow);
            TopLevelWindow -> Hide();
            // TopLevelWindow -> Iconize();
          }
        else if (Mode == ShowAndRaiseTLWModification)
          {
#if defined (__WXMSW__)
            WXHWND WindowHandle = Window -> GetHWND();
            bool IsWindowOkay = (WindowHandle != NULL) ? ::IsWindow ((struct HWND__ *) WindowHandle) : false;
#endif
            bool IsShown = Window -> IsShown();
            // avoid compiler warning about unused variable:
            IsShown = IsShown;
            bool IsInNonModalDialogInfoList = false;
            bool IsExtraWindow = (Window == ExtraWindow);

            if (NonModalDialogManag != NULL)
              {
                int Index = NonModalDialogManag -> findInfoFromWindow (Window);
                IsInNonModalDialogInfoList = Index != -1;
              }

            if (IsExtraWindow || IsInNonModalDialogInfoList)
              {
                // TopLevelWindow -> Restore();

                if (!TopLevelWindow -> IsShown())
                  TopLevelWindow -> Show();

                TopLevelWindow -> Raise();
              }
          }
        else
          {
            wxASSERT_MSG (false, "modifyTopLevelWindows(): unhandled ETopLevelWindowModification argument");
          }
      }
}

//=========================================================================

wxTLWStateInfo::wxTLWStateInfo()
{
    m_Window = NULL;
    m_IsShownWhenNotIconized = false;
}

wxTLWStateInfo::wxTLWStateInfo (const wxTLWStateInfo & TLWStateInfo)
{
    m_Window = TLWStateInfo.m_Window;
    m_IsShownWhenNotIconized = TLWStateInfo.m_IsShownWhenNotIconized;
}

wxTLWStateInfo::wxTLWStateInfo (wxWindow * Window, bool IsShownWhenNotIconized)
{
    m_Window = Window;
    m_IsShownWhenNotIconized = IsShownWhenNotIconized;
}

//-------------------------------------------------------------------------

WX_DEFINE_OBJARRAY(wxTLWStateInfoArray)

//-------------------------------------------------------------------------

wxAppRootFrame * s_GlobalAppRootFrame = NULL;

#if (M_WxExtLib_IsUseAppRootFrame == 1)

IMPLEMENT_DYNAMIC_CLASS(wxAppRootFrame, wxFrame)

BEGIN_EVENT_TABLE(wxAppRootFrame, wxFrame)

    EVT_QUERY_END_SESSION (wxAppRootFrame::OnCloseEvent)
    EVT_END_SESSION (wxAppRootFrame::OnCloseEvent)
    EVT_CLOSE (wxAppRootFrame::OnCloseEvent)

    EVT_SHOW (wxAppRootFrame::OnShowEvent)

    EVT_ACTIVATE (wxAppRootFrame::OnActivateEvent)
    EVT_ACTIVATE_APP (wxAppRootFrame::OnActivateAppEvent)

    EVT_ICONIZE (wxAppRootFrame::OnIconizeEvent)
    EVT_MAXIMIZE (wxAppRootFrame::OnMaximizeEvent)

    EVT_MOVE (wxAppRootFrame::OnMoveEvent)

   // EVT_MENU(ID_Quit,  wxAppRootFrame::OnQuit)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

#if 1
#   define LOG_WindowInfo(Window) \
       { }

// HACK undefine LOG_message(), and LOG_var() macros
//
#   ifdef LOG_message
#       define SAVE_LOG_message LOG_message
#       define SAVE_LOG_var LOG_var
#       define M_IsNeedLogMessageRestore
#   endif

#       define LOG_message(StreamArgs) { }

#       define LOG_var(StreamArgs) 


#else

#define LOG_WindowInfo(Window) \
  { \
    if (Window != NULL) \
      { \
        if (wxVerifyWindowPtr (AppRootFrame, Window)) \
          { \
            wxString WindowName = Window -> GetName();  \
            wxTopLevelWindowNative * TLWN = wxDynamicCast (Window, wxTopLevelWindowNative); \
            \
            wxString WindowTitle; \
            if (TLWN != NULL) \
              WindowTitle = TLWN -> GetTitle(); \
            \
            LOG_message ("Window: " << LOG_var (cast_genericptr (Window)) \
                         << LOG_var(WindowName) << LOG_var(WindowTitle)); \
          } \
        else \
          { \
            LOG_message ("WARNING Window: " << LOG_var (cast_genericptr (Window)) \
                         << " not found anymore."); \
          } \
      } \
    else \
      { \
        LOG_message ("Window: " << LOG_var (cast_genericptr (Window))); \
      } \
  } \

#endif

//-------------------------------------------------------------------------

wxAppRootFrame::wxAppRootFrame ()
{
    init ();
}

wxAppRootFrame::wxAppRootFrame (wxWindow * ParentWindow, wxWindowID id,
                                      const wxString & title, const wxPoint& pos, const wxSize& size, long style,
                                      const wxString & name)
  : wxFrame (ParentWindow, id, title, pos, size, style, name)
{ 
    init ();
}

void wxAppRootFrame::init()
{
    m_ControllingFrame = NULL;
    m_IsLockEventProcessing = false;
    m_IsFirstActivateAppEvent = true;
    m_LastFocusWindow = NULL;

    wxASSERT_MSG (s_GlobalAppRootFrame == NULL, "there  must be only one wxAppRootFrame window");
    s_GlobalAppRootFrame = this;
}

wxAppRootFrame::~wxAppRootFrame ()
{
    s_GlobalAppRootFrame = NULL;
}

//-------------------------------------------------------------------------

wxWindow * wxAppRootFrame::getDefaultParentWindow (wxWindow * ParentWindow)
{
    wxWindow * NewParentWindow = ParentWindow;
    wxAppRootFrame * AppRootFrame = s_GlobalAppRootFrame;
    if (AppRootFrame == NULL)
      return NewParentWindow;

    // if ParentWindow is not null: just use it
    if (NewParentWindow != NULL)
      return NewParentWindow;

    // search windows in backward order to find top-most
    // non-hidden window
    int InfoCount = AppRootFrame -> m_TLWStateInfoArray.GetCount();
    LOG_message (LOG_var (InfoCount));
    for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
      {
        wxTLWStateInfo & TLWStateInfo
          = AppRootFrame -> m_TLWStateInfoArray [InfoCount - InfoIndex - 1];

        wxWindow * Window = TLWStateInfo.m_Window;
        LOG_WindowInfo (Window)
        LOG_message (LOG_var(TLWStateInfo.m_IsShownWhenNotIconized) << LOG_var (Window -> IsShown()));
        
        if (Window -> IsShown())
          {
            LOG_message ("using this window as default parent");
            NewParentWindow = Window;
            break;
          }
      }

    // fallback: use controlling frame as parent
    if (NewParentWindow == NULL)
      {
        LOG_message ("using controlling frame as default parent");
        NewParentWindow = s_GlobalAppRootFrame -> getControllingFrame();
      }

    return NewParentWindow;
}

wxAppRootFrame * wxAppRootFrame::create (const wxIcon & Icon)
{
    // long WindowStyle = wxDEFAULT_FRAME_STYLE;
    long WindowStyle = wxDEFAULT_FRAME_STYLE | wxFRAME_TOOL_WINDOW | wxFRAME_NO_TASKBAR;

    // TEST DummyMain
    wxAppRootFrame * AppRootFrame = new wxAppRootFrame(NULL, wxID_AUTO, "AppRootFrame", 
                                                       wxDefaultPosition, wxDefaultSize, WindowStyle);
    // set the frame icon
    AppRootFrame -> SetIcon (Icon);
    
    // AppRootFrame -> Show (true);
    
    wxSetGlobalDefaultParentWindowFunc (wxAppRootFrame::getDefaultParentWindow);

    return AppRootFrame;
}

void wxAppRootFrame::setup (wxFrame * FrameWindow)
{
    wxAppRootFrame * AppRootFrame = wxGetGlobalAppRootFrame();
    if (AppRootFrame != NULL)
      {
        AppRootFrame -> setControllingFrame (FrameWindow);
        AppRootFrame -> connectTLWEventHandlers (FrameWindow);
      }
}

//-------------------------------------------------------------------------

void wxAppRootFrame::OnDestroyEvent (wxWindowDestroyEvent & DestroyEvent)
{
    DestroyEvent.Skip();
}

void wxAppRootFrame::OnCloseEvent (wxCloseEvent & CloseEvent)
{
    CloseEvent.Skip();
}

void wxAppRootFrame::OnShowEvent (wxShowEvent & ShowEvent)
{
    ShowEvent.Skip();
}

void wxAppRootFrame::OnActivateEvent (wxActivateEvent & Event)
{
    notifyTLWActivateEvent (Event);
    Event.Skip();
}

void wxAppRootFrame::OnActivateAppEvent (wxActivateEvent & Event)
{
    // wxEVT_ACTIVATE_APP may not work, must use special notifyActivateAppEvent() 
    // instead
    bool IsActive = Event.GetActive();
    LOG_message (LOG_var (IsActive));

    Event.Skip();
}

void wxAppRootFrame::OnIconizeEvent (wxIconizeEvent & IconizeEvent)
{
    bool IsIconize = IconizeEvent.Iconized();
    LOG_message (LOG_var (IsIconize));

    IconizeEvent.Skip();
}

void wxAppRootFrame::OnMaximizeEvent (wxMaximizeEvent & MaximizeEvent)
{
    MaximizeEvent.Skip();
}

void wxAppRootFrame::OnMoveEvent (wxMoveEvent & MoveEvent)
{
    MoveEvent.Skip();
}

//-------------------------------------------------------------------------

#define M_implementEventForward(EventName,ShortEventName) \
  void wxAppRootFrame::OnTLW ## ShortEventName ## Forward (wx ## EventName & ShortEventName) \
  { \
    if (wxGetGlobalAppRootFrame () != NULL) \
      { \
        wxGetGlobalAppRootFrame() -> notifyTLW ## ShortEventName (ShortEventName); \
      } \
    ShortEventName.Skip(); \
  } \

M_implementEventForward (WindowDestroyEvent, DestroyEvent)
M_implementEventForward (CloseEvent, CloseEvent)
M_implementEventForward (ShowEvent, ShowEvent)
M_implementEventForward (ActivateEvent, ActivateEvent)
M_implementEventForward (IconizeEvent, IconizeEvent)
M_implementEventForward (MaximizeEvent, MaximizeEvent)
M_implementEventForward (MoveEvent, MoveEvent)

#undef M_implementEventForward

//-------------------------------------------------------------------------

#define M_implementEventHandlerEntry(EventVar)  \
    wxTopLevelType * TLWNative = NULL; \
    if (!getTLWFromEvent (EventVar, & TLWNative)) \
      return false; \
      \
    if (m_IsLockEventProcessing) \
      { \
        LOG_message ("locked, returning"); \
        return false; \
      } \
    wxScopedSetToTrue ScopedSetToTrue (m_IsLockEventProcessing); \

//-------------------------------------------------------------------------

bool wxAppRootFrame::notifyTLWDestroyEvent (wxWindowDestroyEvent & DestroyEvent)
{
    M_implementEventHandlerEntry(DestroyEvent)

    if (TLWNative != m_ControllingFrame)
      {
        deleteInfoFromWindow (TLWNative);
      }
    return false;
}

bool wxAppRootFrame::notifyTLWCloseEvent (wxCloseEvent & CloseEvent /*, bool IsHideInsteadOfClose */)
{
    bool IsHideInsteadOfClose = false;

    M_implementEventHandlerEntry(CloseEvent)

    if (TLWNative != m_ControllingFrame)
      {
        // WARN TODO CloseEvent() may be close or just hide
        int InfoIndex = findInfoFromWindow (TLWNative);
        if (InfoIndex == -1)
          {
            LOG_message ("could not find corresponding info");
          }
        else
          {
            if (IsHideInsteadOfClose)
              {
                // do nothing here
                // wxCloseEvent is used to hide non-modal dialogs
                // caller must indicate behavior of class
                LOG_message ("ignoring close event: IsHideInsteadOfClose == true");
              }
            else
              {
                LOG_message ("ignoring close event: IsHideInsteadOfClose == false, but don't trust");
                // deleteInfo (InfoIndex);
              }
          }
      }
    return false;
}

bool wxAppRootFrame::notifyTLWShowEvent (wxShowEvent & ShowEvent)
{
    M_implementEventHandlerEntry(ShowEvent)

    return false;
}

bool wxAppRootFrame::notifyTLWActivateEvent (wxActivateEvent & ActivateEvent)
{
    bool IsActive = ActivateEvent.GetActive();

    LOG_message (((ActivateEvent.GetEventType() == wxEVT_ACTIVATE_APP) 
                  ? "wxEVT_ACTIVATE_APP" : 
                  ((ActivateEvent.GetEventType() == wxEVT_ACTIVATE) ? "wxEVT_ACTIVATE" : "(other)"))
                 << LOG_var (IsActive));

    M_implementEventHandlerEntry(ActivateEvent)

    wxWindow * AppRootFrame = this;

    if (TLWNative == this)
      {
        if (IsActive)
          {
            wxWindow * Window = getDefaultParentWindow (NULL);
            if (Window != NULL)
              {
                // Window -> Show();
                LOG_WindowInfo (Window);
                LOG_message ("calling Raise()");
                Window -> Raise();
              }
          }
      }
    else if (TLWNative != m_ControllingFrame)
      {
        if (IsActive)
          {
            int InfoIndex = findInfoFromWindow (TLWNative);
            if (InfoIndex == -1)
              {
                // add add top of array/stack
                LOG_message ("window not in list");
                pushInfo (wxTLWStateInfo (TLWNative, true));
              }
            else
              {
                // move to top of array/stack:
                wxTLWStateInfo TLWStateInfo = getInfoByIndex (InfoIndex);
                deleteInfo (InfoIndex);
                pushInfo (TLWStateInfo);
              }
          }
      }
    return false;
}

bool wxAppRootFrame::notifyActivateAppEvent (bool IsActivate, wxWindow * LastFocusWindow)
{
    wxWindow * AppRootFrame = this;

    LOG_message (LOG_var (m_IsLockEventProcessing) 
                 << LOG_var (IsActivate)
                 << LOG_var (m_IsFirstActivateAppEvent));
    LOG_WindowInfo (LastFocusWindow);
    
    if (m_IsLockEventProcessing)
      {
        LOG_message ("locked, returning");
        return false;
      }
    wxScopedSetToTrue ScopedSetToTrue (m_IsLockEventProcessing);

    if (IsActivate == false)
      {
        m_IsFirstActivateAppEvent = true;
        m_LastFocusWindow = LastFocusWindow;
      }

    if (m_IsFirstActivateAppEvent
        && IsActivate)
      {
        int InfoCount = m_TLWStateInfoArray.GetCount();
        LOG_message (LOG_var (InfoCount));
        for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
          {
            // raise windows in Z-order, starting with lowest
            wxTLWStateInfo & TLWStateInfo
              = m_TLWStateInfoArray [InfoIndex];

            wxWindow * Window = TLWStateInfo.m_Window;
            bool IsNeedShow = Window -> IsShown();
            
            LOG_WindowInfo (Window);
            LOG_message (LOG_var(IsNeedShow));
            
            if (IsNeedShow)
              {
                LOG_message ("calling Show()");
                __try
                  {
                    Window -> Show (true);
                  }
                __catch_displayMessageBox
              }
            LOG_message ("calling Raise()");
            __try
              {
                Window -> Raise ();
              }
            __catch_displayMessageBox
          }

        if (m_LastFocusWindow != NULL)
          {
            // first need to verify that window pointer is still
            // valid (sometimes an active-app message arrived "late", 
            // and a window/dialog may have been closed meanwhile, 
            // scope was wxGTK)
            if (wxVerifyWindowPtr (this, m_LastFocusWindow))
              {
                LOG_WindowInfo (m_LastFocusWindow);

                // make sure that the window still can get the focus (if 
                // setting focus to a window that is disabled, the application/
                // message loop may lock up)
                if (m_LastFocusWindow -> IsEnabled())
                  {
                    LOG_message ("setting focus to LastFocusWindow");
                    m_LastFocusWindow -> SetFocus();
                  }
                else
                  {
                    // TODO: set focus to first enabled parent window
                    // (or maybe siblings-window?)
                  }
              }
          }
      }

    if (IsActivate)
      {
        m_IsFirstActivateAppEvent = false;
      }
    return false;
}

bool wxAppRootFrame::notifyTLWIconizeEvent (wxIconizeEvent & IconizeEvent)
{
    M_implementEventHandlerEntry(IconizeEvent)

    wxWindow * AppRootFrame = this;

    if (TLWNative == m_ControllingFrame)
      {
        // minimizing hidden dummy window:
        // - because of tool-window style, this causes as minimalistic
        //   title bar to appear in lower left corner of screen, so
        //   don't do it (scope: wxWidgets 2.5.3, WinXP)
        //     getApp().getAppRootFrame().Iconize();
        // - restore causes the hidden main window to become visible,
        //   so don't do it (scope: wxWidgets 2.5.3, WinXP)
        //     getApp().getAppRootFrame().Restore();


        bool IsIconize = IconizeEvent.Iconized();
        if (IsIconize)
          {
            // hide windows, and remember Show/Hide state before hiding
            int InfoCount = m_TLWStateInfoArray.GetCount();
            for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
              {
                wxTLWStateInfo & TLWStateInfo
                  = m_TLWStateInfoArray [InfoIndex];

                wxWindow * Window = TLWStateInfo.m_Window;
                bool IsCurrentlyShown = Window -> IsShown();

                LOG_WindowInfo (Window)
                LOG_message (LOG_var(IsCurrentlyShown));
                TLWStateInfo.m_IsShownWhenNotIconized = IsCurrentlyShown;

                LOG_message ("calling Hide()");
                Window -> Hide();                
              }
          }
        else
          {
            // it is required to restore e.g. non-modal dialogs (having popup style) 
            // manually: raise windows in Z-order, starting with lowest
            int InfoCount = m_TLWStateInfoArray.GetCount();
            for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
              {
                wxTLWStateInfo & TLWStateInfo
                  = m_TLWStateInfoArray [InfoIndex];

                wxWindow * Window = TLWStateInfo.m_Window;
                bool IsNeedShowAndRaise = TLWStateInfo.m_IsShownWhenNotIconized;

                LOG_WindowInfo (Window)
                LOG_message (LOG_var(IsNeedShowAndRaise));

                if (IsNeedShowAndRaise)
                  {
                    LOG_message ("calling Show() and Raise()");
                    Window -> Show (true);
                    Window -> Raise ();
                  }
              }
          }
      }
    return false;
}

bool wxAppRootFrame::notifyTLWMaximizeEvent (wxMaximizeEvent & MaximizeEvent)
{
    M_implementEventHandlerEntry(MaximizeEvent)

    return false;
}

bool wxAppRootFrame::notifyTLWMoveEvent (wxMoveEvent & MoveEvent)
{
    M_implementEventHandlerEntry(MoveEvent)

    if (TLWNative == m_ControllingFrame)
      {
        wxPoint Point = MoveEvent.GetPosition();
        wxSize Size = TLWNative -> GetSize();
        this -> Move (Point.x + Size.GetWidth()/2, Point.y + Size.GetHeight()/2);
      }
    return false;
}

#undef M_implementEventHandlerEntry

//-------------------------------------------------------------------------

#define M_connectEventHandler(EventName,EventShortName,EventTypeName)   \
  { \
    wx ## EventName ## EventFunction  EventShortName ## EventFunction \
      = (wx ## EventName ## EventFunction) (& wxAppRootFrame::OnTLW ## EventShortName ## EventForward); \
    \
    /* HACK use of non-static member function of wrong object */   \
    Window -> Connect (Window -> GetId(), \
                       EventTypeName, \
                       (wxObjectEventFunction) (wxEventFunction) EventShortName ## EventFunction); \
  } \

void wxAppRootFrame::connectTLWEventHandlers (wxWindow * Window)
{
    wxActivateEventFunction ActivateEventFunction
      = (wxActivateEventFunction) (& wxAppRootFrame::OnTLWActivateEventForward);

    // HACK use of non-static member function of wrong object
    Window -> Connect (Window -> GetId(),
                       wxEVT_ACTIVATE,
                       (wxObjectEventFunction) (wxEventFunction) ActivateEventFunction);

    M_connectEventHandler (WindowDestroy, Destroy, wxEVT_DESTROY)
    M_connectEventHandler (Close, Close, wxEVT_CLOSE_WINDOW)
    M_connectEventHandler (Show, Show, wxEVT_SHOW)
    M_connectEventHandler (Activate, Activate, wxEVT_ACTIVATE)
    // wxEVT_ACTIVATE_APP may not work, must use special notifyActivateAppEvent() 
    // instead
    M_connectEventHandler (Activate, Activate, wxEVT_ACTIVATE_APP)
    M_connectEventHandler (Iconize, Iconize, wxEVT_ICONIZE)
    M_connectEventHandler (Maximize, Maximize, wxEVT_MAXIMIZE)
    M_connectEventHandler (Move, Move, wxEVT_MOVE)
}

#undef M_connectEventHandler

bool wxAppRootFrame::getTLWFromEvent (wxEvent & Event, wxTopLevelType ** TLWNativePtrPtr)
{
    if (Event.GetEventObject() == NULL)
      return false;

    wxWindow * AppRootFrame = this;
      
#if wxCHECK_VERSION (2, 5, 0)
    wxTopLevelType * TLWNative = wxDynamicCast (Event.GetEventObject(), wxTopLevelWindowNative);
#else
    // older wxWidgets versions don't seem to have appropriate wxTopLevelWindowNative
    // class info support
    wxTopLevelType * TLWNative = wxDynamicCast (Event.GetEventObject(), wxWindow);
#endif
    if (TLWNative == NULL)
      return false;

    LOG_message ("found TLW: ");
    LOG_WindowInfo (TLWNative);
    *TLWNativePtrPtr = TLWNative;
    return true;
}

//-------------------------------------------------------------------------

int wxAppRootFrame::pushInfo (const wxTLWStateInfo & TLWStateInfo)
{
    int InfoCount = m_TLWStateInfoArray.GetCount();
    m_TLWStateInfoArray.Add (new wxTLWStateInfo (TLWStateInfo));

    // InfoCount should be index of currently added element:
    return InfoCount;
}

void wxAppRootFrame::deleteInfo (int Index)
{
    LOG_message ("removing info");
    m_TLWStateInfoArray.RemoveAt (Index);
}

void wxAppRootFrame::deleteInfoFromWindow (wxWindow * Window)
{
    int InfoIndex = findInfoFromWindow (Window);
    if (InfoIndex != -1)
      {
        LOG_message ("removing info");
        m_TLWStateInfoArray.RemoveAt (InfoIndex);
      }
    else
      {
        wxASSERT_MSG (false, "deleteInfoFromWindow(): window not found");
      }
}

wxTLWStateInfo & wxAppRootFrame::getInfoByIndex (int InfoIndex)
{
    return m_TLWStateInfoArray [InfoIndex];
}

int wxAppRootFrame::findInfoFromWindow (wxWindow * Window)
{
    int InfoCount = m_TLWStateInfoArray.GetCount();
    for (int InfoIndex = 0; InfoIndex < InfoCount; ++InfoIndex)
      {
        wxTLWStateInfo & TLWStateInfo
          = m_TLWStateInfoArray [InfoIndex];

        if (TLWStateInfo.m_Window == Window)
          return InfoIndex;
      }
    return -1;
}


//-------------------------------------------------------------------------

#undef LOG_WindowInfo

#ifdef M_IsNeedLogMessageRestore
#   define LOG_message SAVE_LOG_message
#   define LOG_var SAVE_LOG_var
#endif

#endif // M_WxExtLib_IsUseAppRootFrame

//-------------------------------------------------------------------------

wxAppRootFrame * wxGetGlobalAppRootFrame()
{
    return s_GlobalAppRootFrame;
}

//=========================================================================

#if (M_WxExtLib_IsUseStxLogging == 1)
    #undef __try
    #undef __catch_rethrow
    #undef __catch_displayMessageBox
#endif

//=========================================================================
