// -*- c++ -*-
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2003-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice

-------------------------------------------------------------------------
*/

#ifndef _INCLUDED_TextCtrlSliderPairValidators_h
#define _INCLUDED_TextCtrlSliderPairValidators_h

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
#   pragma interface "TextCtrlSliderPairValidators.h"
#endif

#include "WxExtLibConfig.h"

#include <wx/defs.h>

#include <wx/textctrl.h>
#include <wx/slider.h>
#include <wx/validate.h>

#include "StatusValidators.h"

//-------------------------------------------------------------------------

#define M_IsDefineExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsDefineExportMagic

//-------------------------------------------------------------------------

// wxTextCtrlSliderPairTextCtrlValidator/wxTextCtrlSliderPairSliderValidator:
// - allow mutual update if one of both associated controls (wxTextCtrl or
//   wxSlider) is changed by users input 
// - if entered text is valid: associated slider is updated immediately;
//   otherwise the user will get immediate feedback via wxStatusMessageTarget
//   (wxTextCtrlSliderPairTextCtrlValidator is derived from
//   wxNumberValidator/wxTextCtrlStatusValidator)
// - both required controls and both required validators can be created with
//   minimum effort by calling wxExtDialog::addTextCtrlSliderPairWithLabel()

class wxTextCtrlSliderPairTextCtrlValidator;
class wxTextCtrlSliderPairSliderValidator;

//-------------------------------------------------------------------------

class M_WxExtLib_ExportDecl wxTextCtrlSliderPairTextCtrlValidator: public wxNumberValidator
{
DECLARE_DYNAMIC_CLASS(wxTextCtrlSliderPairTextCtrlValidator)
public:

    wxTextCtrlSliderPairTextCtrlValidator () ;
    wxTextCtrlSliderPairTextCtrlValidator(long * LongValue, long MinLong, long MaxLong,
                                          wxStatusMessageTarget * StatusMessageTarget,
                                          const wxString & FieldNameString);
    wxTextCtrlSliderPairTextCtrlValidator(const wxTextCtrlSliderPairTextCtrlValidator & TextCtrlSliderPairTextCtrlValidator);

    ~wxTextCtrlSliderPairTextCtrlValidator();

    virtual wxObject *Clone() const { return new wxTextCtrlSliderPairTextCtrlValidator(*this); }
    bool Copy(const wxTextCtrlSliderPairTextCtrlValidator & TextCtrlSliderPairTextCtrlValidator);

    // set associated slider validator
    void setAssociatedSliderValidator (wxTextCtrlSliderPairSliderValidator * AssociatedSliderValidator);

    virtual bool TransferToWindow();

    virtual void handleValidInput ();

    void informSliderChange (long TempLong);

DECLARE_EVENT_TABLE()

protected:
    wxTextCtrlSliderPairSliderValidator * m_AssociatedSliderValidator;
};

//-------------------------------------------------------------------------

class M_WxExtLib_ExportDecl wxTextCtrlSliderPairSliderValidator: public wxValidator
{
DECLARE_DYNAMIC_CLASS(wxTextCtrlSliderPairSliderValidator)
public:

    wxTextCtrlSliderPairSliderValidator () ;
    wxTextCtrlSliderPairSliderValidator(const wxTextCtrlSliderPairSliderValidator& TextCtrlSliderPairSliderValidator);

    ~wxTextCtrlSliderPairSliderValidator();

    virtual wxObject *Clone() const { return new wxTextCtrlSliderPairSliderValidator(*this); }
    bool Copy(const wxTextCtrlSliderPairSliderValidator & TextCtrlSliderPairSliderValidator);

    // validate and transfer from/to window
    virtual bool Validate(wxWindow *parent);
    virtual bool TransferToWindow();
    virtual bool TransferFromWindow();

    // events to handle changes in the slider position
    void OnScrollEvent(wxScrollEvent & Event);

    // set associated slider validator
    void setAssociatedTextCtrlValidator (wxTextCtrlSliderPairTextCtrlValidator * AssociatedTextCtrlValidator);

    void informTextCtrlChange (long TempLong);

DECLARE_EVENT_TABLE()

protected:
    wxTextCtrlSliderPairTextCtrlValidator * m_AssociatedTextCtrlValidator;

    bool m_IsLastSliderPositionValid;
    long m_LastSliderPositionLong;
};

//-------------------------------------------------------------------------

#define M_IsUndefExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsUndefExportMagic

//-------------------------------------------------------------------------

#endif
  // _INCLUDED_TextCtrlSliderPairValidators_h

//-------------------------------------------------------------------------
