// -*- c++ -*-
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2003-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice

-------------------------------------------------------------------------
*/

#if (!defined M_StatusValidators_IsEmitGenericDeclarations)

#ifndef _INCLUDED_StatusValidators_h
#define _INCLUDED_StatusValidators_h

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
#   pragma interface "StatusValidators.h"
#endif

#include "WxExtLibConfig.h"

#include <wx/defs.h>

#ifndef WX_PRECOMP
#   include <wx/validate.h>
#   include <wx/textctrl.h>
#endif

#include <wx/valgen.h>
#include <wx/datetime.h>

#include "WxMisc.h"

//-------------------------------------------------------------------------

#define M_IsDefineExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsDefineExportMagic

//-------------------------------------------------------------------------

// wxStatusMessageTarget
// - used to output status messages - normally directed to
//   a wxTextCtrl
// - may also display a message box (can be enabled/disabled
//   with enableShowMessageBox())
class wxStatusMessageTarget: public wxObject
{
DECLARE_DYNAMIC_CLASS(wxStatusMessageTarget)
public:

    // constructors:
    // - ErrorMessageMultiLineText may be NULL and can be set later
    //   by calling setOutput()
    wxStatusMessageTarget () ;
    wxStatusMessageTarget(wxMultiLineText * ErrorMessageMultiLineText,
                          const wxString & NonErrorMessageString);
    wxStatusMessageTarget(const wxStatusMessageTarget& StatusMessageTarget);

    ~wxStatusMessageTarget();

    virtual wxObject *Clone() const { return new wxStatusMessageTarget(*this); }
    bool Copy(const wxStatusMessageTarget & StatusMessageTarget);

    //-- functions to set and display the error message to some status text output control
    // setMessage(): currently, the old message is replaced by the new message
    virtual void setMessage (const wxString & MessageString, bool IsError);

    virtual void display (wxWindow * ParentWindow);
    virtual void clear ();

    void enableShowMessageBox (bool IsShowMessageBoxEnabled);
    bool isShowMessageBoxEnabled ();

    void setStatusOutput (wxMultiLineText * ErrorMessageMultiLineText);
    void setNonErrorMessageString (const wxString & NonErrorMessageString);

protected:
    wxMultiLineText * m_ErrorMessageMultiLineText;
    wxString m_NonErrorMessageString; 
    wxString m_MessageString;
    bool m_IsError;

    bool m_IsShowMessageBoxEnabled;
};

//-------------------------------------------------------------------------

// wxROGenericValidator: Read-Only GenericValidator
// (ignores the text in the control - transfers only to the control, but not
// from the control)
class wxROGenericValidator: public wxGenericValidator
{
DECLARE_CLASS(wxROGenericValidator)
public:
    // TODO: one could also provide constructors which take const VARTYPE pointers,
    // because the values won't be modified anyway
    wxROGenericValidator(bool* val);
    wxROGenericValidator(int* val);
    wxROGenericValidator(wxString* val);
    wxROGenericValidator(wxArrayInt* val);

    virtual wxObject *Clone() const { return new wxROGenericValidator(*this); }

    virtual bool Validate(wxWindow * WXUNUSED(parent)) { return true; }
    virtual bool TransferFromWindow() { return true; }
};

//-------------------------------------------------------------------------

// wxTextCtrlStatusValidator:
// - base class for validators (such as wxNumberValidator)
// - immediate feedback of validity of entered text via
//   wxStatusMessageTarget
class wxTextCtrlStatusValidator: public wxValidator
{
DECLARE_ABSTRACT_CLASS(wxTextCtrlStatusValidator)
public:
    enum
    {
      IsEmptyAllowed = 0x01,
      IsFilterInputChars = 0x02 // currently unused
    }; 

    wxTextCtrlStatusValidator();
    wxTextCtrlStatusValidator(wxStatusMessageTarget * StatusMessageTarget,
                              int Flags = 0);
    wxTextCtrlStatusValidator(const wxTextCtrlStatusValidator& TextCtrlStatusValidator);

    ~wxTextCtrlStatusValidator();

    bool Copy(const wxTextCtrlStatusValidator & TextCtrlStatusValidator);

    // overridable helper functions to get/set content of TextCtrl
    virtual void getTextCtrlContent (wxString & TextCtrlContentString);
    virtual void setTextCtrlContent (const wxString & TextCtrlContentString);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString) = 0;
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=false) = 0;
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString) = 0;

    // function to display the error message to some status text output control
    virtual void showStatusMessage (const wxString & ErrorMessageString, bool IsError,
                                    wxWindow * ParentWindow);

    // validation and transfer to/from the control
    virtual bool Validate(wxWindow *parent);
    virtual bool TransferToWindow();
    virtual bool TransferFromWindow();

    // events to filter keystrokes and to show status message
    void OnChar(wxKeyEvent& Event);
    void OnTextChanged(wxCommandEvent& Event);
    void OnComboBoxSelected(wxCommandEvent& Event);
    void OnChoiceSelected(wxCommandEvent& Event);

DECLARE_EVENT_TABLE()

protected:
    wxStatusMessageTarget * m_StatusMessageTarget;
    int m_Flags;
    bool m_IsInsideOnTextChanged;

    bool checkValidator() const;
};

//-------------------------------------------------------------------------

class wxTextCtrlStatusValidatorTrait
{
    // DECLARE_ABSTRACT_CLASS(wxTraitedTextCtrlStatusValidator)
public:
    virtual ~wxTextCtrlStatusValidatorTrait()  { };

    virtual void convertToString (wxString & TextCtrlContentString) = 0;
    virtual bool convertFromStringTemporary (const wxString & TextCtrlContentString,
                                             wxString & ErrorMessageString,
                                             bool IsTextCtrlChangeEvent) = 0;
    virtual bool convertFromStringPersistent (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString) = 0;
};

//-------------------------------------------------------------------------

class wxTraitedTextCtrlStatusValidator: public wxTextCtrlStatusValidator
{
DECLARE_ABSTRACT_CLASS(wxTraitedTextCtrlStatusValidator)
public:
    wxTraitedTextCtrlStatusValidator();
    wxTraitedTextCtrlStatusValidator(wxTextCtrlStatusValidatorTrait * TextCtrlStatusValidatorTrait,
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     int Flags);
    wxTraitedTextCtrlStatusValidator(const wxTraitedTextCtrlStatusValidator& TraitedTextCtrlStatusValidator);

    ~wxTraitedTextCtrlStatusValidator();

    // virtual wxObject *Clone() const { return new wxTraitedTextCtrlStatusValidator(*this); }
    bool Copy(const wxTraitedTextCtrlStatusValidator & TraitedTextCtrlStatusValidator);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString);
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=false);
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString);

    virtual void handleValidInput ();

DECLARE_EVENT_TABLE()

protected:
    wxTextCtrlStatusValidatorTrait * m_TextCtrlStatusValidatorTrait;

    bool checkValidator() const;
};

//-------------------------------------------------------------------------

#define M_IsUndefExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsUndefExportMagic

//=========================================================================

#define M_StatusValidators_IsEmitGenericDeclarations

//-------------------------------------------------------------------------

// declare wxBasictypeValidatorTrait_wxInt16
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxInt16
    #define M_BasictypeValidatorTrait_Basictype wxInt16
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_wxUint16
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxUint16
    #define M_BasictypeValidatorTrait_Basictype wxUint16
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_wxInt32
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxInt32
    #define M_BasictypeValidatorTrait_Basictype wxInt32
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_wxUint32
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxUint32
    #define M_BasictypeValidatorTrait_Basictype wxUint32
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_short
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_short
    #define M_BasictypeValidatorTrait_Basictype short
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_ushort
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_ushort
    #define M_BasictypeValidatorTrait_Basictype unsigned short
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_int
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_int
    #define M_BasictypeValidatorTrait_Basictype int
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_uint
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_uint
    #define M_BasictypeValidatorTrait_Basictype unsigned int
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_long
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_long
    #define M_BasictypeValidatorTrait_Basictype long
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_ulong
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_ulong
    #define M_BasictypeValidatorTrait_Basictype unsigned long
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// // CHECK wxFloat32 always is 'float', wxFloat64 always is 'double'? provide typedefs?
// declare wxBasictypeValidatorTrait_wxFloat32
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxFloat32
    #define M_BasictypeValidatorTrait_Basictype wxFloat32
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_wxFloat64
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxFloat64
    #define M_BasictypeValidatorTrait_Basictype wxFloat64
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_wxStringBase
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxStringBase
    #define M_BasictypeValidatorTrait_Basictype wxString
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

// declare wxBasictypeValidatorTrait_wxDateTime
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxDateTime
    #define M_BasictypeValidatorTrait_Basictype wxDateTime
    #define M_BasictypeValidatorTrait_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_ExportDecl

//-------------------------------------------------------------------------

#undef M_StatusValidators_IsEmitGenericDeclarations

//=========================================================================

class wxBasictypeValidatorTrait_wxString 
  : public wxBasictypeValidatorTrait_wxStringBase
{
 public:
#if 0
    // HACK repeat those flag values from wxTextCtrlStatusValidatorTrait classes
    // for ease of use
    enum
    {
      // repeated flags:
      IsEmptyAllowed = 0x01,
      /* IsFilterInputChars = 0x02 // currently unused */
      IsWritebackToCopy = 0x04,
      IsReadFromCopy = 0x08,
      IsIgnoreMinimum = 0x10,
      IsIgnoreMaximum = 0x20,
      IsNoTrimRight = 0x40,
      IsNoTrimLeft = 0x80,
        IsNoTrim = 0xc0  /* == IsNoTrimRight | IsNoTrimLeft */
    };
#endif

    wxBasictypeValidatorTrait_wxString();

    // setMinStringLength()
    // - default is 0
    void setMinStringLength (int MinStringLength);
    // setMaxStringLength()
    // - MaxStringLength == -1 means unlimited length
    // - default is -1
    void setMaxStringLength (int MaxStringLength);

    void setAllowedInputCharset (const wxString & CharsetString);
    // given charset description is included in error messages when input 
    // is incorrect
    void setAllowedInputCharsetDescription (const wxString & CharsetDescriptionString);

    // override this function already defined in base class to add further
    // checks on string length
    virtual bool convertFromStringHelper (const wxString & TextCtrlContentString,
                                          wxString * TrimmedInputStringPtr,
                                          wxString & ErrorMessageString);

    virtual void getErrorMessageString (wxString & ErrorMessageString);

 private:
    int m_MinStringLength;
    int m_MaxStringLength;

    wxString m_AllowedCharsetString;
    wxString m_AllowedCharsetDescriptionString;
};

//=========================================================================

#define M_IsDefineExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsDefineExportMagic

//-------------------------------------------------------------------------

// NOTE wxNumberValidatorVariant could be possibly replaced by wxVariant (which
// is much more powerful), but wxVariant possibly has poorer performance
// (maybe it is better to add a wxVariant type to wxNumberValidatorVariant)
class wxNumberValidatorVariant
{
 public:
    wxNumberValidatorVariant ();

    enum EType { UndefinedType, LongType, DoubleType /*, VariantType */ };

    bool getIsLong () const;
    bool getIsDouble () const;

    long getLong () const;
    double getDouble () const;
    void getLong (long * Long) const;
    void getDouble (double * Double) const;
    void setLong (long Long);
    void setDouble (const double & Double);

    bool operator== (const wxNumberValidatorVariant & Variant) const;

 private:
    EType m_Type;

    // (variables of different types could be made part of a union)
    long m_Long;
    double m_Double;
};

//-------------------------------------------------------------------------

// wxNumberValidator
// - support for integer, long or double type values
// - values are checked if they are within the specified range
//   [Min, Max]
// - immediate feedback is given to the user via the associated
//   wxStatusMessageTarget if string entered in the wxTextCtrl
//   doesn't represent a valid input
// - support for 'Undefined value':
//   - A special value may be choosen to (internally) indicate that 
//     the value is 'Undefined' (or 'unset'). 
//   - To use it, the "IsEmptyAllowed" flag must be set.
//   - The Undefined value is printed as empty string. The user
//     can enter the Undefined value by leaving the wxTextCtrl empty.
//   - Note: the Undefined value should be, of course, outside 
//     the range [Min, Max] of valid values. 
class wxNumberValidator: public wxTraitedTextCtrlStatusValidator
{
DECLARE_DYNAMIC_CLASS(wxNumberValidator)
public:
    // HACK repeat those flag values from wxTextCtrlStatusValidatorTrait classes
    // for ease of use
    enum
    {
      IsEmptyAllowed = 0x01,
      /* IsFilterInputChars = 0x02 // currently unused */
      IsWritebackToCopy = 0x04,
      IsReadFromCopy = 0x08,
      IsIgnoreMinimum = 0x10,
      IsIgnoreMaximum = 0x20,
      IsNoTrimRight = 0x40,
      IsNoTrimLeft = 0x80,
        IsNoTrim = 0xc0  /* == IsNoTrimRight | IsNoTrimLeft */
    };

    wxNumberValidator();
    wxNumberValidator(int * IntegerValue, int MinInteger, int MaxInteger, 
                      wxStatusMessageTarget * StatusMessageTarget,
                      const wxString & FieldNameString,
                      int Flags = 0, int UndefinedInteger = 0);
    wxNumberValidator(long * LongValue, long MinLong, long MaxLong,
                      wxStatusMessageTarget * StatusMessageTarget,
                      const wxString & FieldNameString,
                      int Flags = 0, long UndefinedLong = 0);
    wxNumberValidator(double * DoubleValue, double MinDouble, double MaxDouble,
                      wxStatusMessageTarget * StatusMessageTarget,
                      const wxString & FieldNameString,
                      int Flags = 0, 
                      const wxString & FormatString = "%f",
                      double UndefinedDouble = 0.);
    wxNumberValidator(const wxNumberValidator& NumberValidator);

    ~wxNumberValidator();

    virtual wxObject *Clone() const { return new wxNumberValidator(*this); }
    bool Copy(const wxNumberValidator & NumberValidator);

    // some helper functions

DECLARE_EVENT_TABLE()

protected:
    wxBasictypeValidatorTrait_int m_IntBasictypeValidatorTrait;
    wxBasictypeValidatorTrait_long m_LongBasictypeValidatorTrait;
    wxBasictypeValidatorTrait_wxFloat64 m_DoubleBasictypeValidatorTrait;
};

//-------------------------------------------------------------------------

#define M_IsUndefExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsUndefExportMagic

//=========================================================================

#define M_StatusValidators_IsEmitGenericDeclarations

//-------------------------------------------------------------------------

// declare wxTraitedIntValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedIntValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_int
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype int
    #define M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
    #undef M_TraitedTextCtrlStatusValidatorImpl_ExportDecl

// declare wxTraitedUintValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedUintValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_uint
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype unsigned int
    #define M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
    #undef M_TraitedTextCtrlStatusValidatorImpl_ExportDecl

// declare wxTraitedLongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedLongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_long
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype long
    #define M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
    #undef M_TraitedTextCtrlStatusValidatorImpl_ExportDecl

// declare wxTraitedUlongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedUlongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_ulong
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype unsigned long
    #define M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
    #undef M_TraitedTextCtrlStatusValidatorImpl_ExportDecl

// declare wxTraitedStringValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedStringValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxString
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype wxString
    #define M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
    #undef M_TraitedTextCtrlStatusValidatorImpl_ExportDecl

// declare wxTraitedDateTimeValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedDateTimeValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxDateTime
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype wxDateTime
    #define M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
    #undef M_TraitedTextCtrlStatusValidatorImpl_ExportDecl

//-------------------------------------------------------------------------

#undef M_StatusValidators_IsEmitGenericDeclarations


// // TEST
// DECLARE_CLASS_wxTraitedTextCtrlStatusValidatorImpl(wxTraitedStringValidatorBase, 
                                                   // wxBasictypeValidatorTrait_wxStringBase, wxString)

//=========================================================================

#define M_IsDefineExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsDefineExportMagic

//-------------------------------------------------------------------------

// wxRONumberValidator: Read-Only NumberValidator
// (ignores input made into the wxTextCtrl - transfers only to the window,
// not back)
class wxRONumberValidator: public wxNumberValidator
{
DECLARE_DYNAMIC_CLASS(wxRONumberValidator)
public:

    wxRONumberValidator ();
    wxRONumberValidator (int * IntegerValue,
                         int Flags = 0, int UndefinedInteger = 0);
    wxRONumberValidator (long * LongValue,
                         int Flags = 0, int UndefinedLong = 0);

    virtual wxObject *Clone() const { return new wxRONumberValidator(*this); }

    // no validation shall be made for window content
    virtual bool Validate(wxWindow * WXUNUSED(ParentWindow)) { return true; }
    // no data shall be transferred from the window
    virtual bool TransferFromWindow() { return true; }

};

//-------------------------------------------------------------------------

class wxTraitedStringValidator: public wxTraitedStringValidatorBase
{
    DECLARE_DYNAMIC_CLASS(wxTraitedStringValidator)
public:
    wxTraitedStringValidator ();
    wxTraitedStringValidator(wxString * StringPtr, 
                             wxStatusMessageTarget * StatusMessageTarget,
                             const wxString & FieldNameString,
                             int MaxStringLength = -1, 
                             int Flags = 0, 
                             const wxString & UndefinedString = wxEmptyString);
    virtual ~wxTraitedStringValidator() { };
    wxTraitedStringValidator(const wxTraitedStringValidator& TraitedTextCtrlStatusValidatorImpl);

    virtual wxObject *Clone() const { return new wxTraitedStringValidator(*this); }
    bool Copy(const wxTraitedStringValidator & TraitedStringValidator);

    DECLARE_EVENT_TABLE()
 protected:
};

//-------------------------------------------------------------------------

typedef wxTraitedStringValidator wxStringValidator;

//-------------------------------------------------------------------------

// wxTraitedDateTimeValidator:
// - validate from/to wxDateTime using specified date/time format
//   string (defaulting to a simple ISO style date/time)
class wxTraitedDateTimeValidator: public wxTraitedDateTimeValidatorBase
{
    DECLARE_DYNAMIC_CLASS(wxTraitedDateTimeValidator)
public:
    // - default for DateTimeFormatString (if empty): 
    //   ISO date and time ("%Y-%m-%d %H:%M:%S)
    wxTraitedDateTimeValidator ();
    wxTraitedDateTimeValidator(wxDateTime * DateTimePtr, 
                               wxStatusMessageTarget * StatusMessageTarget,
                               const wxString & FieldNameString,
                               int Flags = 0,
                               const wxString & DateTimeFormatString = wxEmptyString);
    wxTraitedDateTimeValidator (wxDateTime * DateTimePtr, 
                                wxDateTime MinDateTime, wxDateTime MaxDateTime,
                                wxStatusMessageTarget * StatusMessageTarget,
                                const wxString & FieldNameString,
                                int Flags, wxDateTime UndefinedDateTime,
                                const wxString & DateTimeFormatString = wxEmptyString);

    virtual ~wxTraitedDateTimeValidator() { };
    wxTraitedDateTimeValidator(const wxTraitedDateTimeValidator& TraitedTextCtrlStatusValidatorImpl);

    virtual wxObject *Clone() const { return new wxTraitedDateTimeValidator(*this); }
    bool Copy(const wxTraitedDateTimeValidator & TraitedDateTimeValidator);

    DECLARE_EVENT_TABLE()
 protected:
};

//-------------------------------------------------------------------------

typedef wxTraitedDateTimeValidator wxDateTimeValidator;

//-------------------------------------------------------------------------

// wxNonTraitedDateTimeValidator
// - currently can be used for date input/output only (without time)
// - for problem of day-month/month-day order of wxDateTime depending 
//   on the locale see notes in the source code
class wxNonTraitedDateTimeValidator: public wxTextCtrlStatusValidator
{
DECLARE_DYNAMIC_CLASS(wxNonTraitedDateTimeValidator)
public:
    wxNonTraitedDateTimeValidator();
    wxNonTraitedDateTimeValidator(wxDateTime * DateTimeValue,
                        wxStatusMessageTarget * StatusMessageTarget,
                        const wxString & FieldNameString,
                        int Flags = 0);
    wxNonTraitedDateTimeValidator(const wxNonTraitedDateTimeValidator& NonTraitedDateTimeValidator);
    ~wxNonTraitedDateTimeValidator();

    virtual wxObject *Clone() const { return new wxNonTraitedDateTimeValidator(*this); }
    bool Copy(const wxNonTraitedDateTimeValidator & NonTraitedDateTimeValidator);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString);
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=false);
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString);

    // some helper functions
    virtual void transferToWindowHelper (const wxDateTime & DateTime, 
                                         wxString & TextCtrlContentString);
    virtual bool transferFromWindowHelper (const wxString & TextCtrlContentString,
                                           wxDateTime * DateTime, wxString & ErrorMessageString);
    // checkValue() might be overwritten to do further checks
    virtual bool checkValue (const wxDateTime & DateTime);
    virtual void getErrorMessageString (const wxDateTime & DateTime, wxString & ErrorMessageString);

    virtual void handleValidInput (const wxDateTime & DateTime);

DECLARE_EVENT_TABLE()

protected:
    wxDateTime * m_DateTimeValue;
    wxString m_FieldNameString;
};

//-------------------------------------------------------------------------

// wxNonTraitedStringValidator
// - NOTE: this class is superseeded by wxTraitedStringValidator,
//   which is now aliased as wxStringValidator
class wxNonTraitedStringValidator: public wxTextCtrlStatusValidator
{
DECLARE_DYNAMIC_CLASS(wxNonTraitedStringValidator)
public:
    wxNonTraitedStringValidator();
    // DEF MaxStringLength == -1 to indicate an unlimited string length 
    wxNonTraitedStringValidator(wxString * StringValue, 
                                wxStatusMessageTarget * StatusMessageTarget,
                                const wxString & FieldNameString,
                                int MaxStringLength = -1, 
                                int Flags = 0, 
                                const wxString & UndefinedString = wxEmptyString);
    wxNonTraitedStringValidator(const wxNonTraitedStringValidator& StringValidator);

    ~wxNonTraitedStringValidator();

    virtual wxObject *Clone() const { return new wxNonTraitedStringValidator(*this); }
    bool Copy (const wxNonTraitedStringValidator & StringValidator);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString);
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=false);
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString);

    // some helper functions
    virtual void transferToWindowHelper (const wxString & String,
                                         wxString & TextCtrlContentString);
    virtual bool transferFromWindowHelper (const wxString & TextCtrlContentString,
                                           wxString * String, wxString & ErrorMessageString);
    virtual bool checkValue (const wxString & String);
    virtual void getErrorMessageString (const wxString & String, 
                                        wxString & ErrorMessageString);

    virtual void handleValidInput (const wxString & String);

DECLARE_EVENT_TABLE()

protected:
    wxString * m_StringValue; 
    wxString m_FieldNameString;
    int      m_MaxStringLength;
    wxString m_UndefinedString;
};

//=========================================================================

class wxFilenameValidatorTrait : public wxBasictypeValidatorTrait_wxString
{
    /* DECLARE_ABSTRACT_CLASS(wxFilenameValidatorTrait) */
public:
    enum
    {
      /* not yet supported: IsNoImmediateCheck = 0x01, */
      IsNormalize = 0x02,
      IsStoreRelative = 0x04,
      IsStoreNoRelativeParentDir = 0x08,
      /* IsShowRelative = 0x10, */
      /* IsShowNoRelativeParentDir = 0x20, */

      IsErrorIfInvalid = 0x0100,
      IsErrorIfNotFile = 0x0200,
      /* IsErrorIfExisting = 0x0400, */
      /* IsErrorIfDirectory = 0x0800, */
      IsErrorIfNotDirectory = 0x1000
    };

    wxFilenameValidatorTrait ();
    /* wxFilenameValidatorTrait (wxString * FilenameStringPtr,
                              const wxString & FieldNameString,
                              int BasictypeValidatorTraitFlags,
                              int FilenameValidatorTraitFlags,
                              const wxString & UndefinedFilenameString); */
    void init (wxString * FilenameStringPtr,
               const wxString & FieldNameString,
               int BasictypeValidatorTraitFlags,
               int FilenameValidatorTraitFlags,
               const wxString & RelativeRefPathString,
               int NormalizeFlags);
    // next init() function is required to make this class work with 
    // wxTraitedTextCtrlStatusValidatorImpl:
    void init (wxString * BasictypeValuePtr, wxString MinBasictype, wxString MaxBasictype,
               const wxString & FieldNameString,
               int Flags, wxString UndefinedBasictype,
               const wxString & FormatString = wxEmptyString);
    virtual ~wxFilenameValidatorTrait() { };

    bool convertFromStringHelper (const wxString & TextCtrlContentString,
                                  wxString * FilenameStringPtr,
                                  wxString & ErrorMessageString);

/* protected: */
    int m_FilenameValidatorTraitFlags;
    wxString m_RelativeRefPathString;
    int m_NormalizeFlags;
};

//-------------------------------------------------------------------------

#define M_IsUndefExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsUndefExportMagic

//=========================================================================

#define M_StatusValidators_IsEmitGenericDeclarations

// declare wxFilenameValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl wxFilenameValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxFilenameValidatorTrait
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype wxString
    #define M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_WxExtLib_ExportDecl
    #include "StatusValidators.h"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
    #undef M_TraitedTextCtrlStatusValidatorImpl_ExportDecl

#undef M_StatusValidators_IsEmitGenericDeclarations

// DECLARE_CLASS_wxTraitedTextCtrlStatusValidatorImpl(wxFilenameValidatorBase, 
//                                                   wxFilenameValidatorTrait, wxString)

//=========================================================================

#define M_IsDefineExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsDefineExportMagic

//-------------------------------------------------------------------------

// wxFilenameValidator:
// - support validation of file or directory names, with
//   optional checks for existence/non-existence in file system
//   and from/to relative/absolute path resolution
class wxFilenameValidator: public wxFilenameValidatorBase
{
    DECLARE_DYNAMIC_CLASS(wxFilenameValidator)
public:
    wxFilenameValidator ();
    wxFilenameValidator (wxString * FilenameStringPtr,
                         wxStatusMessageTarget * StatusMessageTarget,
                         const wxString & FieldNameString,
                         int BasictypeValidatorTraitFlags,
                         int FilenameValidatorTraitFlags,
                         const wxString & RelativeRefPathString,
                         int NormalizeFlags);
    virtual ~wxFilenameValidator() { };
    wxFilenameValidator(const wxFilenameValidator& TraitedTextCtrlStatusValidatorImpl);

    virtual wxObject *Clone() const { return new wxFilenameValidator(*this); }
    bool Copy(const wxFilenameValidator & FilenameValidator);

    DECLARE_EVENT_TABLE()
 protected:
};

//=========================================================================

extern void wxBasictypeValidatorTrait_convertULongToString (const char * WXUNUSED(FormatString),
                                                            unsigned long ULong,
                                                            wxString & String);
extern void wxBasictypeValidatorTrait_convertLongToString (const char * WXUNUSED(FormatString),
                                                           long Long,
                                                           wxString & String);
extern void wxBasictypeValidatorTrait_convertDoubleToString (const char * FormatString,
                                                             double Double,
                                                             wxString & String);

//-------------------------------------------------------------------------

extern bool wxBasictypeValidatorTrait_convertStringToLong (const char * WXUNUSED(DefaultScanfString),
                                                           const wxString & TrimmedString,
                                                           long & Long);
extern bool wxBasictypeValidatorTrait_convertStringToULong (const char * WXUNUSED(DefaultScanfString),
                                                            const wxString & TrimmedString,
                                                            unsigned long & ULong);
extern bool wxBasictypeValidatorTrait_convertStringToString (const char * WXUNUSED(DefaultScanfString),
                                                             const wxString & TrimmedInputString,
                                                             wxString & OutputString);
extern bool wxBasictypeValidatorTrait_convertStringToFloat (const char * WXUNUSED(DefaultScanfString), 
                                                            const wxString & TrimmedInputString,
                                                            float & Float);
extern bool wxBasictypeValidatorTrait_convertStringToDouble (const char * WXUNUSED(DefaultScanfString), double,
                                                             const wxString & TrimmedInputString,
                                                             double & Double);

extern bool wxBasictypeValidatorTrait_convertStringToWxInt16 (const char * WXUNUSED(DefaultScanfString),
                                                              const wxString & TrimmedInputString,
                                                              wxInt16 & Int16);
extern bool wxBasictypeValidatorTrait_convertStringToWxUint16 (const char * WXUNUSED(DefaultScanfString),
                                                               const wxString & TrimmedInputString,
                                                               wxUint16 & Uint16);
extern bool wxBasictypeValidatorTrait_convertStringToWxInt32 (const char * WXUNUSED(DefaultScanfString),
                                                              const wxString & TrimmedInputString,
                                                              wxInt32 & Int32);
extern bool wxBasictypeValidatorTrait_convertStringToWxUint32 (const char * WXUNUSED(DefaultScanfString), 
                                                               const wxString & TrimmedInputString,
                                                               wxUint32 & Uint32);

extern bool wxBasictypeValidatorTrait_convertStringToShort (const char * WXUNUSED(DefaultScanfString),
                                                            const wxString & TrimmedInputString,
                                                            short & Short);
extern bool wxBasictypeValidatorTrait_convertStringToUShort (const char * WXUNUSED(DefaultScanfString),
                                                             const wxString & TrimmedInputString,
                                                             unsigned short & Ushort);
extern bool wxBasictypeValidatorTrait_convertStringToInt (const char * WXUNUSED(DefaultScanfString),
                                                          const wxString & TrimmedInputString,
                                                          int & Int);
extern bool wxBasictypeValidatorTrait_convertStringToUInt (const char * WXUNUSED(DefaultScanfString),
                                                           const wxString & TrimmedInputString,
                                                           unsigned int & Uint);

//-------------------------------------------------------------------------

class wxComboBox;

extern void updateComboBoxSelectionFromText (wxComboBox * ComboBox, 
                                             const wxString & TextCtrlString, bool IsForce);

//-------------------------------------------------------------------------

// set focus to specified Window and activate (set selection to) book-pages 
// of any parents which are of type wxBookCtrl (wxNotebook for wx < 2.5.0)
extern void setFocusAndSelectParentBookPages (wxWindow * Window);

//-------------------------------------------------------------------------

// helper functions 
// since TransferDataToWindow() and TransferFromWindow() only validate
// child windows of specified window
extern void transferDataToControl (wxWindow * Window);
extern bool validateControl (wxWindow * Window);
extern bool transferDataFromControl (wxWindow * Window);

//=========================================================================

/*  pick up macro definitions from implementation file:
    available macro definitions:

    IMPLEMENT_CLASS_wxBasictypeValidatorTrait(TClassname,TBasictype,DefaultFormatString,
                                              DefaultScanfString,PrintCommand,ParseCommand)

    IMPLEMENT_CLASS_wxTraitedTextCtrlStatusValidatorImpl(TClassname,TBasictypeValidatorTrait,TBasictype)

    // to "instatiate" the macros without compilation problems, inclusion of 
    // following headers may be required (see included headers in .cpp files)
       //
       // For compilers that support precompilation, includes "wx.h".
       // #include "wx/wxprec.h"
       // 
       // #ifdef __BORLANDC__
       //   #pragma hdrstop
       // #endif
       // 
       // #ifndef WX_PRECOMP
       //   // WARN removed stdio.h - it should not be required (or may be it is required?)
       //   // maybe it doesn't hurt
       //   #include <stdio.h>
       //   #include "wx/textctrl.h"
       //   #include "wx/utils.h"
       //   #include "wx/msgdlg.h"
       //   #include "wx/intl.h"
       // #endif 

*/
//#ifndef _TEMPLATEINCLUDE_StatusValidators_cpp
//#   define _TEMPLATEINCLUDE_StatusValidators_cpp
//#   include "StatusValidators.cpp"
//#   undef _TEMPLATEINCLUDE_StatusValidators_cpp
//#endif

//-------------------------------------------------------------------------

#define M_IsUndefExportMagic 1
#    include "WxExtLibAliases.h"
#undef M_IsUndefExportMagic

//=========================================================================

#endif // _INCLUDED_StringValidator_h

//=========================================================================

#else // !defined M_StatusValidators_IsEmitGenericDeclarations

//=========================================================================

#define M_IsDefinePPMacros 1
#   include "pp_basics.h" 
// #undef M_IsDefinePPMacros

//-------------------------------------------------------------------------

#if (defined M_BasictypeValidatorTrait)

// define a few shortcuts
    #define M_Basictype M_BasictypeValidatorTrait_Basictype

//-------------------------------------------------------------------------

// M_BasictypeValidatorTrait
// - trait class for use with wxTraitedTextCtrlStatusValidator 
//   and related classes
// possible improvements:
// - add change-indication flags (for Touched, Modified) (or alternatively,
//   add function getIsModified() which compares against m_CopyBasictype
//   or *m_BasictypeValuePtr)
//   - however, Touched state can be obtained quite easy too by overriding
//     handleWatchedControlChange() and using wxWindowAdder::setIsWatchControl()
class M_BasictypeValidatorTrait_ExportDecl M_BasictypeValidatorTrait : public wxTextCtrlStatusValidatorTrait
{
    /* DECLARE_ABSTRACT_CLASS(M_BasictypeValidatorTrait) */
public:
    enum
    {
      IsEmptyAllowed = 0x01,
      /* IsFilterInputChars = 0x02 // currently unused */
      IsWritebackToCopy = 0x04,
      IsReadFromCopy = 0x08,
      IsIgnoreMinimum = 0x10,
      IsIgnoreMaximum = 0x20,
      IsNoTrimLeft = 0x40,
      IsNoTrimRight = 0x80,
        IsNoTrim = 0xc0  /* == IsNoTrimLeft | IsNoTrimRight */
    };

    M_BasictypeValidatorTrait ();
    M_BasictypeValidatorTrait (M_Basictype * BasictypeValuePtr, M_Basictype MinBasictype, M_Basictype MaxBasictype,
                               const wxString & FieldNameString,
                               int Flags, M_Basictype UndefinedBasictype,
                               const wxString & FormatString = wxEmptyString);
    /* the constructor taking a reference to current value (instead of pointer to non-const)
       has automatically the IsWritebackToCopy and IsReadFromCopy flags set. Some care must be
       taken to call the desired constructor */
    M_BasictypeValidatorTrait (const M_Basictype & BasictypeValueRef, M_Basictype MinBasictype, M_Basictype MaxBasictype,
                               const wxString & FieldNameString,
                               int Flags, M_Basictype UndefinedBasictype,
                               const wxString & FormatString = wxEmptyString);
    virtual ~M_BasictypeValidatorTrait() { };

    void init (M_Basictype * BasictypeValuePtr, M_Basictype MinBasictype, M_Basictype MaxBasictype,
               const wxString & FieldNameString,
               int Flags, M_Basictype UndefinedBasictype,
               const wxString & FormatString = wxEmptyString);
    /* see notes about pointer vs. reference 1st argument at constructor */
    void init (const M_Basictype & BasictypeValueRef, M_Basictype MinBasictype, M_Basictype MaxBasictype,
               const wxString & FieldNameString,
               int Flags, M_Basictype UndefinedBasictype,
               const wxString & FormatString = wxEmptyString);

    virtual void convertToString (wxString & TextCtrlContentString);
    virtual bool convertFromStringTemporary (const wxString & TextCtrlContentString,
                                             wxString & ErrorMessageString,
                                             bool IsTextCtrlChangeEvent);
    virtual bool convertFromStringPersistent (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString);

    virtual bool convertFromStringHelper (const wxString & TextCtrlContentString,
                                          M_Basictype * BasictypePtr,
                                          wxString & ErrorMessageString);

    M_Basictype getCopyValue ();

    virtual bool getIsUndefinedValue (const M_Basictype & Basictype);
    virtual bool checkValueRange (const M_Basictype & Basictype);
    virtual void getErrorMessageString (wxString & ErrorMessageString);

    virtual void convertBasictypeToString (const M_Basictype & Basictype,
                                           wxString & String);
    virtual bool convertStringToBasictype (const wxString & String,
                                           M_Basictype & Basictype);

/* protected: */
    M_Basictype * m_BasictypeValuePtr;
    M_Basictype m_CopyBasictype;
    M_Basictype m_MinBasictype;
    M_Basictype m_MaxBasictype;
    M_Basictype m_UndefinedBasictype;
    M_Basictype m_LastValidationBasicType;

    int m_Flags;
    wxString m_FieldNameString;
    wxString m_FormatString;
};

//-------------------------------------------------------------------------

// undefine shortcuts
    #undef M_Basictype
    #undef M_BasictypeValidatorTrait

#endif // defined M_BasictypeValidatorTrait

//=========================================================================

#if (defined M_TraitedTextCtrlStatusValidatorImpl_Basictype)

// define a few shortcuts
#define M_Basictype M_TraitedTextCtrlStatusValidatorImpl_Basictype
#define M_BasictypeValidatorTrait M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait

//-------------------------------------------------------------------------

// TEST: to get macro stringize, concat work as expected:
//   #define DECLARE_DYNAMIC_CLASS_HELPER(X) DECLARE_DYNAMIC_CLASS(X)
// alternative: 
//   use M_PP_eval1()

// wxTraitedTextCtrlStatusValidatorImpl
// - generic version for easy employment of user-defined wxTextCtrlStatusValidatorTrait
//   classes
class M_TraitedTextCtrlStatusValidatorImpl_ExportDecl M_TraitedTextCtrlStatusValidatorImpl: public wxTraitedTextCtrlStatusValidator
{
    // DECLARE_DYNAMIC_CLASS_HELPER(M_TraitedTextCtrlStatusValidatorImpl)
    M_PP_eval1 (DECLARE_DYNAMIC_CLASS, M_TraitedTextCtrlStatusValidatorImpl)
public:
    /* HACK repeat those flag values from wxTextCtrlStatusValidatorTrait classes */
    /* for ease of use */
    enum
    {
      IsEmptyAllowed = 0x01,
      /* IsFilterInputChars = 0x02 // currently unused */
      IsWritebackToCopy = 0x04,
      IsReadFromCopy = 0x08,
      IsIgnoreMinimum = 0x10,
      IsIgnoreMaximum = 0x20,
      IsNoTrimLeft = 0x40,
      IsNoTrimRight = 0x80,
        IsNoTrim = 0xc0  /* == IsNoTrimLeft | IsNoTrimRight */
    };

    M_TraitedTextCtrlStatusValidatorImpl();
    M_TraitedTextCtrlStatusValidatorImpl(M_Basictype * BasictypeValue, 
                                         M_Basictype MinBasictype, M_Basictype MaxBasictype,
                                         wxStatusMessageTarget * StatusMessageTarget,
                                         const wxString & FieldNameString,
                                         int Flags, M_Basictype UndefinedBasictype,
                                         const wxString & FormatString = wxEmptyString);
    M_TraitedTextCtrlStatusValidatorImpl(const M_TraitedTextCtrlStatusValidatorImpl
                                         & TraitedTextCtrlStatusValidatorImpl);

    ~M_TraitedTextCtrlStatusValidatorImpl();

    virtual wxObject *Clone() const { return new M_TraitedTextCtrlStatusValidatorImpl(*this); }
    bool Copy(const M_TraitedTextCtrlStatusValidatorImpl & TraitedTextCtrlStatusValidatorImpl);

DECLARE_EVENT_TABLE()

protected:
    M_BasictypeValidatorTrait m_BasictypeValidatorTrait;
};

//#undef DECLARE_DYNAMIC_CLASS_HELPER

//-------------------------------------------------------------------------

// undefine shortcuts
#undef M_Basictype
#undef M_BasictypeValidatorTrait

#endif // defined M_TraitedTextCtrlStatusValidatorImpl

//=========================================================================

// #define M_IsUndefPPMacros 1
// #   include "pp_basics.h" 
// #undef M_IsUndefPPMacros

//-------------------------------------------------------------------------

#endif // else defined M_StatusValidators_IsEmitGenericDeclarations

//=========================================================================
