
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2003-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice

-------------------------------------------------------------------------
*/

//=========================================================================

#ifndef M_StatusValidators_IsEmitGenericImplementation

//=========================================================================

#ifndef _NO_HEADER_INCLUDE

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
#   pragma implementation "StatusValidators.h"
#endif

#include "WxExtLibConfig.h"

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
  #pragma hdrstop
#endif

#ifndef WX_PRECOMP
  // WARN removed stdio.h - it should not be required (or may be it is required?)
  // maybe it doesn't hurt
  // #include <stdio.h>
  #include <wx/textctrl.h>
  #include <wx/combobox.h>
  #include <wx/utils.h>
  #include <wx/msgdlg.h>
  #include <wx/intl.h>
#endif

// for setFocusAndSelectParentBookPages()
#include <wx/notebook.h>
#include <wx/listbook.h>
// note: for newer versions, wx/bookctrl.h would be sufficient
// for setFocusAndSelectParentBookPages() implementation
//   #include <wx/bookctrl.h>

#include "wx/msw/private.h"

#include "StatusValidators.h"

// #include <ctype.h>
// #include <string.h>
// #include <stdlib.h>

// #ifdef __SALFORDC__
//    #include <clib.h>
// #endif

#include "MessageExtDialog.h"

#include "WxMisc.h"
#include "safecast.h"

#endif // _NO_HEADER_INCLUDE

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxStatusMessageTarget, wxObject)

//-------------------------------------------------------------------------

wxStatusMessageTarget::wxStatusMessageTarget()
{
    m_ErrorMessageMultiLineText = NULL;
    m_IsShowMessageBoxEnabled = true;
}

wxStatusMessageTarget::wxStatusMessageTarget(wxMultiLineText * ErrorMessageMultiLineText,
                                             const wxString & NonErrorMessageString)
{
    m_ErrorMessageMultiLineText = ErrorMessageMultiLineText;
    m_NonErrorMessageString = NonErrorMessageString;
}

wxStatusMessageTarget::wxStatusMessageTarget(const wxStatusMessageTarget& StatusMessageTarget)
    : wxObject()
{
    Copy(StatusMessageTarget);
}

bool wxStatusMessageTarget::Copy(const wxStatusMessageTarget& StatusMessageTarget)
{
    // wxObject::Copy(StatusMessageTarget);

    m_ErrorMessageMultiLineText = StatusMessageTarget.m_ErrorMessageMultiLineText;
    m_NonErrorMessageString = StatusMessageTarget.m_NonErrorMessageString;

    return true;
}

wxStatusMessageTarget::~wxStatusMessageTarget()
{
}

//-------------------------------------------------------------------------

void wxStatusMessageTarget::setMessage (const wxString & MessageString, bool IsError)
{
    m_MessageString = MessageString;
    m_IsError = IsError;
}

void wxStatusMessageTarget::display (wxWindow * WXUNUSED(ParentWindow))
{
    if (m_ErrorMessageMultiLineText != NULL)
      {
        if (! m_NonErrorMessageString.IsEmpty() && ! m_IsError)
          {
            m_ErrorMessageMultiLineText -> getWindow() -> SetForegroundColour (wxColour (128, 0, 64));
            m_ErrorMessageMultiLineText -> setText (m_NonErrorMessageString);
          }
        else
          {
            m_ErrorMessageMultiLineText -> getWindow() -> SetForegroundColour (wxColour (64, 0, 128));
            m_ErrorMessageMultiLineText -> setText (m_MessageString);
          }
      }

//  if (m_IsError && m_IsShowMessageBoxEnabled)
//    {
//      wxMessageBox(m_MessageString, _("Input error"),
//                   wxOK | wxICON_EXCLAMATION, ParentWindow);
//    }
}

void wxStatusMessageTarget::clear ()
{
    if (m_ErrorMessageMultiLineText != NULL)
      {
        m_ErrorMessageMultiLineText -> getWindow() -> SetForegroundColour (*wxBLACK);
        m_ErrorMessageMultiLineText -> setText ("");
      }
}

void wxStatusMessageTarget::enableShowMessageBox (bool IsShowMessageBoxEnabled)
{
    m_IsShowMessageBoxEnabled = IsShowMessageBoxEnabled;
}

bool wxStatusMessageTarget::isShowMessageBoxEnabled ()
{
    return m_IsShowMessageBoxEnabled;
}

//-------------------------------------------------------------------------

void wxStatusMessageTarget::setStatusOutput (wxMultiLineText * ErrorMessageMultiLineText)
{
    m_ErrorMessageMultiLineText = ErrorMessageMultiLineText;
}

void wxStatusMessageTarget::setNonErrorMessageString (const wxString & NonErrorMessageString)
{
    m_NonErrorMessageString = NonErrorMessageString;
}

//=========================================================================

IMPLEMENT_CLASS(wxROGenericValidator, wxGenericValidator)

//-------------------------------------------------------------------------

wxROGenericValidator::wxROGenericValidator(bool* val)
  : wxGenericValidator (val)
{
}

wxROGenericValidator::wxROGenericValidator(int* val)
  : wxGenericValidator (val)
{
}

wxROGenericValidator::wxROGenericValidator(wxString* val)
  : wxGenericValidator (val)
{
}

wxROGenericValidator::wxROGenericValidator(wxArrayInt* val)
  : wxGenericValidator (val)
{
}

//=========================================================================

IMPLEMENT_ABSTRACT_CLASS(wxTextCtrlStatusValidator, wxValidator)

BEGIN_EVENT_TABLE(wxTextCtrlStatusValidator, wxValidator)
    EVT_CHAR(wxTextCtrlStatusValidator::OnChar)
    EVT_TEXT(wxID_ANY, wxTextCtrlStatusValidator::OnTextChanged)
    EVT_COMBOBOX(wxID_ANY, wxTextCtrlStatusValidator::OnComboBoxSelected) 
    EVT_CHOICE(wxID_ANY, wxTextCtrlStatusValidator::OnChoiceSelected) 
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxTextCtrlStatusValidator::wxTextCtrlStatusValidator()
{
    m_StatusMessageTarget = NULL;
    m_Flags = 0;
    m_IsInsideOnTextChanged = false;
}

wxTextCtrlStatusValidator::wxTextCtrlStatusValidator(wxStatusMessageTarget * StatusMessageTarget,
                                     int Flags)
{
    m_StatusMessageTarget = StatusMessageTarget;
    m_Flags = Flags;
    m_IsInsideOnTextChanged = false;
}

wxTextCtrlStatusValidator::wxTextCtrlStatusValidator(const wxTextCtrlStatusValidator& TextCtrlStatusValidator)
    : wxValidator()
{
    Copy(TextCtrlStatusValidator);
}

bool wxTextCtrlStatusValidator::Copy(const wxTextCtrlStatusValidator& TextCtrlStatusValidator)
{
    wxValidator::Copy(TextCtrlStatusValidator);

    m_StatusMessageTarget = TextCtrlStatusValidator.m_StatusMessageTarget;
    m_Flags = TextCtrlStatusValidator.m_Flags;
    // WARN copy state of m_IsInsideOnTextChanged okay?
    m_IsInsideOnTextChanged = TextCtrlStatusValidator.m_IsInsideOnTextChanged;

    return true;
}

wxTextCtrlStatusValidator::~wxTextCtrlStatusValidator()
{
}

//-------------------------------------------------------------------------

bool wxTextCtrlStatusValidator::TransferToWindow(void)
{
    if( !checkValidator() )
        return false;

    wxString TextCtrlContentString;
    transferToWindow(TextCtrlContentString);
    setTextCtrlContent (TextCtrlContentString);

    return true;
}

//-------------------------------------------------------------------------

void wxTextCtrlStatusValidator::getTextCtrlContent (wxString & TextCtrlContentString)
{
    // wxControlWithItems * ControlWithItems = NULL;

    wxTextCtrl* TextCtrl = wxDynamicCast (m_validatorWindow, wxTextCtrl);
    if (TextCtrl != NULL)
      {
        TextCtrlContentString = TextCtrl -> GetValue ();
        return; 
      }
    wxChoice * ChoiceCtrl = wxDynamicCast (m_validatorWindow, wxChoice);
    if (ChoiceCtrl != NULL)
      {
        TextCtrlContentString = ChoiceCtrl -> GetStringSelection ();
        return;
      }
    wxListBox * ListBox = wxDynamicCast (m_validatorWindow, wxListBox);
    if (ListBox != NULL)
      {
        TextCtrlContentString = ListBox -> GetStringSelection ();
        return;
      }
    wxComboBox * ComboBox = wxDynamicCast (m_validatorWindow, wxComboBox);
    if (ComboBox != NULL)
      {
        TextCtrlContentString = ComboBox -> GetValue ();
        return;
      }

    wxASSERT_MSG (false, "wxTextCtrlStatusValidator::getTextCtrlContent(): unsupported control type");
}

void wxTextCtrlStatusValidator::setTextCtrlContent (const wxString & TextCtrlContentString)
{
    wxTextCtrl* TextCtrl = wxDynamicCast (m_validatorWindow, wxTextCtrl);
    if (TextCtrl != NULL)
      {
        TextCtrl -> SetValue (TextCtrlContentString);
        return;
      }
    wxChoice * ChoiceCtrl = wxDynamicCast (m_validatorWindow, wxChoice);
    if (ChoiceCtrl != NULL)
      {
        if (TextCtrlContentString == "")
          {
            // HACK
            // calling e.g. SetStringSelection ("") gives assertion failure
            // if empty string is not element of string array
            //
            // WARN this hack means that empty string cannot be used for
            // normal entries anymore
            // - more correct solution would be to ask trait if 
            //   TextCtrlContentString == m_UndefinedBasictype
            ChoiceCtrl -> SetSelection (-1);
          }
        else
          {
            ChoiceCtrl -> SetStringSelection (TextCtrlContentString);
          }
        return;
      }
    wxListBox * ListBox = wxDynamicCast (m_validatorWindow, wxListBox);
    if (ListBox != NULL)
      {
        if (TextCtrlContentString == "")
          {
            // HACK
            // calling e.g. SetStringSelection ("") gives assertion failure
            // if empty string is not element of string array
            //
            // WARN this hack means that empty string cannot be used for
            // normal entries anymore
            // - more correct solution would be to ask trait if 
            //   TextCtrlContentString == m_UndefinedBasictype
            ListBox -> SetSelection (-1);
          }
        else
          {
            ListBox -> SetStringSelection (TextCtrlContentString);
          }
        return;
      }
    wxComboBox * ComboBox = wxDynamicCast (m_validatorWindow, wxComboBox);
    if (ComboBox != NULL)
      {
        // WARN need use above hacks for SetStringSelection() with empty string?
        //
        // TEST
        if (0)
          {
            ComboBox -> SetValue (TextCtrlContentString);
            // updateComboBoxSelectionFromText (ComboBox, TextCtrlContentString, true);
          }
        else
          {
            int FoundIndex = ComboBox -> FindString (TextCtrlContentString);
            if (FoundIndex != -1)
              {
                // ComboBox -> SetStringSelection (TextCtrlContentString);
                // ::SendMessage(GetHwnd(), CB_SETCURSEL, n, 0);
                ComboBox -> SetValue (TextCtrlContentString);
              }
            else
              {
                // ComboBox -> Select (-1);
                // ComboBox -> SetSelection (-1);

                // wxComboBox also has                 
                //   void SetSelection(long from, long to)
                // but this has a complete different meaning:
                //   Selects the text between the two positions, in the combobox text field.

#ifdef __WXMSW__
                // deal with following bug (scope: wx version 2.5.3, wxMSW)
                // - wxComboBox: setting values causes some other value with this
                //   prefix to be selected from the list (scope: wxMSW)
                // - note: SetValue() seems to work as expected with wxGTK

                //-- trying to write text directly to control with MSW API
                // (this seems to have the same effect of selecting some
                // other entry with same prefix):
                //   WXHWND WindowHandle = ComboBox -> GetHWND();
                //   HWND WindowHandle = ComboBox -> GetHwnd(); // doesn't work, anyhow
                //   ::SetWindowText ((struct HWND__ *) WindowHandle, 
                //                     wxString (" ") + TextCtrlContentString.c_str());

                //-- workaround:
                // - 1) could add empty space for text shown to avoid having same
                //   prefix:
                //     wxString ModifiedTextCtrlContentString = " ";
                //     ModifiedTextCtrlContentString << TextCtrlContentString;
                //     ComboBox -> SetValue (ModifiedTextCtrlContentString);
                // - 2) could add empty space to all list elements
                ComboBox -> SetValue (TextCtrlContentString);

                // - notes: 
                //   - both methods probably require left-trimming of white space
                //     to be enabled for the wxTextCtrlStatusValidator
                //   - method 2 (currently used) causes automatic selection of matching
                //     list entry to faild (not critical)
#else
                ComboBox -> SetValue (TextCtrlContentString);
#endif
              }
            // updateComboBoxSelectionFromText (ComboBox, TextCtrlContentString, true);
          }

        return;
      }

    wxASSERT_MSG (false, "wxTextCtrlStatusValidator::setTextCtrlContent(): unsupported control type");
}

//-------------------------------------------------------------------------

bool wxTextCtrlStatusValidator::Validate(wxWindow * ParentWindow)
{
    if (!checkValidator())
        return false;

    // return if the window is disabled
    if (!m_validatorWindow -> IsEnabled())
      return true;

    wxString TextCtrlContentString;
    getTextCtrlContent (TextCtrlContentString);
    wxString ErrorMessageString;
    bool IsOk = transferFromWindowTemporary (TextCtrlContentString,
                                             ErrorMessageString);

    if (IsOk)
      {
        showStatusMessage ("", false, ParentWindow);
      }
    else
      {
        showStatusMessage (ErrorMessageString, true, ParentWindow);

        if (m_StatusMessageTarget != NULL
            && m_StatusMessageTarget -> isShowMessageBoxEnabled())
          {
            // Because of intended handleWatchedControlChange()
            // implementations which would call Validate() for any control
            // change (e.g. any time a character is typed in a wxTextCtrl by
            // the user), we set the focus to the wxTextCtrl with an input error
            // only if the message box is enabled for the StatusMessageTarget.
            setFocusAndSelectParentBookPages (GetWindow());

//          wxMessageBox(ErrorMessageString, _("Input error"),
//                       wxOK | wxICON_EXCLAMATION, ParentWindow);

            wxMessageExtDialog MessageExtDialog (ParentWindow, 
                                              ErrorMessageString,
                                              _("Input error"));
            MessageExtDialog.addButton (_("Cancel"), wxID_CANCEL);
            MessageExtDialog.makeLastAddedButtonDefault ();
            MessageExtDialog.ShowModal ();
          }
      }

    return IsOk;
}

bool wxTextCtrlStatusValidator::TransferFromWindow(void)
{
    if (!checkValidator())
        return false;

    // return if window is disabled
    if (!m_validatorWindow -> IsEnabled())
      return true;

    // theoretically, the string in the wxTextCtrl should be valid here
    // because Validate() would have been called before successfully
    wxString TextCtrlContentString;
    getTextCtrlContent (TextCtrlContentString);
    wxString ErrorMessageString;
    bool IsOk = transferFromWindowPersistent (TextCtrlContentString,
                                              ErrorMessageString);

    return IsOk;
}

//-------------------------------------------------------------------------

void wxTextCtrlStatusValidator::OnChar(wxKeyEvent& Event)
{
    if (m_validatorWindow 
        && (m_Flags & IsFilterInputChars))
      {
        // here, filtering of keyboard events could be realized
      }

    Event.Skip();
}

// Note that OnTextChanged() will always be sent when the text controls contents
// changes (scope: wxMSW, wxGTK) - whether this is due to user input or comes 
// from the program itself (for example, if SetValue() is called).
void wxTextCtrlStatusValidator::OnTextChanged(wxCommandEvent& Event)
{
    if (m_IsInsideOnTextChanged)
      return;
    wxScopedSetToTrue ScopedSetToTrue (m_IsInsideOnTextChanged);

    if (m_validatorWindow)
      {
        wxComboBox * ComboBox = wxDynamicCast (m_validatorWindow, wxComboBox);
        if (ComboBox != NULL)
          {
            wxString TextCtrlContentString = ComboBox -> GetValue();
            updateComboBoxSelectionFromText (ComboBox, TextCtrlContentString, false);
          }

        // check if string that is now in the TextCtrl is valid; if
        // not, display the error message in the status control (if available)
        wxString TextCtrlContentString;
        getTextCtrlContent (TextCtrlContentString);
        wxString ErrorMessageString;
        if (transferFromWindowTemporary (TextCtrlContentString,
                                         ErrorMessageString, true))
          {
            showStatusMessage ("", false, NULL);
            // handleValidInput (TempLong);
          }
        else
          {
            showStatusMessage (ErrorMessageString, true, NULL);
          }
      }

    // skip is required here to get other handlers (e.g. watchControlChange...())
    // called
    Event.Skip ();
}

// HACK for wxMSW wxComboBox: 
// it doesn't seem to call SetValue() if an item is selected from
// the list, and GetValue() returns the old value, not the selected
// one
// NOTE: however, even the wxEVT_COMMAND_COMBOBOX_SELECTED
// event seems to be lost sometimes
void wxTextCtrlStatusValidator::OnComboBoxSelected(wxCommandEvent& Event)
{
    wxComboBox * ComboBox = wxDynamicCast (m_validatorWindow, wxComboBox);
    if (ComboBox != NULL)
      {
      }

    Event.Skip ();
}

//-------------------------------------------------------------------------

void wxTextCtrlStatusValidator::OnChoiceSelected(wxCommandEvent& Event)
{
    wxChoice * ChoiceCtrl = wxDynamicCast (m_validatorWindow, wxChoice);
    if (ChoiceCtrl != NULL)
      {
      }

    Event.Skip ();
}

//-------------------------------------------------------------------------

void wxTextCtrlStatusValidator::showStatusMessage (const wxString & MessageString, 
                                                   bool IsError,
                                                   wxWindow * ParentWindow)
{
    // use m_StatusMessageTarget for output of error message if available,
    // otherwise don't display error message immediatly (it will be shown in
    // a message box later when Validate() is called by the dialog)

    if (m_StatusMessageTarget != NULL)
      {
        m_StatusMessageTarget -> setMessage (MessageString, IsError);
        m_StatusMessageTarget -> display (ParentWindow);
      }
}

//-------------------------------------------------------------------------

bool wxTextCtrlStatusValidator::checkValidator() const
{
    wxCHECK_MSG (m_validatorWindow, false,
                 _T("No window associated with validator"));
    wxCHECK_MSG (m_validatorWindow -> IsKindOf (CLASSINFO (wxTextCtrl))
                 || m_validatorWindow -> IsKindOf (CLASSINFO (wxChoice))
                 || m_validatorWindow -> IsKindOf (CLASSINFO (wxListBox))
                 || m_validatorWindow -> IsKindOf (CLASSINFO (wxComboBox)), false,
                 _T("Associated control must be of type wxTextCtrl, wxChoiceCtrl, wxListBox or wxComboxBox"));
    
    return true;
}

//=========================================================================

IMPLEMENT_ABSTRACT_CLASS(wxTraitedTextCtrlStatusValidator, wxTextCtrlStatusValidator)

BEGIN_EVENT_TABLE(wxTraitedTextCtrlStatusValidator, wxTextCtrlStatusValidator)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxTraitedTextCtrlStatusValidator::wxTraitedTextCtrlStatusValidator()
{
    m_TextCtrlStatusValidatorTrait = NULL;
}

wxTraitedTextCtrlStatusValidator::wxTraitedTextCtrlStatusValidator(wxTextCtrlStatusValidatorTrait * TextCtrlStatusValidatorTrait,
                                                                   wxStatusMessageTarget * StatusMessageTarget,
                                                                   int Flags)
    : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_TextCtrlStatusValidatorTrait = TextCtrlStatusValidatorTrait;
}

wxTraitedTextCtrlStatusValidator::wxTraitedTextCtrlStatusValidator(const wxTraitedTextCtrlStatusValidator& TraitedTextCtrlStatusValidator)
    : wxTextCtrlStatusValidator()
{
    Copy(TraitedTextCtrlStatusValidator);
}

bool wxTraitedTextCtrlStatusValidator::Copy(const wxTraitedTextCtrlStatusValidator& TraitedTextCtrlStatusValidator)
{
    wxTextCtrlStatusValidator::Copy(TraitedTextCtrlStatusValidator);

    m_TextCtrlStatusValidatorTrait = TraitedTextCtrlStatusValidator.m_TextCtrlStatusValidatorTrait;

    return true;
}

wxTraitedTextCtrlStatusValidator::~wxTraitedTextCtrlStatusValidator()
{
    m_TextCtrlStatusValidatorTrait = NULL;
}

//-------------------------------------------------------------------------

void wxTraitedTextCtrlStatusValidator::transferToWindow (wxString & TextCtrlContentString)
{
    if (!checkValidator())
        return;

    m_TextCtrlStatusValidatorTrait -> convertToString (TextCtrlContentString);
}

//-------------------------------------------------------------------------

bool wxTraitedTextCtrlStatusValidator::transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                                                    wxString & ErrorMessageString,
                                                                    bool IsTextCtrlChangeEvent)
{
    if (!checkValidator())
      {
        ErrorMessageString = "[internal error: wxTraitedTextCtrlStatusValidator object not correctly initialized]";
        return false;
      }

    bool IsOk = false;
    IsOk = m_TextCtrlStatusValidatorTrait -> convertFromStringTemporary (TextCtrlContentString,
                                                                         ErrorMessageString,
                                                                         IsTextCtrlChangeEvent);
    if (IsOk && IsTextCtrlChangeEvent)
      handleValidInput ();

    return IsOk;
}

bool wxTraitedTextCtrlStatusValidator::transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                                                     wxString & ErrorMessageString)
{
    if (!checkValidator())
      {
        ErrorMessageString = "[internal error: wxTraitedTextCtrlStatusValidator object not correctly initialized]";
        return false;
      }

    bool IsOk = false;
    IsOk = m_TextCtrlStatusValidatorTrait -> convertFromStringPersistent (TextCtrlContentString,
                                                                          ErrorMessageString);
    return IsOk;
}

//-------------------------------------------------------------------------

void wxTraitedTextCtrlStatusValidator::handleValidInput ()
{
}

bool wxTraitedTextCtrlStatusValidator::checkValidator () const
{
    return m_TextCtrlStatusValidatorTrait != NULL;
}

//=========================================================================
// conversions basic-type to string


void wxBasictypeValidatorTrait_convertULongToString (const char * WXUNUSED(FormatString),
                                                     unsigned long ULong,
                                                     wxString & String)
{
    String = wxString::Format ("%lu", ULong);
}

void wxBasictypeValidatorTrait_convertLongToString (const char * WXUNUSED(FormatString),
                                                    long Long,
                                                    wxString & String)
{
    String = wxString::Format ("%ld", Long);
}

void wxBasictypeValidatorTrait_convertDoubleToString (const char * FormatString,
                                                      double Double,
                                                      wxString & String)
{
    String = wxString::Format (FormatString, Double);
}

//=========================================================================
// conversions string to basic-type
                                  
bool wxBasictypeValidatorTrait_convertStringToLong (const char * WXUNUSED(DefaultScanfString),
                                                    const wxString & TrimmedString,
                                                    long & Long)
{
    return convertStringToLong (TrimmedString, Long);
}

bool wxBasictypeValidatorTrait_convertStringToULong (const char * WXUNUSED(DefaultScanfString),
                                                     const wxString & TrimmedString,
                                                     unsigned long & ULong)
{
    return convertStringToLong (TrimmedString, ULong);
}

//-------------------------------------------------------------------------

bool wxBasictypeValidatorTrait_convertStringToString (const char * WXUNUSED(DefaultScanfString),
                                                      const wxString & TrimmedInputString,
                                                      wxString & OutputString)
{
    OutputString = TrimmedInputString;
    return true;
}


//=========================================================================

#define IMPLEMENT_FUNCTION_convertStringToBasictype(Functionname,TBasictype,ScanfFormatString) \
 \
bool Functionname (const char * WXUNUSED(DefaultScanfString), \
                   const wxString & TrimmedString, \
                   TBasictype & Basictype) \
{ \
    char DummyChar; \
    wxString CheckingFormatString (ScanfFormatString); \
    CheckingFormatString += "%c"; \
    int ReadArgumentCount = wxSscanf (TrimmedString, CheckingFormatString, \
                                      & Basictype, \
                                      & DummyChar); \
    return ReadArgumentCount == 1; \
} \

//-------------------------------------------------------------------------

#define IMPLEMENT_FUNCTION_convertStringToInttype(Functionname,TInttype,TLongType,MinInttype,MaxInttype) \
 \
  bool Functionname (const char * WXUNUSED(DefaultScanfString), \
                     const wxString & String, \
                     TInttype & Inttype) \
{ \
    TLongType Long = 0; /* TLongType should be 'long' */ \
    bool IsOk = convertStringToLong (String, Long); \
    if ((Long < (TLongType) (MinInttype)) \
        || (Long > (TLongType) (MaxInttype))) \
      { \
        IsOk = false; \
      } \
    if (IsOk) \
       Inttype = (TInttype) Long; \
 \
    return IsOk; \
} \

// unsigned-int-type version of function above to avoid GCC warnings like:
//   ./src/StatusValidators.cpp: In function `bool
//   wxBasictypeValidatorTrait_convertStringToUShort(const char*, const
//   wxString&, short unsigned int&)':
//   ./src/StatusValidators.cpp:722: warning: comparison of unsigned expression
//   < 0 is always false
#define IMPLEMENT_FUNCTION_convertStringToUInttype(Functionname,TInttype,TLongType,MinInttype,MaxInttype) \
 \
  bool Functionname (const char * WXUNUSED(DefaultScanfString), \
                     const wxString & String, \
                     TInttype & Inttype) \
{ \
    TLongType Long; /* TLongType should be 'unsigned long' */ \
    bool IsOk = convertStringToLong (String, Long); \
    if (Long > (TLongType) (MaxInttype)) \
      { \
        IsOk = false; \
      } \
    if (IsOk) \
       Inttype = (TInttype) Long; \
 \
    return IsOk; \
} \

//-------------------------------------------------------------------------

IMPLEMENT_FUNCTION_convertStringToBasictype(wxBasictypeValidatorTrait_convertStringToFloat,
                                            float, "%f")
IMPLEMENT_FUNCTION_convertStringToBasictype(wxBasictypeValidatorTrait_convertStringToDouble,
                                            double, "%lf")

IMPLEMENT_FUNCTION_convertStringToInttype(wxBasictypeValidatorTrait_convertStringToWxInt16, 
                                          wxInt16, long, -32768, 32767)
IMPLEMENT_FUNCTION_convertStringToUInttype(wxBasictypeValidatorTrait_convertStringToWxUint16, 
                                           wxUint16, unsigned long, 0, USHRT_MAX)
IMPLEMENT_FUNCTION_convertStringToInttype(wxBasictypeValidatorTrait_convertStringToWxInt32, 
                                          wxInt32, long, -2147483647L - 1L, 2147483647)
IMPLEMENT_FUNCTION_convertStringToUInttype(wxBasictypeValidatorTrait_convertStringToWxUint32, 
                                           wxUint32, unsigned long, 0, ULONG_MAX)
IMPLEMENT_FUNCTION_convertStringToInttype(wxBasictypeValidatorTrait_convertStringToShort, 
                                          short, long, SHRT_MIN, SHRT_MAX)
IMPLEMENT_FUNCTION_convertStringToUInttype(wxBasictypeValidatorTrait_convertStringToUShort, 
                                           unsigned short, unsigned long, 0, SHRT_MAX)
IMPLEMENT_FUNCTION_convertStringToInttype(wxBasictypeValidatorTrait_convertStringToInt, 
                                          int, long, INT_MIN, INT_MAX)
IMPLEMENT_FUNCTION_convertStringToUInttype(wxBasictypeValidatorTrait_convertStringToUInt, 
                                           unsigned int, unsigned long, 0, UINT_MAX)

//=========================================================================

#else // M_StatusValidators_IsEmitGenericImplementation

//=========================================================================

#if (defined M_BasictypeValidatorTrait)

// macros which must be defined
// - M_BasictypeValidatorTrait
// - M_BasictypeValidatorTrait_Basictype
// - M_BasictypeValidatorTrait_DefaultFormatString
// - M_BasictypeValidatorTrait_DefaultScanfString
// - M_BasictypeValidatorTrait_FormatFunction
// - M_BasictypeValidatorTrait_ParseFunction

//-------------------------------------------------------------------------

// define a few shortcuts
    #define M_Basictype M_BasictypeValidatorTrait_Basictype

//-------------------------------------------------------------------------

M_BasictypeValidatorTrait::M_BasictypeValidatorTrait ()
{
    // m_Flags = NotInitialized; 
}

M_BasictypeValidatorTrait::M_BasictypeValidatorTrait (M_Basictype * BasictypeValue,
                                                      M_Basictype MinBasictype,
                                                      M_Basictype MaxBasictype,
                                                      const wxString & FieldNameString,
                                                      int Flags,
                                                      M_Basictype UndefinedBasictype,
                                                      const wxString & FormatString)
{
    init (BasictypeValue, MinBasictype, MaxBasictype,
          FieldNameString, Flags,
          UndefinedBasictype,
          FormatString);
}

M_BasictypeValidatorTrait::M_BasictypeValidatorTrait (const M_Basictype & BasictypeValueRef,
                                                      M_Basictype MinBasictype,
                                                      M_Basictype MaxBasictype,
                                                      const wxString & FieldNameString,
                                                      int Flags,
                                                      M_Basictype UndefinedBasictype,
                                                      const wxString & FormatString)
{
    init (BasictypeValueRef, MinBasictype, MaxBasictype,
          FieldNameString, Flags,
          UndefinedBasictype,
          FormatString);
}

//-------------------------------------------------------------------------

void M_BasictypeValidatorTrait::init (M_Basictype * BasictypeValuePtr,
                                      M_Basictype MinBasictype,
                                      M_Basictype MaxBasictype,
                                      const wxString & FieldNameString,
                                      int Flags, M_Basictype UndefinedBasictype,
                                      const wxString & FormatString)
{
    if (Flags & IsWritebackToCopy)
      {
        m_BasictypeValuePtr = NULL;
        m_CopyBasictype = * BasictypeValuePtr;
      }
    else
      {
        m_BasictypeValuePtr = BasictypeValuePtr;
        m_CopyBasictype = * BasictypeValuePtr;
      }
    m_MinBasictype = MinBasictype;
    m_MaxBasictype = MaxBasictype;
    m_UndefinedBasictype = UndefinedBasictype;

    if (FormatString == wxEmptyString)
      {
        m_FormatString = M_BasictypeValidatorTrait_DefaultFormatString;
      }
    else
      {
        m_FormatString = FormatString;
      }
    m_FieldNameString = FieldNameString;
    m_Flags = Flags;
}

void M_BasictypeValidatorTrait::init (const M_Basictype & BasictypeValueRef,
                                      M_Basictype MinBasictype,
                                      M_Basictype MaxBasictype,
                                      const wxString & FieldNameString,
                                      int Flags, M_Basictype UndefinedBasictype,
                                      const wxString & FormatString)
{
    Flags |= IsWritebackToCopy | IsReadFromCopy;
    m_BasictypeValuePtr = NULL;
    m_CopyBasictype = BasictypeValueRef;

    m_MinBasictype = MinBasictype;
    m_MaxBasictype = MaxBasictype;
    m_UndefinedBasictype = UndefinedBasictype;

    if (FormatString == wxEmptyString)
      {
        m_FormatString = M_BasictypeValidatorTrait_DefaultFormatString;
      }
    else
      {
        m_FormatString = FormatString;
      }
    m_FieldNameString = FieldNameString;
    m_Flags = Flags;
}

//-------------------------------------------------------------------------

void M_BasictypeValidatorTrait::convertToString (wxString & TextCtrlContentString)
{
    M_Basictype * BasictypePtr = (m_Flags & IsReadFromCopy) ? & m_CopyBasictype : m_BasictypeValuePtr;
    if ((m_Flags & IsEmptyAllowed)
        && (getIsUndefinedValue (*BasictypePtr)))
      {
        TextCtrlContentString = "";
      }
    else
      {
        // long Long = *BasictypePtr; 
        // TextCtrlContentString = wxString::Format (m_FormatString, Long); 
        convertBasictypeToString (*BasictypePtr, TextCtrlContentString);
      }
}

//-------------------------------------------------------------------------

bool M_BasictypeValidatorTrait::convertFromStringTemporary (const wxString & TextCtrlContentString,
                                                            wxString & ErrorMessageString,
                                                            bool WXUNUSED(IsTextCtrlChangeEvent))
{
    // M_Basictype TempBasictype = 0; 
    return convertFromStringHelper (TextCtrlContentString, & m_LastValidationBasicType, ErrorMessageString);
}

bool M_BasictypeValidatorTrait::convertFromStringPersistent (const wxString & TextCtrlContentString,
                                                             wxString & ErrorMessageString)
{
    bool IsOkay = convertFromStringHelper (TextCtrlContentString, & m_CopyBasictype, ErrorMessageString);
    if (IsOkay
        && (!(m_Flags & IsWritebackToCopy)))
      {
        // write back to original location only if that's desired 
        *m_BasictypeValuePtr = m_CopyBasictype;
      }
    return IsOkay;
}

//-------------------------------------------------------------------------

bool M_BasictypeValidatorTrait::convertFromStringHelper (const wxString & TextCtrlContentString,
                                                         M_Basictype * BasictypePtr,
                                                         wxString & ErrorMessageString)
{
    wxString TrimmedInputString = TextCtrlContentString;

    if (!(m_Flags & IsNoTrimLeft))
      {
        TrimmedInputString.Trim (false /* IsTrimFromRight */);
      }
    if (!(m_Flags & IsNoTrimRight))
      {
        TrimmedInputString.Trim (true /* IsTrimFromRight */);
      }

    bool IsOk = false;
    if ((m_Flags & IsEmptyAllowed) && TrimmedInputString.IsEmpty())
      {
        *BasictypePtr = m_UndefinedBasictype;
        IsOk = true;
      }
    else
      {
        IsOk = true;
        if ((!(m_Flags & IsEmptyAllowed))
            && TrimmedInputString.IsEmpty())
          {
            // handle case that input (after trimming) is empty, but 
            // empty input is not allowed (needed e.g. for instantiations
            // with type wxString):
            IsOk = false;
          }

        M_Basictype TempBasictype;

        if (IsOk)
          IsOk = convertStringToBasictype (TrimmedInputString, TempBasictype);

        if (IsOk)
          IsOk = checkValueRange (TempBasictype);

        if (IsOk)
          *BasictypePtr = TempBasictype;

        if (!IsOk)
          getErrorMessageString (ErrorMessageString);
      }

    return IsOk;
}

//-------------------------------------------------------------------------

// getErrorMessageString() must be implemented separated 

M_Basictype M_BasictypeValidatorTrait::getCopyValue ()
{
    return m_CopyBasictype;
}

//-------------------------------------------------------------------------

#if (!(M_BasictypeValidatorTrait_IsUseSpecialParseAndFormatFunction == 1))

void M_BasictypeValidatorTrait::convertBasictypeToString (const M_Basictype & Basictype,
                                                          wxString & String)
{
    // String = wxString::Format (m_FormatString, Basictype);
    M_BasictypeValidatorTrait_FormatFunction (m_FormatString, Basictype, String);
}

bool M_BasictypeValidatorTrait::convertStringToBasictype (const wxString & TrimmedString,
                                                          M_Basictype & Basictype)
{
  /*  char DummyChar;
    wxString CheckingFormatString (M_BasictypeValidatorTrait_DefaultScanfString);
    CheckingFormatString += "%c";
    int ReadArgumentCount = wxSscanf (TrimmedString, CheckingFormatString,
                                      & Basictype,
                                      & DummyChar);
                                      return ReadArgumentCount == 1; */
    // convertStringToLong (TrimmedString, Basictype); 
    return M_BasictypeValidatorTrait_ParseFunction (M_BasictypeValidatorTrait_DefaultScanfString, 
                                                    TrimmedString, Basictype);
}

#endif

//-------------------------------------------------------------------------

#if (!(M_BasictypeValidatorTrait_IsSpecialUndefinedCheckFunction == 1))

bool M_BasictypeValidatorTrait::getIsUndefinedValue (const M_Basictype & Basictype)
{
    // this check is okay for builtin-types like int, long, float etc.
    return Basictype == m_UndefinedBasictype;
}

#endif

#if (!(M_BasictypeValidatorTrait_IsNoCheckValueRangeImplementation == 1))
// implementation for checkValueRange() can be disabled so it's easier
// to replace it by a custom function

bool M_BasictypeValidatorTrait::checkValueRange (const M_Basictype & Basictype)
{
    // TODO add support for left and/or right open intervals 
    // (instead of closed) - required for float/double types 
    bool IsOkay = true;
    if ((m_Flags & IsIgnoreMinimum) == 0)
      IsOkay = IsOkay && (Basictype >= m_MinBasictype);
    if ((m_Flags & IsIgnoreMaximum) == 0)
      IsOkay = IsOkay && (Basictype <= m_MaxBasictype);
    return IsOkay;
}

#endif

//-------------------------------------------------------------------------

#if (!(M_BasictypeValidatorTrait_IsNoGetErrorMessageStringImplementation == 1))

// implementation for getErrorMessageString() can be disabled to make it easier
// to replace it by a custom message
// (initially, M_BasictypeValidatorTrait was only used for numeric types, like
// int, long, double, which explains the error message text here)

void M_BasictypeValidatorTrait::getErrorMessageString (wxString & ErrorMessageString)
{
    wxString MinBasictypeString;
    wxString MaxBasictypeString;

    if (!(m_Flags & IsIgnoreMinimum))
      convertBasictypeToString (m_MinBasictype, MinBasictypeString);

    if (!(m_Flags & IsIgnoreMaximum))
      convertBasictypeToString (m_MaxBasictype, MaxBasictypeString);

    const char * FormatMessageString = NULL;
    if ((m_Flags & IsIgnoreMinimum)
        && (m_Flags & IsIgnoreMaximum))
      FormatMessageString = _("ERROR: input must be a number%3 for \"%4\"");
    else if ((m_Flags & IsIgnoreMinimum) == 0
             && (m_Flags & IsIgnoreMaximum))
      FormatMessageString = _("ERROR: input must be a number greater than or equal to %1%3 for \"%4\"");
    else if ((m_Flags & IsIgnoreMinimum) != 0
             && (m_Flags & IsIgnoreMaximum) == 0)
      FormatMessageString = _("ERROR: input must be a number smaller than or equal to %2%3 for \"%4\"");
    else
      FormatMessageString = _("ERROR: input must be a number between %1 and %2%3 for \"%4\".");

    ErrorMessageString
      += MessageFormatter (FormatMessageString)
         % wxFormat (MinBasictypeString)
         % wxFormat (MaxBasictypeString)
         % ((m_Flags & IsEmptyAllowed) ? _(" (or empty)") : "")
         % m_FieldNameString;
}

#endif

//-------------------------------------------------------------------------

// undefine shortcuts
    #undef M_Basictype

//=========================================================================

#endif // defined M_StatusValidators_IsEmitGenericImplementation

//-------------------------------------------------------------------------

#endif // defined M_StatusValidators_IsEmitGenericImplementation

//-------------------------------------------------------------------------

#ifndef M_StatusValidators_IsEmitGenericImplementation

//=========================================================================

// implementation of trait classes using generic includes

// NB format strings are ignored except for 'double' and 'float' types
// currently

#define M_StatusValidators_IsEmitGenericImplementation

//-------------------------------------------------------------------------

// implement wxBasictypeValidatorTrait_wxInt16
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxInt16
    #define M_BasictypeValidatorTrait_Basictype wxInt16
    #define M_BasictypeValidatorTrait_DefaultFormatString "%ld"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%hd"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertLongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToWxInt16
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_wxUint16
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxUint16
    #define M_BasictypeValidatorTrait_Basictype wxUint16
    #define M_BasictypeValidatorTrait_DefaultFormatString "%hu"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%hu"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertULongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToWxUint16
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_wxInt32
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxInt32
    #define M_BasictypeValidatorTrait_Basictype wxInt32
    #define M_BasictypeValidatorTrait_DefaultFormatString "%ld"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%ld"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertLongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToWxInt32
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_wxUint32
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxUint32
    #define M_BasictypeValidatorTrait_Basictype wxUint32
    #define M_BasictypeValidatorTrait_DefaultFormatString "%u"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%u"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertULongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToWxUint32
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_short
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_short
    #define M_BasictypeValidatorTrait_Basictype short
    #define M_BasictypeValidatorTrait_DefaultFormatString "%d"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%hd"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertLongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToShort
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_ushort
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_ushort
    #define M_BasictypeValidatorTrait_Basictype unsigned short
    #define M_BasictypeValidatorTrait_DefaultFormatString "%u"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%hu"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertULongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToUShort
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_int
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_int
    #define M_BasictypeValidatorTrait_Basictype int
    #define M_BasictypeValidatorTrait_DefaultFormatString "%d"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%d"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertLongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToInt
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_uint
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_uint
    #define M_BasictypeValidatorTrait_Basictype unsigned int
    #define M_BasictypeValidatorTrait_DefaultFormatString "%u"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%u"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertULongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToUInt
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_long
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_long
    #define M_BasictypeValidatorTrait_Basictype long
    #define M_BasictypeValidatorTrait_DefaultFormatString "%ld"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%ld"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertLongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToLong
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_ulong
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_ulong
    #define M_BasictypeValidatorTrait_Basictype unsigned long
    #define M_BasictypeValidatorTrait_DefaultFormatString "%ld"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%ld"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertULongToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToULong
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_wxFloat32
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxFloat32
    #define M_BasictypeValidatorTrait_Basictype wxFloat32
    // float doesn't have direct printf() support (only scanf() support), so we
    // use conversion function and printf format specifier for 'double'
    #define M_BasictypeValidatorTrait_DefaultFormatString "%f"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%lf"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertDoubleToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToFloat
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_wxFloat64
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxFloat64
    #define M_BasictypeValidatorTrait_Basictype wxFloat64
    // printf() %f is already double, not float, and float is not directly supported
    #define M_BasictypeValidatorTrait_DefaultFormatString "%f" 
    #define M_BasictypeValidatorTrait_DefaultScanfString "%lf"
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertDoubleToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToDouble
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

// implement wxBasictypeValidatorTrait_wxStringBase
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxStringBase
    #define M_BasictypeValidatorTrait_Basictype wxString
    #define M_BasictypeValidatorTrait_DefaultFormatString "%%"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%%" /* unused */
    #define M_BasictypeValidatorTrait_FormatFunction wxBasictypeValidatorTrait_convertStringToString
    #define M_BasictypeValidatorTrait_ParseFunction wxBasictypeValidatorTrait_convertStringToString
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_FormatFunction
    #undef M_BasictypeValidatorTrait_ParseFunction

//-------------------------------------------------------------------------

// implement wxBasictypeValidatorTrait_wxDateTime
    #define M_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxDateTime
    #define M_BasictypeValidatorTrait_Basictype wxDateTime
    // #define M_BasictypeValidatorTrait_DefaultFormatString "%%"
    #define M_BasictypeValidatorTrait_DefaultFormatString "%Y-%m-%d %H:%M:%S"
    #define M_BasictypeValidatorTrait_DefaultScanfString "%%" /* unused */
    #define M_BasictypeValidatorTrait_IsUseSpecialParseAndFormatFunction 1
    #define M_BasictypeValidatorTrait_IsSpecialUndefinedCheckFunction 1
    #define M_BasictypeValidatorTrait_IsNoGetErrorMessageStringImplementation 1
    #include "StatusValidators.cpp"
    #undef M_BasictypeValidatorTrait
    #undef M_BasictypeValidatorTrait_Basictype
    #undef M_BasictypeValidatorTrait_DefaultFormatString
    #undef M_BasictypeValidatorTrait_DefaultScanfString
    #undef M_BasictypeValidatorTrait_IsUseSpecialParseAndFormatFunction
    #undef M_BasictypeValidatorTrait_IsSpecialUndefinedCheckFunction
    #undef M_BasictypeValidatorTrait_IsNoGetErrorMessageStringImplementation

void wxBasictypeValidatorTrait_wxDateTime::convertBasictypeToString (const wxDateTime & Basictype,
                                                                     wxString & String)
{
    // formatDateTimeInISOFormat (Basictype, String);
    formatDateTimeWithFormat (Basictype, String, m_FormatString);
}

bool wxBasictypeValidatorTrait_wxDateTime::convertStringToBasictype (const wxString & TrimmedString,
                                                                     wxDateTime & Basictype)
{
    // return parseDateTimeFromISOFormat (TrimmedString, Basictype);
    return parseDateTimeWithFormat (TrimmedString, Basictype, m_FormatString);
}

bool wxBasictypeValidatorTrait_wxDateTime::getIsUndefinedValue (const wxDateTime & Basictype)
{
    // cannot compare Basictype == m_UndefinedBasictype
    // because is wxDateTime, in case wxInvalidDateTime
    // is used as m_UndefinedBasictype (in this case, the comparision causes
    // an assertion failure, because supplied date is invalid)
    if (!Basictype.IsValid())
      return true;

    if (m_UndefinedBasictype.IsValid())
      return (Basictype == m_UndefinedBasictype);

    return false;
}

void wxBasictypeValidatorTrait_wxDateTime::getErrorMessageString (wxString & ErrorMessageString)
{
    wxString MinBasictypeString;
    wxString MaxBasictypeString;
    wxString ExampleDateTimeString;

    if (!(m_Flags & IsIgnoreMinimum))
      convertBasictypeToString (m_MinBasictype, MinBasictypeString);

    if (!(m_Flags & IsIgnoreMaximum))
      convertBasictypeToString (m_MaxBasictype, MaxBasictypeString);

    //-- formatting of date/time example string: this is quite tedious 
    // because want to output a sample string which is in the valid
    // range of accepted dates, to avoid confusing the user
    wxDateTime ExampleDateTime;
    if (m_Flags & IsIgnoreMinimum)
      {
        if (m_Flags & IsIgnoreMaximum)
          {
            // neither maximum nor minimum
            ExampleDateTime =  wxDateTime::Now();
          }
        else
          {
            // maximum but no minimum
            ExampleDateTime = m_MaxBasictype - wxTimeSpan::Days (50);
          }
      }
    else
      {
        if (m_Flags & IsIgnoreMaximum)
          {
            // minimum but no maximum
            ExampleDateTime = m_MaxBasictype - wxTimeSpan::Days (50);
          }
        else
          {
            // both minimum and maximum
            // BUG: the calculation code for wxTimeSpan possibly has a bug or
            // cannot deal with long distances in time (e.g. for Min==1900-01-01
            // and Max==2100-01-01, result is 1904-03-03)
            ExampleDateTime = m_MinBasictype + wxTimeSpan ((m_MaxBasictype - m_MinBasictype).GetDays() / 2);
          }
      }
    convertBasictypeToString (ExampleDateTime, ExampleDateTimeString);

    //-- formatting of error message
    const char * FormatMessageString = NULL;
    if ((m_Flags & IsIgnoreMinimum)
        && (m_Flags & IsIgnoreMaximum))
      FormatMessageString = _("ERROR: input must be date/time%3 for \"%4\" (input format example: %5)");
    else if ((m_Flags & IsIgnoreMinimum) == 0
             && (m_Flags & IsIgnoreMaximum))
      FormatMessageString = _("ERROR: input must be date/time greater than or equal to %1%3 for \"%4\" (input format example: %5)");
    else if ((m_Flags & IsIgnoreMinimum) != 0
             && (m_Flags & IsIgnoreMaximum) == 0)
      FormatMessageString = _("ERROR: input must be date/time smaller than or equal to %2%3 for \"%4\" (input format example: %5)");
    else
      FormatMessageString = _("ERROR: input must be date/time between %1 and %2%3 for \"%4\" (input format example: %5)");

    ErrorMessageString
      += MessageFormatter (FormatMessageString)
         % wxFormat (MinBasictypeString)
         % wxFormat (MaxBasictypeString)
         % ((m_Flags & IsEmptyAllowed) ? _(" (or empty)") : "")
         % m_FieldNameString
         % ExampleDateTimeString;
}

//-------------------------------------------------------------------------

wxBasictypeValidatorTrait_wxString::wxBasictypeValidatorTrait_wxString()
{
    m_MinStringLength = 0;
    m_MaxStringLength = -1;
}

void wxBasictypeValidatorTrait_wxString::setMinStringLength(int MinStringLength)
{
    m_MinStringLength = MinStringLength;
}

void wxBasictypeValidatorTrait_wxString::setMaxStringLength(int MaxStringLength)
{
    m_MaxStringLength = MaxStringLength;
}

void wxBasictypeValidatorTrait_wxString::setAllowedInputCharset (const wxString & AllowedCharsetString)
{
    m_AllowedCharsetString = AllowedCharsetString;
}

void wxBasictypeValidatorTrait_wxString::setAllowedInputCharsetDescription (const wxString & AllowedCharsetDescriptionString)
{
    m_AllowedCharsetDescriptionString = AllowedCharsetDescriptionString;
}

bool wxBasictypeValidatorTrait_wxString::convertFromStringHelper (const wxString & TextCtrlContentString,
                                                                          wxString * TrimmedInputStringPtr,
                                                                          wxString & ErrorMessageString)
{
    bool IsOkay
      = wxBasictypeValidatorTrait_wxStringBase::convertFromStringHelper (TextCtrlContentString, 
                                                                         TrimmedInputStringPtr, 
                                                                         ErrorMessageString);

    if (IsOkay)
      {
        int Length = TrimmedInputStringPtr->Length();

        wxString FormatMessageString;
        if (Length < m_MinStringLength)
          {
            FormatMessageString = _("ERROR: input must consist of at least %1 characters for \"%3\".");
            IsOkay = false;
          }
        else if ((m_MaxStringLength != -1)
                 && (Length > m_MaxStringLength))
          {
            FormatMessageString = _("ERROR: input must have no more than %2 characters for \"%3\".");
            IsOkay = false;
          }

        if (!IsOkay)
          {
            ErrorMessageString += wxFormatMessage (FormatMessageString,
                                                   m_MinStringLength,
                                                   m_MaxStringLength,
                                                   m_FieldNameString);
          }
        else
          {
            // now check for accepted charset

            const char * InputCharPtr = TrimmedInputStringPtr -> c_str();
            const char * AllowedCharsetStringCharPtr = m_AllowedCharsetString.c_str();
            
            if ((InputCharPtr != NULL)
                && (AllowedCharsetStringCharPtr != NULL)
                && (m_AllowedCharsetString.Length() > 0))
              {
                if (strspn (InputCharPtr, AllowedCharsetStringCharPtr) != TrimmedInputStringPtr->Length())
                  {
                    IsOkay = false;
                  }
              }

            if (!IsOkay)
              {
                FormatMessageString = _("ERROR: input must consist only of characters of type <%1> for \"%2\".");
                
                ErrorMessageString += wxFormatMessage (FormatMessageString,
                                                       m_AllowedCharsetDescriptionString,
                                                       m_FieldNameString);
              }

          }
      }
    return IsOkay;
}

void wxBasictypeValidatorTrait_wxString::getErrorMessageString (wxString & ErrorMessageString)
{
    const char * FormatMessageString = NULL;

    // unlike for numeric types, this error message doesn't contain a 
    // full description of all required constraints (min, max count of characters,
    // accepted characters) 
    // - specialized error message is returned if a constraint doesn't hold
    //   (see convertFromStringHelper())
    FormatMessageString = _("ERROR: input must be a%1 string%2 for \"%3\"");

    ErrorMessageString
      += MessageFormatter (FormatMessageString)
      % ((m_Flags & IsEmptyAllowed) ? "" :  _(" non-empty"))
      % ((m_Flags & IsEmptyAllowed) ? _(" (or empty)") : "")
      % m_FieldNameString;
}

//-------------------------------------------------------------------------

#undef M_StatusValidators_IsEmitGenericImplementation

//=========================================================================

wxNumberValidatorVariant::wxNumberValidatorVariant ()
{
    m_Type = UndefinedType;
    m_Long = 0;
    m_Double = 0.;
}

bool wxNumberValidatorVariant::getIsLong () const
{
    return m_Type == LongType;
}

bool wxNumberValidatorVariant::getIsDouble () const
{
    return m_Type == DoubleType;
}

long wxNumberValidatorVariant::getLong () const
{
    return m_Long;
}

double wxNumberValidatorVariant::getDouble () const
{
    return m_Double;
}

void wxNumberValidatorVariant::getLong (long * Long) const
{
    * Long = m_Long;
}

void wxNumberValidatorVariant::getDouble (double * Double) const
{
    * Double = m_Double;
}

void wxNumberValidatorVariant::setLong (long Long)
{
    m_Long = Long;
    m_Double = 0.;
    m_Type = LongType;
}

void wxNumberValidatorVariant::setDouble (const double & Double)
{
    m_Long = 0;
    m_Double = Double;
    m_Type = DoubleType;
}

bool wxNumberValidatorVariant::operator== (const wxNumberValidatorVariant & Variant) const
{
    // this equality test operator requires unused elements to be uniquely set
    // to a certain value (e.g. 0 or 0.) to work as expected.
    bool IsEqual = m_Type == Variant.m_Type
      && m_Long == Variant.m_Long
      && m_Double == Variant.m_Double;
    return IsEqual;
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxNumberValidator, wxTraitedTextCtrlStatusValidator)

BEGIN_EVENT_TABLE(wxNumberValidator, wxTextCtrlStatusValidator)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxNumberValidator::wxNumberValidator()
{
    m_TextCtrlStatusValidatorTrait = NULL;
}

wxNumberValidator::wxNumberValidator(int * IntegerValue, int MinInteger, int MaxInteger,
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int Flags, int UndefinedInteger)
  : wxTraitedTextCtrlStatusValidator(& m_IntBasictypeValidatorTrait, 
                                     StatusMessageTarget, Flags)
{
    m_IntBasictypeValidatorTrait.init (IntegerValue, 
                                       MinInteger, MaxInteger,
                                       FieldNameString,
                                       Flags, UndefinedInteger,
                                       wxEmptyString);
    // m_FormatString = "%ld";
}

wxNumberValidator::wxNumberValidator(long * LongValue, long MinLong, long MaxLong,
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int Flags, long UndefinedLong)
  : wxTraitedTextCtrlStatusValidator(& m_LongBasictypeValidatorTrait, 
                                     StatusMessageTarget, Flags)
{
    m_LongBasictypeValidatorTrait.init (LongValue, 
                                        MinLong, MaxLong,
                                        FieldNameString,
                                        Flags, UndefinedLong,
                                        wxEmptyString);
    // m_FormatString = "%ld";
}

wxNumberValidator::wxNumberValidator(double * DoubleValue, double MinDouble, double MaxDouble,
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int Flags, 
                                     const wxString & FormatString,
                                     double UndefinedDouble)
  : wxTraitedTextCtrlStatusValidator(& m_DoubleBasictypeValidatorTrait, 
                                     StatusMessageTarget, Flags)
{
    m_DoubleBasictypeValidatorTrait.init (DoubleValue, 
                                          MinDouble, MaxDouble,
                                          FieldNameString,
                                          Flags, UndefinedDouble,
                                          FormatString);
}

wxNumberValidator::wxNumberValidator(const wxNumberValidator& NumberValidator)
    : wxTraitedTextCtrlStatusValidator()
{
    Copy(NumberValidator);
}

bool wxNumberValidator::Copy(const wxNumberValidator& NumberValidator)
{
    wxTraitedTextCtrlStatusValidator::Copy(NumberValidator);

    m_IntBasictypeValidatorTrait = NumberValidator.m_IntBasictypeValidatorTrait;
    m_LongBasictypeValidatorTrait = NumberValidator.m_LongBasictypeValidatorTrait;
    m_DoubleBasictypeValidatorTrait = NumberValidator.m_DoubleBasictypeValidatorTrait;

    // HACK to deal with pointer to different types of BasictypeValidatorTrait
    // the pointer must point the right BasictypeValidatorTrait within
    // the destination object (this), not source object
    // HACK (const wxTextCtrlStatusValidator *) cast is a cast to the base class
    // and is added for VC++ compatibility
    if (NumberValidator.m_TextCtrlStatusValidatorTrait == 
        (const wxTextCtrlStatusValidatorTrait *) (& NumberValidator.m_IntBasictypeValidatorTrait))
      {
        m_TextCtrlStatusValidatorTrait = & m_IntBasictypeValidatorTrait;
      }
    else if (NumberValidator.m_TextCtrlStatusValidatorTrait == 
        (const wxTextCtrlStatusValidatorTrait *) & NumberValidator.m_LongBasictypeValidatorTrait)
      {
        m_TextCtrlStatusValidatorTrait = & m_LongBasictypeValidatorTrait;
      }
    else if (NumberValidator.m_TextCtrlStatusValidatorTrait == 
        (const wxTextCtrlStatusValidatorTrait *) & NumberValidator.m_DoubleBasictypeValidatorTrait)
      {
        m_TextCtrlStatusValidatorTrait = & m_DoubleBasictypeValidatorTrait;
      }
    else
      {
        m_TextCtrlStatusValidatorTrait = NULL;
      }
    return true;
}

wxNumberValidator::~wxNumberValidator()
{
}

//=========================================================================

#else // M_StatusValidators_IsEmitGenericImplementation

//-------------------------------------------------------------------------

#define M_IsDefinePPMacros 1
#   include "pp_basics.h" 
// #undef M_IsDefinePPMacros

//=========================================================================

// #define IMPLEMENT_CLASS_wxTraitedTextCtrlStatusValidatorImpl(TClassname,M_BasictypeValidatorTrait,M_Basictype)

#if (defined M_TraitedTextCtrlStatusValidatorImpl)

// macros which must be defined
// - M_TraitedTextCtrlStatusValidatorImpl
// - M_TraitedTextCtrlStatusValidatorImpl_Basictype
// - M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait

//-------------------------------------------------------------------------

// define a few shortcuts
#define M_Basictype M_TraitedTextCtrlStatusValidatorImpl_Basictype
#define M_BasictypeValidatorTrait M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait

//-------------------------------------------------------------------------

M_PP_eval2 (IMPLEMENT_DYNAMIC_CLASS, M_TraitedTextCtrlStatusValidatorImpl, wxTraitedTextCtrlStatusValidator)

M_PP_eval2 (BEGIN_EVENT_TABLE, M_TraitedTextCtrlStatusValidatorImpl, wxTraitedTextCtrlStatusValidator)
M_PP_eval0 (END_EVENT_TABLE)

//-------------------------------------------------------------------------

M_TraitedTextCtrlStatusValidatorImpl::M_TraitedTextCtrlStatusValidatorImpl()
{
    m_TextCtrlStatusValidatorTrait = NULL;
}

M_TraitedTextCtrlStatusValidatorImpl::M_TraitedTextCtrlStatusValidatorImpl(M_Basictype * BasictypeValue,
                       M_Basictype MinBasictype, M_Basictype MaxBasictype,
                       wxStatusMessageTarget * StatusMessageTarget,
                       const wxString & FieldNameString,
                       int Flags, M_Basictype UndefinedBasictype,
                       const wxString & FormatString)
  : wxTraitedTextCtrlStatusValidator(& m_BasictypeValidatorTrait,
                                     StatusMessageTarget, Flags)
{
    m_BasictypeValidatorTrait.init (BasictypeValue,
                                    MinBasictype, MaxBasictype,
                                    FieldNameString,
                                    Flags, UndefinedBasictype,
                                    FormatString);
}

M_TraitedTextCtrlStatusValidatorImpl::M_TraitedTextCtrlStatusValidatorImpl(const M_TraitedTextCtrlStatusValidatorImpl& TraitedTextCtrlStatusValidatorImpl)
    : wxTraitedTextCtrlStatusValidator()
{
    Copy(TraitedTextCtrlStatusValidatorImpl);
}

M_TraitedTextCtrlStatusValidatorImpl::~M_TraitedTextCtrlStatusValidatorImpl()
{
}

//-------------------------------------------------------------------------

bool M_TraitedTextCtrlStatusValidatorImpl::Copy(const M_TraitedTextCtrlStatusValidatorImpl& TraitedTextCtrlStatusValidatorImpl)
{
    wxTraitedTextCtrlStatusValidator::Copy(TraitedTextCtrlStatusValidatorImpl);

    m_BasictypeValidatorTrait = TraitedTextCtrlStatusValidatorImpl.m_BasictypeValidatorTrait;
    m_TextCtrlStatusValidatorTrait = & m_BasictypeValidatorTrait;
    return true;
}

//-------------------------------------------------------------------------

// undefine shortcuts
    #undef M_Basictype
    #undef M_BasictypeValidatorTrait

//-------------------------------------------------------------------------

#endif // defined M_TraitedTextCtrlStatusValidatorImpl

//=========================================================================

#endif // defined M_StatusValidators_IsEmitGenericImplementation

//-------------------------------------------------------------------------

#if (!defined M_StatusValidators_IsEmitGenericImplementation)

//-------------------------------------------------------------------------

#define M_StatusValidators_IsEmitGenericImplementation

//-------------------------------------------------------------------------

// implement wxTraitedIntValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedIntValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_int
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype int
    #include "StatusValidators.cpp"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype

// implement wxTraitedUintValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedUintValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_uint
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype unsigned int
    #include "StatusValidators.cpp"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype

// implement wxTraitedLongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedLongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_long
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype long
    #include "StatusValidators.cpp"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype

// implement wxTraitedUlongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedUlongValidator
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_ulong
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype unsigned long
    #include "StatusValidators.cpp"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype

// implement wxTraitedStringValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedStringValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxString
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype wxString
    #include "StatusValidators.cpp"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype

// implement wxTraitedDateTimeValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl wxTraitedDateTimeValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxBasictypeValidatorTrait_wxDateTime
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype wxDateTime
    #include "StatusValidators.cpp"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype


//-------------------------------------------------------------------------

#undef M_StatusValidators_IsEmitGenericImplementation

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxRONumberValidator, wxNumberValidator)

//-------------------------------------------------------------------------

wxRONumberValidator::wxRONumberValidator()
{
}

wxRONumberValidator::wxRONumberValidator(int * IntegerValue,
                                         int Flags, int UndefinedInteger)
  : wxNumberValidator (IntegerValue, 0, 0, NULL, wxEmptyString, Flags, UndefinedInteger)
{
}

wxRONumberValidator::wxRONumberValidator(long * LongValue,
                                         int Flags, int UndefinedLong)
  : wxNumberValidator (LongValue, 0L, 0L, NULL, wxEmptyString, Flags, UndefinedLong)
{
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxTraitedStringValidator, wxTraitedStringValidatorBase)

BEGIN_EVENT_TABLE(wxTraitedStringValidator, wxTraitedStringValidatorBase)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxTraitedStringValidator::wxTraitedStringValidator ()
{
}

wxTraitedStringValidator::wxTraitedStringValidator(wxString * StringPtr, 
                                                   wxStatusMessageTarget * StatusMessageTarget,
                                                   const wxString & FieldNameString,
                                                   int MaxStringLength, 
                                                   int Flags, 
                                                   const wxString & UndefinedString)
{
    // TODO: add init() function to base classes instead of directly 
    // accessing member variables
    m_TextCtrlStatusValidatorTrait = & m_BasictypeValidatorTrait;
    m_StatusMessageTarget = StatusMessageTarget;

    Flags |= IsIgnoreMinimum | IsIgnoreMaximum;

    m_Flags = Flags;

    m_BasictypeValidatorTrait.init (StringPtr,
                                    wxEmptyString /* MinBasictype (dummy) */,
                                    wxEmptyString /* MaxBasictype (dummy) */,
                                    FieldNameString,
                                    Flags,
                                    UndefinedString,
                                    wxEmptyString /* FormatString */);

    m_BasictypeValidatorTrait.setMinStringLength (0);
    m_BasictypeValidatorTrait.setMaxStringLength (MaxStringLength);
}

wxTraitedStringValidator::wxTraitedStringValidator (const wxTraitedStringValidator & TraitedStringValidator)
{
    // WARN must Copy() of base class called here or in copy-ctr?
    Copy (TraitedStringValidator);
}

bool wxTraitedStringValidator::Copy (const wxTraitedStringValidator & TraitedStringValidator)
{
    // WARN must Copy() of base class called here or in copy-ctr?
    wxTraitedStringValidatorBase::Copy (TraitedStringValidator);
    return true;
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxTraitedDateTimeValidator, wxTraitedDateTimeValidatorBase)

BEGIN_EVENT_TABLE(wxTraitedDateTimeValidator, wxTraitedDateTimeValidatorBase)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxTraitedDateTimeValidator::wxTraitedDateTimeValidator ()
{
}

wxTraitedDateTimeValidator::wxTraitedDateTimeValidator(wxDateTime * DateTimePtr, 
                                                       wxStatusMessageTarget * StatusMessageTarget,
                                                       const wxString & FieldNameString,
                                                       int Flags,
                                                       const wxString & DateTimeFormatString)
{
    // TODO: add init() function to base classes instead of directly 
    // accessing member variables
    m_TextCtrlStatusValidatorTrait = & m_BasictypeValidatorTrait;
    m_StatusMessageTarget = StatusMessageTarget;

    Flags |= IsIgnoreMinimum | IsIgnoreMaximum;

    m_Flags = Flags;

    wxString UsedDateTimeFormatString = DateTimeFormatString;
    if (UsedDateTimeFormatString.IsEmpty())
      {
        UsedDateTimeFormatString = "%Y-%m-%d %H:%M:%S";
      }

    m_BasictypeValidatorTrait.init (DateTimePtr,
                                    wxInvalidDateTime /* MinBasictype (dummy) */,
                                    wxInvalidDateTime /* MaxBasictype (dummy) */,
                                    FieldNameString,
                                    Flags,
                                    wxInvalidDateTime /* UndefinedBasictype */,
                                    UsedDateTimeFormatString);
}

wxTraitedDateTimeValidator::wxTraitedDateTimeValidator (wxDateTime * DateTimePtr, 
                                                        wxDateTime MinDateTime, wxDateTime MaxDateTime,
                                                        wxStatusMessageTarget * StatusMessageTarget,
                                                        const wxString & FieldNameString,
                                                        int Flags, wxDateTime UndefinedDateTime,
                                                        const wxString & DateTimeFormatString)
{
    // TODO: add init() function to base classes instead of directly 
    // accessing member variables
    m_TextCtrlStatusValidatorTrait = & m_BasictypeValidatorTrait;
    m_StatusMessageTarget = StatusMessageTarget;

    m_Flags = Flags;

    wxString UsedDateTimeFormatString = DateTimeFormatString;
    if (UsedDateTimeFormatString.IsEmpty())
      {
        UsedDateTimeFormatString = "%Y-%m-%d %H:%M:%S";
      }

    m_BasictypeValidatorTrait.init (DateTimePtr,
                                    MinDateTime,
                                    MaxDateTime,
                                    FieldNameString,
                                    Flags,
                                    UndefinedDateTime,
                                    UsedDateTimeFormatString);
}

wxTraitedDateTimeValidator::wxTraitedDateTimeValidator (const wxTraitedDateTimeValidator & TraitedDateTimeValidator)
{
    // WARN must Copy() of base class called here or in copy-ctr?
    Copy (TraitedDateTimeValidator);
}

bool wxTraitedDateTimeValidator::Copy (const wxTraitedDateTimeValidator & TraitedDateTimeValidator)
{
    // WARN must Copy() of base class called here or in copy-ctr?
    wxTraitedDateTimeValidatorBase::Copy (TraitedDateTimeValidator);
    return true;
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxNonTraitedDateTimeValidator, wxTextCtrlStatusValidator)

BEGIN_EVENT_TABLE(wxNonTraitedDateTimeValidator, wxTextCtrlStatusValidator)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxNonTraitedDateTimeValidator::wxNonTraitedDateTimeValidator()
{
    m_DateTimeValue = NULL;
    m_FieldNameString = "";
}

wxNonTraitedDateTimeValidator::wxNonTraitedDateTimeValidator(wxDateTime * DateTime, 
                                         wxStatusMessageTarget * StatusMessageTarget,
                                         const wxString & FieldNameString,
                                         int Flags)
  : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_DateTimeValue = DateTime;
    m_FieldNameString = FieldNameString;
}

wxNonTraitedDateTimeValidator::wxNonTraitedDateTimeValidator(const wxNonTraitedDateTimeValidator& NonTraitedDateTimeValidator)
    : wxTextCtrlStatusValidator()
{
    Copy(NonTraitedDateTimeValidator);
}

bool wxNonTraitedDateTimeValidator::Copy(const wxNonTraitedDateTimeValidator& NonTraitedDateTimeValidator)
{
    wxTextCtrlStatusValidator::Copy(NonTraitedDateTimeValidator);

    m_DateTimeValue = NonTraitedDateTimeValidator.m_DateTimeValue ;
    m_FieldNameString = NonTraitedDateTimeValidator.m_FieldNameString;

    return true;
}

wxNonTraitedDateTimeValidator::~wxNonTraitedDateTimeValidator()
{
}

//-------------------------------------------------------------------------

void wxNonTraitedDateTimeValidator::transferToWindow (wxString & TextCtrlContentString)
{
    transferToWindowHelper (* m_DateTimeValue, TextCtrlContentString);
}

void wxNonTraitedDateTimeValidator::transferToWindowHelper (const wxDateTime & TempDateTime, wxString & TextCtrlContentString)
{
    if ((m_Flags & IsEmptyAllowed) 
        && (!TempDateTime.IsValid()))
      {
        TextCtrlContentString = "";
      }
    else
      {
        formatDate (TempDateTime, TextCtrlContentString);
      }
}

//-------------------------------------------------------------------------

bool wxNonTraitedDateTimeValidator::transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                                       wxString & ErrorMessageString,
                                                       bool IsTextCtrlChangeEvent)
{
    wxDateTime TempDateTime;
    bool IsOk = transferFromWindowHelper (TextCtrlContentString,
                                          & TempDateTime, ErrorMessageString);
    if (IsOk && IsTextCtrlChangeEvent)
      handleValidInput (TempDateTime);

    return IsOk;
}

bool wxNonTraitedDateTimeValidator::transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                                        wxString & ErrorMessageString)
{
    bool IsOk = true;
    if (m_DateTimeValue)
      {
        IsOk = transferFromWindowHelper (TextCtrlContentString,
                                         m_DateTimeValue, ErrorMessageString);
      }
    return IsOk;
}

//-------------------------------------------------------------------------

bool wxNonTraitedDateTimeValidator::transferFromWindowHelper (const wxString & TextCtrlContentString,
                                                    wxDateTime * DateTime, 
                                                    wxString & ErrorMessageString)
{
    wxString TrimmedInputString = TextCtrlContentString;
    TrimmedInputString.Trim (false);
    TrimmedInputString.Trim (true);

    wxDateTime TempDateTime = wxInvalidDateTime;
    if ((m_Flags & IsEmptyAllowed) && TrimmedInputString.IsEmpty())
      {
        TempDateTime = wxInvalidDateTime;
      }
    else
      {
        bool IsOk = parseDate (TrimmedInputString, TempDateTime);
        if (IsOk)
          {
            if (!checkValue (TempDateTime))
              IsOk = false;
          }

        if (!IsOk)
          {
            // TODO: the error message should contain information about
            // which date date format(s) are accepted for the current locale
            getErrorMessageString (TempDateTime, ErrorMessageString);
            return false;
          }
      }
    *DateTime = TempDateTime;
    return true;
}

bool wxNonTraitedDateTimeValidator::checkValue (const wxDateTime & DateTime)
{
    return DateTime.IsValid();
    // return true;
}

void wxNonTraitedDateTimeValidator::getErrorMessageString (const wxDateTime & WXUNUSED(DateTime), 
                                                 wxString & ErrorMessageString)
{
    ErrorMessageString
      += MessageFormatter (_("ERROR: input must be a valid date%1 for \"%2\""))
      % ((m_Flags & IsEmptyAllowed) ? _(" (or empty)") : "")
      % m_FieldNameString;
}

//-------------------------------------------------------------------------

void wxNonTraitedDateTimeValidator::handleValidInput (const wxDateTime & WXUNUSED(DateTime))
{
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxNonTraitedStringValidator, wxTextCtrlStatusValidator)

BEGIN_EVENT_TABLE(wxNonTraitedStringValidator, wxTextCtrlStatusValidator)
END_EVENT_TABLE()

// WARN this should be better of type size_t:
const int UnlimitedStringLength = -1;

//-------------------------------------------------------------------------

wxNonTraitedStringValidator::wxNonTraitedStringValidator()
{
    m_StringValue = NULL;
    m_FieldNameString = "";
    m_MaxStringLength = UnlimitedStringLength;
    m_Flags = 0;
    m_UndefinedString = "";
}

wxNonTraitedStringValidator::wxNonTraitedStringValidator(wxString * StringValue, 
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int MaxStringLength,
                                     int Flags, const wxString & UndefinedString)
  : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_StringValue = StringValue;
    m_FieldNameString = FieldNameString;
    m_MaxStringLength = MaxStringLength;
    m_Flags = Flags;
    m_UndefinedString = UndefinedString;
}

wxNonTraitedStringValidator::wxNonTraitedStringValidator(const wxNonTraitedStringValidator& StringValidator)
    : wxTextCtrlStatusValidator()
{
    Copy(StringValidator);
}

bool wxNonTraitedStringValidator::Copy(const wxNonTraitedStringValidator& StringValidator)
{
    wxTextCtrlStatusValidator::Copy(StringValidator);

    m_StringValue = StringValidator.m_StringValue;
    m_FieldNameString = StringValidator.m_FieldNameString;
    m_MaxStringLength = StringValidator.m_MaxStringLength;
    m_Flags = StringValidator.m_Flags;
    m_UndefinedString = StringValidator.m_UndefinedString;

    return true;
}

wxNonTraitedStringValidator::~wxNonTraitedStringValidator()
{
}

//-------------------------------------------------------------------------

void wxNonTraitedStringValidator::transferToWindow (wxString & TextCtrlContentString)
{
    transferToWindowHelper (*m_StringValue, TextCtrlContentString);
}

void wxNonTraitedStringValidator::transferToWindowHelper (const wxString & String, 
                                                wxString & TextCtrlContentString)
{
    if ((m_Flags & IsEmptyAllowed) 
        && (String == m_UndefinedString))
      {
        TextCtrlContentString = "";
      }
    else
      {
        TextCtrlContentString = String;
      }
}

//-------------------------------------------------------------------------

bool wxNonTraitedStringValidator::transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                                     wxString & ErrorMessageString,
                                                     bool IsTextCtrlChangeEvent)
{
    wxString TempString;
    bool IsOk = transferFromWindowHelper (TextCtrlContentString,
                                          & TempString, ErrorMessageString);
    if (IsOk && IsTextCtrlChangeEvent)
      handleValidInput (TempString);

    return IsOk;
}

bool wxNonTraitedStringValidator::transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                                      wxString & ErrorMessageString)
{
    bool IsOk = true;
    if (m_StringValue)
      {
        IsOk = transferFromWindowHelper (TextCtrlContentString,
                                         m_StringValue, ErrorMessageString);
      }
    return IsOk;
}

//-------------------------------------------------------------------------

bool wxNonTraitedStringValidator::transferFromWindowHelper (const wxString & TextCtrlContentString,
                                                  wxString * String, 
                                                  wxString & ErrorMessageString)
{
    wxString TempString = TextCtrlContentString;
    // if trimming is desired:
    // TODO: add a flag like 'IsRemoveLeadingTrailingSpaces'
    // TempString.Trim (false);
    // TempString.Trim (true);

    if ((m_Flags & IsEmptyAllowed) 
        && TempString.IsEmpty())
      {
        TempString = m_UndefinedString;
      }
    else
      {
        if (!checkValue (TempString))
          {
            getErrorMessageString (TempString, ErrorMessageString);
            return false;
          }
      }
    *String = TempString;
    return true;
}

bool wxNonTraitedStringValidator::checkValue (const wxString & String)
{
    bool IsOK = true;
    if (!m_Flags & IsEmptyAllowed)
      {
        if (String.IsEmpty())
          IsOK = false;
      }
    if (m_MaxStringLength != UnlimitedStringLength)
      {
        if (cast_is_greater (String.Length(), m_MaxStringLength))
          IsOK = false;
      }
    return IsOK;
}

void wxNonTraitedStringValidator::getErrorMessageString (const wxString & WXUNUSED(String), 
                                               wxString & ErrorMessageString)
{
    wxString MaxStringLengthDescriptionString;
    if (m_MaxStringLength != UnlimitedStringLength)
      {
        MaxStringLengthDescriptionString 
          = wxFormatMessage (_("with no more than %1 characters "), m_MaxStringLength);
      }

    ErrorMessageString = wxFormatMessage 
      (_("ERROR: input must be a string %1%2for \"%3\"."),
       MaxStringLengthDescriptionString,
       m_Flags & IsEmptyAllowed ? _("(or empty) ") : "",
       m_FieldNameString);
}

//-------------------------------------------------------------------------

void wxNonTraitedStringValidator::handleValidInput (const wxString & WXUNUSED(String))
{
}

//=========================================================================

wxFilenameValidatorTrait::wxFilenameValidatorTrait ()
  : wxBasictypeValidatorTrait_wxString ()
{
}

/*
wxFilenameValidatorTrait::wxFilenameValidatorTrait (wxString * FilenameStringPtr,
                                                    const wxString & FieldNameString,
                                                    int BasictypeValidatorTraitFlags,
                                                    int FilenameValidatorTraitFlags,
                                                    const wxString & UndefinedFilenameString)
{
}
*/

void wxFilenameValidatorTrait::init (wxString * FilenameStringPtr,
                                     const wxString & FieldNameString,
                                     int BasictypeValidatorTraitFlags,
                                     int FilenameValidatorTraitFlags,
                                     const wxString & RelativeRefPathString,
                                     int NormalizeFlags)
{
    init (FilenameStringPtr,
          wxEmptyString /* MinBasictype */, 
          wxEmptyString /* MaxBasictype */,
          FieldNameString,
          BasictypeValidatorTraitFlags 
          | wxBasictypeValidatorTrait_wxString::IsIgnoreMinimum
          | wxBasictypeValidatorTrait_wxString::IsIgnoreMaximum, 
          wxEmptyString,
          wxEmptyString /* FormatString */);

    m_FilenameValidatorTraitFlags = FilenameValidatorTraitFlags;
    m_RelativeRefPathString = RelativeRefPathString;
    m_NormalizeFlags = NormalizeFlags;
}

void wxFilenameValidatorTrait::init (wxString * BasictypeValuePtr, 
                                     wxString MinBasictype, wxString MaxBasictype,
                                     const wxString & FieldNameString,
                                     int Flags, wxString UndefinedBasictype,
                                     const wxString & FormatString)
{
    wxBasictypeValidatorTrait_wxString::init (BasictypeValuePtr,
                                              MinBasictype, MaxBasictype,
                                              FieldNameString,
                                              Flags,
                                              UndefinedBasictype,
                                              FormatString);
}

bool wxFilenameValidatorTrait::convertFromStringHelper (const wxString & TextCtrlContentString,
                                                        wxString * FilenameStringPtr,
                                                        wxString & ErrorMessageString)
{
    wxString TrimmedInputString = TextCtrlContentString;
    TrimmedInputString.Trim (false);
    TrimmedInputString.Trim (true);

    bool IsOk = false;
    if ((m_Flags & IsEmptyAllowed) && TrimmedInputString.IsEmpty())
      {
        *FilenameStringPtr = m_UndefinedBasictype;
        IsOk = true;
      }
    else
      {
        bool IsFilenameOk = true;

        wxFileName FileName (TrimmedInputString);

        if (m_FilenameValidatorTraitFlags & IsNormalize)
          {
            FileName.Normalize (m_NormalizeFlags, m_RelativeRefPathString 
                                /*, wxPATH_NATIVE */);
          }

        const char * ErrorMessageFormatString = _("[no error]");

        if (TrimmedInputString.IsEmpty())
          {
            ErrorMessageFormatString = _("ERROR: filename must be given for \"%2\"");
            IsFilenameOk = false;
          }

        if (IsFilenameOk 
            && (m_FilenameValidatorTraitFlags & IsErrorIfInvalid))
          {
            if (!FileName.IsOk())
              {
                ErrorMessageFormatString = _("ERROR: not a valid filename for \"%2\"");
                IsFilenameOk = false;
              }
          }
        if (IsFilenameOk 
            && (m_FilenameValidatorTraitFlags & IsErrorIfNotFile))
          {
            if (!FileName.FileExists())
              {
                ErrorMessageFormatString = _("ERROR: file does not exist for \"%2\"");
                IsFilenameOk = false;
              }
          }
        if (IsFilenameOk 
            && (m_FilenameValidatorTraitFlags & IsErrorIfNotDirectory))
          {
            if (!FileName.DirExists())
              {
                ErrorMessageFormatString = _("ERROR: directory does not exist for \"%2\"");
                IsFilenameOk = false;
              }
          }

        IsOk = IsFilenameOk;

        if (IsOk)
          {
            if (m_FilenameValidatorTraitFlags & IsNormalize)
              {
                if (m_FilenameValidatorTraitFlags & IsStoreRelative)
                  {
                    wxString FilenameString = FileName.GetFullPath();
                    FileName.MakeRelativeTo (m_RelativeRefPathString /*, RelativeRefPathFormat */);

                    if (((m_FilenameValidatorTraitFlags & IsStoreNoRelativeParentDir) != 0)
                        && (FileName.GetFullPath().StartsWith ("..")))
                      {
                        *FilenameStringPtr = FilenameString;
                      }
                    else
                      {
                        *FilenameStringPtr = FileName.GetFullPath ();
                      }
                  }
                else
                  {
                    *FilenameStringPtr = FileName.GetFullPath();
                  }
              }
            else
              {
                *FilenameStringPtr = TrimmedInputString;
              }
          }

        if (!IsOk)
          {
            ErrorMessageString = wxFormatMessage (ErrorMessageFormatString,
                                                  TrimmedInputString,
                                                  m_FieldNameString);
          }
      }

    return IsOk;
}

//-------------------------------------------------------------------------

// implement wxFilenameValidatorBase
  #define M_StatusValidators_IsEmitGenericImplementation
    #define M_TraitedTextCtrlStatusValidatorImpl wxFilenameValidatorBase
    #define M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait wxFilenameValidatorTrait
    #define M_TraitedTextCtrlStatusValidatorImpl_Basictype wxString
    #include "StatusValidators.cpp"
    #undef M_TraitedTextCtrlStatusValidatorImpl
    #undef M_TraitedTextCtrlStatusValidatorImpl_BasictypeValidatorTrait
    #undef M_TraitedTextCtrlStatusValidatorImpl_Basictype
  #undef M_StatusValidators_IsEmitGenericImplementation

//-------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxFilenameValidator, wxFilenameValidatorBase)

BEGIN_EVENT_TABLE(wxFilenameValidator, wxFilenameValidatorBase)
END_EVENT_TABLE()

wxFilenameValidator::wxFilenameValidator ()
{
}

wxFilenameValidator::wxFilenameValidator (wxString * FilenameStringPtr,
                                          wxStatusMessageTarget * StatusMessageTarget,
                                          const wxString & FieldNameString,
                                          int BasictypeValidatorTraitFlags,
                                          int FilenameValidatorTraitFlags,
                                          const wxString & RelativeRefPathString,
                                          int NormalizeFlags)
{
    // TODO: add init() function to base classes instead of directly 
    // accessing member variables
    m_TextCtrlStatusValidatorTrait = & m_BasictypeValidatorTrait;
    m_StatusMessageTarget = StatusMessageTarget;
    m_Flags = BasictypeValidatorTraitFlags;

    m_BasictypeValidatorTrait.init (FilenameStringPtr,
                                    FieldNameString,
                                    BasictypeValidatorTraitFlags,
                                    FilenameValidatorTraitFlags,
                                    RelativeRefPathString,
                                    NormalizeFlags);
}

wxFilenameValidator::wxFilenameValidator (const wxFilenameValidator& FilenameValidator)
{
    // WARN must Copy() of base class called here or in copy-ctr?
    Copy (FilenameValidator);
}

bool wxFilenameValidator::Copy (const wxFilenameValidator & FilenameValidator)
{
    // WARN must Copy() of base class called here or in copy-ctr?
    wxFilenameValidatorBase::Copy (FilenameValidator);
    return true;
}

//=========================================================================

void updateComboBoxSelectionFromText (wxComboBox * ComboBox, 
                                      const wxString & TextCtrlString, bool IsForce)
{
    // HACK for wxMSW ComboBox (scope: wxWidgets 2.5.3): changing text
    // in ComboBox's text fields seems to forget to update selection 
    // state of items, so do this here
    int CorrectSelectionIndex = ComboBox -> FindString (TextCtrlString);
    int CurrentSelectionIndex = ComboBox -> GetSelection();
    if (IsForce 
        || (CurrentSelectionIndex != CorrectSelectionIndex))
      {
        // we must remember insertion index (cursor index)
        // and text typed, because SetSelection(-1) resets
        // them to 0/empty string
        long InsertionIndex = ComboBox -> GetInsertionPoint ();
                
        // the text typed into the ComboBox's text field doesn't
        // have a corresponding item
        // deselect if some item currently has the selected state
        ComboBox -> SetSelection (CorrectSelectionIndex);
        // WARN following may cause infinite recursive call of 
        // this function, check
        ComboBox -> SetValue (TextCtrlString);
        ComboBox -> SetInsertionPoint (InsertionIndex);
      }
}

//-------------------------------------------------------------------------

#define M_activatePageIfBookCtrl(BookCtrlType) \
    \
        BookCtrlType * BookCtrl = wxDynamicCast (ParentWindow, BookCtrlType); \
        if (BookCtrl != NULL) \
          { \
            /* try to find PageIndex which corresponds to CurrentWindow */  \
            for (int PageIndex = 0; PageIndex < BookCtrl -> GetPageCount(); ++PageIndex) \
              { \
                wxWindow * CurrentPageWindow = BookCtrl -> GetPage (PageIndex); \
                if (CurrentPageWindow == CurrentWindow) \
                  { \
                    /* activate page if found (but don't call SetSelection() if page */ \
                    /* is already activated) */ \
                    if (BookCtrl -> GetSelection() != PageIndex) \
                      BookCtrl -> SetSelection (PageIndex); \
 \
                    break; \
                  } \
              } \
          } \

void setFocusAndSelectParentBookPages (wxWindow * Window)
{
    Window -> SetFocus();

    wxWindow * CurrentWindow = Window;
    wxWindow * ParentWindow = NULL;

    while (true)
      {
        ParentWindow = CurrentWindow -> GetParent();
        if (ParentWindow == NULL)
          break;

#if wxCHECK_VERSION (2, 5, 0)
        // FUZZY don't know at which version exactly wxBookCtrl was added
        // (sometime between 2.4.2 and 2.5.3)

        // could do:
        //   M_activatePageIfBookCtrl (wxNotebook)
        //   M_activatePageIfBookCtrl (wxListbook)
        // but use of common base class wxBookCtrl class is better:
        M_activatePageIfBookCtrl (wxBookCtrl)
#else
        M_activatePageIfBookCtrl (wxNotebook)
#endif

        CurrentWindow = ParentWindow;
      }
}

#undef M_activatePageIfBookCtrl

//-------------------------------------------------------------------------

void transferDataToControl (wxWindow * Window)
{
    wxValidator * Validator = Window -> GetValidator();
    if (Validator != NULL)
      {
        Validator -> TransferToWindow();
      }
}

bool validateControl (wxWindow * Window)
{
    wxValidator * Validator = Window -> GetValidator();
    if (Validator != NULL)
      {
        // NOTE trap: Window->Validate() would only validate
        // child windows (but not itself)

        // WARN according to the docs, Validate() expects pointer
        // to parent window, but maybe associated dialog window was
        // meant instead?
        return (Validator -> Validate(Window -> GetParent()));
      }
    // default if no validator associated:
    return true;
}

bool transferDataFromControl (wxWindow * Window)
{
    wxValidator * Validator = Window -> GetValidator();
    if (Validator != NULL)
      {
        // NOTE trap: Window->TransferToWindow() would only transfer
        // data for all child windows (but not itself)

        return (Validator -> TransferFromWindow ());
      }
    // default if no validator associated:
    return true;
}

//=========================================================================

// #define M_IsUndefPPMacros 1
// #   include "pp_basics.h" 
// #undef M_IsUndefPPMacros

//-------------------------------------------------------------------------

#endif // M_StatusValidators_IsEmitGenericImplementation

//=========================================================================
