#!/bin/sh
#--------------------------------------------------------------------------
# Copyright (C) 2005 by Daniel Kps.
#
# This program is part of WxExtLib library and is distributed under
# the terms of the license contained in the file doc/WxExtLib-license.txt.
#--------------------------------------------------------------------------

# stop on any unhandled error:
set -e

#--------------------------------------------------------------------------

if [ "$1" != "--reextract" -a "$1" != "--compile" ] ; then
    echo "Usage: $0 [ --reextract | --compile ] LANG-ID"
    echo ""
    echo "Examples: "
    echo "    $0 --reextract de_DE"
    echo "    $0 --compile de_DE"
    exit 1
fi

Action="$1"
if [ -z "$2" ] ; then
    echo "LANG-ID must be specified, try '--help' for help on options"
    exit 1
fi
LangId="$2"
shift 2

#------------------------------------------------------------------------

reextract_with_id()
{
    LangId="$1"
    shift

    XgettextArgs="-j --omit-header -C -n -k_"
    # re-extract into .po file:
    echo "-- extracting to src/msg/WxExtLib-$LangId.po:"
    xgettext $XgettextArgs -o "src/msg/WxExtLib-$LangId.po" \
        `echo src/*.{h,cpp} | tr " " "\n" | grep -v WxExtLibTest.cpp`

    echo "-- extracting to src/msg/WxExtLibTest-$LangId.po:"
    xgettext $XgettextArgs -o "src/msg/WxExtLibTest-$LangId.po" \
        `echo src/*.{h,cpp} | tr " " "\n" | grep WxExtLibTest.cpp`
}

compile_with_id()
{
    LangId="$1"
    shift

    # compile .po to binary .mo files:
    BinaryMsgCatDir="build/messages/$LangId"
    mkdir -p "$BinaryMsgCatDir"
    echo "-- compiling $BinaryMsgCatDir/WxExtLib-$LangId.mo:"
    msgfmt --statistics --check -o "$BinaryMsgCatDir/WxExtLib.mo" "src/msg/WxExtLib-$LangId.po"
    echo "-- compiling $BinaryMsgCatDir/WxExtLibTest-$LangId.mo:"
    msgfmt --statistics --check -o "$BinaryMsgCatDir/WxExtLibTest.mo" "src/msg/WxExtLibTest-$LangId.po"
}

#------------------------------------------------------------------------

if [ "$Action" == "--reextract" ] ; then
    reextract_with_id "$LangId"
fi

if [ "$Action" == "--compile" ] ; then
    compile_with_id "$LangId"
fi

#------------------------------------------------------------------------
