
//-------------------------------------------------------------------------
// Author: Daniel Kps, created 2004.
// This file is public domain.
//-------------------------------------------------------------------------

#ifndef _INCLUDED_safecast_h  
#define _INCLUDED_safecast_h  

//-------------------------------------------------------------------------
// typesafer casts
//
// Idea:
// - centralize cast operators in functions, avoid
//   using C casts (or static_cast<>) directly in the rest of the code
// - provide overloads if necessary for required parameter types
//   (the right overloaded function should be selected automatically
//   by the compiler if available, if not, the compiler should give
//   an error) - a change of a parameter by the calling code to a greater 
//   value range should be detected
// - note that since the C++ overload mechanism only considers parameters
//   (not the function's return value), a (polymorph) return value must 
//   be returned using a non-const parameter reference (or maybe pointer) 
//   (cf. cast_assign())
//
// Notes:
// - this is experimental
//
//-------------------------------------------------------------------------

inline bool cast_is_equal(unsigned int LeftUInt, int RightInt)
{
    return LeftUInt == (unsigned int) RightInt;
}

inline bool cast_is_not_equal(unsigned int LeftUInt, int RightInt)
{
    return LeftUInt != (unsigned int) RightInt;
}

inline bool cast_is_smaller(int LeftInt, unsigned int RightUInt)
{
    return ((unsigned int) LeftInt) < RightUInt;
}

inline bool cast_is_equal_smaller(int LeftInt, unsigned int RightUInt)
{
    return ((unsigned int) LeftInt) <= RightUInt;
}

inline bool cast_is_greater(unsigned int LeftUInt, int RightInt)
{
    return LeftUInt > (unsigned int) RightInt;
}

inline void  cast_assign (int & Int, double Double)
{
    Int = (int) Double;
}

//-------------------------------------------------------------------------

#endif
