
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxWidgetsExtensions library 0.7.1
-----------------------------

COPYRIGHT NOTICE:

WxWidgetsExtensions library Copyright (c) 2003, 2004 Daniel Kps.

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxWidgetsExtensions library Copyright notice

-------------------------------------------------------------------------
*/

#ifndef _INCLUDED_WxMisc_h
#define _INCLUDED_WxMisc_h

#ifdef __WIN32__
#define M_MinimalTimeInterval_UseGetTickCount
#endif

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!defined(M_NoPragmaInterface))
#   pragma interface "WxMisc.h"
#endif

#ifndef WX_PRECOMP
#   include <wx/longlong.h>
#   include <wx/gdicmn.h>
#   include <wx/dynarray.h>
#   include <wx/event.h>
// HACK to avoid error "base class `wxWindow' has incomplete type": include
// something which includes the necessary header files
#   include <wx/stattext.h>
#ifndef M_MinimalTimeInterval_UseGetTickCount
#   include <wx/timer.h>
#endif
#endif

#include <wx/image.h>

#include <wx/datetime.h>
#include <wx/html/htmltag.h>
#include <wx/html/htmlwin.h>
#include <wx/textctrl.h>

#include <wx/brush.h> // for class definition of wxBrush
#include <wx/dcclient.h>

#if defined(__WXMSW__)
#   include <windows.h> // WARN may not be the right include place here
// #   include <wx/msw/dibutils.h> // commented out for wxWindows 2.5.2

// NOTE
// for wxWindows 2.5.2, dibutils.h disappeared so we provide an own
// HDIB definition (now called WXHDIB for consistency with WXHWND etc.)
typedef HGLOBAL WXHDIB;

#endif

//-------------------------------------------------------------------------


#ifndef WX_DEFINE_ARRAY_PTR
// under wxWindows 2.5.2, WX_DEFINE_ARRAY_PTR should be used, but it
// doesn't seem to be available under wxWindows 2.4.1
#   define WX_DEFINE_ARRAY_PTR WX_DEFINE_ARRAY
#endif


//-------------------------------------------------------------------------

#ifndef for_once
#define for_once  for (int _for_once___ ## __LINE__=0; _for_once___ ## __LINE__ < 1; ++ _for_once___ ## __LINE__)
#endif

//-------------------------------------------------------------------------
// wxMinimalTimeInterval
//
// Alternative implementations - and their problems:
// 0) wxStopWatch - timer overflow (calls wxLongLong.GetLo(), 
//    uses wxGetLocalTimeMillis(), same problems as with wxGetLocalTimeMillis())
// 1) wxGetLocalTimeMillis() - problem after adjusting the system clock (e.g. under Win98SE),
//    but quasi no timer overflow (wxLongLong is used)
// 2) ::GetTickCount() (Win32) - timer overflow after about 48 hours
// 3) ::timeGetTime() (Win32, winmm.lib) - timer overflow after about 48 hours
//
// Now done above where headers are included:
// #ifdef __WIN32__
// #    define M_MinimalTimeInterval_UseGetTickCount
// #endif

class wxMinimalTimeInterval
{
 public:
    wxMinimalTimeInterval ();
    
    void setMinimalTimeInterval (long MinimalTimeIntervalMS);

    void setBegin ();
    bool check ();

 private:
#ifdef M_MinimalTimeInterval_UseGetTickCount
    DWORD m_BeginUpTimeMS;
#else
    // wxStopWatch m_StopWatch;
    wxLongLong m_BeginTimeMSLongLong;
#endif
    long m_MinimalTimeIntervalMS;
    bool m_IsInitialized;
};

//-------------------------------------------------------------------------

// convertAsciiToHtml(): useful when generating HTML code: will escape the
// characters '<', '>', '"' (quotation mark) and '&' to their 
// HTML entities '&lt;', '&gt;', '&quot;' and '&amp;', respectively
// (If this escaping isn't done, syntactically incorrect HTML code may
// result).
//
// NOTE translation of ISO 8859-1/Latin-1 specific characters (128-255) 
// (e.g. umlauts, accented characters etc.) is not needed if we specify 
// the ISO Latin-1 encoding/charset in the HTML header - example:
// <head>
//   ...
//   <meta http-equiv="content-type" content="text/html; charset=iso-8559-1">
//   ...
// </head>
// If no charset was specified, possibly the (system) default charset is used.
// Translation of characters (128-255) (for all different charsets) remains 
// as a to-do, however.

void convertAsciiToHtml (const char * AsciiCharPtr, wxString & HtmlString,
                         bool IsTranslateNewlines = FALSE);
wxString convertAsciiToHtml (const char * AsciiStringCharPtr,
                             bool IsTranslateNewlines = FALSE);

wxString formatColourToHtmlParam (const wxColour & Colour);

//-------------------------------------------------------------------------

// get double parameter independent of the locale setting(for restrictions, see
// comments in the implementation of parseDoubleFromAnyLocaleString())
bool getHtmlTagParamAsDouble (const wxHtmlTag & HtmlTag,
                              const wxString & ParamNameString, double * Double);

// parseDoubleFromAnyLocaleString():
// - get double from a string in current locale or C locale (this is possibly
//   useful if both variants were mixed for whatever reason)
// Restrictions:
// - currently only accepts ',' or '.' as decimal point separator character
// - currently no thousand-separator is supported
// - for details, see comments in the implementation of the function
// TODO:
// - make a test print of known double value to determine the decimal point
//   character for the current locale
// - rename the function - the name parseDoubleFromAnyLocaleString() is wrong
bool parseDoubleFromAnyLocaleString (const wxString & InputValueString, double * Double);

//-------------------------------------------------------------------------

// getDecomposedDateFormatString()
// - return decomposed format string according to current locale setting
// - example: when called with "%#x", the result may be "%a, %d %B %Y"
// implementation notes:
// - this uses a sample date to infer the decomposed format string
// - (there is no standard or OS specific function for this as it seems)
void getDecomposedDateFormatString (const wxString & InputFormatString,
                                    wxString & DecomposedDateFormatString);

//-------------------------------------------------------------------------

// formatDate()
// TODO
// - integrate into wxDateTime
void formatDate (const wxDateTime & DateTime, wxString & String,
                 bool IsLongFormat = TRUE);

/*
 use the following fix for a bug in wxDateTime::GetWeekDayName():
    // FIX (probably all wxWindows versions, problem verified with 2.4.1, 2.5.2)
    // tm.tm_mday = 28; is not good because for wday >= Wed
    // the day will become invalid (e.g. 31.11.99) and CallStrftime
    // won't return the right thing - so use 21 (seven days before)
    // instead
    tm.tm_mday = 21;
    tm.tm_mon = Nov;
    tm.tm_year = 99;
*/

// parseDate()
// - will try to parse date in short, long (alternative) and ISO 8601 date format 
// Notes
// - parsing in short date format is tried with 2-digit and 4-digit year
// - parsing in long date format is tried with and without weekday name
// - therefore, five different format strings are tried
// - the short and long (alternative) date format are according the 
//   the current locale setting
// possible improvements:
// - allow abbreviations for month name and weekday name (could also
//   add a flag to allow abbreviations to wxDateTime class)
// - allow 2-digit years in long/alternative format
// - allow spaces to be used (implement in wxDateTime::ParseFormat())
// - check for consistency of weekday with date (weekday
//   is parsed but ignored) (fix it in wxDateTime::ParseFormat())
// TODO
// - integrate into wxDateTime
bool parseDate (const wxString & String, wxDateTime & DateTime);

// TODO:
// add support for time and date-time formatting and parsing

//-------------------------------------------------------------------------

// wxMessageFormatter/wxFormat/wxFormatMessage:
// provide type-safe string formatting similar to printf 
// - parameters are added with the "%" operator
// - format string refers to parameters with %N or %{N} (with N 
//   being the N-th parameter added)
// - "%+" may be used to refer to "next" parameter
// Notes:
// - Currently, type-safety may be breached by specifying wrong
//   printf-format strings to wxFormat objects, but this string 
//   is usually changed by the programmer only (not internationalized)
//   (to do: add type-compatibility checks).
// - This approach allows reordering of parameters in the output 
//   which might be useful or even required when translating 
//   messages into other languages.
// - Unlike with the usual with C++-stream operators "<<", 
//   the message string must not be split up into several sub-strings
//   which makes it all possibly better readable.
// - wxFormat may be used to set up output precision as usual, 
//   but for safety reasons currently this cannot be done in the
//   message format string (which might be edited by translators 
//   externally)
// - For the %N syntax, N must be a single digit. This means that
//   %23 prints parameter two, followed by the digit 'three'.
//   (%23 is identical to %{2}3). However, %{23} can be used to
//   refer parameter '23'.
//   It was opted to use this syntax because parameter numbers >= 10
//   are probably rarely used, so normally the %N syntax is sufficient.
// - The idea of using the percent (%) operator has been borrowed
//   from boost::format which also provides printf-like formatting
//   in a type-safe manner, but heavily depends on C++-templates
// - The "%+" syntax can also be used to ease conversion of printf
//   format strings: just replace all occurences of "%d", "%s" etc. 
//   with "%+".
// Possible improvements:
// - avoid allocations of wxStrings by pre-calculating the resulting
//   string size and by using static buffers for intermediate
//   number output buffers
// TODO
// - test with older compilers if overloads work as expected, also test
//   with latest compilers
// TESTED
// - GCC 2.95.2, MSVC 6, DMC 8.40, BCC 5.5.1

// possible (thinkable) shorthands for wxFormat: "wxF", "_F", "F"
// typedef wxFormat wxF;

class wxFormat
{
public:
    wxFormat (int Integer);
    wxFormat (const char * PrintfFormatString, int Integer);
    wxFormat (long Long);
    wxFormat (const char * PrintfFormatString, long Long);
    wxFormat (const double & Double);
    wxFormat (const char * PrintfFormatString, const double & Double);
    wxFormat (const char * CharPtr);
    wxFormat (const char * PrintfFormatString, const char * CharPtr);
    wxFormat (const wxString & String);
    wxFormat (const char * PrintfFormatString, const wxString & String);
    // TODO: add signed/unsigned overloads, overload for char-types,
    // wxDateTime (for current locale)

    virtual ~wxFormat ();

    void init (const char * PrintfFormatString, int Integer);
    void init (const char * PrintfFormatString, long Long);
    void init (const char * PrintfFormatString, const double & Double);
    void init (const char * PrintfFormatString, const char * CharPtr);
    void init (const char * PrintfFormatString, const wxString & String);

    // interface draft which might be used for optimization purposes:
    // virtual int getPrintCharCount () const;
    // virtual void printInto (wxString & String, int FirstPos, int Count) const;
    virtual void appendTo (wxString & String) const;
    // virtual wxString print ();

private:
    wxString m_FormattedValueString;
};

WX_DEFINE_ARRAY_PTR(wxFormat *, wxFormatArray);

class wxMessageFormatter;

//-------------------------------------------------------------------------

// helper functions to ease transition to use wxMessageFormatter:
// - Example:
//   use 
//       wxFormatMessage ("TEXT %1 TEXT %2", Int, Double)
//   instead of 
//       wxString::Format ("TEXT %d TEXT %f", Int, Double)
//
wxString wxFormatMessage (const char * FormatString);
wxString wxFormatMessage (const char * FormatString, const wxFormat & Param1Format);
wxString wxFormatMessage (const char * FormatString, 
                          const wxFormat & Param1Format,
                          const wxFormat & Param2Format);
wxString wxFormatMessage (const char * FormatString, 
                          const wxFormat & Param1Format,
                          const wxFormat & Param2Format,
                          const wxFormat & Param3Format);
wxString wxFormatMessage (const char * FormatString, 
                          const wxFormat & Param1Format,
                          const wxFormat & Param2Format,
                          const wxFormat & Param3Format,
                          const wxFormat & Param4Format);
wxString wxFormatMessage (const char * FormatString, 
                          const wxFormat & Param1Format,
                          const wxFormat & Param2Format,
                          const wxFormat & Param3Format,
                          const wxFormat & Param4Format,
                          const wxFormat & Param5Format);
// add overloads with more parameters if required...

//-------------------------------------------------------------------------

// MessageFormatter will return a wxMessageFormatter object
wxMessageFormatter MessageFormatter (const char * FormatString);

// helper function
wxString & operator+= (wxString & String, wxMessageFormatter & MessageFormatter);

class wxMessageFormatter
{
public:
    wxMessageFormatter (const char * FormatString);
    ~wxMessageFormatter ();

    wxMessageFormatter & operator% (int Integer);
    wxMessageFormatter & operator% (long Long);
    wxMessageFormatter & operator% (const double & Double);
    wxMessageFormatter & operator% (const char * CharPtr);
    wxMessageFormatter & operator% (const wxString & String);
    // NOTE: maybe, the above overloads are not required since
    // wxFormat class constructor has also the required overloads - maybe
    // these functions even cause problems together with the overloads
    // in the wxFormat constructor on some compilers
    wxMessageFormatter & operator% (const wxFormat & Format);
    wxMessageFormatter & operator% (wxFormat * FormatPtr);
    // TODO: add signed/unsigned overloads, overload for char-types,
    // wxDateTime

    wxMessageFormatter & addFormat (wxFormat * FormatPtr);

    // format() does the formatting work
    void format ();

    // format string and return reference to it:
    const wxString & getRef ();
    operator const wxString & ();
    operator const char *();

    // format string and return result or append result to other string
    void appendTo (wxString & String);
    void assignTo (wxString & String);

protected:
    wxString m_FormatString;
    wxFormatArray m_FormatArray;

    wxString m_OutputString;
};

//-------------------------------------------------------------------------

// fits object with ObjectSize extensions into FrameRect and returns
// result into FittedObjectRect. AlignmentFlags can be a combination of
// wxALIGN_CENTER_HORIZONTAL and wxALIGN_CENTER_VERTICAL
void fitInside (const wxRect & FrameRect, const wxSize & ObjectSize, 
                wxRect & FittedObjectRect, int AlignmentFlags);

//-------------------------------------------------------------------------

// NOTE semantics not well defined for Win16: there, some function like
// releaseDataResource() or copying the data block would be required
//
// This function is similar to wxLoadUserResource(), but it is intended
// to handle arbitrary data blocks; not just strings
//
// NOTE the 'ResourceTypeString' parameter must be a normal char pointer
// (not 'const wxString &'), because the RT_* definitions may not 
// be pointers to valid memory
bool loadDataResource (const wxString & ResourceNameString, 
                       const char * ResourceTypeString,
                       unsigned char ** DataPtr, size_t * DataSize);

//-------------------------------------------------------------------------

bool loadImageFromMemory (const unsigned char * ImageData, size_t ImageDataSize,
                          wxImage & Image);
bool loadBitmapFromMemory (const unsigned char * ImageData, size_t ImageDataSize,
                           wxBitmap ** Bitmap);

#if defined(__WXMSW__)

//-------------------------------------------------------------------------
// to put e.g. a PNG type image as it is (raw) into a resource, use e.g.:
//    IDR_About      RCDATA  DISCARDABLE     "images/About.png"
// and then just call:
//    wxBitmap AboutBitmap;
//    loadBitmapFromResource ("IDR_About", & AboutBitmap);
bool loadImageFromResource (const wxString & ImageDataResourceNameString, 
                            wxImage & Image);
bool loadBitmapFromResource (const wxString & ImageDataResourceNameString, 
                             wxBitmap ** Bitmap);

#endif // defined(__WXMSW__)

//-------------------------------------------------------------------------

// doTextLineWrap
// - automatic line-break (wrap) using the font selected for the given DC
// - currently, line-break is possible only at character indices where
//   the input string contains a space (wxIsspace(char) used)
void doTextLineWrap (const wxString & InputString, 
                     int MaxLineWidth,
                     wxDC & DC,
                     wxString & ResultString);

void doTextLineWrap (const wxString & InputString, 
                     int MaxLineWidth,
                     wxWindow * Window,
                     wxString & ResultString);

//-------------------------------------------------------------------------

// wxMultiLineText:
// - use best suited control for output of possibly longer texts
//   (selected control depends on the used platform)
// - control implementations that can be used are wxTextCtrl and wxHtmlWindow
// - on platforms where wxTextCtrl doesn't support wrapping of long lines,
//   doTextLineWrap() is called automatically when calling setText()
// Rationale:
// - wxTextCtrl is under some platforms quite restricted:
//   - may not support wrapping of long lines (situation will change with 
//     wxWindows 2.6.0)
//   - may not support setting background and text colour
//   - under Lesstif: may not support setting a different font or font size
//   - may not support copying to clipboard (copying to clipboard works
//     for Motif/Lesstif, MSW, GTK)
// - wxHtmlWindow has everywhere the same functionality, but also
//   has some restrictions:
//   - copying to clipboard is not possible (situation will change with
//     wxWindows 2.6.0)
//   - probably lower performance than wxTextCtrl
//   (- might not have been compiled into the wxWindows library)
class wxMultiLineText
{
public:
    enum EMultiLineTextStyle
    {
      wxFORCE_TEXTCTRL    = 0x0001,
      wxFORCE_HTMLWINDOW  = 0x0002,

      wxHTML_MODE = 0x0010
    };

    wxMultiLineText ();
    // CtrlStyle can be: wxBORDER_NONE, wxSIMPLE_BORDER, wxSUNKEN_BORDER
    void create (wxWindow * ParentWindow,
                 int WindowIdent,
                 int CtrlStyle,
                 const wxSize & MinSize,
                 int MultiLineTextStyle = 0);

    // wxMultiLineText::getWindow() -> SetBackgroundColour()/SetForegroundColour()
    // may be used _before_ calling setText() is used - for wxHtmlWindow, suitable HTML 
    // code is generated to use those colors)
    // - if the wxHTML_MODE flag is specified, String must be in HTML
    //   (but without the <html>, <body> tags - they are added automatically)
    void setText (const wxString & String);
    wxString getHtmlTextString ();

    wxWindow * getWindow ();
    wxTextCtrl * getTextCtrl ();
    wxStaticText * getStaticText ();
    wxHtmlWindow * getHtmlWindow ();
private:
    long m_MultiLineTextStyle;

    wxTextCtrl * m_TextCtrl;
    wxStaticText * m_StaticText; // never used - may not support scroll bar
    wxHtmlWindow * m_HtmlWindow;
    wxString m_HtmlTextString; // used only if type is wxHtmlWindow
};

//-------------------------------------------------------------------------

// wxColourBarWindow:
// - a control/rectangle filled with the specified colour
class wxColourBarWindow : public wxWindow
{
  public:
    wxColourBarWindow ();
    wxColourBarWindow (wxWindow * ParentWindow, int ControlIdent,
                       const wxColour & Colour,
                       const wxPoint & Position = wxDefaultPosition, 
                       const wxSize & Size = wxDefaultSize,
                       long Style = 0, const wxString& Name = wxPanelNameStr);

    void setBrush (const wxBrush & Brush);

    void OnEraseBackground (wxEraseEvent & EraseEvent);
    void OnPaint (wxPaintEvent & PaintEvent);

    wxBrush m_Brush;

  private:
    DECLARE_DYNAMIC_CLASS (wxColourBarWindow)
    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxStatusMessageTarget;

// wxItemWindow:
// A control which can be selected and focused. The selection and focus
// states are visualized by drawing colored rectangles around the
// actual item drawing area/rectangle. This kind of selection and focus
// visualization may be useful for e.g. images (which may not look nice
// when inverted, blue-ified etc.).
// 
// Note that the focus state is (intentionally) independent of the 
// the wxWindow focus.
// 
// Currently this class doesn't handle selection and focus state changes 
// from input events itself. However, a derived class may define e.g. 
// an OnMouseEvent() handler to handle these state changes.
//
class wxItemWindow : public wxWindow
{
  public:
    wxItemWindow ();
    wxItemWindow (wxWindow * ParentWindow, int ControlIdent,
                      const wxPoint & Position = wxDefaultPosition, 
                      const wxSize & Size = wxDefaultSize,
                      bool IsSelectable = FALSE, bool IsFocusable = FALSE,
                      wxStatusMessageTarget * StatusMessageTarget = NULL,
                      long Style = 0, const wxString& Name = wxPanelNameStr);

    void init ();

    void setFocusedBackgroundBrush (const wxBrush & Brush);

    void OnEraseBackground (wxEraseEvent & EraseEvent);
    void OnPaint (wxPaintEvent & PaintEvent);

    virtual void handleItemPaint (wxPaintDC & PaintDC,
                                  const wxRect & ItemRect,
                                  const wxBrush * BackgroundBrush = NULL);

    wxStatusMessageTarget * m_StatusMessageTarget;
    bool m_IsSelectable;
    bool m_IsSelected;
    bool m_IsFocusable;
    bool m_IsFocused;
    bool m_IsBorder;

    bool m_IsUsingFocusedBackgroundBrush;
    wxBrush m_FocusedBackgroundBrush;

  private:
    DECLARE_DYNAMIC_CLASS (wxItemWindow)
    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

// NOTE EResolutionIdent is not yet used
enum EResolutionIdent
{
    FullResolution,
    ThumbnailResolution
};

#if defined(__WXMSW__)

// currently MSW only
class wxImageProxy
{
  public:
    wxImageProxy ();
    ~wxImageProxy ();

    virtual void getDIB (EResolutionIdent ResolutionIdent, WXHDIB & DIB) = 0;
    virtual void draw (wxDC & DC, int X, int Y, int Width, int Height,
                       EResolutionIdent ResolutionIdent,
                       const wxBrush * BackgroundBrush = NULL);

    virtual void updateFromFile (bool IsReadingForced = FALSE) = 0;
    virtual void discard ();

    //-------------------------------------------------------------------------
    virtual void loadFromFile (const wxString & PathString) = 0;
    virtual void freeDIB ();

    WXHDIB m_DIBFromFile;
};

#endif // defined(__WXMSW__)


//-------------------------------------------------------------------------

#if defined(__WXMSW__)

// wxBitmapPaintHelper:
// - facilitate dealing with memory DCs under MSW (create a compatible DC,
//   automatic deselection of image from DC)
//
// currently MSW only:
class wxBitmapPaintHelper
{
public:
    wxBitmapPaintHelper (const wxString & ResourceIdentString);
    wxBitmapPaintHelper (const wxString & ResourceIdentString, HDC PaintDCHandle);
    wxBitmapPaintHelper (wxBitmap & Bitmap);
    wxBitmapPaintHelper (wxBitmap & Bitmap, HDC PaintDCHandle);
    wxBitmapPaintHelper (int Width, int Height);
    wxBitmapPaintHelper (int Width, int Height, HDC PaintDCHandle);
    ~wxBitmapPaintHelper ();

    void createBitmap (int Width, int Height);
    void setBitmap (wxBitmap & Bitmap);
    void loadBitmap (const wxString & ResourceIdent);
    void prepare (HDC PaintDCHandle);
    void release ();

    int getWidth ();
    int getHeight ();

    wxBitmap m_Bitmap;
    wxBitmap * m_BitmapRef;
    HDC m_MemoryDCHandle;
    HBITMAP m_BitmapHandle;
    HBITMAP m_PreviousBitmapHandle;
};

#endif // defined(__WXMSW__)

//-------------------------------------------------------------------------

#if defined(__WXMSW__)

// DIB only
int getActualUsedColorCount (BITMAPINFO * BitmapInfo);
void drawDIBFitted (wxDC & WxDC, int X, int Y, int Width, int Height,
                    WXHDIB DIBHandle,
                    const wxBrush * BackgroundBrush = NULL);

#endif // defined(__WXMSW__)

//-------------------------------------------------------------------------

// WxBeep
// - emit a beep for about the given number of milli-seconds
void WxBeep (int MilliSeconds);

//-------------------------------------------------------------------------

// doRotateMirrorCoord() - rotates and mirrors points (x,y) around the
// rotation center whose coordinates determine the mirroring axes
// Notes:
// 1) RotationAngle must be either 0, 90, 180 or 270 - otherwise the 
//    behavior is undefined
// 2) Vertical mirroring axis is a horizontal line at CentrePoint.y,
//    horizontal mirroring axis is a vertical line at CentrePoint.y
// 3) Order of application: mirroring is applied after rotation, 
//    not before
void doRotateMirrorCoord (int RotationAngle, 
                          bool IsHorizontallyMirrored, 
                          bool IsVerticallyMirrored,
                          const wxPoint & CentrePoint,
                          const wxPoint & InputPoint,
                          wxPoint & OutputPoint,
                          bool IsRotateCenter = FALSE);

//-------------------------------------------------------------------------

class wxRotationMirrorState
{
public:
    wxRotationMirrorState();
    ~wxRotationMirrorState();

    void reset ();

    // maybe just one mirroring axis would be sufficient
    void mirror (bool IsHorizontallyMirrored, bool IsVerticallyMirrored);
    void rotate (int RotationAngle);
    void handleMirrorRotation(int RotationAngle,
                              bool & IsHorizontallyMirrored,
                              bool & IsVerticallyMirrored);

    void getNormalizedState (int & RotationAngle, 
                             bool & IsHorizontallyMirrored, 
                             bool & IsVerticallyMirrored);

    void assign (const wxRotationMirrorState & RHSRotationMirrorState);
    void subtract (const wxRotationMirrorState & FirstRotationMirrorState,
                   const wxRotationMirrorState & SecondRotationMirrorState);

    bool m_IsUpdateRequired;

    bool m_IsHorizontallyMirrored;
    bool m_IsVerticallyMirrored;
    int m_RotationAngle;
};

//-------------------------------------------------------------------------

#ifdef M_IsFilteredDIBEnabled

// try to forward-declare ImageMagick's image and ExceptionInfo:
extern "C"
{
  struct _Image; // wxImageMagick image
  struct _ExceptionInfo; // wxImageMagick ExceptionInfo
}

// WX_DECLARE_EXPORTED_BASEARRAY(char, wxBaseArrayChar);
// _WX_DEFINE_BASEARRAY (char, wxBaseArrayChar);

// WX_DECLARE_BASEARRAY(unsigned char, wxBaseArrayUChar);
// _WX_DEFINE_BASEARRAY (unsigned char, wxBaseArrayUChar);

WX_DEFINE_ARRAY_LONG(long, wxFilteredDIBColorPaletteArray);

#if defined(__WXMSW__)

// currently DIB only:

// wxFilteredDIB:
// - input and output image format is DIB
// - filtering may be realized by applying an ImageMagick filter
// - rotation is done in DIB format and must be handled by a derived class
// - wxFilteredDIB will manage required conversions (e.g. convert from a 
//   palette-based DIB to 32 Bit color ImageMagick if any filter is to 
//   be applied)
// - for palette-based images, color adjustment is realized by modifying the
//   palette in-place which is much faster than modifying all pixels - the
//   old palette is stored for a later undo or a new modification
// - image rotation must be 0, 90, 180 or 270 degree - if only the rotation
//   angle (or mirroring) has changed since last filtering, 
//   rotation/mirroring will be made relative to the last result 
//   (improves performance)
// Notes:
// - ImageMagick's image type also supports palette-based images, but
//   many filters will only work for 32 Bit images (or 64 Bit when using
//   16-Bit color channel resolution)
// - linking of the ImageMagick core library (the C-API) is required
//   to use wxFilteredDIB
// - the files 'ImageMagickExtensions.{h,c}' are required for DIB <-> 
//   ImageMagick image and color depth conversions
// Todo:
// - implement better color adjustment function
// - implement DIB rotation functions (or look for existing code)
// - check new wxDIB class (new since wxWidgets 2.5.?)
class wxFilteredDIB
{
public:
    wxFilteredDIB ();
    ~wxFilteredDIB ();

    // color adjustment
    // Brightness [-1.0, 1.0], Contrast [-1.0, 1.0]
    void setBrightnessContrast (double Brightness, double Contrast);
    void setColorAdjustment (double RedGamma, double GreenGamma,
                             double BlueGamma);
    void setInversion (bool IsInverted);

    // palette based color adjustment
    // virtual void setPaletteBasedColorAdjustmentEnabled (bool IsEnable);
    virtual void rememberOriginalPalette ();
    virtual void rememberModifiedPalette ();
    virtual void setOriginalPaletteIntoSourceImage ();
    virtual void setModifiedPaletteIntoSourceImage ();
    bool rememberPalette (WXHDIB DIBHandle,
                          wxFilteredDIBColorPaletteArray & ColorPaletteByteArray);
    bool restorePalette (WXHDIB DIBHandle,
                         wxFilteredDIBColorPaletteArray & ColorPaletteByteArray);

    // filtering related
    virtual void setIsFilteringModified ();
    virtual void setIsImageMagickFilteringRequired (bool IsRequired);

    // rotation and mirroring
    virtual void resetRotationMirror ();
    virtual void rotate (int RotationAngle);
    virtual void mirror (bool IsHorizontallyMirrored, bool IsVerticallyMirrored);

    // setting source image, obtaining result image
    virtual void setSourceImage (const WXHDIB & SourceDIBHandle);
    virtual void getResultImage (WXHDIB & ResultDIBHandle);
    virtual void setIsOwningSourceImage (bool IsOwningSourceImage);
    virtual void setIsOwningResultImage (bool IsOwningResultImage);
    void freeSourceImage();
    void freeResultImage();

    // updating result image
    virtual void updateResultImage ();
    virtual void handleResultImageChanged ();

    // handler which do actual image modifications/transformations
    virtual void applyColorAdjustment (struct _Image ** MagickImagePtrPtr,
                                       struct _ExceptionInfo * exceptionInfo);
    virtual void applyImageMagickFiltering (struct _Image ** MagickImagePtrPtr,
                                            struct _ExceptionInfo * exceptionInfo);
    virtual void applyImageRotationMirroring (int RotationAngle,
                                              bool IsHorizontallyMirrored,
                                              bool IsVerticallyMirrored,
                                              WXHDIB & InputDIBHandle,
                                              WXHDIB & OutputDIBHandle,
                                              bool & IsNewOutputDIBHandle);

    virtual WXHDIB applyDIBRotation (WXHDIB InputDIBHandle, int RotationAngle) = 0;
    virtual WXHDIB applyDIBMirroring (WXHDIB InputDIBHandle, bool IsVertically) = 0;

protected:
    // color adjustment
    double m_Brightness;
    double m_Contrast;
    double m_RedGamma;
    double m_GreenGamma;
    double m_BlueGamma;
    bool m_IsInverted;
    bool m_IsColorAdjustmentModified;
    void levelGamma (double & Gamma);

    // palette based color adjustment
    bool m_IsPaletteBasedColorAdjustmentEnabled;
    wxFilteredDIBColorPaletteArray m_OriginalColorPaletteByteArray;
    bool m_IsOriginalColorPaletteRemembered;
    wxFilteredDIBColorPaletteArray m_ModifiedColorPaletteByteArray;
    bool m_IsModifiedColorPaletteRemembered;

    // filtering related
    bool m_IsImageMagickFilteringRequired;
    bool m_IsFilteringModified;
    int m_FilteredDIBBitsPerPixel;

    // rotation and mirroring
    wxRotationMirrorState m_PreviousRotationMirrorState;
    wxRotationMirrorState m_RotationMirrorState;

    // source image, result image handling
    void freeImage (WXHDIB & DIBHandle);
    WXHDIB m_SourceDIBHandle;
    bool m_IsOwningSourceImage;
    WXHDIB m_ResultDIBHandle;
    bool m_IsOwningResultImage;
};

#endif // defined(__WXMSW__)

#endif

//-------------------------------------------------------------------------

// wxChoiceManager:
// - manages selections from a set of source items into
//   choice items
class wxChoiceManager
{
public:
    wxChoiceManager ();

    // high-level user interface interaction
    void OnSelect ();
    void OnDeselect ();
    void OnClearSelection ();
    void OnSourceLeftMouseButton (int SourceItemIndex);
    void OnSourceRightMouseButton (int SourceItemIndex);
    void OnChoiceLeftMouseButton (int ChoiceItemIndex);
    void OnChoiceRightMouseButton (int ChoiceItemIndex);

    //-------------------------------------------------------------------------
    // selection and focus managment
    // almost all functions accept '-1' as notion of 'no document' or
    // 'no item'

    void handleSelection (bool IsNewlyFocused, int ChoiceItemIndex,
                          int SourceItemIndex);

    void selectIntoChoice (int ChoiceItemIndex, int SourceItemIndex,
                            bool IsUpdateChoiceView = TRUE);
    void deselectFromChoice (int ChoiceItemIndex, bool IsUpdateChoiceView = TRUE);

    // focus management
    int getSourceFocus();
    void setSourceFocus (int SourceItemIndex);
    virtual void updateSourceFocus (int NewFocusedItemIndex, bool IsFocus) = 0;
    int getChoiceFocus();
    void setChoiceFocus (int ChoiceItemIndex);
    virtual void updateChoiceFocus (int NewFocusedItemIndex, bool IsFocus) = 0;

    // this should be kept in sync with m_IsFocused of e.g. wxItemWindow
    int m_FocusedChoiceItemIndex;
    int m_FocusedSourceItemIndex;

    // selection managment
    void redoSelections ();
    void setSelection (int SourceItemIndex, bool IsSelect);
    virtual void updateSelection (int SourceItemIndex, bool IsSelect) = 0;

    virtual void updateChoiceView () = 0;

    // functions for mapping from item index into document ident or vice
    // versa
    virtual int getSourceDocument (int SourceItemIndex) = 0;
    virtual int getChoiceDocument (int ChoiceItemIndex) = 0;
    virtual int getSourceItemCount () = 0;
    virtual int getChoiceItemCount () = 0;

    virtual int findSourceItemIndex (int DocumentIdent);
    virtual int findChoiceItemIndex (int DocumentIdent);

    virtual void insertChoiceDocument (int DocumentIdent, int ChoiceItemIndex, int Count) = 0;
    virtual void setChoiceDocument (int ChoiceItemIndex, int DocumentIdent) = 0;
};

//-------------------------------------------------------------------------

#endif
