
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxWidgetsExtensions library 0.7.1
-----------------------------

COPYRIGHT NOTICE:

WxWidgetsExtensions library Copyright (c) 2003, 2004 Daniel Kps.

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxWidgetsExtensions library Copyright notice

-------------------------------------------------------------------------
*/

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
    #pragma implementation "WxExtDialog.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include "WxExtDialog.h"
#include "WxMisc.h"

#include "TextCtrlSliderPairValidators.h"

#include <math.h>

#include "safecast.h"

#include <wx/html/htmprint.h>

//=========================================================================

#ifdef M_IsMFCCompatibility

wxWindow * MSWCreateChildWindowForMFCFrame (CWnd * ParentWindow)
{
    //-------------------------------------------------------------------------
    // creating a wxFrame has following disadvantages:
    // - non-modal dialogs are hidden if the MFC main frame is activated
    // - wxDialogs will have an own icon in the task-switch window
    // - when activating an other application and switching back to this
    //   application, modal and non-modal dialogs having the wxFrame
    //   as parent are hidden
    //
    //  wxWindow * Window = new wxFrame (NULL, -1, "Dummy Frame", 
    //                                   wxPoint(10, 10), wxSize(300, 300),
    //                                   wxFRAME_NO_TASKBAR); // wxDEFAULT_FRAME_STYLE

    //-------------------------------------------------------------------------
    // create a normal MFC child window for the specified parent:
    CWnd * Wnd = new CWnd();
    RECT Rect = { 0, 0, 100, 100 };
    Wnd -> Create (NULL, "Dummy Frame", 
                   WS_CHILD, 
                   Rect, 
                   ParentWindow,
                   NULL,
                   NULL);

    WXHWND WxHwnd = Wnd != NULL ? (long) Wnd -> m_hWnd : 0;

    // make the MFC window wxWindow class compatible (this seems to work!)
    wxWindow * Window = new wxWindow ();
    if (Window)
    {
        Window -> SetEventHandler (Window);
        Window -> SetHWND (WxHwnd);
        Window -> SetId (-1);
        Window -> SubclassWin (WxHwnd);
        Window -> AdoptAttributesFromHWND ();
        Window -> SetupColours ();
    }

    return Window;
}

#endif

//=========================================================================

enum
{
#if defined(__WXMSW__)
    DefaultDialogFontSize = 8
#elif defined(__WXGTK__)
    DefaultDialogFontSize = 12
#elif defined(__WXX11__)
#   pragma message ("Please adjust DefaultDialogFontSize for your wxWindows port.")
    DefaultDialogFontSize = 12
#elif defined(__WXMOTIF__)
#   pragma message ("Please adjust DefaultDialogFontSize for your wxWindows port.")
    DefaultDialogFontSize = 12
#else
#   pragma message Please adjust DefaultDialogFontSize for your wxWindows port.
    DefaultDialogFontSize = 12
#endif
};

//-------------------------------------------------------------------------

BEGIN_EVENT_TABLE (wxExtDialog, wxDialog)
    EVT_TEXT  (wxID_ANY, wxExtDialog::OnTextCtrlChanged)
    EVT_COMMAND_SCROLL_ENDSCROLL (wxID_ANY, wxExtDialog::OnSliderCtrlChanged)
    EVT_RADIOBUTTON (wxID_ANY, wxExtDialog::OnRadioButtonSelected)
    EVT_RADIOBOX (wxID_ANY, wxExtDialog::OnRadioBoxSelected)
    EVT_CHECKBOX (wxID_ANY, wxExtDialog::OnCheckBoxSelected)
    EVT_COMBOBOX (wxID_ANY, wxExtDialog::OnComboBoxSelected)
    EVT_LISTBOX (wxID_ANY, wxExtDialog::OnListBoxSelected)
    EVT_CHOICE (wxID_ANY, wxExtDialog::OnChoiceCtrlSelected)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxExtDialog::wxExtDialog()
{
    initCWxDialog();

    setDialogZoom (1.);
}

wxExtDialog::wxExtDialog(wxWindow *parent, wxWindowID id,
                     const wxString& title,
                     const wxPoint& pos,
                     const wxSize& size,
                     long style,
                     const wxString& name)
  : wxDialog (parent, id, title, pos, size, style, name)
{
    initCWxDialog ();

    setDialogZoom (1.);
}

void wxExtDialog::initCWxDialog ()
{
    m_ZoomValue = 1.; 
    m_DialogZoomValue = 1.;
    m_DesktopReferenceSize = wxSize (-1, -1);
    m_BorderCompressionValue = 1.;

    m_DialogFontSize = DefaultDialogFontSize;
    m_DialogFontHeight = DefaultDialogFontSize;

    m_IsWatchedControlChangeNotification = FALSE;
    m_IsDialogInitialized = FALSE;
    m_StatusMessageTarget = NULL;
    // m_ErrorMessageMultiLineText = NULL;
}

wxExtDialog::~wxExtDialog()
{
    delete m_StatusMessageTarget;
    m_StatusMessageTarget = NULL;
}

//-------------------------------------------------------------------------

void wxExtDialog::InitDialog ()
{
    wxDialog::InitDialog ();
    m_IsDialogInitialized = TRUE;
}

//=========================================================================

#ifdef M_IsNonWxMainIntegration

wxWindow *wxExtDialog::FindSuitableParent() const
{
    wxWindow * ParentWindow = NULL;

#if 0
    // TODO: GetModalDialogList() should be a const function
    // HACK: cast away const from 'this' pointer to be able to use
    // GetModalDialogList()
    wxWindowList & ModalDialogList = ((wxDialog *) this) -> GetModalDialogList ();
    if (ModalDialogList.GetCount() > 0)
      {
        // TEST: if another modal dialog is shown, use this one as parent
        // (otherwise, no input is possible to any modal dialogs anymore
        // if another modal dialog is shown already, and the dialog is created 
        // only once)
        // (has not helped)
        // Finally, the problem was solved by calling new/Create() everytime
        // the dialog is shown modally. This way, the dialog gets the a correct
        // parent window automatically.
        wxWindowList::Node * LastWindowNode = ModalDialogList.GetLast();
        ParentWindow = LastWindowNode->GetData();
      }
    else
#endif
      {
        wxWindow * ParentWindow = wxDialog::FindSuitableParent();

        if (ParentWindow == NULL)
          {
            ParentWindow = wxTheApp->GetTopWindow();
            // we use this window even if it is not shown:
            // it is our special child window that has the MFC frame
            // as parent (wxDialog::FindSuitableParent() above will
            // return NULL because it is not shown)
          }
      }

    return ParentWindow;
}

#endif // M_IsNonWxMainIntegration

//-------------------------------------------------------------------------

#ifdef M_IsNonWxMainIntegration
#if defined(__WXMSW__)

void wxExtDialog::MSWEnableOtherWindows (bool IsEnable)
{
    // for MFC main window compatibility:
    AfxGetApp() -> EnableModeless (IsEnable);
    getMain().EnableWindow (IsEnable);
}

#endif // defined(__WXMSW__)
#endif

#if defined(__WXMSW__)
HWND wxExtDialog::MSWGetHandle()
{
    return (HWND) GetHWND();
}
#endif

//=========================================================================

int wxExtDialog::ShowModal ()
{
    Centre (wxBOTH);
    return wxDialog::ShowModal ();
}

//=========================================================================

wxSizer * wxExtDialog::addSpace (int Width, int Height, wxSizer * Sizer)
{
    if (Sizer != NULL)
      {
        Sizer -> Add (Width, Height);
      }

    return Sizer;
}

//-------------------------------------------------------------------------

wxButton * wxExtDialog::addButton (wxButton ** ButtonPtrPtr,
                                 wxWindowID ButtonId, 
                                 wxCommandEventFunction CommandEventFunction,
                                 const wxString& LabelString, 
                                 wxSizer * Sizer,
                                 const wxPoint& Position,
                                 const wxSize& Size,
                                 long Style, const wxValidator& Validator)
{
    wxButton * Button = NULL;

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultButtonSize);

    // to use wxBU_EXACTFIT, wxDefaultSize must be specifed as size
    if (Style & wxBU_EXACTFIT)
      UsedSize = wxDefaultSize;

    Button = new wxButton (this, ButtonId, LabelString, Position, UsedSize, 
                           Style, Validator);

    if (CommandEventFunction != (wxCommandEventFunction) NULL)
      this -> Connect (Button -> GetId(),
                       wxEVT_COMMAND_BUTTON_CLICKED,
                       (wxObjectEventFunction) (wxEventFunction) CommandEventFunction);

    if (Sizer != NULL)
      Sizer->Add (Button, 0, 0, _B(0));

    if (ButtonPtrPtr != NULL)
      *ButtonPtrPtr = Button;
    return Button;
}

//-------------------------------------------------------------------------

wxSizer * wxExtDialog::addCheckBoxWithLabel (wxCheckBox ** CheckBox,
             const wxString & LabelString, const wxValidator & Validator,
             int TextCtrlStyle, wxSizer * Sizer, bool IsLabelOnTheLeft)
{
    wxWindow *PanelWnd = this;

    if (Sizer == NULL)
      {
        Sizer = new wxBoxSizer (wxHORIZONTAL);
      }

    bool IsExtraLabelControl = TextCtrlStyle & wxTE_READONLY || IsLabelOnTheLeft;

    *CheckBox = new wxCheckBox (PanelWnd, -1, 
                                wxString (IsExtraLabelControl ? wxString("") : LabelString), 
                                // IsExtraLabelControl ? wxString("") : wxString(LabelString), 
                                wxDefaultPosition, wxDefaultSize, 0, Validator);
    wxStaticText * StaticText = NULL;

    if (TextCtrlStyle & wxTE_READONLY)
      {
        (*CheckBox) -> Enable (FALSE);
      }

    if (IsExtraLabelControl)
      {
        StaticText = new wxStaticText (PanelWnd, -1, LabelString);
      }

    if (! IsLabelOnTheLeft)
      {
        Sizer -> Add (*CheckBox, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, _B(5));
        if (IsExtraLabelControl)
            Sizer -> Add (StaticText, 0, wxLEFT|wxEXPAND|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, _B(5));
      }
    else
      {
        Sizer -> Add (StaticText, 0, wxRIGHT|wxEXPAND|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, _B(8));
        Sizer -> Add (*CheckBox, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, _B(8));
      }

    return Sizer;
}

//-------------------------------------------------------------------------

wxSizer * wxExtDialog::addRadioButtonWithLabel (wxRadioButton ** RadioButton,
             const wxString & LabelString, const wxValidator & Validator,
             int RadioCtrlStyle, wxSizer * Sizer)
{
    wxWindow *PanelWnd = this;

    if (Sizer == NULL)
      {
        Sizer = new wxBoxSizer (wxHORIZONTAL);
      }

    *RadioButton = new wxRadioButton (PanelWnd, -1, 
                                      LabelString, 
                                      wxDefaultPosition, wxDefaultSize, 
                                      RadioCtrlStyle, Validator);

//  if (TextCtrlStyle & wxTE_READONLY)
//    {
//      (*RadioButton) -> Enable (FALSE);
//    }

    Sizer -> Add (*RadioButton, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, _B(5));

    return Sizer;
}

//-------------------------------------------------------------------------

wxStaticText * wxExtDialog::addLabel (wxStaticText ** StaticTextCtrl,
                                    const wxString & LabelString,
                                    wxSizer * Sizer,
                                    int WindowStyle,
                                    const wxSize & Size)
{
    wxStaticText * TempStaticTextCtrl 
      = new wxStaticText (this, -1, LabelString,
                          wxDefaultPosition, Size,
                          WindowStyle);
    
    if (StaticTextCtrl != NULL)
      *StaticTextCtrl = TempStaticTextCtrl;
    
    if (Sizer != NULL)
      Sizer -> Add (TempStaticTextCtrl, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, _B(8));

    return TempStaticTextCtrl;
}

wxWindow * wxExtDialog::addMultiLineText (wxMultiLineText * MultiLineText,
                                        int CtrlStyle,
                                        const wxSize & CtrlSize,
                                        int MultiLineTextStyle,
                                        wxSizer * Sizer)
{
    wxSize UsedSize = getSizeFromDefaults (CtrlSize, m_DefaultTextCtrlSize);

    MultiLineText -> create (this, -1, 
                             CtrlStyle, 
                             UsedSize,
                             MultiLineTextStyle);

    if (MultiLineText -> getHtmlWindow() != NULL)
      {
        setHtmlWindowFonts (MultiLineText -> getHtmlWindow(),
                            m_DialogFontSize,
                            TRUE,
                            FALSE);

        MultiLineText -> getHtmlWindow() -> SetBackgroundColour (this -> GetBackgroundColour ());
      }

    if (Sizer != NULL)
      Sizer -> Add (MultiLineText -> getWindow(), 0, wxEXPAND, _B(0));

    return MultiLineText -> getWindow ();
}

wxWindow * wxExtDialog::addMultiLineText (wxMultiLineText * MultiLineText,
										  int CtrlStyle,
										  const wxSize & CtrlSize,
										  int MultiLineTextStyle,
										  wxSizer * Sizer,
										  const wxString & TextString,
										  int MinLineCount, int MaxLineCount, 
										  int BorderWidth)
{
    wxWindow * Window = addMultiLineText (MultiLineText,
                                          CtrlStyle,
                                          CtrlSize,
                                          MultiLineTextStyle,
                                          Sizer);

	if (MultiLineText -> getHtmlWindow() != NULL)
	  {
		MultiLineText -> getHtmlWindow() -> SetBorders (BorderWidth);
	  }

    MultiLineText -> setText (TextString);
    adjustMultiLineTextSize (* MultiLineText, MinLineCount, MaxLineCount);

    return Window;
}

wxTextCtrl * wxExtDialog::addTextCtrl
   (
    wxTextCtrl ** TextCtrl, const wxValidator & Validator,
    int TextCtrlStyle,
    const wxSize& Size,
    wxSizer * Sizer
    )
{
    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultTextCtrlSize);

    *TextCtrl = new wxTextCtrl (this, -1, _T(""),
                                wxDefaultPosition, UsedSize,
                                TextCtrlStyle, Validator);

    if (TextCtrlStyle & wxTE_READONLY)
      {
        // (*TextCtrl) -> SetBackgroundColour (*wxLIGHT_GREY);
        (*TextCtrl) -> SetBackgroundColour (this -> GetBackgroundColour ());
      }

    if (Sizer != NULL)
      {
        Sizer -> Add (*TextCtrl, 0, 0, _B(0));
      }

    return *TextCtrl;
}

wxSizer * wxExtDialog::addTextCtrlWithLabel (wxTextCtrl ** TextCtrl,
                                           const wxString & LabelString, 
                                           const wxValidator & Validator,
                                           int TextCtrlStyle,
                                           const wxSize & Size,
                                           wxSizer * Sizer)
{
    if (Sizer == NULL)
      {
        Sizer = new wxBoxSizer (wxHORIZONTAL);
      }
    if (! LabelString.IsEmpty())
      {
        Sizer->Add (new wxStaticText (this, -1, LabelString),
                       0, wxRIGHT|wxALIGN_CENTER_VERTICAL, _B(8));
      }

    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultTextCtrlSize);
    Sizer->Add (addTextCtrl (TextCtrl,
                             Validator, TextCtrlStyle, 
                             UsedSize),
                   0, wxALIGN_CENTER_VERTICAL, _B(8));

    return Sizer;
}

wxSizer * wxExtDialog::addTextCtrlWithTwoLabels (wxTextCtrl ** TextCtrl,
                                               const wxString & FirstLabelString,
                                               const wxString & SecondLabelString,
                                               const wxValidator & Validator,
                                               int TextCtrlStyle, 
                                               const wxSize & Size,
                                               wxSizer * Sizer)
{
    // NOTE: OtherSizer is possibly the same as Sizer
    wxSizer * OtherSizer = addTextCtrlWithLabel (TextCtrl, FirstLabelString, Validator,
                                                 TextCtrlStyle, Size, Sizer);
    OtherSizer->Add (new wxStaticText (this, -1, SecondLabelString),
                     0, wxLEFT|wxALIGN_CENTER_VERTICAL, _B(5));

    return OtherSizer;
}

wxSizer * wxExtDialog::addTextCtrlSliderPairWithLabel (wxTextCtrl ** TextCtrl,
                                                     wxSlider ** SliderCtrl,
                                                     const wxString & LabelString,
                                                     long * LongValue, long MinLong, long MaxLong,
                                                     wxStatusMessageTarget * StatusMessageTarget,
                                                     wxSizer * Sizer,
                                                     const wxString & FieldNameString)
{
    if (Sizer == NULL)
      {
        Sizer = new wxBoxSizer (wxHORIZONTAL);
      }

    Sizer->Add (new wxStaticText (this, -1, LabelString),
                0, wxALIGN_CENTER_VERTICAL, _B(5));
    *TextCtrl = new wxTextCtrl (this, -1, _T(""),
                                wxDefaultPosition,
                                wxSize(getAdjustedTextCtrlWidth(60), getAdjustedTextCtrlHeight (1, TRUE)),
                                wxTE_LEFT,
                                wxTextCtrlSliderPairTextCtrlValidator (LongValue, MinLong, 
                                                                       MaxLong, StatusMessageTarget,
                                                                       FieldNameString));
    Sizer->Add (*TextCtrl, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, _B(5));

    // specify 'MinLong' as initial value for the slider just in case it is not yet initialized correctly:
    *SliderCtrl = new wxSlider(this, -1, MinLong , MinLong, MaxLong, wxDefaultPosition, 
                               wxSize (getAdjustedSliderWidth(160), getAdjustedSliderHeight(22)), 
                               wxSL_HORIZONTAL,
                               wxTextCtrlSliderPairSliderValidator ());
    Sizer->Add (*SliderCtrl, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, _B(5));

//  wxTextCtrlSliderPairSliderValidator * TextCtrlSliderPairSliderValidator =
//    wxDynamicCast ((**SliderCtrl).GetValidator(), wxTextCtrlSliderPairSliderValidator);
//  wxTextCtrlSliderPairTextCtrlValidator * TextCtrlSliderPairTextCtrlValidator =
//    wxDynamicCast ((**TextCtrl).GetValidator(), wxTextCtrlSliderPairTextCtrlValidator);
    wxTextCtrlSliderPairSliderValidator * TextCtrlSliderPairSliderValidator =
      (wxTextCtrlSliderPairSliderValidator *) (**SliderCtrl).GetValidator();
    wxTextCtrlSliderPairTextCtrlValidator * TextCtrlSliderPairTextCtrlValidator =
      (wxTextCtrlSliderPairTextCtrlValidator *) (**TextCtrl).GetValidator();

    if (TextCtrlSliderPairSliderValidator)
      TextCtrlSliderPairSliderValidator -> setAssociatedTextCtrlValidator (TextCtrlSliderPairTextCtrlValidator);

    if (TextCtrlSliderPairTextCtrlValidator)
      TextCtrlSliderPairTextCtrlValidator -> setAssociatedSliderValidator (TextCtrlSliderPairSliderValidator);

    return Sizer;
}

//-------------------------------------------------------------------------

wxListBox * wxExtDialog::addListBox
   (
    wxListBox ** ListBox, const wxValidator & Validator,
    int ChoiceCount, const wxString ChoiceStringArray [],
    const wxSize& Size
    )
{
    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultListBoxSize);

    int WindowStyle = 0;
    *ListBox = new wxListBox (this, -1,
                              wxDefaultPosition, UsedSize,
                              ChoiceCount, ChoiceStringArray,
                              WindowStyle, Validator);

    return *ListBox;
}

//-------------------------------------------------------------------------

wxChoice * wxExtDialog::addChoiceCtrl
   (
    wxChoice ** ChoiceCtrl, const wxValidator & Validator,
    int ChoiceCount, const wxString ChoiceStringArray [],
    const wxSize& Size
    )
{
    wxSize UsedSize = getSizeFromDefaults (Size, m_DefaultChoiceCtrlSize);

    int WindowStyle = 0;
    *ChoiceCtrl = new wxChoice (this, -1,
                                wxDefaultPosition, UsedSize,
                                ChoiceCount, ChoiceStringArray,
                                WindowStyle, Validator);

    return *ChoiceCtrl;
}

wxSizer * wxExtDialog::addChoiceCtrlWithLabel (wxChoice ** ChoiceCtrl,
                                             const wxString & LabelString, 
                                             const wxValidator & Validator,
                                             int ChoiceCount, const wxString ChoiceStringArray [],
                                             const wxSize & Size,
                                             wxSizer * Sizer)
{
    if (Sizer == NULL)
      {
        Sizer = new wxBoxSizer (wxHORIZONTAL);
      }
    if (! LabelString.IsEmpty())
      {
        Sizer->Add (new wxStaticText (this, -1, LabelString),
                       0, wxRIGHT|wxALIGN_CENTER_VERTICAL, _B(8));
      }

    Sizer->Add (addChoiceCtrl (ChoiceCtrl, Validator,
                               ChoiceCount, ChoiceStringArray,
                               Size),
                0, wxALIGN_CENTER_VERTICAL, _B(8));
    
    return Sizer;
}

// DEF if (ImageDataSize==-1) then ImageData is the name of a
// resource RCDATA (raw data) block
wxSizer * wxExtDialog::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtr,
                                      const unsigned char * ImageData,
                                      size_t ImageDataSize,
                                      const wxPoint& Position,
                                      const wxSize& Size,
                                      wxSizer * Sizer)
{
    for_once
      {
        if (Sizer == NULL)
          {
            Sizer = new wxBoxSizer (wxHORIZONTAL);
            if (Sizer == NULL)
              break;
          }

        wxBitmap * Bitmap = NULL;

        if (cast_is_not_equal (ImageDataSize, -1))
          {
            if (!loadBitmapFromMemory (ImageData, ImageDataSize, & Bitmap))
              break;
          }
        else
          {
#if defined(__WXMSW__)
            if (!loadBitmapFromResource (ImageData, & Bitmap))
              break;
#endif // defined(__WXMSW__)
          }

        if (Bitmap == NULL)
          break;

        wxSize BitmapSize (Bitmap -> GetWidth(), Bitmap -> GetHeight());
        wxSize UsedSize = getSizeFromAspectRatio (Size, BitmapSize);

        wxStaticBitmap * StaticBitmap = new wxStaticBitmap (this, -1, *Bitmap, 
                                                            Position, UsedSize);
        if (StaticBitmap == NULL)
          break;

        Sizer -> Add (StaticBitmap, 0, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(0));
        
        if (StaticBitmapPtr != NULL)
          *StaticBitmapPtr = StaticBitmap;
      }
    return Sizer;
}

wxSizer * wxExtDialog::addStaticBitmap (wxStaticBitmap ** StaticBitmapPtr,
                                      const char * ResourceNameString,
                                      const wxPoint& Position,
                                      const wxSize& Size,
                                      wxSizer * Sizer)
{
    return addStaticBitmap (StaticBitmapPtr, 
                            (const unsigned char *) ResourceNameString, -1,
                            Position, Size, Sizer);
}

//-------------------------------------------------------------------------

wxMultiLineText * wxExtDialog::createErrorMessageCtrl (wxMultiLineText * ErrorMessageMultiLineTextPtr)
{
    wxMultiLineText & ErrorMessageMultiLineText = *ErrorMessageMultiLineTextPtr;
    wxSize Size (1 /* width: -1 worked for wxTextCtrl but doesn't for wxHtmlWindow */, 
                 getAdjustedTextCtrlHeight (2, TRUE) /* height */);

    // flags used for wxTextCtrl were: wxTE_READONLY | wxTE_LINEWRAP | wxTE_MULTILINE | wxVSCROLL
    addMultiLineText (& ErrorMessageMultiLineText, 
                      0,
                      Size,
                      0);

    return ErrorMessageMultiLineTextPtr;
    
}

//-------------------------------------------------------------------------

void wxExtDialog::addFlexGridSizer (wxFlexGridSizer ** FlexGridSizer,
                                  int Columns, int VGap, int HGap)
{
    *FlexGridSizer = new wxFlexGridSizer (Columns, VGap, HGap);
}

void wxExtDialog::addFlexGridSizer (wxFlexGridSizer ** FlexGridSizer,
                                  int Columns, int VGap, int HGap,
                                  wxSizer * OuterSizer, int AddFlags, int AddBorder)
{
    *FlexGridSizer = new wxFlexGridSizer (Columns, VGap, HGap);

    OuterSizer -> Add (*FlexGridSizer, 0, AddFlags, AddBorder);
}

void wxExtDialog::addStaticBox (wxFlexGridSizer ** FlexGridSizer,
                              const wxString & LabelString,
                              int Columns, int VGap, int HGap,
                              wxSizer * OuterSizer, int AddFlags, int AddBorder)
{
    wxStaticBoxSizer *StaticBoxSizer
      = new wxStaticBoxSizer (new wxStaticBox (this, -1, LabelString), wxVERTICAL);

    *FlexGridSizer = new wxFlexGridSizer (Columns, VGap, HGap);

    StaticBoxSizer -> Add (*FlexGridSizer, 0, wxALL|wxEXPAND, _B(5));

    OuterSizer -> Add (StaticBoxSizer, 0, AddFlags, AddBorder);
}

//-------------------------------------------------------------------------

wxFont wxExtDialog::createDialogFont (int PointSize, int Family, int Style, int Weight,
                                    const bool IsUnderlined, const wxString& FaceName,
                                    wxFontEncoding Encoding, int * RequestedPointSize,
                                    bool IsCreateFont)
{
    const char * UsedFaceNameString = FaceName;

    int MinReadablePointSize = 3; // probably not a sensible value

#if defined(__WXMSW__)

    if (Family == wxDEFAULT && 
        (Weight == wxNORMAL || Weight == wxBOLD))
      {
        // this is the minimal readable font size at least for some wxSWISS
        // font face under Windows 
        // MinReadablePointSize = 7;

        // this is the minimal readable font size at least for 'Small Fonts'
        // under Windows 
        MinReadablePointSize = 6;

        if (PointSize <= 7)
          {
            UsedFaceNameString = "Small Fonts";
            // ?? Family=wxSWISS;
          }
        else if (PointSize == 8 || PointSize == 10 || PointSize == 12)
          {
            UsedFaceNameString = "MS Sans Serif";
            // ?? Family=wxSWISS;
          }
        else
          {
            // because wxDEFAULT will override requested point size and there seems to
            // be only one size available for wxDEFAULT (9), we must specify an other 
            // (similar) font family if we want other font sizes than the only
            // one available for the wxDEFAULT font
            Family=wxSWISS;

            // NOTE the same problem may exist for other parameters (e.g. wxITALIC),
            // may have to apply similar modification of font family (TODO)
          }

        if (FaceName == "Small Fonts")
          {
            // these font sizes look ugly, so use the next smaller size instead:
            excludeRange (PointSize, 8, 127);
          }
        else if (FaceName == "MS Sans Serif")
          {
          }

      }

#elif (defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXX11__))

    if (Family == wxDEFAULT && 
        (Weight == wxNORMAL || Weight == wxBOLD))
      {

        // 8 seems to be the minimal readable font size under X (no font name provided) 
        // (not much testing done to find special fonts which are readable
        // at smaller sizes)
        MinReadablePointSize = 8;

        // these font sizes look ugly, so use the next smaller size instead:
        excludeRange (PointSize, 9);
        excludeRange (PointSize, 15);
        excludeRange (PointSize, 17);
        excludeRange (PointSize, 19, 23);
        excludeRange (PointSize, 25, 29);

        // could try 'xfontsel' to look for a nicely scaling font for big font
        // sizes

//      if (PointSize > 12)
//        {
//          // bigger font sizes don't look well - no scalable fonts seem to
//          // be used - specfiying wxSWISS doesn't help either (scope: GTK 1.2.7)
//          Family = wxSWISS;
//        }
      }

    // UsedFaceNameString = wxEmptyString;
    // TEST:
    // encoding = wxFONTENCODING_DEFAULT;

// #elif defined(__WXX11__)

#else
#   pragma message ("Please adjust function createDialogFont() for your wxWindows port.")
#endif

    if (PointSize < MinReadablePointSize)
      {
        PointSize = MinReadablePointSize;
      }

    if (RequestedPointSize != NULL)
      *RequestedPointSize = PointSize;

    if (IsCreateFont)
      {
        wxFont TempFont (PointSize,
                         Family, Style, Weight,
                         IsUnderlined, UsedFaceNameString,
                         Encoding);
        // wxString NativeFontInfoDescString = TempFont.GetNativeFontInfoDesc ();
        // int ActualPointSize = TempFont.GetPointSize ();

        return TempFont;
      }
    else
      {
        return wxNullFont;
      }
}

//-------------------------------------------------------------------------

void wxExtDialog::excludeRange (int & PointSize, int ExcludeRangeMin, int ExcludeRangeMax)
{
    if (ExcludeRangeMax == -1)
      ExcludeRangeMax = ExcludeRangeMin;

    if (PointSize >= ExcludeRangeMin
        && PointSize <= ExcludeRangeMax)
      PointSize = ExcludeRangeMin - 1;
}

//-------------------------------------------------------------------------

void wxExtDialog::adjustMultiLineTextSize (wxMultiLineText & MultiLineText,
                                         int MinLineCount, int MaxLineCount)
{
  int Height = getAdjustedTextCtrlHeight (/* LineCount */ 1, TRUE);
  if (MultiLineText.getTextCtrl() != NULL)
    {
      wxTextCtrl * TextCtrl = MultiLineText.getTextCtrl();
      // adjust size of TextCtrl:
      //
      // under WXGTK, the function GetNumberOfLines() will only count the number
      // of newline characters in the text, which is not really useful since with
      // wxTE_LINEWRAP the number of lines after doing the linebreak will usually
      // differ from the number of newline characters in the text
      // int LineCount = 7;
      //
      // under MSW, the number of lines actually used (after the (Rich) text control 
      // does linebreak internally) can be obtained with GetNumberOfLines(). 
      //
      // since now we doTextLineWrap(), the number of newline-characters
      // is the same as the number of lines after wrapping also for GTK,
      // Lesstif/Motif, X11
      int LineCount = TextCtrl -> GetNumberOfLines();

      if (LineCount < MinLineCount)
        LineCount = MinLineCount;

      // limit height of wxTextCtrl:
      if (LineCount > MaxLineCount)
        LineCount = MaxLineCount;

      // NOTE getAdjustedTextCtrlHeight (LineCount, 1)
      // is not fully correct here, because the font height of the
      // wxTextCtrl may be different from the font height specified
      // for the dialog

      Height = getAdjustedTextCtrlHeight (LineCount, TRUE);
    }
  else if (MultiLineText.getHtmlWindow() != NULL)
    {
      wxHtmlWindow * HtmlWindow = MultiLineText.getHtmlWindow();

      int MinHeight = getAdjustedTextCtrlHeight (MinLineCount, TRUE); // WARN
      int MaxHeight = getAdjustedTextCtrlHeight (MaxLineCount, TRUE); // WARN

      // the required height for the HTML text is contained
      // in the outermost HTML cell's height member
      wxHtmlContainerCell * Cell = HtmlWindow -> GetInternalRepresentation();
      int RenderedHeight = Cell -> GetHeight();
      
      if (RenderedHeight < MinHeight)
        Height = MinHeight;
      else if (RenderedHeight > MaxHeight)
        Height = MaxHeight;
      else
        Height = RenderedHeight;

    }

  wxWindow * Window = MultiLineText.getWindow();
  wxSize WindowSize = Window -> GetSize ();
  WindowSize.SetHeight (Height);
  Window -> SetSize (WindowSize);

  // if the window is already assigned to a sizer, the associated
  // sizer's minimum size must be updated as well (it would otherwise
  // override the size specified via wxWindow::SetSize() above)
  wxSizer * ContainingSizer = Window -> GetContainingSizer();
  if (ContainingSizer != NULL)
    {
      ContainingSizer -> SetItemMinSize (Window, WindowSize);
    }
}

//-------------------------------------------------------------------------

int wxExtDialog::getAdjustedBorderSize (int BorderSize)
{
    // int AdjustedBorderSize = m_BorderCompressionValue * BorderSize;
    int AdjustedBorderSize;

    if (BorderSize == 0)
      return 0;

    AdjustedBorderSize = (BorderSize * m_DialogFontSize) / DefaultDialogFontSize;

    if (m_BorderCompressionValue < 1 /*&& m_IsBorderHyperZoom*/)
      {
        cast_assign (AdjustedBorderSize, pow (AdjustedBorderSize, m_BorderCompressionValue));
      }
    else
      {
        cast_assign (AdjustedBorderSize, AdjustedBorderSize * m_BorderCompressionValue);
      }
    // if the border size was greater zero, the adjusted size shall be
    // at least 1 (pixel)
    if (AdjustedBorderSize < 1)
      AdjustedBorderSize = 1;
    return AdjustedBorderSize;
}

int wxExtDialog::getAdjustedTextCtrlWidth (int TextCtrlWidth)
{
    return getAdjustedFontLikeWidth (TextCtrlWidth);
}

int wxExtDialog::getAdjustedTextCtrlHeight (int TextCtrlHeight, bool IsFromLineCount)
{
    // TODO: calculation should include type of border and font set
    // for the used control
#if defined(__WXMSW__)
    int TotalBorderingHeight = 10;
#elif defined(__WXMOTIF__)
    int TotalBorderingHeight = 18;
#elif defined(__WXGTK__)
    int TotalBorderingHeight = 10;
#else
#   pragma message ("Please adjust function getAdjustedTextCtrlHeight() for your wxWindows port.")
    int TotalBorderingHeight = 10;
#endif

    if (IsFromLineCount)
      {
        int LineCount = TextCtrlHeight;

#if defined(__WXMOTIF__)
        // under Lesstif(Motif?), requests to set a different font for
        // wxTextCtrl are ignored so always some fixed char width font is used
        int FontHeight = 12;
#else
        int FontHeight = getDialogFontHeight();
#endif

#if defined(__WXMSW__)
        int LineSpacing = 2;
#elif defined(__WXMOTIF__)
        int LineSpacing = 1;
#elif defined(__WXGTK__)
        int LineSpacing = 0;
#else
#       pragma message "Please adjust function getAdjustedTextCtrlHeight() for your wxWindows port."
        int LineSpacing = 0;
#endif

        int TotalHeight = TotalBorderingHeight;
//      if (LineCount >= 1)
//        TotalHeight += (FontHeight) * LineCount
//          + LineSpacing * (LineCount - 1);
        if (LineCount >= 1)
          {
            TotalHeight += (FontHeight + LineSpacing) * (LineCount -1)
              + getDialogFontSize();
          }

        return TotalHeight;
      }
    else
      return getAdjustedFontLikeHeight (TextCtrlHeight - TotalBorderingHeight) + TotalBorderingHeight;
}

int wxExtDialog::getAdjustedButtonWidth (int ButtonWidth)
{
    return getAdjustedFontLikeWidth (ButtonWidth);
}

int wxExtDialog::getAdjustedButtonHeight ()
{
#if defined(__WXMOTIF__)
    // NOTE Lesstif(Motif?) uses a lot of space around the actual
    // button to indicate which is the default button. If a dialog
    // has a default button, the actual (visible) button height
    // is much smaller than the provided height. If there is no
    // default button, the button has a large height. Unfortunately,
    // here we cannot know if the dialog will get any default buttons, 
    // so must assume that there might be any.
    return m_DialogFontSize + 28;
#elif defined(__WXMSW__)
    return m_DialogFontSize + 16;
#elif defined(__WXGTK__)
    return m_DialogFontSize + 12;
#elif defined(__WXX11__)
#   pragma message "Please adjust function getAdjustedButtonHeight() for your wxWindows port."
    return m_DialogFontSize + 12;
#else
#   pragma message "Please adjust function getAdjustedButtonHeight() for your wxWindows port."
    return m_DialogFontSize + 12;
#endif
}

int wxExtDialog::getAdjustedSliderWidth (int SliderWidth)
{
    return getAdjustedProportionalWidth (SliderWidth);
}

int wxExtDialog::getAdjustedSliderHeight (int SliderHeight)
{
    return getAdjustedFontLikeHeight (SliderHeight);
}

int wxExtDialog::getAdjustedBitmapWidth (int BitmapWidth)
{
    return getAdjustedProportionalWidth (BitmapWidth);
}

int wxExtDialog::getAdjustedBitmapHeight (int BitmapHeight)
{
    return getAdjustedProportionalHeight (BitmapHeight);
}

//-------------------------------------------------------------------------

int wxExtDialog::getDialogFontSize ()
{
    return m_DialogFontSize;
}

int wxExtDialog::getDialogFontHeight ()
{
    return m_DialogFontHeight;
}

//-------------------------------------------------------------------------

int wxExtDialog::getAdjustedProportionalWidth(int Width)
{
    int AdjustedWidth;

    cast_assign (AdjustedWidth, Width * m_ZoomValue);

    return AdjustedWidth;
}

int wxExtDialog::getAdjustedProportionalHeight(int Height)
{
    int AdjustedHeight;

    cast_assign (AdjustedHeight, Height * m_ZoomValue);

    return AdjustedHeight;
}

int wxExtDialog::getAdjustedFontLikeWidth(int Width)
{
    int AdjustedWidth;

    AdjustedWidth = (Width * m_DialogFontSize) / DefaultDialogFontSize;

    return AdjustedWidth;
}

int wxExtDialog::getAdjustedFontLikeHeight(int Height)
{
    int AdjustedHeight;

    AdjustedHeight = (Height * m_DialogFontSize) / DefaultDialogFontSize;

    return AdjustedHeight;
}

//-------------------------------------------------------------------------

void wxExtDialog::setDefaultButtonSize (int Width, int Height)
{
    m_DefaultButtonSize = wxSize (Width, Height);
}

//-------------------------------------------------------------------------

void wxExtDialog::setHtmlWindowFonts (wxHtmlWindow * HtmlWindow,
                                    int BaseSize,
                                    bool IsUseReadableFontSizes,
                                    bool IsUseScaleableFont)
{

    int FontSizeArray [7];

    cast_assign (FontSizeArray [0], BaseSize * 0.7);
    cast_assign (FontSizeArray [1], BaseSize * 0.85);
    cast_assign (FontSizeArray [2], BaseSize * 1.0);
    cast_assign (FontSizeArray [3], BaseSize * 1.2);
    cast_assign (FontSizeArray [4], BaseSize * 1.4);
    cast_assign (FontSizeArray [5], BaseSize * 2.0);
    cast_assign (FontSizeArray [6], BaseSize * 2.5);

    int Family = 0;
    wxString FaceName;
    if (IsUseScaleableFont)
      {
        Family = wxSWISS;
      }
    else
      {
        Family = wxDEFAULT;
        FaceName = GetFont().GetFaceName();
      }

    if (IsUseReadableFontSizes)
      {
        for (int Index=0; cast_is_smaller (Index, WXSIZEOF(FontSizeArray)); ++Index)
          {
            int RequestedPointSize = 0;
            createDialogFont (FontSizeArray[Index],
                              Family,
                              wxNORMAL /* upright/slant/italic */, 
                              wxNORMAL /* weight */,
                              FALSE /* underlined? */, 
                              FaceName /* face name */,
                              wxFONTENCODING_DEFAULT /* wxFONTENCODING_ISO8859_1 */,
                              & RequestedPointSize,
                              FALSE /* create font? */);
                              
            FontSizeArray[Index] = RequestedPointSize;
          }
      }

    HtmlWindow -> SetFonts (FaceName, "", FontSizeArray);
}

//-------------------------------------------------------------------------

double wxExtDialog::getZoom ()
{
    double GlobalZoom = m_GlobalDialogZoom;
    double DialogZoom = m_DialogZoomValue;
    if (m_GlobalDesktopReferenceSize != wxSize (-1, -1)
        || m_DesktopReferenceSize != wxSize (-1, -1))
      {
        int Width = 0;
        int Height = 0;
        wxClientDisplayRect (NULL, NULL, & Width, & Height);

        wxSize DesktopReferenceSize = m_GlobalDesktopReferenceSize;
        if (m_DesktopReferenceSize != wxSize (-1, -1))
          DesktopReferenceSize = m_DesktopReferenceSize;

        double WidthRatio = Width / ((double) DesktopReferenceSize.GetWidth());
        double HeightRatio = Height / ((double) DesktopReferenceSize.GetHeight());

        if (WidthRatio <= HeightRatio)
          GlobalZoom *= WidthRatio;
        else
          GlobalZoom *= HeightRatio;
      }

    return DialogZoom * GlobalZoom;
}

void wxExtDialog::setDialogZoom (double DialogZoomValue)
{
    m_DialogZoomValue = DialogZoomValue;
    m_ZoomValue = getZoom ();

    int AdjustedFontSize;
    cast_assign (AdjustedFontSize, DefaultDialogFontSize * m_ZoomValue);

    this -> SetFont (createDialogFont(AdjustedFontSize,
                                      wxDEFAULT /* family */, 
                                      wxNORMAL /* upright/slant/italic */, 
                                      wxNORMAL /* weight */,
                                      FALSE /* underlined? */, 
                                      _T("") /* face name */,
                                      wxFONTENCODING_DEFAULT /* wxFONTENCODING_ISO8859_1 */ ));

    // determine actually used font size (may differ from requested size)
    m_DialogFontSize = this -> GetFont().GetPointSize();

    // GetCharHeight() doesn't seem to be sensible for all fonts
    // int CharHeight = GetCharHeight();
    int TextWidth, TextHeight, Descent, ExternalLeading;
    GetTextExtent ("g-test", & TextWidth, & TextHeight, & Descent, & ExternalLeading);
    m_DialogFontHeight = TextHeight;

    m_DefaultButtonSize = wxSize (getAdjustedButtonWidth (100), 
                                  getAdjustedButtonHeight());

    m_DefaultTextCtrlSize = wxSize (getAdjustedTextCtrlWidth (60),
                                    getAdjustedTextCtrlHeight (1, TRUE));

    m_DefaultListBoxSize = wxSize (getAdjustedTextCtrlWidth (80),
                                   getAdjustedTextCtrlHeight (1, TRUE));

    m_DefaultChoiceCtrlSize = wxSize (getAdjustedTextCtrlWidth (80),
                                      getAdjustedTextCtrlHeight (1, TRUE));

    // setBorderZoom (ZoomValue);
}

double wxExtDialog::getDialogZoom ()
{
    return m_DialogZoomValue;
}

double wxExtDialog::m_GlobalDialogZoom = 1.;

void wxExtDialog::setGlobalDialogZoom (double ZoomValue)
{
    m_GlobalDialogZoom = ZoomValue;
}

double wxExtDialog::getGlobalDialogZoom ()
{
    return m_GlobalDialogZoom;
}

void wxExtDialog::setDesktopReferenceSize (const wxSize & Size)
{
    m_DesktopReferenceSize = Size;
}

wxSize wxExtDialog::m_GlobalDesktopReferenceSize = wxSize (-1, -1);

void wxExtDialog::setGlobalDesktopReferenceSize (const wxSize & Size)
{
    m_GlobalDesktopReferenceSize = Size;
}

void wxExtDialog::setBorderCompression (double BorderCompressionValue)
{
    m_BorderCompressionValue = BorderCompressionValue;
}

//-------------------------------------------------------------------------

wxSize wxExtDialog::getSizeFromDefaults (const wxSize & Size, const wxSize & DefaultSize)
{
    wxSize UsedSize;
    if (& Size == & wxDefaultSize)
      UsedSize = DefaultSize;
    else
      UsedSize = Size;

    if (UsedSize.GetWidth () == -1)
      UsedSize.SetWidth (DefaultSize.GetWidth());
    if (UsedSize.GetHeight () == -1)
      UsedSize.SetHeight (DefaultSize.GetHeight());

    return UsedSize;
}

wxSize wxExtDialog::getSizeFromAspectRatio (const wxSize & Size, const wxSize & AspectRatioAsSize)
{
    wxSize UsedSize;
    if (& Size == & wxDefaultSize)
      UsedSize = AspectRatioAsSize;
    else
      UsedSize = Size;

    if (UsedSize.GetWidth () == -1)
      UsedSize.SetWidth ((AspectRatioAsSize.GetWidth() * UsedSize.GetHeight()) / AspectRatioAsSize.GetHeight());
    if (UsedSize.GetHeight () == -1)
      UsedSize.SetHeight ((AspectRatioAsSize.GetHeight() * UsedSize.GetWidth()) / AspectRatioAsSize.GetWidth());

    return UsedSize;
}

//-------------------------------------------------------------------------

void wxExtDialog::enableWatchedControlChangeNotification (bool IsWatchedControlChangeNotification)
{
    m_IsWatchedControlChangeNotification = IsWatchedControlChangeNotification;
}

void wxExtDialog::addWatchedControl(wxWindow * Window)
{
    m_WatchedObjectArray.Add (Window);
}

void wxExtDialog::handleControlChange(wxCommandEvent& Event)
{
    if (m_IsDialogInitialized 
        && m_IsWatchedControlChangeNotification 
        && m_WatchedObjectArray.Index (Event.m_eventObject) != wxNOT_FOUND)
      {
        handleWatchedControlChange (Event);
      }
}

void wxExtDialog::handleWatchedControlChange(wxCommandEvent & WXUNUSED(Event))
{
}

//-------------------------------------------------------------------------

void wxExtDialog::OnTextCtrlChanged(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

// void wxExtDialog::OnSliderCtrlChanged(wxCommandEvent& Event)
void wxExtDialog::OnSliderCtrlChanged(wxScrollEvent & Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDialog::OnRadioButtonSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDialog::OnRadioBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDialog::OnCheckBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDialog::OnComboBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDialog::OnListBoxSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

void wxExtDialog::OnChoiceCtrlSelected(wxCommandEvent& Event)
{
    handleControlChange (Event);
    Event.Skip();
}

//-------------------------------------------------------------------------

bool wxExtDialog::TransferDataToWindow()
{
    bool PreviousIsWatchedControlChangeNotification = 
      m_IsWatchedControlChangeNotification;
    m_IsWatchedControlChangeNotification = FALSE;
    bool IsOk = wxDialog::TransferDataToWindow();
    m_IsWatchedControlChangeNotification =
      PreviousIsWatchedControlChangeNotification;
    return IsOk;
}

void wxExtDialog::initializeDialog ()
{
#if (defined(__WXMOTIF__) || defined(__WXX11__)) // maybe others required here
    TransferDataToWindow ();
#elif (defined(__WXGTK__) || defined(__WXMSW__))
    // GTK, MSW: TransferDataToWindow() is called by OnInitDialog()
    // OnInitDialog() itself is called automatically after the dialog was 
    // created.
#else
#   pragma message "Please adjust function initializeDialog() for your wxWindows port."
    TransferDataToWindow (); // may not be required here
#endif
}

bool wxExtDialog::ValidateWithMessageBox(int ReturnCode)
{
    bool IsOk;
    if (m_StatusMessageTarget != NULL)
      m_StatusMessageTarget -> enableShowMessageBox (TRUE);
    IsOk = Validate ();
    if (m_StatusMessageTarget != NULL)
      m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    if (IsOk)
      TransferDataFromWindow();

    if (IsOk && ReturnCode != -1)
      EndModal (ReturnCode);

    return IsOk;
}

//-------------------------------------------------------------------------
