
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxWidgetsExtensions library 0.7.1
-----------------------------

COPYRIGHT NOTICE:

WxWidgetsExtensions library Copyright (c) 2003, 2004 Daniel Kps.

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxWidgetsExtensions library Copyright notice

-------------------------------------------------------------------------
*/

#ifndef _INCLUDED_StatusValidators_h
#define _INCLUDED_StatusValidators_h

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
#   pragma interface "StatusValidators.h"
#endif

#include "wx/defs.h"

#ifndef WX_PRECOMP
#   include <wx/validate.h>
#   include <wx/textctrl.h>
#endif

#include <wx/valgen.h>
#include <wx/datetime.h>

#include "WxMisc.h"

#define _WxExtLibDLLExport // putting classes into DLL is untested

//-------------------------------------------------------------------------

// wxStatusMessageTarget
// - used to output status messages - normally directed to
//   a wxTextCtrl
// - may also display a message box (can be enabled/disabled
//   with enableShowMessageBox())
class _WxExtLibDLLExport wxStatusMessageTarget: public wxObject
{
DECLARE_DYNAMIC_CLASS(wxStatusMessageTarget)
public:

    wxStatusMessageTarget () ;
    wxStatusMessageTarget(wxMultiLineText * m_ErrorMessageMultiLineText,
                          const wxString & NonErrorMessageString);
    wxStatusMessageTarget(const wxStatusMessageTarget& StatusMessageTarget);

    ~wxStatusMessageTarget();

    virtual wxObject *Clone() const { return new wxStatusMessageTarget(*this); }
    bool Copy(const wxStatusMessageTarget & StatusMessageTarget);

    //-- functions to set and display the error message to some status text output control
    // setMessage(): currently, the old message is replaced by the new message
    virtual void setMessage (const wxString & MessageString, bool IsError);

    virtual void display (wxWindow * ParentWindow);
    virtual void clear ();

    void enableShowMessageBox (bool IsShowMessageBoxEnabled);
    bool isShowMessageBoxEnabled ();

protected:
    wxMultiLineText * m_ErrorMessageMultiLineText;
    wxString m_NonErrorMessageString; 
    wxString m_MessageString;
    bool m_IsError;

    bool m_IsShowMessageBoxEnabled;
};

//-------------------------------------------------------------------------

// wxROGenericValidator: Read-Only GenericValidator
// (ignores the text in the control - transfers only to the control, but not
// from the control)
class _WxExtLibDLLExport wxROGenericValidator: public wxGenericValidator
{
DECLARE_CLASS(wxROGenericValidator)
public:
    // TODO: one could also provide constructors which take const VARTYPE pointers,
    // because the values won't be modified anyway
    wxROGenericValidator(bool* val);
    wxROGenericValidator(int* val);
    wxROGenericValidator(wxString* val);
    wxROGenericValidator(wxArrayInt* val);

    virtual wxObject *Clone() const { return new wxROGenericValidator(*this); }

    virtual bool Validate(wxWindow * WXUNUSED(parent)) { return TRUE; }
    virtual bool TransferFromWindow() { return TRUE; }
};

//-------------------------------------------------------------------------

// wxTextCtrlStatusValidator:
// - base class for validators (such as wxNumberValidator)
// - immediate feedback of validity of entered text via
//   wxStatusMessageTarget
class _WxExtLibDLLExport wxTextCtrlStatusValidator: public wxValidator
{
DECLARE_ABSTRACT_CLASS(wxTextCtrlStatusValidator)
public:
    enum
    {
      IsEmptyAllowed = 0x01,
      IsFilterInputChars = 0x02 // currently unused
    }; 

    wxTextCtrlStatusValidator();
    wxTextCtrlStatusValidator(wxStatusMessageTarget * StatusMessageTarget,
                              int Flags = 0);
    wxTextCtrlStatusValidator(const wxTextCtrlStatusValidator& TextCtrlStatusValidator);

    ~wxTextCtrlStatusValidator();

    bool Copy(const wxTextCtrlStatusValidator & TextCtrlStatusValidator);

    // overridable helper functions to get/set content of TextCtrl
    virtual void getTextCtrlContent (wxString & TextCtrlContentString);
    virtual void setTextCtrlContent (const wxString & TextCtrlContentString);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString) = 0;
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=FALSE) = 0;
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString) = 0;

    // function to display the error message to some status text output control
    virtual void showStatusMessage (const wxString & ErrorMessageString, bool IsError,
                                    wxWindow * ParentWindow);

    // validation and transfer to/from the control
    virtual bool Validate(wxWindow *parent);
    virtual bool TransferToWindow();
    virtual bool TransferFromWindow();

    // events to filter keystrokes and to show status message
    void OnChar(wxKeyEvent& Event);
    void OnTextChanged(wxCommandEvent& Event);

DECLARE_EVENT_TABLE()

protected:
    wxStatusMessageTarget * m_StatusMessageTarget;

    int m_Flags;

    bool checkValidator() const;
};

//-------------------------------------------------------------------------

// NOTE wxNumberValidatorVariant could be possibly replaced by wxVariant (which
// is much more powerful), but wxVariant possibly has poorer performance
// (maybe it is better to add a wxVariant type to wxNumberValidatorVariant)
class wxNumberValidatorVariant
{
 public:
    wxNumberValidatorVariant ();

    enum EType { UndefinedType, LongType, DoubleType /*, VariantType */ };

    bool getIsLong () const;
    bool getIsDouble () const;

    long getLong () const;
    double getDouble () const;
    void getLong (long * Long) const;
    void getDouble (double * Double) const;
    void setLong (long Long);
    void setDouble (const double & Double);

    bool operator== (const wxNumberValidatorVariant & Variant) const;

 private:
    EType m_Type;

    // (variables of different types could be made part of a union)
    long m_Long;
    double m_Double;
};

//-------------------------------------------------------------------------

// wxNumberValidator
// - support for integer, long or double type values
// - values are checked if they are within the specified range
//   [Min, Max]
// - immediate feedback is given to the user via the associated
//   wxStatusMessageTarget if string entered in the wxTextCtrl
//   doesn't represent a valid input
// - support for 'Undefined value':
//   - A special value may be choosen to (internally) indicate that 
//     the value is 'Undefined' (or 'unset'). 
//   - To use it, the "IsEmptyAllowed" flag must be set.
//   - The Undefined value is printed as empty string. The user
//     can enter the Undefined value by leaving the wxTextCtrl empty.
//   - Note: the Undefined value should be, of course, outside 
//     the range [Min, Max] of valid values. 
class _WxExtLibDLLExport wxNumberValidator: public wxTextCtrlStatusValidator
{
DECLARE_DYNAMIC_CLASS(wxNumberValidator)
public:
    wxNumberValidator();
    wxNumberValidator(int * IntegerValue, int MinInteger, int MaxInteger, 
                      wxStatusMessageTarget * StatusMessageTarget,
                      const wxString & FieldNameString,
                      int Flags = 0, int UndefinedInteger = 0);
    wxNumberValidator(long * LongValue, long MinLong, long MaxLong,
                      wxStatusMessageTarget * StatusMessageTarget,
                      const wxString & FieldNameString,
                      int Flags = 0, long UndefinedLong = 0);
    wxNumberValidator(double * DoubleValue, double MinDouble, double MaxDouble,
                      wxStatusMessageTarget * StatusMessageTarget,
                      const wxString & FieldNameString,
                      int Flags = 0, 
                      const wxString & FormatString = "%f",
                      double UndefinedDouble = 0.);
    wxNumberValidator(const wxNumberValidator& NumberValidator);

    ~wxNumberValidator();

    virtual wxObject *Clone() const { return new wxNumberValidator(*this); }
    bool Copy(const wxNumberValidator & NumberValidator);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString);
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=FALSE);
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString);

    // some helper functions
    virtual void transferToWindowHelper (const wxNumberValidatorVariant & Variant, 
                                         wxString & TextCtrlContentString);
    virtual bool transferFromWindowHelper (const wxString & TextCtrlContentString,
                                           wxNumberValidatorVariant * Variant, 
                                           wxString & ErrorMessageString);
    virtual bool convertStringToVariant (const wxString & TrimmedInputString,
                                         wxNumberValidatorVariant & Variant);
    virtual bool checkValue (const wxNumberValidatorVariant & Variant);
    virtual void getErrorMessageString (const wxNumberValidatorVariant & Variant, 
                                        wxString & ErrorMessageString);

    virtual void handleValidInput (const wxNumberValidatorVariant & TempVariant);

DECLARE_EVENT_TABLE()

protected:
    int * m_IntegerValue;
    long * m_LongValue;
    double * m_DoubleValue;

    wxNumberValidatorVariant m_MinVariant;
    wxNumberValidatorVariant m_MaxVariant;
    wxNumberValidatorVariant m_UndefinedVariant;

    wxString m_FieldNameString;

    // note: m_FormatString is used for output only
    wxString m_FormatString;
};

//-------------------------------------------------------------------------

// wxRONumberValidator: Read-Only NumberValidator
// (ignores input made into the wxTextCtrl - transfers only to the window,
// not back)
class _WxExtLibDLLExport wxRONumberValidator: public wxNumberValidator
{
DECLARE_DYNAMIC_CLASS(wxRONumberValidator)
public:

    wxRONumberValidator ();
    wxRONumberValidator (int * IntegerValue,
                         int Flags = 0, int UndefinedInteger = 0);
    wxRONumberValidator (long * LongValue,
                         int Flags = 0, int UndefinedLong = 0);

    virtual wxObject *Clone() const { return new wxRONumberValidator(*this); }

    // no validation shall be made for window content
    virtual bool Validate(wxWindow * WXUNUSED(ParentWindow)) { return TRUE; }
    // no data shall be transferred from the window
    virtual bool TransferFromWindow() { return TRUE; }

};

//-------------------------------------------------------------------------

// DEF MonthIndex starts from 1, _not_ 0!
wxDateTime::Month getMonthFromMonthIndex (int MonthIndex);
// DEF returned month index starts from 1, _not_ 0!
int getMonthIndexFromMonth (wxDateTime::Month Month);

//-------------------------------------------------------------------------

// wxDateTimeValidator
// - currently can be used for date input/output only (without time)
// - for problem of day-month/month-day order of wxDateTime depending 
//   on the locale see notes in the source code
class _WxExtLibDLLExport wxDateTimeValidator: public wxTextCtrlStatusValidator
{
DECLARE_DYNAMIC_CLASS(wxDateTimeValidator)
public:
    wxDateTimeValidator();
    wxDateTimeValidator(wxDateTime * DateTimeValue,
                        wxStatusMessageTarget * StatusMessageTarget,
                        const wxString & FieldNameString,
                        int Flags = 0);
    wxDateTimeValidator(const wxDateTimeValidator& DateTimeValidator);
    ~wxDateTimeValidator();

    virtual wxObject *Clone() const { return new wxDateTimeValidator(*this); }
    bool Copy(const wxDateTimeValidator & DateTimeValidator);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString);
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=FALSE);
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString);

    // some helper functions
    virtual void transferToWindowHelper (const wxDateTime & DateTime, 
                                         wxString & TextCtrlContentString);
    virtual bool transferFromWindowHelper (const wxString & TextCtrlContentString,
                                           wxDateTime * DateTime, wxString & ErrorMessageString);
    // checkValue() might be overwritten to do further checks
    virtual bool checkValue (const wxDateTime & DateTime);
    virtual void getErrorMessageString (const wxDateTime & DateTime, wxString & ErrorMessageString);

    virtual void handleValidInput (const wxDateTime & DateTime);

DECLARE_EVENT_TABLE()

protected:
    wxDateTime * m_DateTimeValue;
    wxString m_FieldNameString;
};

//-------------------------------------------------------------------------

class _WxExtLibDLLExport wxStringValidator: public wxTextCtrlStatusValidator
{
DECLARE_DYNAMIC_CLASS(wxStringValidator)
public:
    wxStringValidator();
    // DEF MaxStringLength == -1 to indicate an unlimited string length 
    wxStringValidator(wxString * StringValue, 
                      wxStatusMessageTarget * StatusMessageTarget,
                      const wxString & FieldNameString,
                      int MaxStringLength = -1, 
                      int Flags = 0, 
                      const wxString & UndefinedString = wxEmptyString);
    wxStringValidator(const wxStringValidator& StringValidator);

    ~wxStringValidator();

    virtual wxObject *Clone() const { return new wxStringValidator(*this); }
    bool Copy (const wxStringValidator & StringValidator);

    // conversions to/from strings
    virtual void transferToWindow (wxString & TextCtrlContentString);
    virtual bool transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                              wxString & ErrorMessageString,
                                              bool IsTextCtrlChangeEvent=FALSE);
    virtual bool transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                               wxString & ErrorMessageString);

    // some helper functions
    virtual void transferToWindowHelper (const wxString & String,
                                         wxString & TextCtrlContentString);
    virtual bool transferFromWindowHelper (const wxString & TextCtrlContentString,
                                           wxString * String, wxString & ErrorMessageString);
    virtual bool checkValue (const wxString & String);
    virtual void getErrorMessageString (const wxString & String, 
                                        wxString & ErrorMessageString);

    virtual void handleValidInput (const wxString & String);

DECLARE_EVENT_TABLE()

protected:
    wxString * m_StringValue; 
    wxString m_FieldNameString;
    int      m_MaxStringLength;
    wxString m_UndefinedString;
};

//=========================================================================

bool convertStringToLong (const char * CharPtr, long &Long);

//=========================================================================

#endif // _INCLUDED_StringValidator_h
